/*
 * SCCS info --- @(#)psutil.c	1.8   12/2/94
 */
/*
 * Copyright (c) 1994 by Castelle
 * The use of this software is restricted to Castelle customers.
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE CASTELLE ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE CASTELLE BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	psutil.c	-	Print Server Configuration Utility Program
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <ctype.h>
#include <netdb.h>
#include <stdio.h>

#include <psipcfg.h>
#include <ps_text.h>

void  showSyntax(serno)
char *serno;
{
   char sf_name[16];

   sprintf(sf_name, "uxconfig");
   printf(TEXT_INSTALL_1, sf_name);
   if ((serno[1] == '6') && (serno[2] == '8')) { /* Fujitsu 1p only */
      printf(TEXT_INSTALL_2A);
      printf(TEXT_INSTALL_3); /* for LPT1 */
      printf(TEXT_INSTALL_9B); /* for SPA */
      printf(TEXT_INSTALL_9C); /* for Clear Printer Driver Buffer */
      printf(TEXT_INSTALL_9D); /* for initiating the printer*/
      printf("\n");
      return;
   }
   printf(TEXT_INSTALL_2);
   printf(TEXT_INSTALL_3); /* for LPT1 */
   if ((serno[1] == '3') && (serno[2] == '7')) {  /* for enet 1+0 */
	  printf(TEXT_INSTALL_9);
	  printf("\n");
	  return;
   }

   if (serno[0] == 0) {
      printf(TEXT_INSTALL_9B); /* for SPA */
      printf("\n");
      printf(TEXT_INSTALL_4); /* for LPT2 */
      printf("\n");
      printf(TEXT_INSTALL_5); /* for COM1 */
      /* printf(TEXT_INSTALL_7); */
      printf(TEXT_INSTALL_6); /* for COM2 */
      /* printf(TEXT_INSTALL_8); */
   }
   else
   if (((serno[1] == '3') && (serno[2] == '2')) || (serno[1] == '5')) { /* LanPress 2+2 */
      printf(TEXT_INSTALL_4A); /* for LPT2 */
      printf("\n");
      printf(TEXT_INSTALL_5); /* for COM1 */
      /* printf(TEXT_INSTALL_7); */
      printf(TEXT_INSTALL_6); /* for COM2 */
      /* printf(TEXT_INSTALL_8); */
   }
   else
   if ((serno[1] == '3') && ((serno[2] == '5') || (serno[2] == '6'))) { /* LanPress 2+2E */
      printf(TEXT_INSTALL_9B); /* for SPA */
      printf("\n");
      printf(TEXT_INSTALL_4); /* for LPT2 */
      printf("\n");
      printf(TEXT_INSTALL_5); /* for COM1 */
      /* printf(TEXT_INSTALL_7); */
      printf(TEXT_INSTALL_6); /* for COM2 */
      /* printf(TEXT_INSTALL_8); */
   }
   else
   if (((serno[1] == '3') && (serno[2] == '3')) ||
        ((serno[1] == '3') && (serno[2] == '4'))) { /* LanPress 1+1 */
      printf(TEXT_INSTALL_9B); /* for SPA */
      printf("\n");
      printf(TEXT_INSTALL_5); /* for COM1 */
      /* printf(TEXT_INSTALL_7); */
   }
   else
   if (((serno[1] == '6') && (serno[2] == '0')) || /* JetPress XIO Ethernet */
       ((serno[1] == '6') && (serno[2] == '1')) || /* JetPress XIO TokenRing */
       ((serno[1] == '6') && (serno[2] == '3')) || /* JetPress MIO Ethernet */
       ((serno[1] == '6') && (serno[2] == '4'))) { /* JetPress EPSON */
      printf("\n");
   }
   else
   if (((serno[1] == '6') && (serno[2] == '2')) || /* JetPress MIO 1+1 Ethernet */
       ((serno[1] == '6') && (serno[2] == '5'))) { /* JetPress MIO 1+1 TokenRing */
      printf("\n");
      printf(TEXT_INSTALL_4); /* for LPT2 */
      printf(TEXT_INSTALL_9B); /* for SPA */
      printf("\n");
      printf(TEXT_INSTALL_5); /* for COM1 */
      /* printf(TEXT_INSTALL_7); */
   }
   else {
      printf(TEXT_INSTALL_9B); /* for SPA */
      printf("\n");
      printf(TEXT_INSTALL_4); /* for LPT2 */
      printf("\n");
      printf(TEXT_INSTALL_5); /* for COM1 */
      /* printf(TEXT_INSTALL_7); */
      printf(TEXT_INSTALL_6); /* for COM2 */
      /* printf(TEXT_INSTALL_8); */
   }
} /* showSyntax */

/*
 *
 *	Dump buffer in hexadecimal format
 *
 */

int print_hex(buf, length, addr)
unsigned char *buf;
int length;
char *addr;
{
    int				i, num, ai, ascii=1;
    unsigned char	*c;
    char			h[50], a[20];
    
    c = buf;
    ai = 0;
    a[ai++] = ' ';
    a[ai++] = ' ';
    
    printf("%8.8lx: ", addr);
    
    for (i=0; i < length; i++, c++) {
    	if (ascii) {
    		if (*c >= 0x20 && *c < 0x7f)
    			a[ai++] = *c;
    		else
    			a[ai++] = '.';
    	}
    
    	h[0] = (*c >> 4) & 0x0f;
    	if (h[0] >= 0x0a)
    		h[0] += 'a' - 0x0a;
    	else
    		h[0] += '0';
    
    	h[1] = *c & 0x0f;
    	if (h[1] >= 0x0a)
    		h[1] += 'a' - 0x0a;
    	else
    		h[1] += '0';
    
    	h[2] = ' ';
    	h[3] = 0;

    	printf("%s", h);
    
    	if (((i+1)%16) == 0) {
    		if (ascii) {
    			a[ai] = 0;
    			printf("%s", a);
    			ai = 0;
    			a[ai++] = ' ';
    			a[ai++] = ' ';
    		}
    
    		/* do CRLF only for intermediate lines */
    		if ((i+1) < length) {
    			h[0] = '\r';
    			h[1] = '\n';
    			h[2] = 0;
    			printf("%s%8.8lx: ", h, addr+i+1);
    		}
    	}
    }
    /* end of for loop */

    /* dump the ascii string for the last line */
    if (ascii) {
    	/* fill spaces */
    	num = length%16;
    	if (num) {
    		num = 16 - num;
    		(void) memset(h, ' ', num*3);
    		h[num*3] = 0;
    		printf("%s", h);
    
    		a[ai] = 0;
    		printf("%s", a);
    	}
    }

    printf("\r\n");
    return(0);
}

int  check_ip_string(string)
char *string;
{
   int i,j, k;
   int length, value;
   char s1[16];

   length = strlen(string);
   j = k = 0;
   for (i=0; i<length; i++) {
     if (isdigit(string[i])) {
       s1[i-j] = string[i];
     }
     else
     if (string[i] == '.') {
       k++;
       s1[i-j] = 0;
       j = i + 1;
       value = atoi(s1);
       if ((value < 0) || (value > 255)) {
          return(1);
       }
     }
     else {
       return(2);
     }
   }
   s1[i-j] = 0;
   if (k != 3)
     return(4);
   value = atoi(s1);
   if ((value < 0) || (value > 255)) {
      return(3);
   }
   return(0);
} /* check_ip_string */

int  check_baud_string(string)
char *string;
{
   if ((strncmp(string, "300", 3) != 0) &&
       (strncmp(string, "600", 3) != 0) &&
       (strncmp(string, "1200", 4) != 0) &&
       (strncmp(string, "2400", 4) != 0) &&
       (strncmp(string, "4800", 4) != 0) &&
       (strncmp(string, "9600", 4) != 0) &&
       (strncmp(string, "19200", 5) != 0) &&
       (strncmp(string, "38400", 5) != 0)) {
     return(1);
   }
   return(0);
} /* check_baud_string */

int  check_dbits_string(string)
char *string;
{
   if ((*string != '7') &&
       (*string != '8')) {
     return(1);
   }
   return(0);
} /* check_dbits_string */

int  check_sbits_string(string)
char *string;
{
   if ((*string != '1') &&
       (*string != '2')) {
     return(1);
   }
   return(0);
} /* check_sbits_string */

int  check_fcntl_string(string)
char *string;
{
   if ((strncmp(string, "XON", 3) != 0) &&
       (strncmp(string, "XOFF", 4) != 0)) {
     return(1);
   }
   return(0);
} /* check_fcntl_string */

int  check_parity_string(string)
char *string;
{
   if ((strncmp(string, "ODD", 3) != 0) &&
       (strncmp(string, "NO", 2) != 0) &&
       (strncmp(string, "EVEN", 4) != 0)) {
     return(1);
   }
   return(0);
} /* check_parity_string */
