########################################################################### 
#                                                                         #
#                                                                         #
# Copyright (c) 1994 by Castelle
# The use of this software is restricted to Castelle customers.
#
#
# THIS SOFTWARE IS PROVIDED BY THE CASTELLE ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE CASTELLE BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#                                                                         #
#   makefile    -   Castelle Print Server Software                        #
#                                                                         #
########################################################################### 

# change SYS to SCO for sco compiliation
# chnage SYS to IBMAIX or _ALL_AOURCE for ibmaix compiliation
SYS = SCO

SRC = .
INC = $(SRC)
BIN = .

CC1 =
CC2 =
CC3 =
CC4 =
CC5 =

LD1 = -lscoket
LD2 =
LD3 =
LD4 =
LD5 =

CCOPT = -I$(INC) -D$(SYS) $(CC1) $(CC2) $(CC3) $(CC4) $(CC5)
LDOPT = $(LD1) $(LD2) $(LD3) $(LD4) $(LD5)

INSTALL = etherhex 
UTILITY = psbrarp uxconfig
DIAGS = 

all: $(INSTALL) $(UTILITY) $(DIAGS)

etherhex: $(SRC)/etherhex.c
	cc $(CCOPT) $(SRC)/etherhex.c -o $(BIN)/etherhex $(LDOPT)
	strip $(BIN)/etherhex

psbrarp: $(SRC)/psbrarp.c
	cc $(CCOPT) $(SRC)/psbrarp.c -o $(BIN)/psbrarp $(LDOPT)
	strip $(BIN)/psbrarp

uxconfig: $(BIN)/psutil.o $(BIN)/psconfig.o
	cc $(CCOPT) -o $(BIN)/uxconfig $(BIN)/psutil.o $(BIN)/psconfig.o $(LDOPT)
	strip $(BIN)/uxconfig
	rm -f $(BIN)/psutil.o
	rm -f $(BIN)/psconfig.o

$(BIN)/psutil.o: $(SRC)/psutil.c
	cc $(CCOPT) -c -o $(BIN)/psutil.o  $(SRC)/psutil.c $(LDOPT)
#	sh $(SRC)/moveobj psutil.o

$(BIN)/psconfig.o: $(SRC)/psconfig.c
	cc $(CCOPT) -c -o $(BIN)/psconfig.o $(SRC)/psconfig.c $(LDOPT)
#	sh $(SRC)/moveobj psconfig.o
