/*
 *
 *	SCCS info	-	@(#)etherhex.c	1.1   4/4/93
 *
 * Copyright (c) 1994 by Castelle
 * The use of this software is restricted to Castelle customers.
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE CASTELLE ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE CASTELLE BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	etherhex.c	-	generates a line in /etc/ethers format
 *
 */

#include	<stdio.h>
#include	<ctype.h>

/*
 *
 *	Display usage and exit
 *
 */

usage(cmd)
char *cmd;
{
	printf("Usage: %s  8-digit-serial-number  [hostname]\n", cmd);
	exit(1);
}

/*
 *
 *	Generate 'ethers' RARP entry with a host name
 *
 */

main(argc, argv)
int argc;
char *argv[];
{
	int				len, i;
	unsigned long	number;
	char			*cp;

	if (argc < 2)
		usage(argv[0]);

	if ((len = strlen(argv[1])) > 8)
		usage(argv[0]);

	cp = argv[1];
	for (i=0; i < len; i++, cp++) {
		if (!isdigit(*cp))
			usage(argv[0]);
	}

	sscanf(argv[1], "%ld", &number);

	printf("%x:%x:%x:%x:%x:%x	%s	# Castelle %s RARP entry\n",
					0x00, 0x00, 0x44,
					(number>>16) & 0xff, (number>>8) & 0xff, number & 0xff,
					(argc == 3) ? argv[2] : argv[1], argv[1]);
	exit(0);
}
