		save
	if DontListIncls
		listing off
	endif

;********************************************************************
;
; This file contains definitions for D6.06 LLF firmware
;
; 2002-11-24 PS
; last changes 2014-01-23 PS
;
;********************************************************************


Stack_Top 	EQU 080h		; Register 07Fh +1



;********************************************************************
; Hardware
;********************************************************************
;
;	I/O Port	Use
;	--------	---
;	   0		Bit 0: Adr8
;	{Output}	Bit 1: Adr9
;			Bit 2: Adr10 
;			Bit 3: PreComp  (precomp / reduce write current)
;			Bit 4: PHIB2  (step motor phases)
;			Bit 5: PHIB1
;			Bit 6: PHIA2
;			Bit 7: PHIA1
;
;	   1 		Bit 0: Adr0 
;    {Input/Output}	Bit 1: Adr1 
;			Bit 2: Adr2 
;			Bit 3: Adr3
;			Bit 4: Adr4 
;			Bit 5: Adr5 
;			Bit 6: Adr6 
;			Bit 7: Adr7
;
;	   2 		Bit 0: WRTSMI  (write sector mark input)
;    {Input/Output}	Bit 1: Trk0  (track 0 input)
;			Bit 2: CMD  (command input)
;			Bit 3: BSY  (busy output)
;			Bit 4: Msel0
;			Bit 5: Msel1  (1=disk, 0=host)
;			Bit 6: DSTART
;			Bit 7: DRW  (disk read=1 / write=0)
;
;	   3		Bit 0: FastSeek  (=1 for fast seek)
;    {Input/Output}	Bit 1: SectorMark (sector pulse input)
;			Bit 2: Index (index pulse input)
;			Bit 3: CRCERR (=0 if error detected)
;			Bit 4: HS0
;			Bit 5: HS1
;			Bit 6: WRTSM  (write sector mark output)
;			Bit 7: RDHDR/TX
;

; Port 0 Defs:
PreComp	 	EQU 008h	; set 1 to reduce write current (above cylinder 128)
PHIB2	 	EQU 010h
PHIB1	 	EQU 020h	; step motor phases
PHIA2 		EQU 040h
PHIA1	 	EQU 080h

; Port 2 Defs:
SECTDN	 	EQU 001h	; =0 when state machine finished
Trk0 		EQU 002h	; =0 when heads on track 0
CMD 		EQU 004h	; Apple CMD input
BSY 		EQU 008h	; Apple BUSY output. Set 0 when busy.
Msel0 		EQU 010h	; Memory Select bit 0
Msel1 		EQU 020h	; Memory Select bit 1
				;   00: Apple --> Mem
				;   01: Z8 --> Timer
				;   10: State Machine (Disk) --> Mem
				;   11: Z8 --> Mem
DSTART 		EQU 040h	; set 1 to reset state machine, set 0 to start
DRW_Read 	EQU 080h	; Apple/Disk direction: 1 = Read, 0 = Write

; Port 3 Defs:
FastSeek	EQU 001h	; =1 for fast, =0 for slow seek
SectorMark 	EQU 002h	; sector mark from analog board
Index	 	EQU 004h	; index pulse input from analog board
CRCERR		EQU 008h	; =0 if CRC error detected
HS0 		EQU 010h	; Head select 
HS1 		EQU 020h	;
WRTSM		EQU 040h	; set 0 to write sector mark
RDHDR 		EQU 080h	; set 0 to read next header into RAM



;********************************************************************
; Registers
;********************************************************************

PwrFlg1		EQU 004h	; =001h for warm start
P3Mask1		EQU 005h	; WRTSM + RDHDR + Heads
P3Mask2		EQU 006h	; WRTSM + Heads
Status1   	EQU 007h	; these are the status bytes for the host
Status2   	EQU 008h
Status3   	EQU 009h
Status4         EQU 00Ah
CurStep   	EQU 00Bh	; step motor angle (0..7)
MaskChkHdr	EQU 00Ch	; don't check headers after seek when <>0
;MaskSctrErr	EQU 00Dh	; don't report sector mark errors when <>0
;DSM_FastTo	EQU 00Eh	; <>0 for fast disk state machine timeout
HeaderImage	EQU 00Fh	; sector header bytes: this byte always = 000h
ActCylH  	EQU 010h	;   actual cylinder
ActCylL  	EQU 011h
ActHead   	EQU 012h	;          head
ActSector 	EQU 013h	;          sector
ComCylH	  	EQU 014h	;   complemented actual cylinder
ComCylL		EQU 015h
ComHead   	EQU 016h	; 	  	        head
ComSector 	EQU 017h	; 		        sector
;SeekDir   	EQU 018h
DiskSM_Timeout	EQU 019h	; <>0 if disk state machine timeout
RWstat		EQU 01Ah	; this goes into Status1 
OnTrackFlg	EQU 01Bh	; <>0 when heads have been moved
OnTrackCtr	EQU 01Ch	; counter for Seek_ChkHdr function
RAM_MSB		EQU 01Dh	; RAM MSB (010h or 013h)
HeaderBufLSB 	EQU 01Eh	; RAM LSB for state machine operation
StatusBufLSB	EQU 01Fh	; RAM LSB of status buffer address (set but not used)
SettlingReqd	EQU 021h	; <>0 when we just moved the heads
PwrFlg0		EQU 023h	; =0FFh for warm start
HostCmdLength	EQU 024h	; these are the command bytes from host
HostCommand	EQU 025h	;   command
CylinderH  	EQU 026h	;   cylinder
CylinderL  	EQU 027h
Head	  	EQU 028h	;   head
Sector	  	EQU 029h	;   sector
RetryCnt  	EQU 02Ah	;   (for Read Header command only)
FirstTrackFlg	EQU 02Dh	; =0 if first track to be formatted
; 02Eh	; seek, =0 for first call do not range check when 0
; 02Fh	; cleared but never used
; 030h	; cleared but never used
; 031h	; seek
; 032h	; _06eb seek difference MSB
; 033h	; _06eb seek difference LSB
; 034h	; seek =FFh at init or when stepper off
; 035h	; seek backwards
; 036h	; seek delay value
; 037h	; _06eb
; 038h	; _06eb
FormatFlag	EQU 039h	; =0 when format, =0FFh when cmd 8, A, =1 when cmd 9
OldMaskCkHdr	EQU 03Ch	; seek stores MaskChkHdr there
; 03Dh	; set for initial seek to park position
WorkingRegs	EQU 040h	; 040..04Fh are our working registers R0..R15
TempRegs	EQU 050h	; 050..06Fh are used as temporary storage
				;  for the Init Spare Table result


;********************************************************************
; External Ram Stuff
;********************************************************************

RAM		EQU 01000h
ReadBuffer	EQU 01014h
RdHdrBuffer	EQU 01020h
WriteBuffer	EQU 01028h
AuxBuffer	EQU 01240h
SpareSublists	EQU 012DCh
SeekHeaderBuf	EQU 013E0h
HostCmdBuffer	EQU 013F0h	; host DMAs his commands here

FMTEN		EQU 00800h	; open write gate (needs jumper P7 to be closed)


;********************************************************************
; Constants
;********************************************************************

; System Status Definitions
;   Status1
Bad_55 		EQU 080h	; Status: Other than 55 response from host
Stat_NoIdx	EQU 040h	; Status: No index found during formatting
Stat_NoSect	EQU 020h	; Status: No sector mark found during formatting
Stat_Seek_Err	EQU 010h	; Status: Seek Error
Stat_Rd_Err	EQU 008h	; Status: Read Error (CRC)
Stat_No_Hdr 	EQU 004h	; Status: No Header Found
Op_Failed 	EQU 001h	; Status: Operation Failed
;   Status2
Power_Reset	EQU 080h	; Profile was power reset
Illegal_Track 	EQU 040h	; Status: track number out of bounds
Stat_Seek 	EQU 002h	; Status: Seek to wrong track
;   Status3	(fault reason for write compare)
WriteTimeout	EQU 000h
ReadTimeout	EQU 080h
ReadCRC		EQU 040h
DataCompare	EQU 020h
;   Status4 holds the number of retries needed


; Spare Table offsets (relative to start of buffer)
ST_DeviceName	EQU 0		; "PROFILE      "
ST_DeviceType	EQU 13		; 000h, 000h, 000h
ST_FwRev	EQU 16		; 003h, 098h
ST_Capacity	EQU 18		; 000h, 026h, 000h
ST_BlockSize	EQU 21		; 002h, 014h
ST_SparesAvail	EQU 23		; 020h
ST_SparesAlloc	EQU 24	
ST_BadPending	EQU 25
ST_SpareMap	EQU 26		; length 154 bytes
ST_SpareMapEnd	EQU 180
ST_Sublists	EQU 182


	restore


