   \ZORAN\VM\LINKREST.BAT                                                                                                    : LINKREST.BAT: Common tail of VL.BAT and CREATE.BAT
:
: LINKREST supports linking of user simulators in four ways:
:
:   1) Single user object file, no board support:
:      LINKREST name        -- where name.obj is user's object file
:
:   2) Single user object file, with board support
:      LINKREST name board  -- where name.obj is user's object file,
:                              and board_b.lnk is board-specific link file
:
:   3) Multiple user object files, no board support
:      LINKREST name        -- where name.obj is user's object file
:                              and name.lnk is user's link file (see below)
:
:   4) Multiple user object files, with board support
:      LINKREST name board  -- where name.obj is user's object file,
:                              name.lnk is user's link file (see below),
:                              and board_b.lnk is board-specific link file
: 
: For multiple user object files (cases 3 and 4), the file name.lnk should
: contain one or more lines of the form:
:
:     FILE name1, name2, ..., nameN
:
: where nameK = name of the Kth additional user object file, NOT including
: the user's main object file (the one containing 'vspop').
:
: If the second parameter (%2) is null, no board support is linked in.
: If %2 is non-null, linkfile \zoran\vm\%2_b.lnk is expected.

echo off

:------- Check input parameters and select appropriate case ----------
: Must have at least one parameter
if %1x==x goto noparam

: If no second parameter, no board support requested
: else (board) check for link files with name %2_b, %2_e on board directory
if %2x==x goto skipbrd
if not exist \zoran\%2\%2_b.lnk goto nbbf
if not exist \zoran\%2\%2_e.lnk goto nbef
:skipbrd

echo   
: If linkfile exists with name = first parameter, assume single user module 
if exist %1.lnk goto multiple

: Single user module
if not %2x==x goto sb
goto snb

:multiple
: Multiple user modules
if not %2x==x goto mb
goto mnb

:--------------- Do the link ----------------

: 1) Single user module, no board support
:snb
echo Linking user simulator '%1.EXE' from SINGLE module '%1.obj'
echo (this takes several minutes)...
Plink86 @\zoran\vm\b file %1 map=%1 A out %1 @\zoran\vm\e > %1.ler
goto linkend

: 2) Single user module with board support
:sb
echo Linking user simulator '%1.EXE' from SINGLE module '%1.obj'
echo with '%2' board support
echo (this takes several minutes)...
Plink86 @\zoran\%2\%2_b file %1 out %1 map=%1 A @\zoran\%2\%2_e >%1.ler
goto linkend

: 3) Multiple user modules, no board support
:mnb
echo Linking user simulator '%1.EXE' from MULTIPLE modules via '%1.lnk'
echo (this takes several minutes)...
Plink86 @\zoran\vm\b file %1 @%1 out %1 map=%1 A @\zoran\vm\e > %1.ler
goto linkend

: 4) Multiple user modules with board support
:mb
echo Linking user simulator '%1.EXE' from MULTIPLE modules via '%1.lnk'
echo with '%2' board support
echo (this takes several minutes)...
Plink86 @\zoran\%2\%2_b file %1 @%1 out %1 map=%1 A @\zoran\%2\%2_e > %1.ler
goto linkend

:linkend
: Done with link -- indicate results
echo   
if not errorlevel 1 goto linked

: Link failed.  Delete map file
if exist %1.map del %1.map
echo Link failed.  File '%1.ler' follows:
echo -------------------------------------------------------------
type %1.ler
echo -------------------------------------------------------------
goto end

:linked
echo Link complete.  File '%1.ler' follows:
echo -------------------------------------------------------------
type %1.ler
echo -------------------------------------------------------------
echo Enter '%1' to run user simulator.
goto end

:------------------- Error messages -------------------------
:nbbf
: Two parameters entered, but found no board begin link file by that name
echo   Error: link file '%2_b.lnk' was not found.
goto end

:nbef
: Two parameters entered, but found no board end link file by that name
echo   Error: link file '%2_e.lnk' was not found.
goto end

:noparam
: No parameters entered
echo   LINKREST is not intended to be invoked directly.

:end
