   \ZORAN\VM\CREATE.BAT                                                                                                      : CREATE.BAT: Create a user simulator named '%1.exe' by parsing, compiling,
: and linking the user's VSP source module '%1.ffp'.
: This batch file expects to run on \ZORAN\VM, where PARSE.EXE is.
: It is sufficient that \ZORAN\VM be on the path.
: Sequence:
:   1) Parse %1.ffp into %1.c
:   2) Compile %1.c into %1.obj
:   3) Delete ffpop.obj if it exists (so rename below succeeds)
:   4) Rename %1.obj to ffpop.obj (usr.lnk expects 'ffpop.obj')
:   5) Link ffpop.obj (via usr.lnk) into a working simulator, emul.exe
:   6) Rename emul.exe to %1.exe, and emul.map to %1.map
: Last edit 7/22/86 JJC

echo off
cls

: Check for 1 or 2 params, and an '.ffp' file whose name is the 1st param
if %1x==x goto explain
if not %3x==x goto explain
if not exist %1.ffp goto explain

: User entered exactly one param, and there is an '.ffp' file by that name
echo === CREATE: Create a user simulator from VSP source file '%1.FFP' ====
if not %2x==x echo             with '%2' board support

: Parse the .ffp file into a .c file
echo   
echo Parsing '%1.FFP' to create '%1.C'...
parser %1.ffp

: Compile the .c file
echo   
echo Compiling '%1.C', creating '%1.OBJ'...
msc %1 /AL /Od /Ze /Gt16 ; &> %1.err
if not errorlevel 1 goto compiled
echo C compilation failed.  See file '%1.ERR' for details.
goto end

:compiled
echo C compilation successful.
del %1.err

: Following batch file does the rest, and does not return
linkrest %1 %2

:-------------------------------------------------------------------
:explain
: Zero or more than two parameters entered, or no '.FFP' file found
echo   CREATE expects a parameter (the name of a .FFP file), and an optional
echo   second parameter (the name of a hardware board).  Examples:
echo  
echo   CREATE parses, compiles, and links a simulator with a user module
echo   whose name is given by the first command line argument.  Examples:
echo  
echo     'CREATE TEST'      ...creates a user simulator TEST.EXE starting
echo                           from a user VSP code module named TEST.FFP.
echo     'CREATE TEST VSPE' ...creates a user simulator TEST.EXE starting
echo                           from a user VSP code module named TEST.FFP,
echo                           with hardware support for the 'VSPE' board.
echo  
echo   If CREATE finds no .FFP file, it will not proceed.

:end
