/*

Freely Distributable C30 Simulator Package

Copyright (c) 1996-1998 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
  
The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Authors: Chi Duong, Brian Evans, and Chris Moy
Version: @(#)execute.h	1.13	01/19/98

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

#ifndef _EXECUTE_H
#define _EXECUTE_H

#include "pipeline.h"
#include "state.h"

/* Simulator functions */

void S_absf(pipeline *, state *);
void S_absf_stf(pipeline *, state *);
void S_absi(pipeline *, state *);
void S_absi_sti(pipeline *, state *);
void S_addc(pipeline *, state *);
void S_addc3(pipeline *, state *);
void S_addf(pipeline *, state *);
void S_addf3(pipeline *, state *);
void S_addf3_stf(pipeline *, state *);
void S_addi(pipeline *, state *);
void S_addi3(pipeline *, state *);
void S_addi3_sti(pipeline *, state *);
void S_and(pipeline *, state *);
void S_and3(pipeline *, state *);
void S_and3_sti(pipeline *, state *);
void S_andn(pipeline *, state *);
void S_andn3(pipeline *, state *);
void S_ash(pipeline *, state *);
void S_ash3(pipeline *, state *);
void S_ash3_sti(pipeline *, state *);

void S_bcnd(pipeline *, state *);
void S_bd(pipeline *, state *);
void S_bdc(pipeline *, state *);
void S_br(pipeline *, state *);
void S_brd(pipeline *, state *);

void S_call(pipeline *, state *);
void S_callc(pipeline *, state *);
void S_cmpf(pipeline *, state *);
void S_cmpf3(pipeline *, state *);
void S_cmpi(pipeline *, state *);
void S_cmpi3(pipeline *, state *);

void S_dbc(pipeline *, state *);
void S_dbdc(pipeline *, state *);

void S_FRIEEE(pipeline *, state *);
void S_fix(pipeline *, state *);
void S_fix_sti(pipeline *, state *);
void S_float(pipeline *, state *);
void S_float_stf(pipeline *, state *);

void S_iack(pipeline *, state *);
void S_idle(pipeline *, state *);
void S_idle2(pipeline *, state *);

void S_LDA(pipeline *, state *);
void S_lde(pipeline *, state *);
void S_ldf(pipeline *, state *);
void S_ldfc(pipeline *, state *);
void S_ldfic(pipeline *, state *);
void S_ldfi(pipeline *, state *);
void S_ldf_ldf(pipeline *, state *);
void S_ldf_stf(pipeline *, state *);
void S_ldi(pipeline *, state *);
void S_ldic(pipeline *, state *);
void S_ldii(pipeline *, state *);
void S_ldi_ldi(pipeline *, state *);
void S_ldi_sti(pipeline *, state *);
void S_ldm(pipeline *, state *);
void S_ldp(pipeline *, state *);
void S_lopower(pipeline *, state *);
void S_lsh(pipeline *, state *);
void S_lsh3(pipeline *, state *);
void S_lsh3_sti(pipeline *, state *);

void S_maxspeed(pipeline *, state *);
void S_mpyf(pipeline *, state *);
void S_mpyf3(pipeline *, state *);
void S_mpyf3_addf3(pipeline *, state *);
void S_mpyf3_stf(pipeline *, state *);
void S_mpyf3_subf3(pipeline *, state *);
void S_mpyi(pipeline *, state *);
void S_mpyi3(pipeline *, state *);
void S_mpyi3_addi3(pipeline *, state *);
void S_mpyi3_sti(pipeline *, state *);
void S_mpyi3_subi3(pipeline *, state *);

void S_negb(pipeline *, state *);
void S_negf(pipeline *, state *);
void S_negf_stf(pipeline *, state *);
void S_negi(pipeline *, state *);
void S_negi_sti(pipeline *, state *);
void S_nop(pipeline *, state *);
void S_norm(pipeline *, state *);
void S_not(pipeline *, state *);
void S_not_sti(pipeline *, state *);

void S_or(pipeline *, state *);
void S_or3(pipeline *, state *);
void S_or3_sti(pipeline *, state *);

void S_pop(pipeline *, state *);
void S_popf(pipeline *, state *);
void S_push(pipeline *, state *);
void S_pushf(pipeline *, state *);

void S_retic(pipeline *, state *);
void S_retsc(pipeline *, state *);
void S_rnd(pipeline *, state *);
void S_rol(pipeline *, state *);
void S_rolc(pipeline *, state *);
void S_ror(pipeline *, state *);
void S_rorc(pipeline *, state *);
void S_rptb(pipeline *, state *);
void S_rpts(pipeline *, state *);

void S_sigi(pipeline *, state *);
void S_stf(pipeline *, state *);
void S_stfi(pipeline *, state *);
void S_stf_stf(pipeline *, state *);
void S_sti(pipeline *, state *);
void S_stii(pipeline *, state *);
void S_sti_sti(pipeline *, state *);
void S_subb(pipeline *, state *);
void S_subb3(pipeline *, state *);
void S_subrb(pipeline *, state *);
void S_subc(pipeline *, state *);
void S_subf(pipeline *, state *);
void S_subf3(pipeline *, state *);
void S_subf3_stf(pipeline *, state *);
void S_subi(pipeline *, state *);
void S_subi3(pipeline *, state *);
void S_subi3_sti(pipeline *, state *);
void S_subf(pipeline *, state *);
void S_subrf(pipeline *, state *);
void S_subri(pipeline *, state *);
void S_swi(pipeline *, state *);

void S_TOIEEE(pipeline *, state *);
void S_trap(pipeline *, state *);
void S_trap4x(pipeline *, state *);
void S_tstb(pipeline *, state *);
void S_tstb3(pipeline *, state *);

void S_word(pipeline *, state *);

void S_xor(pipeline *, state *);
void S_xor3(pipeline *, state *);
void S_xor3_sti(pipeline *, state *);

#endif
