#ifndef __TYPEDEFS
#define __TYPEDEFS
//--------------------------------------------
// TYPEDEFS.H
// Keith Larson 
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//--------------------------------------------
typedef unsigned short ushort;
typedef unsigned char uchar;
typedef unsigned int  uint;
typedef unsigned long ulong;
typedef unsigned char* byte;
typedef          char* string;
/*---------------------------------------------------------------
  In 32 bit OS machines far and huge do not exist and will create
  compile errors.  The following #if undefines these types if the
  program is not targeted for DOS
  ---------------------------------------------------------------*/
#if  __HUGE__ || __LARGE__ || __COMPACT__ || __MEDIUM__ || __SMALL__
#else
#define far
#define huge
#endif

/*
typedef int16    short;  // Some Unix machines
typedef int32    int;
typedef int64    int;
*/

#include <string.h>
//
// 'static' functions can be defined within a header, keeping the
// compiler from generating multiple copies using the same function
// name.  Inline, causes the function to be expanded like a macro
// for maximum speed.  Note that in this case the function is very
// small and that a call to strexact would use as much code as
// the inlining.
//
//int strexact(char *p1,char *p2);
static inline int strexact(char *p1,char *p2)
{
  return (  strstr(p1,p2) && strstr(p2,p1)  );
}
/* Verbose version
static inline int strexact(char *p1,char *p2)
{
  if(strstr(p1,p2)==NULL) return 0;
  if(strstr(p2,p1)==NULL) return 0;
  return 1;
}
*/

#endif
