#ifndef __SYMBOLS
#define __SYMBOLS
//---------------------------------------------------------
// SYMBOLS.H
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996, 1997
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//---------------------------------------------------------
//#define MAX_SYMBOLS    512 /* max number of symbols   */
#define MAX_SYMBOLS     1024 /* use small array to avoid 64K DGROUP error */
#define sym_str_tbl_sz 10000 /* apx 10 chars per symbol */
#include "typedefs.h"
#include "errormsg.h"
// Chi Duong
/*
  Note the use of defined types 'NUM_TYPE' and 'SYM_TYPE' in XREF_TBL
  This helps in being able to guarentee that the proper flags are
  passed between functions, but has one serious drawback if an
  enumeration typedef is used.  Namely that each element would be forced
  to be an 'int' in size, and therefor occupying 2x the space.

  To get around this restriction, 'SYM_TYPE' and 'NUM_TYPE' are defined
  to be of type 'char', and then assignments are made of the enumerated
  types into elements of char size.

  The downside of this is that automatic type checking is not enforced.
  In other words, if the enumeration was used directly, an error would
  be generated if a type not belonging to the enumeration were used.

  If an enumerated type were used, the usage of data memory will cause
  an 'DATA SEGMENT EXCEEDS 64K' linker error.  To solve this, either
  decrease MAX_SYMBOLS to 512, or compile and linke using the huge
  model.  Note however that if you used the huge model, the objects
  that are created would not coincide with the other DSK project build
  files.  And if huge were to be used, all executable file sizes would
  grow substantialy, plus execute slower.
*/
#define SYM_TYPE char
#define NUM_TYPE char

//chi the following line does not work for Borland C++ 5
//typedef enum E_SYM_TYPE
typedef enum 
{
  SYM_FOO     ,
  SYM_VAR     , // VAR_ADD     ,
  SYM_LBL     , // LBL_ADD     ,
  SYM_DEF       // DEF_ADD     ,
//};
} E_SYM_TYPE;

// chi the following line does not work for Borland C++ 5
//typedef enum E_NUM_TYPE
typedef enum 
{
  NOREF  ,
  INTEGER,
  FLOAT  ,
  LONG   ,
  ULONG  ,
  QFORM  ,
  AUTO
//};
} E_NUM_TYPE;

struct XREF_TABLE    // structure to hold pointer to
{ char     *sptr;       // symbol string and also value
  long     value;       //
  NUM_TYPE  numt;       // Storage type Nothing INTEGER  FLOAT  DEFINE
  SYM_TYPE  symt;       // Addressable  0=Variable  1=Label  2=Define
};

#define MAX_SEGMENTS 32  /* 32 segments max for DSK3A */
struct segments
{
  long start;     // start of segment - Used to calculate length
  long offs;      // current address offset
  long length;
  char name[16];  // 16 character length for section names
};

extern int  current_seg;
extern int  post_boot_sym; // Symbol pointer value at end of boot
extern int  last_ref;
extern int  last_segment;
extern char *post_boot_symbols;
extern char *symbol_ptr;
extern char symbols[];       // large array of symbol strings
extern XREF_TABLE huge SYM[];
extern segments SEG[];

int symb_defined(char *ptr);
char *argstart(char *ptr);
char *argend(char *ptr,char field);
NUM_TYPE  ref_value(char *ptr, long *value);
int  get_label (char *label,ulong addr, int lws);
int  ref_offs  (char *ptr);
MSGS xref_add  (char *ptr, ulong val, NUM_TYPE, SYM_TYPE);
MSGS ref_mod   (char *ptr, ulong val);
MSGS xref_mod2 (char *ptr, ulong val, NUM_TYPE, SYM_TYPE);
void remove_defines(void);
void tabstrip(char *buf,int N);
#endif
