# Makefile for java classes, usually included at the bottom of a makefile
#
# Version identification:
# @(#)javafoot.mk	1.5 12/29/96
#
# Copyright (c) 1996 The Regents of the University of California.
# All rights reserved.
# 
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in all
# copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
# FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
# ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
# THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
# PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
# CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
# ENHANCEMENTS, OR MODIFICATIONS.
# 
# 						PT_COPYRIGHT_VERSION_2
# 						COPYRIGHTENDKEY
# Date of creation: 11/21/96
# Written by: Christopher Hylands, based on a file by Thomas M. Parks

# Typically, this file is included at the bottom of a makefile that has
# java files to be compiled.
# javahead.mk is included at the top of the makefile

.SUFFIXES: .class .java

%.class: %.java
	CLASSPATH=$(CLASSPATH) $(JAVAC) $(JFLAGS) $<

# Build all class files and documentation.
all:	class html 

# Build all class files.
class:	$(JSRCS) $(JCLASS) 

# Build documentation.
html:	$(JSRCS)
	if [ ! -d html ]; then mkdir html; fi
	CLASSPATH=$(CLASSPATH) $(JAVADOC) $(JDOCFLAGS) -d html $(JCLASSES)
	perl -pi \
	-e "s|<a href=\"java|<a href=\"$(JDK)/doc/api/java|g;" \
	-e "s|<img src=\"images/|<img src=\"$(JDK)/doc/api/images/|g;" \
	html/*.html


test: $(TESTHTML) $(JCLASS)
	CLASSPATH=$(CLASSPATH) appletviewer $(TESTHTML)

test-netscape: $(TESTHTML) $(JCLASS)
	CLASSPATH=$(CLASSPATH) netscape $(TESTHTML)


%.class: %.java
	CLASSPATH=$(CLASSPATH) $(JAVAC) $(JFLAGS) $<

# Get rules like 'sccsinfo'
include $(ROOT)/mk/no-compile.mk
