/*
**	Interrupts
**		Tomaso Paoletti, 1994-1996
*/

#ifndef _SIM_IRQ_H
#define _SIM_IRQ_H

/* Register page */

#define PORTA	0x1000	/*  Port A data register */
#define RESV1	0x1001	/*  Reserved */
#define PIOC	0x1002	/*  Parallel I/O Control register */
#define PORTC	0x1003	/*  Port C latched data register */
#define PORTB	0x1004	/*  Port B data register */
#define PORTCL	0x1005	
#define DDRC	0x1007	/*  Data Direction register for port C */
#define PORTD	0x1008	/*  Port D data register */
#define DDRD	0x1009	/*  Data Direction register for port D */
#define PORTE	0x100A	/*  Port E data register */
#define CFORC	0x100B	/*  Timer Compare Force Register */
#define OC1M	0x100C	/*  Output Compare 1 Mask register */
#define OC1D	0x100D	/*  Output Compare 1 Data register */

/* Two-Byte Registers (High,Low -- Use Load & Store Double to access) */
#define TCNT	0x100E	/*  Timer Count Register */
#define TIC1	0x1010	/*  Timer Input Capture register 1 */
#define TIC2	0x1012	/*  Timer Input Capture register 2 */
#define TIC3	0x1014	/*  Timer Input Capture register 3 */
#define TOC1	0x1016	/*  Timer Output Compare register 1 */
#define TOC2	0x1018	/*  Timer Output Compare register 2 */
#define TOC3	0x101A	/*  Timer Output Compare register 3 */
#define TOC4	0x101C	/*  Timer Output Compare register 4 */
#define TI4O5	0x101E	/*  Timer Input compare 4 or Output compare 5 register */

#define TCTL1	0x1020	/*  Timer Control register 1 */
#define TCTL2	0x1021	/*  Timer Control register 2 */
#define TMSK1	0x1022	/*  main Timer interrupt Mask register 1 */
#define TFLG1	0x1023	/*  main Timer interrupt Flag register 1 */
#define TMSK2	0x1024	/*  misc Timer interrupt Mask register 2 */
#define TFLG2	0x1025	/*  misc Timer interrupt Flag register 2 */
#define PACTL	0x1026	/*  Pulse Accumulator Control register */
#define PACNT	0x1027	/*  Pulse Accumulator Count register */
#define SPCR	0x1028	/*  SPI Control Register */
#define SPSR	0x1029	/*  SPI Status Register */
#define SPDR	0x102A	/*  SPI Data Register */
#define BAUD	0x102B	/*  SCI Baud Rate Control Register */
#define SCCR1	0x102C	/*  SCI Control Register 1 */
#define SCCR2	0x102D	/*  SCI Control Register 2 */
#define SCSR	0x102E	/*  SCI Status Register */
#define SCDR	0x102F	/*  SCI Data Register */
#define ADCTL	0x1030	/*  A/D Control/status Register */
#define ADR1	0x1031	/*  A/D Result Register 1 */
#define ADR2	0x1032	/*  A/D Result Register 2 */
#define ADR3	0x1033	/*  A/D Result Register 3 */
#define ADR4	0x1034	/*  A/D Result Register 4 */
#define BPROT	0x1035	/*  Block Protect register */
#define RESV2	0x1036	/*  Reserved */
#define RESV3	0x1037	/*  Reserved */
#define RESV4	0x1038	/*  Reserved */
#define OPTION	0x1039	/*  system configuration Options */
#define COPRST	0x103A	/*  Arm/Reset COP timer circuitry */
#define PPROG	0x103B	/*  EEPROM Programming register */
#define HPRIO	0x103C	/*  Highest Priority Interrupt and misc. */
#define INIT	0x103D	/*  RAM and I/O Mapping Register */
#define TEST1	0x103E	/*  factory Test register */
#define CONFIG	0x103F	/*  Configuration Control Register */


/* Interrupt Vector locations */

#define SCIINT	0xFFD6	/*  SCI serial system */
#define SPIINT	0xFFD8	/*  SPI serial system */
#define PAIINT	0xFFDA	/*  Pulse Accumulator Input Edge */
#define PAOVINT 0xFFDC	/*  Pulse Accumulator Overflow */
#define TOINT	0xFFDE	/*  Timer Overflow */
#define TOC5INT	0xFFE0	/*  Timer Output Compare 5 */
#define TOC4INT	0xFFE2	/*  Timer Output Compare 4 */
#define TOC3INT	0xFFE4	/*  Timer Output Compare 3 */
#define TOC2INT	0xFFE6	/*  Timer Output Compare 2 */
#define TOC1INT	0xFFE8	/*  Timer Output Compare 1 */
#define TIC3INT	0xFFEA	/*  Timer Input Capture 3 */
#define TIC2INT	0xFFEC	/*  Timer Input Capture 2 */
#define TIC1INT	0xFFEE	/*  Timer Input Capture 1 */
#define RTIINT	0xFFF0	/*  Real Time Interrupt */
#define IRQINT	0xFFF2	/*  IRQ External Interrupt */
#define XIRQINT	0xFFF4	/*  XIRQ External Interrupt */
#define SWIINT	0xFFF6	/*  Software Interrupt */
#define BADOPINT 0xFFF8	/*  Illegal Opcode Trap Interrupt */
#define NOCOPINT 0xFFFA	/*  COP Failure (Reset) */
#define CMEINT	0xFFFC	/*  COP Clock Monitor Fail (Reset) */
#define RESETINT 0xFFFE	/*  RESET Interrupt */

#define MASK_0	0x01
#define MASK_1	0x02
#define MASK_2	0x04
#define MASK_3	0x08
#define MASK_4	0x10
#define MASK_5	0x20
#define MASK_6	0x40
#define MASK_7	0x80

/*
void reset_interrupts(m6811 *state, byte *memory);
short idle_subsystems(byte *memory, m6811 *state);

void handle_swi (byte *memory, m6811 *state);
void handle_wai (byte *memory, m6811 *state);

void return_from_ISR(byte *memory, m6811 *state);

char * describe_irq(word vec_adr);

should be defined EXTERNALLY 

short serial_input (byte *memory, m6811 *state, byte *c);
short serial_output(byte *memory, m6811 * state, byte c);
void NotifyIRQToUser(word vec_adr, m6811 * state, short pending);
*/

#endif
