
/* disassembler for 6811 */

/* all instructions are now fully supported, except addd */

/*$Log: dis.c,v $
 * Revision 1.5  1993/05/28  06:04:55  ted
 * fully bracked initializers to get rid of complaints from gcc,
 * and cleaned up bad type declaration for init_dis
 *
 * Revision 1.4  1993/03/02  05:45:00  ted
 * fixed direct mode disassembly
 *
 * Revision 1.2  1993/01/27  23:22:34  ted
 * added some commands for multi-stepping and support for breakpoints
 * and disassembling
 *
 * Revision 1.2  1993/01/27  23:22:34  ted
 * added some commands for multi-stepping and support for breakpoints
 * and disassembling
 *

*/

#include "foreign.h"
#include <stdio.h>
#include "sim.h"
#include "symbols.h"

/** addressing modes **/
#define ILL 0 /* illegal */
#define IMM 1
#define IMM2 2
#define EXT 3
#define DIR 4
#define INDX 5
#define INDY 6
#define INH	7
#define SPC1 8 /* bset & bclr DIR */
#define SPC2 9 /* bset & bclr INDX */
#define SPC3 10 /* bset & bclr INDY */
#define REL 11
#define SPC4 12 /* brset & brclr DIR */
#define SPC5 13 /* brset & brclr INDX */
#define SPC6 14 /* brset & brclr INDY */
#define SPC7 15 /* daa */

char *format[] = { /*formats for addr. modes*/ 
        /* ILL 	*/	"",
	/* IMM	*/	"#%02x",
	/* IMM2 */	"#%02x%02x",
	/* EXT  */	"%02x%02x",
	/* DIR	*/	"%02x",
	/* INDX	*/	"%02x,x",
	/* INDY */	"%02x,y",
	/* INH	*/	"",
	/* SPC1 */	"%02x	%02x ",
	/* SPC2	*/	"%02x,x %02x ",
	/* SPC3	*/	"%02x,y %02x ",
	/* REL  */	"",
	/* SPC4 */	"%02x    %02x     ",
	/* SPC5 */	"%02x,x  %02x     ",
	/* SPC6 */	"%02x,y  %02x     ",
	/* SPC7 */	"unsupported %02x %02x %02x %02x"
};

typedef struct {
    char *name;			/* the name of the op code */
    short mode;			/* the addr. mode */
    short bytes;			/* the number of bytes (excluding prefix) */
} disop;

disop page1[] = {		/* unprefixed instructions */
    /* 0x00 */ {"test", INH, 1}, /* 0x01 */ {"nop", INH, 1},
    /* 0x02 */ {"idiv", INH, 1}, /* 0x03 */ {"fdiv", INH, 1},
    /* 0x04 */ {"lsrd", INH, 1}, /* 0x05 */ {"asld", INH, 1},
    /* 0x06 */ {"tap", INH, 1}, /* 0x07 */ {"tpa", INH, 1},
    /* 0x08 */ {"inx", INH, 1}, /* 0x09 */ {"dex", INH, 1},
    /* 0x0a */ {"clv", INH, 1}, /* 0x0b */ {"sev", INH, 1},
    /* 0x0c */ {"clc", INH, 1}, /* 0x0d */ {"sec", INH, 1},
    /* 0x0e */ {"cli", INH, 1}, /* 0x0f */ {"sei", INH, 1},
    /* 0x10 */ {"sba", INH, 1}, /* 0x11 */ {"cba", INH, 1},
    /* 0x12 */ {"brset", SPC4, 4}, /* 0x13 */ {"brclr", SPC4, 4}, 
    /* 0x14 */ {"bset", SPC1, 3}, /* 0x15 */ {"bclr", SPC1, 3},  
    /* 0x16 */ {"tab", INH, 1}, /* 0x17 */ {"tba", INH, 1},
    /* 0x18 */ {"place holder", ILL, 0}, /* 0x19 */ {"daa", SPC7, 1},
    /* 0x1a */ {"place holder", ILL, 0}, /* 0x1b */ {"aba", INH, 1},
    /* 0x1c */ {"bset", SPC2, 3}, /* 0x1d */ {"bclr", SPC2, 3}, 
    /* 0x1e */ {"brset", SPC5, 4}, /* 0x1f */ {"brclr", SPC5, 4},
    /* 0x20 */ {"bra", REL, 2}, /* 0x21 */ {"brn", REL, 2},
    /* 0x22 */ {"bhi", REL, 2}, /* 0x23 */ {"bls", REL, 2},
    /* 0x24 */ {"bcc", REL, 2}, /* 0x25 */ {"bcs", REL, 2},
    /* 0x26 */ {"bne", REL, 2}, /* 0x27 */ {"beq", REL, 2},
    /* 0x28 */ {"bvc", REL, 2}, /* 0x29 */ {"bvs", REL, 2},
    /* 0x2a */ {"bpl", REL, 2}, /* 0x2b */ {"bmi", REL, 2},
    /* 0x2c */ {"bge", REL, 2}, /* 0x2d */ {"blt", REL, 2},
    /* 0x2e */ {"bgt", REL, 2}, /* 0x2f */ {"ble", REL, 2},
    /* 0x30 */ {"tsx", INH, 1}, /* 0x31 */ {"ins", INH, 1},
    /* 0x32 */ {"pula", INH, 1}, /* 0x33 */ {"pulb", INH, 1},
    /* 0x34 */ {"des", INH, 1}, /* 0x35 */ {"txs", INH, 1},
    /* 0x36 */ {"psha", INH, 1}, /* 0x37 */ {"pshb", INH, 1},
    /* 0x38 */ {"pulx", INH, 1}, /* 0x39 */ {"rts", INH, 1},
    /* 0x3a */ {"abx", INH, 1}, /* 0x3b */ {"rti", INH, 1},
    /* 0x3c */ {"pshx", INH, 1}, /* 0x3d */ {"mul", INH, 1},
    /* 0x3e */ {"wai", INH, 1}, /* 0x3f */ {"swi", INH, 1},
    /* 0x40 */ {"nega", INH, 1}, /* 0x41 */ {"illegal", ILL, 1},
    /* 0x42 */ {"illegal", ILL, 1}, /* 0x43 */ {"coma", INH, 1},
    /* 0x44 */ {"lsra", INH, 1}, /* 0x45 */ {"illegal", ILL, 1},
    /* 0x46 */ {"rora", INH, 1}, /* 0x47 */ {"asra", INH, 1},
    /* 0x48 */ {"asla", INH, 1}, /* 0x49 */ {"rola", INH, 1},
    /* 0x4a */ {"deca", INH, 1}, /* 0x4b */ {"illegal", ILL, 1},
    /* 0x4c */ {"inca", INH, 1}, /* 0x4d */ {"tsta", INH, 1},
    /* 0x4e */ {"illegal", ILL, 1}, /* 0x4f */ {"clra", INH, 1},
    /* 0x50 */ {"negb", INH, 1}, /* 0x51 */ {"illegal", ILL, 1},
    /* 0x52 */ {"illegal", ILL, 1}, /* 0x53 */ {"comb", INH, 1},
    /* 0x54 */ {"lsrb", INH, 1}, /* 0x55 */ {"illegal", ILL, 1},
    /* 0x56 */ {"rorb", INH, 1}, /* 0x57 */ {"asrb", INH, 1},
    /* 0x58 */ {"aslb", INH, 1}, /* 0x59 */ {"rolb", INH, 1},
    /* 0x5a */ {"decb", INH, 1}, /* 0x5b */ {"illegal", ILL, 1},
    /* 0x5c */ {"incb", INH, 1}, /* 0x5d */ {"tstb", INH, 1},
    /* 0x5e */ {"illegal", ILL, 1}, /* 0x5f */ {"clrb", INH, 1},
    /* 0x60 */ {"neg", INDX, 2}, /* 0x61 */ {"illegal", ILL, 1},
    /* 0x62 */ {"illegal", ILL, 1}, /* 0x63 */ {"com", INDX, 2},
    /* 0x64 */ {"lsr", INDX, 2}, /* 0x65 */ {"illegal", ILL, 1},
    /* 0x66 */ {"ror", INDX, 2}, /* 0x67 */ {"asr", INDX, 2},
    /* 0x68 */ {"asl", INDX, 2}, /* 0x69 */ {"rol", INDX, 2}, 
    /* 0x6a */ {"dec", INDX, 2}, /* 0x6b */ {"illegal", ILL, 1},
    /* 0x6c */ {"inc", INDX, 2}, /* 0x6d */ {"tst", INDX, 2},
    /* 0x6e */ {"jmp", INDX, 2}, /* 0x6f */ {"clr", INDX, 2},
    /* 0x70 */ {"neg", EXT, 3}, /* 0x71 */ {"illegal", ILL, 1},
    /* 0x72 */ {"illegal", ILL, 1}, /* 0x73 */ {"com", EXT, 3},
    /* 0x74 */ {"lsr", EXT, 3}, /* 0x75 */ {"illegal", ILL, 1},
    /* 0x76 */ {"ror", EXT, 3}, /* 0x77 */ {"asr", EXT, 3},
    /* 0x78 */ {"asl", EXT, 3}, /* 0x79 */ {"rol", EXT, 3},
    /* 0x7a */ {"dec", EXT, 3}, /* 0x7b */ {"illegal", ILL, 1},
    /* 0x7c */ {"inc", EXT, 3}, /* 0x7d */ {"tst", EXT, 3},
    /* 0x7e */ {"jmp", EXT, 3}, /* 0x7f */ {"clr", EXT, 3},
    /* 0x80 */ {"suba", IMM, 2}, /* 0x81 */ {"cmpa", IMM, 2},
    /* 0x82 */ {"sbca", IMM, 2}, /* 0x83 */ {"subd", IMM2, 3}, 
    /* 0x84 */ {"anda", IMM, 2}, /* 0x85 */ {"bita", IMM, 2}, 
    /* 0x86 */ {"ldaa", IMM, 2}, /* 0x87 */ {"illegal", ILL, 1},
    /* 0x88 */ {"eora", IMM, 2}, /* 0x89 */ {"adca", IMM, 2},
    /* 0x8a */ {"ora", IMM, 2}, /* 0x8b */ {"adda", IMM, 2},
    /* 0x8c */ {"cpx", IMM2, 3}, /* 0x8d */ {"bsr", REL, 2},
    /* 0x8e */ {"lds", IMM2, 3}, /* 0x8f */ {"xgdx", INH, 1},
    /* 0x90 */ {"suba", DIR, 2}, /* 0x91 */ {"cmpa", DIR, 2}, 
    /* 0x92 */ {"sbca", DIR, 2}, /* 0x93 */ {"subd", DIR, 2},
    /* 0x94 */ {"anda", DIR, 2}, /* 0x95 */ {"bita", DIR, 2}, 
    /* 0x96 */ {"ldaa", DIR, 2}, /* 0x97 */ {"staa", DIR, 2},  
    /* 0x98 */ {"eora", DIR, 2}, /* 0x99 */ {"adca", DIR, 2}, 
    /* 0x9a */ {"ora", DIR, 2}, /* 0x9b */ {"adda", DIR, 2}, 
    /* 0x9c */ {"cpx", DIR, 2}, /* 0x9d */ {"jsr", DIR, 2},
    /* 0x9e */ {"lds", DIR, 2}, /* 0x9f */ {"sts", DIR, 2},
    /* 0xa0 */ {"suba", INDX, 2}, /* 0xa1 */ {"cmpa", INDX, 2},
    /* 0xa2 */ {"sbca", INDX, 2}, /* 0xa3 */ {"subd", INDX, 2},
    /* 0xa4 */ {"anda", INDX, 2}, /* 0xa5 */ {"bita", INDX, 2},
    /* 0xa6 */ {"ldaa", INDX, 2}, /* 0xa7 */ {"staa", INDX, 2},
    /* 0xa8 */ {"eora", INDX, 2}, /* 0xa9 */ {"adca", INDX, 2},
    /* 0xaa */ {"ora", INDX, 2}, /* 0xab */ {"adda", INDX, 2},
    /* 0xac */ {"cpx", INDX, 2}, /* 0xad */ {"jsr", INDX, 2},
    /* 0xae */ {"lds", INDX, 2}, /* 0xaf */ {"sts", INDX, 2},
    
    /* 0xb0 */ {"suba", EXT, 3}, /* 0xb1 */ {"cmpa", EXT, 3},
    /* 0xb2 */ {"sbca", EXT, 3}, /* 0xb3 */ {"subd", EXT, 3},
    /* 0xb4 */ {"anda", EXT, 3}, /* 0xb5 */ {"bita", EXT, 3},
    /* 0xb6 */ {"ldaa", EXT, 3}, /* 0xb7 */ {"staa", EXT, 3},
    /* 0xb8 */ {"eora", EXT, 3}, /* 0xb9 */ {"adca", EXT, 3},
    /* 0xba */ {"ora", EXT, 3}, /* 0xbb */ {"adda", EXT, 3},
    /* 0xbc */ {"cpx", EXT, 3}, /* 0xbd */ {"jsr", EXT, 3},
    /* 0xbe */ {"lds", EXT, 3}, /* 0xbf */ {"sts", EXT, 3},
    /* 0xc0 */ {"subb", IMM, 2}, /* 0xc1 */ {"cmpb", IMM, 2},
    /* 0xc2 */ {"sbcb", IMM, 2}, /* 0xc3 */ {"addd", IMM2, 3},
    /* 0xc4 */ {"andb", IMM, 2}, /* 0xc5 */ {"bitb", IMM, 2},
    /* 0xc6 */ {"ldab", IMM, 2}, /* 0xc7 */ {"illegal", ILL, 1},
    /* 0xc8 */ {"eorb", IMM, 2}, /* 0xc9 */ {"adcb", IMM, 2},
    /* 0xca */ {"orab", IMM, 2}, /* 0xcb */ {"addb", IMM, 2},
    /* 0xcc */ {"ldd", IMM2, 3}, /* 0xcd */ {"place holder", ILL, 0},
    /* 0xce */ {"ldx", IMM2, 3}, /* 0xcf */ {"stop", INH, 1},
    /* 0xd0 */ {"subb", DIR, 2}, /* 0xd1 */ {"cmpb", DIR, 2}, 
    /* 0xd2 */ {"sbcb", DIR, 2}, /* 0xd3 */ {"addd", DIR, 2},
    /* 0xd4 */ {"andb", DIR, 2}, /* 0xd5 */ {"bitb", DIR, 2}, 
    /* 0xd6 */ {"ldab", DIR, 2}, /* 0xd7 */ {"stab", DIR, 2},
    /* 0xd8 */ {"eorb", DIR, 2}, /* 0xd9 */ {"adcb", DIR, 2}, 
    /* 0xda */ {"orab", DIR, 2}, /* 0xdb */ {"addb", DIR, 2}, 
    /* 0xdc */ {"ldd", DIR, 2}, /* 0xdd */ {"std", DIR, 2},
    /* 0xde */ {"ldx", DIR, 2}, /* 0xdf */ {"stx", DIR, 2},
    
    /* 0xe0 */ {"subb", INDX, 2}, /* 0xe1 */ {"cmpb", INDX, 2},
    /* 0xe2 */ {"sbcb", INDX, 2}, /* 0xe3 */ {"addd", INDX, 2},
    /* 0xe4 */ {"andb", INDX, 2}, /* 0xe5 */ {"bitb", INDX, 2},
    /* 0xe6 */ {"ldab", INDX, 2}, /* 0xe7 */ {"stab", INDX, 2},
    /* 0xe8 */ {"eorb", INDX, 2}, /* 0xe9 */ {"adcb", INDX, 2},
    /* 0xea */ {"orb", INDX, 2}, /* 0xeb */ {"addb", INDX, 2},
    /* 0xec */ {"ldd", INDX, 2}, /* 0xed */ {"std", INDX, 2},
    /* 0xee */ {"ldx", INDX, 2}, /* 0xef */ {"stx", INDX, 2},
    
    /* 0xf0 */ {"subb", EXT, 3}, /* 0xf1 */ {"cmpb", EXT, 3},
    /* 0xf2 */ {"sbcb", EXT, 3}, /* 0xf3 */ {"addd", EXT, 3},
    /* 0xf4 */ {"andb", EXT, 3}, /* 0xf5 */ {"bitb", EXT, 3},
    /* 0xf6 */ {"ldab", EXT, 3}, /* 0xf7 */ {"stab", EXT, 3},
    /* 0xf8 */ {"eorb", EXT, 3}, /* 0xf9 */ {"adcb", EXT, 3},
    /* 0xfa */ {"orb", EXT, 3}, /* 0xfb */ {"addb", EXT, 3},
    /* 0xfc */ {"ldd", EXT, 3}, /* 0xfd */ {"std", EXT, 3},
    /* 0xfe */ {"ldx", EXT, 3}, /* 0xff */ {"stx", EXT, 3},
};

disop page2[] = {		/* ops prefixed by page2 prefix */
    /* 00 */ {"illegal", ILL, 1}, /* 01 */ {"illegal", ILL, 1},
    /* 02 */ {"illegal", ILL, 1}, /* 03 */ {"illegal", ILL, 1},
    /* 04 */ {"illegal", ILL, 1}, /* 05 */ {"illegal", ILL, 1},
    /* 06 */ {"illegal", ILL, 1}, /* 07 */ {"illegal", ILL, 1},
    /* 08 */ {"iny", INH, 2}, /* 09 */ {"dey", INH, 2},
    /* 0a */ {"illegal", ILL, 1}, /* 0b */ {"illegal", ILL, 1},
    /* 0c */ {"illegal", ILL, 1}, /* 0d */ {"illegal", ILL, 1},
    /* 0e */ {"illegal", ILL, 1}, /* 0f */ {"illegal", ILL, 1},
    /* 10 */ {"illegal", ILL, 1}, /* 11 */ {"illegal", ILL, 1},
    /* 12 */ {"illegal", ILL, 1}, /* 13 */ {"illegal", ILL, 1},
    /* 14 */ {"illegal", ILL, 1}, /* 15 */ {"illegal", ILL, 1},
    /* 16 */ {"illegal", ILL, 1}, /* 17 */ {"illegal", ILL, 1},
    /* 18 */ {"illegal", ILL, 1}, /* 19 */ {"illegal", ILL, 1},
    /* 1a */ {"illegal", ILL, 1}, /* 1b */ {"illegal", ILL, 1},
    /* 1c */ {"bset", SPC3, 4}, /* 1d */ {"bclr", SPC3, 4},
    /* 1e */ {"brset", SPC6, 5},
    /* 1f */ {"brclr", SPC6, 5}, 
    /* 20 */ {"illegal", ILL, 1}, /* 21 */ {"illegal", ILL, 1},
    /* 22 */ {"illegal", ILL, 1}, /* 23 */ {"illegal", ILL, 1},
    /* 24 */ {"illegal", ILL, 1}, /* 25 */ {"illegal", ILL, 1},
    /* 26 */ {"illegal", ILL, 1}, /* 27 */ {"illegal", ILL, 1},
    /* 28 */ {"illegal", ILL, 1}, /* 29 */ {"illegal", ILL, 1},
    /* 2a */ {"illegal", ILL, 1}, /* 2b */ {"illegal", ILL, 1},
    /* 2c */ {"illegal", ILL, 1}, /* 2d */ {"illegal", ILL, 1},
    /* 2e */ {"illegal", ILL, 1}, /* 2f */ {"illegal", ILL, 1},
    /* 30 */ {"tsy", INH, 2}, /* 31 */ {"illegal", ILL, 1},
    /* 32 */ {"illegal", ILL, 1}, /* 33 */ {"illegal", ILL, 1},
    /* 34 */ {"illegal", ILL, 1}, /* 35 */ {"tys", INH, 2},
    /* 36 */ {"illegal", ILL, 1}, /* 37 */ {"illegal", ILL, 1},
    /* 38 */ {"puly", INH, 2}, /* 39 */ {"illegal", ILL, 1},
    /* 3a */ {"aby", INH, 2}, /* 3b */ {"illegal", ILL, 1},
    /* 3c */ {"pshy", INH, 2}, /* 3d */ {"illegal", ILL, 1},
    /* 3e */ {"illegal", ILL, 1}, /* 3f */ {"illegal", ILL, 1},
    /* 40 */ {"illegal", ILL, 1}, /* 41 */ {"illegal", ILL, 1},
    /* 42 */ {"illegal", ILL, 1}, /* 43 */ {"illegal", ILL, 1},
    /* 44 */ {"illegal", ILL, 1}, /* 45 */ {"illegal", ILL, 1},
    /* 46 */ {"illegal", ILL, 1}, /* 47 */ {"illegal", ILL, 1},
    /* 48 */ {"illegal", ILL, 1}, /* 49 */ {"illegal", ILL, 1},
    /* 4a */ {"illegal", ILL, 1}, /* 4b */ {"illegal", ILL, 1},
    /* 4c */ {"illegal", ILL, 1}, /* 4d */ {"illegal", ILL, 1},
    /* 4e */ {"illegal", ILL, 1}, /* 4f */ {"illegal", ILL, 1},
    /* 50 */ {"illegal", ILL, 1}, /* 51 */ {"illegal", ILL, 1},
    /* 52 */ {"illegal", ILL, 1}, /* 53 */ {"illegal", ILL, 1},
    /* 54 */ {"illegal", ILL, 1}, /* 55 */ {"illegal", ILL, 1},
    /* 56 */ {"illegal", ILL, 1}, /* 57 */ {"illegal", ILL, 1},
    /* 58 */ {"illegal", ILL, 1}, /* 59 */ {"illegal", ILL, 1},
    /* 5a */ {"illegal", ILL, 1}, /* 5b */ {"illegal", ILL, 1},
    /* 5c */ {"illegal", ILL, 1}, /* 5d */ {"illegal", ILL, 1},
    /* 5e */ {"illegal", ILL, 1}, /* 5f */ {"illegal", ILL, 1},
    /* 60 */ {"neg", INDY, 3}, /* 61 */ {"illegal", ILL, 1},
    /* 62 */ {"illegal", ILL, 1}, /* 63 */ {"com", INDY, 3},
    /* 64 */ {"lsr", INDY, 3}, /* 65 */ {"illegal", ILL, 1},
    /* 66 */ {"ror", INDY, 3}, /* 67 */ {"asr", INDY, 3},
    /* 68 */ {"asl", INDY, 3}, /* 69 */ {"rol", INDY, 3},
    /* 6a */ {"dec", INDY, 3}, /* 6b */ {"illegal", ILL, 1},
    /* 6c */ {"inc", INDY, 3}, /* 6d */ {"tst", INDY, 3},
    /* 6e */ {"jmp", INDY, 3}, /* 6f */ {"clr", INDY, 3},
    /* 70 */ {"illegal", ILL, 1}, /* 71 */ {"illegal", ILL, 1},
    /* 72 */ {"illegal", ILL, 1}, /* 73 */ {"illegal", ILL, 1},
    /* 74 */ {"illegal", ILL, 1}, /* 75 */ {"illegal", ILL, 1},
    /* 76 */ {"illegal", ILL, 1}, /* 77 */ {"illegal", ILL, 1},
    /* 78 */ {"illegal", ILL, 1}, /* 79 */ {"illegal", ILL, 1},
    /* 7a */ {"illegal", ILL, 1}, /* 7b */ {"illegal", ILL, 1},
    /* 7c */ {"illegal", ILL, 1}, /* 7d */ {"illegal", ILL, 1},
    /* 7e */ {"illegal", ILL, 1}, /* 7f */ {"illegal", ILL, 1},
    /* 80 */ {"illegal", ILL, 1}, /* 81 */ {"illegal", ILL, 1},
    /* 82 */ {"illegal", ILL, 1}, /* 83 */ {"illegal", ILL, 1},
    /* 84 */ {"illegal", ILL, 1}, /* 85 */ {"illegal", ILL, 1},
    /* 86 */ {"illegal", ILL, 1}, /* 87 */ {"illegal", ILL, 1},
    /* 88 */ {"illegal", ILL, 1}, /* 89 */ {"illegal", ILL, 1},
    /* 8a */ {"illegal", ILL, 1}, /* 8b */ {"illegal", ILL, 1},
    /* 8c */ {"cpy", IMM2, 4}, /* 8d */ {"illegal", ILL, 1},
    /* 8e */ {"illegal", ILL, 1}, /* 8f */ {"xgdy", INH, 2},
    /* 90 */ {"illegal", ILL, 1}, /* 91 */ {"illegal", ILL, 1},
    /* 92 */ {"illegal", ILL, 1}, /* 93 */ {"illegal", ILL, 1},
    /* 94 */ {"illegal", ILL, 1}, /* 95 */ {"illegal", ILL, 1},
    /* 96 */ {"illegal", ILL, 1}, /* 97 */ {"illegal", ILL, 1},
    /* 98 */ {"illegal", ILL, 1}, /* 99 */ {"illegal", ILL, 1},
    /* 9a */ {"illegal", ILL, 1}, /* 9b */ {"illegal", ILL, 1},
    /* 9c */ {"cpy", DIR, 3}, /* 9d */ {"illegal", ILL, 1},
    /* 9e */ {"illegal", ILL, 1}, /* 9f */ {"illegal", ILL, 1},
    /* a0 */ {"suba", INDY, 3}, /* a1 */ {"cmpa", INDY, 3},
    /* a2 */ {"sbca", INDY, 3}, /* a3 */ {"subd", INDY, 3},
    /* a4 */ {"anda", INDY, 3}, /* a5 */ {"bita", INDY, 3},
    /* a6 */ {"ldaa", INDY, 3}, /* a7 */ {"staa", INDY, 3},
    /* a8 */ {"eora", INDY, 3}, /* a9 */ {"adca", INDY, 3},
    /* aa */ {"ora", INDY, 3}, /* ab */ {"adda", INDY, 3},
    /* ac */ {"cpy", INDY, 3}, /* ad */ {"jsr", INDY, 3},
    /* ae */ {"illegal", ILL, 1}, /* af */ {"sts", INDY, 3},
    /* b0 */ {"illegal", ILL, 1}, /* b1 */ {"illegal", ILL, 1},
    /* b2 */ {"illegal", ILL, 1}, /* b3 */ {"illegal", ILL, 1},
    /* b4 */ {"illegal", ILL, 1}, /* b5 */ {"illegal", ILL, 1},
    /* b6 */ {"illegal", ILL, 1}, /* b7 */ {"illegal", ILL, 1},
    /* b8 */ {"illegal", ILL, 1}, /* b9 */ {"illegal", ILL, 1},
    /* ba */ {"illegal", ILL, 1}, /* bb */ {"illegal", ILL, 1},
    /* bc */ {"cpy", EXT, 4}, /* bd */ {"illegal", ILL, 1},
    /* be */ {"illegal", ILL, 1}, /* bf */ {"illegal", ILL, 1},
    /* c0 */ {"illegal", ILL, 1}, /* c1 */ {"illegal", ILL, 1},
    /* c2 */ {"illegal", ILL, 1}, /* c3 */ {"illegal", ILL, 1},
    /* c4 */ {"illegal", ILL, 1}, /* c5 */ {"illegal", ILL, 1},
    /* c6 */ {"illegal", ILL, 1}, /* c7 */ {"illegal", ILL, 1},
    /* c8 */ {"illegal", ILL, 1}, /* c9 */ {"illegal", ILL, 1},
    /* ca */ {"illegal", ILL, 1}, /* cb */ {"illegal", ILL, 1},
    /* cc */ {"illegal", ILL, 1}, /* 0xcd */ {"illegal", ILL, 1},
    /* ce */ {"ldy", IMM2, 4}, /* cf */ {"illegal", ILL, 1},
    /* d0 */ {"illegal", ILL, 1}, /* d1 */ {"illegal", ILL, 1},
    /* d2 */ {"illegal", ILL, 1}, /* d3 */ {"illegal", ILL, 1},
    /* d4 */ {"illegal", ILL, 1}, /* d5 */ {"illegal", ILL, 1},
    /* d6 */ {"illegal", ILL, 1}, /* d7 */ {"illegal", ILL, 1},
    /* d8 */ {"illegal", ILL, 1}, /* d9 */ {"illegal", ILL, 1},
    /* da */ {"illegal", ILL, 1}, /* db */ {"illegal", ILL, 1},
    /* dc */ {"illegal", ILL, 1}, /* dd */ {"illegal", ILL, 1},
    /* de */ {"ldy", DIR, 3}, /* df */ {"sty", DIR, 3},
    /* e0 */ {"subb", INDY, 3}, /* e1 */ {"cmpb", INDY, 3},
    /* e2 */ {"sbcb", INDY, 3}, /* e3 */ {"addd", INDY, 3},
    /* e4 */ {"andb", INDY, 3}, /* e5 */ {"bitb", INDY, 3},
    /* e6 */ {"ldab", INDY, 3}, /* e7 */ {"stab", INDY, 3},
    /* e8 */ {"eorb", INDY, 3}, /* e9 */ {"adcb", INDY, 3},
    /* ea */ {"orb", INDY, 3}, /* eb */ {"addb", INDY, 3},
    /* ec */ {"ldad", INDY, 3}, /* ed */ {"std", INDY, 3},
    /* ee */ {"ldy", INDY, 3}, /* ef */ {"sty", INDY, 3},
    /* f0 */ {"illegal", ILL, 1}, /* f1 */ {"illegal", ILL, 1},
    /* f2 */ {"illegal", ILL, 1}, /* f3 */ {"illegal", ILL, 1},
    /* f4 */ {"illegal", ILL, 1}, /* f5 */ {"illegal", ILL, 1},
    /* f6 */ {"illegal", ILL, 1}, /* f7 */ {"illegal", ILL, 1},
    /* f8 */ {"illegal", ILL, 1}, /* f9 */ {"illegal", ILL, 1},
    /* fa */ {"illegal", ILL, 1}, /* fb */ {"illegal", ILL, 1},
    /* fc */ {"illegal", ILL, 1}, /* fd */ {"illegal", ILL, 1},
    /* fe */ {"ldy", EXT, 4}, /* ff */ {"sty", EXT, 4},
};

disop page3[256];		/* only a few ops follow page 3 prefix */
disop page4[256];		/* and even fewer follow page 4 prefix */

/* initialization is from sparse vectors */
typedef struct { short index; disop op; } dis_init;

dis_init page3_inits[] = {
    {0x83, {"cmpd", IMM2, 4}},
    {0x93, {"cmpd", DIR, 3}},
    {0xa3, {"cmpd", INDX, 3}},
    {0xac, {"cmpd", INDY, 3}},
    {0xb3, {"cmpd", EXT, 4}},
    {0xee, {"ldy", INDX, 3}},
    {0xef, {"sty", INDX, 3}},
    {0, {"", 0, 0}},
};

dis_init page4_inits[] = {
    {0xa3, {"cmpd", INDY, 3}},
    {0xac, {"cpx", INDY, 3}},
    {0xee, {"ldx", INDY, 3}},
    {0xef, {"stx", INDY, 3}},
    {0, {"", 0, 0}},
};

Boolean initialized = FALSE;


short disassemble(FILE *buf, byte *code, word add)
/* 	disassemble a byte stream (one instruction per call)
	for chained prints, we have to pass the char bufer
	returns the number of disassembled bytes */
{
  
  disop op; 
  word nn;
  char *s;
  
  if (!initialized) { /*Error("dis not initialized correctly")*/; } 
  if (buf == NULL) { 
    /* Error("passed NULL buffer to disassemble()"); */
    return 0; }
  
  code += add;
  switch (code[0]) {
  case 0x18:			/* page 2 prefix? */
    code++;
    op = page2[*code];
    break;
  case 0x1a:			/* page 3? */
    code++;
    op = page3[*code];
    break;
  case 0xcd:			/* page 4? */
    code++;
    op = page4[*code];
    break;
  default:			/* none of above, must be page 1 */
    op = page1[*code];
    break;
  }
  
  printf("%s     ", op.name);
  fflush(stdout);

  switch(op.mode) { 
  case IMM:
  case DIR:
    s = lookup_val( nn = code[1] & 0xff );
    if (s==NULL) goto Default;
    if (op.mode==IMM)
      fprintf(buf, "#%s", s);
    else
      fprintf(buf, "%s", s);
    break;
  case IMM2:
  case EXT:
    s = lookup_val( nn = ((code[1]<<8)+code[2]) & 0xffff );
    if (s==NULL) goto Default;
    if (op.mode==IMM2)
      fprintf(buf, "#%s", s);
    else 
      fprintf(buf, "%s", s);
    break;
  case INDX:
  case INDY:
    s = lookup_val( nn = code[1] & 0xff );
    if (s==NULL) goto Default;
    if (op.mode==INDX)
      fprintf(buf, "%s,x", s);
    else
      fprintf(buf, "%s,y", s);
    break;
  case REL: 
    s = lookup_val( nn = add+2+(signed char)code[1] );
    if (s!=NULL) 
      fprintf(buf, "%-8s", s);
    else 
      fprintf(buf, "%04lx    ",nn);
    break;
  case SPC4:
  case SPC5: 
    s = lookup_val( nn = add+4+(signed char)code[3] );
    if (s!=NULL) 
      fprintf(buf, "%-8s",s);
    else 
      fprintf(buf, "%04lx    ",nn);
    break;
  case SPC6:
    s = lookup_val( nn = add+5+(signed char)code[3] );
    if (s!=NULL) 
      fprintf(buf, "%-8s",s);
    else 
      fprintf(buf, "%04lx    ",nn);
    break;
  Default:
  default:
    fprintf(buf, format[op.mode], code[1], code[2], code[3]); 
    break;
  };

  fprintf(buf, "\n");
  fflush(stderr);

  return op.bytes;
}




disop illegal_op = {"illegal", ILL, 1};


void init_dis()
/* initialization consists of reading the sparse page 3 and 4 initialization
   records and stuffing them into the real page 3 and 4 */
{
  short i;
  
  initialized = TRUE;
  
  /*****
    if ((f = fopen(sym_fname,"r"))!=NULL)
    {
    init_symbols();
    load_symbols(f,sym_fname);
    }
    else 
    Error("can't find special '%s' file",sym_fname);
    ;
    ****/
  
  for (i=0;i<256;i++) {
    page3[i] = illegal_op;
    page4[i] = illegal_op;
  }
  
  for (i=0;page3_inits[i].index;i++) {
    page3[page3_inits[i].index] = page3_inits[i].op;
    }
  
  for (i=0;page4_inits[i].index;i++) {
    page4[page4_inits[i].index] = page4_inits[i].op;
  }
}







