/*

Freely Distributable 68HC11 Simulator Package

Copyright (c) 1997-1998 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
  
The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Authors: Brian Evans and Saleem Marway
Version: @(#)commands.h	1.2	01/19/98

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

#ifndef COMMANDS_H
#define COMMANDS_H

#include <stdio.h>

#include "sim.h"

struct MCSimState_t {
    m6811* state;
    byte*  memory;
    short* breaks;
    char*  filename;
    int    load;
};
typedef struct MCSimState_t MCSimState;

struct MCSimCommandFunctions_t {
    const char* name;
    int length;
    int (*function)(const char*, MCSimState*);
    const char* comment;
};

typedef struct MCSimCommandFunctions_t MCSimCommandFunctions;

const char* MCSimCommandErrorMessage(int errorNumber);

int MCSimBreakAddCommand(const char* input, MCSimState* mcsimptr);
int MCSimBreakDelCommand(const char* input, MCSimState* mcsimptr);
int MCSimCopyrightCommand(const char* input, MCSimState* mcsimptr);
int MCSimCycleCommand(const char* input, MCSimState* mcsimptr);
int MCSimDasmOffCommand(const char* input, MCSimState* mcsimptr);
int MCSimDasmOnCommand(const char* input, MCSimState* mcsimptr);
int MCSimDisassembleCommand(const char* input, MCSimState* mcsimptr);
int MCSimDisplayMemoryCommand(const char* input, MCSimState* mcsimptr);
int MCSimDummyCommand(const char* input, MCSimState* mcsimptr );
int MCSimExitCommand(const char* input, MCSimState* mcsimptr);
int MCSimHelpCommand(const char* input, MCSimState* mcsimptr);
int MCSimInterruptCommand(const char* input, MCSimState* mcsimptr);
int MCSimLoadCommand(const char* input, MCSimState *mcsimptr);
int MCSimMC68StateCommand(const char* input, MCSimState *mcsimptr);
int MCSimNotAvailCommand(const char* input, MCSimState* mcsimptr);
int MCSimResetCommand(const char* input, MCSimState* mcsimptr);
int MCSimRunCommand(const char* input, MCSimState* mcsimptr);
int MCSimSetMemoryCommand(const char* input, MCSimState* mcsimptr);
int MCSimSetRegisterCommand(const char* input, MCSimState* mcsimptr);
int MCSimShowBreaksCommand(const char* input, MCSimState* mcsimptr);
int MCSimSimStateCommand(const char* input, MCSimState* mcsimptr);
int MCSimStepCommand(const char* input, MCSimState* mcsimptr);
int MCSimStateCommand(const char* input, MCSimState* mcsimptr);
int MCSimTempBreakCommand(const char* input, MCSimState* mcsimptr);
int MCSimVersionCommand(const char* input, MCSimState* mcsimptr);
 
/*
int MCSimAddBoard(const char* boardName, MCSimCommandFunctions* newCommands);
int MCSimFindBoardIdNum(const char* boardDesc);
MCSimCommandFunctions* MCSimBoardCommandTable(int boardId);
int MCSimInitSimState(MCSimState* MCsimptr, int processor, int board);
*/

MCSimCommandFunctions* MCSimSearchForFunction(
	    const char* input, MCSimCommandFunctions* commandInfo);
int MCSimEvaluateCommand(const char* input, MCSimState* mcsimptr);

#endif
