#ifndef	__simdev_h__
#define __simdev_h__


#include "vstruct.h"

#include <string.h>


/* pin value constants */
#define DSP_PINVAL_L 0		/* driven low output */
#define DSP_PINVAL_H 1		/* driven high output */
#define DSP_PINVAL_F 2		/* undriven input or output */
#define DSP_PINVAL_N 3		/* negative input pulse */
#define DSP_PINVAL_P 4		/* positive input pulse */
#define DSP_PINVAL_0 8		/* driven low input */
#define DSP_PINVAL_1 9		/* driven high input */
#define DSP_PINVAL_D 10		/* open drain high output */

/* port numbers */
#define DSP_PORT_M   0		/* mode pins, reset,irq, etc. */
#define DSP_PORT_A   1		/* address bus */
#define DSP_PORT_AA  1		/* 96k port a address bus */
#define DSP_PORT_CA  2		/* 96k bus control a */
#define DSP_PORT_B   2
#define DSP_PORT_CB  3		/* 96k bus control b */
#define DSP_PORT_C   3
#define DSP_PORT_D   4		/* data bus */
#define DSP_PORT_DA  4		/* 96k port a data bus */
#define DSP_PORT_AB  5		/* 96k port b address bus */
#define DSP_PORT_E   5		/* 56k port e */
#define DSP_PORT_DB  6		/* 96k port b data bus */
#define DSP_PORT_B1  6		/* 563 port B extention */
#define DSP_PORT_M1  6		/* 56030 port M extention */
#define DSP_PORT_DATA 7		/* 563 data bus */
#define DSP_PORT_X 8		/* 563 OnCE, PLL */
#define DSP_PORT_PMB    9       /* PMB port (for blm use only) */
#define DSP_PORT_MCAB   10
#define DSP_PORT_GDB    11
#define DSP_PORT_MDAB   12
#define DSP_PORT_MDDBN  13
#define DSP_PORT_MDRQN  14
#define DSP_PORT_DFMREN 15
#define DSP_PORT_MIRQN  16
#define DSP_PORT_VAB    17
#define DSP_PORT_PIVSSE 18


/* pin mask numbers */
#define DSP_BIT_0   0x1L
#define DSP_BIT_1   0x2L
#define DSP_BIT_2   0x4L
#define DSP_BIT_3   0x8L
#define DSP_BIT_4   0x10L
#define DSP_BIT_5   0x20L
#define DSP_BIT_6   0x40L
#define DSP_BIT_7   0x80L
#define DSP_BIT_8   0x100L
#define DSP_BIT_9   0x200L
#define DSP_BIT_10   0x400L
#define DSP_BIT_11   0x800L
#define DSP_BIT_12   0x1000L
#define DSP_BIT_13   0x2000L
#define DSP_BIT_14   0x4000L
#define DSP_BIT_15   0x8000L
#define DSP_BIT_16   0x10000L
#define DSP_BIT_17   0x20000L
#define DSP_BIT_18   0x40000L
#define DSP_BIT_19   0x80000L
#define DSP_BIT_20   0x100000L
#define DSP_BIT_21   0x200000L
#define DSP_BIT_22   0x400000L
#define DSP_BIT_23   0x800000L
#define DSP_BIT_24   0x1000000L
#define DSP_BIT_25   0x2000000L
#define DSP_BIT_26   0x4000000L
#define DSP_BIT_27   0x8000000L
#define DSP_BIT_28   0x10000000L
#define DSP_BIT_29   0x20000000L
#define DSP_BIT_30   0x40000000L
#define DSP_BIT_31   0x80000000L

/* Memory attributes */
#define DSP_MEMA_NONE 0x4L	/* NON-EXISTANT MEMORY FLAG BIT */
#define DSP_MEMA_WR_PROT 0x8L	/* WRITE PROTECT MEMORY FLAG BIT */
#define DSP_MEMA_EXTA 0x10L	/* EXTERNAL MEMORY REFERENCED THROUGH PORT A */
#define DSP_MEMA_EXTB 0x20L	/* EXTERNAL MEMORY REFERENCED THROUGH PORT B */
#define DSP_MEMA_DMA0 0X40L	/* FETCHED OR STORED BY DMA CONTROLLER 0 */
#define DSP_MEMA_DMA1 0X80L	/* FETCHED OR STORED BY DMA CONTROLLER 1 */
#define DSP_MEMA_ICACHE_WORD_HIT 0x100L
#define DSP_MEMA_ICACHE_SECTOR_HIT 0x200L
#define DSP_MEMA_ICACHE_MISS 0x400L
#define DSP_MEMA_ICACHE_LOCKED 0x800L
#define DSP_MEMA_EXEC 0X1000L
#define DSP_MEMA_DISP 0X2000L	/* able to be displayed */
#define DSP_MEMA_DON 0X4000L	/* COME ON WHEN DISPLAY ON COMMAND USED */
#define DSP_MEMA_ROM 0X8000L	/* HAS ROM VALUES FOR INITIALIZATION */
#define DSP_MEMA_PERIPH 0x10000L
#define DSP_MEMA_MULT 0x20000L	/* multiple memories exist with same name */
#define DSP_MEMA_IO   0x40000L	/* able to support IO functions */
#define DSP_MEMA_DMA 0X80000L
#define DSP_MEMA_DALU_BCONT 0x100000L
#define DSP_MEMA_BRK   0x200000L	/* able to support breakpoint functions */
#define DSP_MEMA_REAL  0x400000L	/* memory allocated for this */
#define DSP_MEMA_LOAD_PROT  0x800000L	/* write protect against load */
#define DSP_MEMA_EXT 0x1000000L	/* EXTERNAL MEMORY FLAG BIT */
#define DSP_MEMA_SPEC 0x2000000L	/* SPECIAL PROCESSING MEMORY LOCATION */
#define DSP_MEMA_RESERVED 0x4000000L	/* RESERVED memory (Not displayed with 
						"help map"*/
#define DSP_MEMA_SHARED 0x8000000L    /* SHARED memory - accessed from both
                                              core and peripherals */


/* these need to be the same as the corresponding register size attributes */
/* these are in the wordsize variable of the dt_memory memory description */
#define DSP_MEMW_WRDN 0X3L
#define DSP_MEMW_WRD1 0X1L	/* must be same as DSP_WRD1 */
#define DSP_MEMW_WRD2 0X2L	/* must be same as DSP_WRD2 */
#define DSP_MEMW_SIZEN  0xff400000l	/* memory size bits reserved, includes those below */
#define DSP_MEMW_SIZE64 0X00400000L	/* 64 bit memory size */
#define DSP_MEMW_SIZE48 0X00800000L	/* 48 bit memory size */
#define DSP_MEMW_SIZE36 0X01000000L	/* 36 bit memory size */
#define DSP_MEMW_SIZE32 0X02000000L	/* 32 bit memory size */
#define DSP_MEMW_SIZE24 0X04000000L	/* 24 bit memory size */
#define DSP_MEMW_SIZE20 0X08000000L     /* 12 bit memory size */
#define DSP_MEMW_SIZE16 0X10000000L	/* 16 bit memory size */
#define DSP_MEMW_SIZE12 0X20000000L     /* 12 bit memory size */
#define DSP_MEMW_SIZE8  0X40000000L	/* 8 bit memory size */
#define DSP_MEMW_SIZE4  0X80000000L	/* 4 bit memory size */

#define DSP_MEM_P	0X80000000L	/* Program memory */
#define DSP_MEM_X   	0X40000000L	/* x data memory */
#define DSP_MEM_Y  	0X20000000L	/* y data memory */
#define DSP_MEM_L 	0X10000000L	/* l data memory */
#define DSP_MEM_PA 	(DSP_MEM_P|0X08000000L)	/* uses A external port */
#define DSP_MEM_PB 	(DSP_MEM_P|0X04000000L)	/* uses B external port */
#define DSP_MEM_XA 	(DSP_MEM_X|0X02000000L)	/* uses A external port */
#define DSP_MEM_XB 	(DSP_MEM_X|0X01000000L)	/* uses B external port */
#define DSP_MEM_YA 	(DSP_MEM_Y|0X00800000L)	/* uses A external port */
#define DSP_MEM_YB 	(DSP_MEM_Y|0X00400000L)	/* uses B external port */
#define DSP_MEM_I 	0X00200000L	/* internal memory */
#define DSP_MEM_R  	0X00100000L	/* rom memory */
#define DSP_MEM_IC	0X00080000L	/* instruction cache memory */
#define DSP_MEM_EMI	0X00040000L	/* emi memory  */
#define DSP_MEM_DM	0X00020000L	/* direct access memory  */
#define DSP_MEM_S	0X00010000L	/* shared memory */

#define DSP_MEM_XS      (DSP_MEM_X|DSP_MEM_S) 	/* shared memory */
#define DSP_MEM_YS      (DSP_MEM_Y|DSP_MEM_S) 	/* shared memory */
#define DSP_MEM_PE 	(DSP_MEM_P|DSP_MEM_PA|DSP_MEM_PB)	/* external PA or PB only */
#define DSP_MEM_PI 	(DSP_MEM_P|DSP_MEM_I)	/* internal P ram only */
#define DSP_MEM_PR 	(DSP_MEM_P|DSP_MEM_R)	/* internal P rom only */
#define DSP_MEM_PG	(DSP_MEM_PE|DSP_MEM_PI|DSP_MEM_PR)	/* generic program memory P */
#define DSP_MEM_PIC	(DSP_MEM_PI|DSP_MEM_IC) /* internal P ram or cache */

#define DSP_MEM_XE 	(DSP_MEM_X|DSP_MEM_XA|DSP_MEM_XB)	/* external X only */
#define DSP_MEM_XI      (DSP_MEM_X|DSP_MEM_I)	/* internal X ram only */
#define DSP_MEM_XR 	(DSP_MEM_X|DSP_MEM_R)	/* internal X rom only */
#define DSP_MEM_XG	(DSP_MEM_XE|DSP_MEM_XI|DSP_MEM_XR)	/* generic X memory */

#define DSP_MEM_YE 	(DSP_MEM_Y|DSP_MEM_YA|DSP_MEM_YB)	/* external Y only */
#define DSP_MEM_YI      (DSP_MEM_Y|DSP_MEM_I)	/* internal Y ram only */
#define DSP_MEM_YR 	(DSP_MEM_Y|DSP_MEM_R)	/* internal Y rom only */
#define DSP_MEM_YG	(DSP_MEM_YE|DSP_MEM_YI|DSP_MEM_YR)	/* generic Y memory */

#define DSP_MEM_LI 	(DSP_MEM_L|DSP_MEM_I)	/* internal L memory */
#define DSP_MEM_LAA  	(DSP_MEM_L|DSP_MEM_XA|DSP_MEM_YA)	/* external L combinations */
#define DSP_MEM_LAB  	(DSP_MEM_L|DSP_MEM_XA|DSP_MEM_YB)
#define DSP_MEM_LBA  	(DSP_MEM_L|DSP_MEM_XB|DSP_MEM_YA)
#define DSP_MEM_LBB  	(DSP_MEM_L|DSP_MEM_XB|DSP_MEM_YB)
#define DSP_MEM_LE 	(DSP_MEM_LAA|DSP_MEM_LBB)	/* external L memory */
#define DSP_MEM_LG 	(DSP_MEM_LI|DSP_MEM_LE)		/* generic L memory  */

#define DSP_MEM_PT 	(DSP_MEM_IC|0X1L)	/* icache tags */
#define DSP_MEM_PF 	(DSP_MEM_IC|0X2L)	/* icache flags */

#define DSP_ON_DISK 1		/* possible values for dev_memlist.memf */
#define DSP_BLOCK_FILL 2
#define DSP_IN_MEMORY 4

#if ADSx
#define IN_L_SPACE(mem_space) (!!(dx_var->mem[dx_var->memxref[(int)(mem_space)]].subtypes & DSP_MEM_L))
#define IN_P_SPACE(mem_space) (!!(dx_var->mem[dx_var->memxref[(int)(mem_space)]].subtypes & DSP_MEM_P))
#define IN_X_SPACE(mem_space) (!!((dx_var->mem[dx_var->memxref[(int)(mem_space)]].subtypes & DSP_MEM_X) && !IN_L_SPACE(mem_space)))
#define IN_Y_SPACE(mem_space) (!!((dx_var->mem[dx_var->memxref[(int)(mem_space)]].subtypes & DSP_MEM_Y) && !IN_L_SPACE(mem_space)))

#endif /* ADSx */
/* these are indexes to global signals used by the simulator */
#define DSP_EXT_MODE 0
#define DSP_CLK_FREE 1
#define DSP_FLG_SEQN 2
#define DSP_FLG_STOP 3
#define DSP_CLK_STATE 4

/* GLOBAL STATUS FLAG BIT DEFINITIONS FOR FLG_STAT FIELDS */
#define DSP_GEOI 1		/* END OF INSTRUCTION */
#define DSP_GEOR 2		/* AT END OF 1 REPEAT CYCLE OF INSTRUCTION */
#define DSP_GILLEG 4		/* ILLEGAL OP CODE */
#define DSP_GNEWPC 8		/* NEW PC VALUE WRITTEN */
#define DSP_GBREAK 0X10		/* BREAK FLAG */
#define DSP_GOFF 0X20		/* DISABLED DEVICE FLAG */
#define DSP_GERR 0x40		/* ILLEGAL SITUATION - device dependent, use gerrptr*/

#define DSP_PR_NORM 0		/* FIRST STEP OF NORMAL PROCESSING SEQUENCE */
#define DSP_PR_RESET 1		/* START OF RESET PROCESSING */

#define DSP_PH0    0x100	/* PHASE 0 clock */
#define DSP_PH1	   0x200	/* PHASE 1 clock */
#define DSP_PH_EOC 0x100000L    /* END of clock cycle */

#define DSP_TICK0  (0x00400 | DSP_PH0)	/* PHASE 0 clock */
#define DSP_TICK0P (0x00800 | DSP_PH0)	/* PHASE 0 clock */
#define DSP_TICK1  (0x01000 | DSP_PH0)	/* PHASE 0 clock */
#define DSP_TICK1P (0x02000 | DSP_PH0)	/* PHASE 0 clock */
#define DSP_TICK2  (0x04000 | DSP_PH1)	/* PHASE 1 clock */
#define DSP_TICK2P (0x08000 | DSP_PH1)	/* PHASE 1 clock */
#define DSP_TICK3  (0x10000 | DSP_PH1)	/* PHASE 1 clock */
#define DSP_TICK3P (0x20000 | DSP_PH1 | DSP_PH_EOC)	/* PHASE 1 clock */

#define DSP_TICK_MASK   (DSP_TICK0 | DSP_TICK0P | DSP_TICK1 | DSP_TICK1P | DSP_TICK2 | DSP_TICK2P | DSP_TICK3 | DSP_TICK3P)


#define DSP_TPH0   0x1		/* T PHASES */
#define DSP_TPH0W  0x2
#define DSP_TPH1   0x4
#define DSP_TPH2   0x8
#define DSP_TPH2W  0x10
#define DSP_TPH3   0x20
#define DSP_TPH4   0x40
#define DSP_TPH2S  0x80

#define DSP_PHASE0 (DSP_TPH0|DSP_PH0)
#define DSP_PHASE1 (DSP_TPH1|DSP_PH1|DSP_PH_EOC)
#define DSP_PHASE0C (DSP_TPH0W|DSP_PH0)
#define DSP_PHASE0C_ (DSP_TPH0W|DSP_PH1|DSP_PH_EOC)
#define DSP_PHASE2 (DSP_TPH2|DSP_PH0)
#define DSP_PHASE3 (DSP_TPH3|DSP_PH1|DSP_PH_EOC)
#define DSP_PHASE2W (DSP_TPH2W|DSP_TPH2|DSP_PH0)		/* WAIT STATE WHILE EXECUTING EXTERNAL ACCESS WAIT CYCLES */
#define DSP_PHASE2W_ (DSP_TPH2W|DSP_PH1|DSP_PH_EOC)	/* WAIT STATE WHILE EXECUTING EXTERNAL ACCESS WAIT CYCLES */
#define DSP_PHASE0F (DSP_TPH4|DSP_PH0)	/* DATA ALU NORMALIZATION FREEZE CYCLES */
#define DSP_PHASEF (DSP_TPH4|DSP_PH1|DSP_PH_EOC)	/* DATA ALU NORMALIZATION FREEZE CYCLES */
#define DSP_PHASE2S (DSP_TPH2S|DSP_PH1|DSP_PH_EOC)		/* WAIT in PHASE 2 due to WAIT OR STOP INST */

#define REG_ILLEG (-1)
#define REG_NONE (-2)
#define BUS_NONE (-2)

#define FIRST_PASS 1
#define SECOND_PASS 2
#define THIRD_PASS 3



/**
 * global structure definitions
 **/

struct dev_garbage
{				/* used by virtual memory mechanism */
    struct dev_garbage *next;
    long offset;
};

struct dev_memlist
{				/* used by virtual memory mechanism */
    struct dev_memlist *next;	/* next block in memory circular list */
    struct dev_memlist *prev;	/* previous block in memory circular list */
    unsigned long add;		/* start address of this 256 word block */
    int memf;			/* on disk,blockfilled,or in memory */
    union
    {
	long disk;		/* Disk block if on disk  */
	long blok;		/*  block fill values for constant value mem blocks */
	unsigned long *memp;	/* pointers to allocated block of 256 memory */
    }
    memd;
};

struct dev_vmem
{				/* virtual memory reference structure */
    FILE *memfn;		/* File pointer used when blocks are swapped to disk. */
    struct dev_garbage *garbagep;	/* Disk next free block */
};

struct dev_xpdata
{
    unsigned long ind;		/* input binary data */
    unsigned long inf;		/* which pins are driven on input */
    unsigned long outd;		/* output binary data */
    unsigned long outf;		/* which pins are being driven on output */
    unsigned long outo;		/* which pins are open drain output */
    float aval[32];		/* pin analog values for each pin - assumes no i/o analog */
#if BLM
    unsigned long ias;		/* asynchronous input pin mask */
#endif
};

struct dev_xpval
{				/* structure that defines a device port */
    struct dev_xpdata pc,
     pp;			/* current cycle and previous cycle pin data */
};

struct dev_periph
{
    unsigned long *regval;	/* register value of all registers */

};

struct dev_memory
{
    struct dev_memlist *recent;	/* virtual mem most recent block referenced */
    struct dev_memlist *recent2;	/* virtual mem next most recent referenced */
    unsigned long *memval;	/* pointer to allocated on-chip memory */
    unsigned long disabled;     /* flag for disabled memory blocks */
};

struct dev_var
{
    int devtype;		/* index to the dev_const.dt device description */
    int devindex;		/* index to the dev_const.sv device pointer number */
    struct dev_periph *periph;	/* pointer to array of peripherals */
    struct dev_memory *mem;	/* pointer to array of memory structures */
    struct dev_vmem vmem;	/* virtual memory details */
    struct dev_xpval *xportval;	/* external pin and port data values */
    unsigned long reg_exec;	/* execution address of device equiv to pc */
    unsigned long reg_cycl;	/* cycle count */
    unsigned long reg_icnt;	/* instruction cycle count */
    double reg_pcnt;		/* phase count - same as reg_cycl, except advances in .5 increments */
    double real_time;		/* real time clock - advances based on clk_period value */
    double clk_period;		/* period of external clock source */
    unsigned long *gsig;	/* global signals */
    int flg_stat;
    int CTRLBR;			/* Control break flag from user keyboard interrupt */
    char pathwork[DSP_LINE_LEN];
#if ADSx
    unsigned long target_freq;  /* target clock frequency in Hz */
    unsigned long debug_freq;   /* target clock frequency in Hz in debug mode */
    unsigned long PLL_reg[2];   /* saved values of the PPL registers */
    unsigned long PLL_stat;     /* active inactive state of the PLL debug state
                                   0 - inactive
                                   1 - active
                                   2 - never been activated yet
                                 */
    unsigned long ocr_reg;      /* the OnCE OCR register copy */
    unsigned long cc_freq;      /* command converter frequency in Hz */
    unsigned long pipe[2];      /* pipe[0] = opilr, pipe[1] = opdbr */
    int pc_modified;            /* Set if pc is changed from the cmd line */
    unsigned long reg_sr;       /* Save off sr for 56811 only.  It must be
                                   restored when leaving debug mode */
    unsigned long pab_restore_value;
    int exec_method; /* 0 is normal, 1 is 811 int bug workaround method */
    int increment_lc;
#endif    
  /* SAMSON */
    struct vdevice_inst vd_inst;   /* vcx device instance structure */
};

/* each external port in xpid has the following info */
struct dt_xpid
{				/* structure that defines a device port */
    char *name;
    int portindex;		/* index to xportval structure */
    unsigned long portmask;	/* mask for port */
    int portindex2;		/* index to xportval2 structure */
    unsigned long portmask2;	/* mask for port2 */
};

struct dt_mfunc
{
#if ADSx    
    /* pointer to function to read value from memory */
    int (*readf) (enum memory_map, unsigned long, unsigned long,
                  unsigned long *);
    /* pointer to function to write value to memory */
    int (*writef) (enum memory_map, unsigned long, unsigned long,
                   unsigned long *);
#else
    /* pointer to function to read value from memory */    
    int (*readf) (enum memory_map, unsigned long, unsigned long *);
    /* pointer to function to write value to memory */
    int (*writef) (enum memory_map, unsigned long, unsigned long *);
#endif /* ADSx */    
    /* pointer to function to fill memory with value */
    int (*fillf) (enum memory_map, unsigned long, unsigned long,
                  unsigned long *);
    /* pointer to function to return memory attribute */
    int (*mattrf) (enum memory_map, unsigned long);
    /* pointer to function to configure switchable memory blocks */
    void (*configuref) (unsigned long);
    /* pointer to function to read instruction word value from memory */    
    /* this will pack data memory into an instruction word from overlays */
    int (*readif) (enum memory_map, unsigned long, unsigned long *,int);
    /* pointer to function to write instruction word value to memory */
    /* This will unpack an instruction word to data memory */
    int (*writeif) (enum memory_map, unsigned long, unsigned long *,int);
    /* pointer to function to return memory attribute for reads */
    int (*mattrrf) (enum memory_map, unsigned long);
    /* pointer to function to return memory attribute for writes */
    int (*mattrwf) (enum memory_map, unsigned long);
#if ADSx
    /* pointer to function to program flash memory */
    int (*progflash) (int, char*);
    /* pointer to function to erase/clean flash memory */
    int (*ersflash) (int, int, unsigned long, unsigned long, unsigned long);
    /* pointer to function to write flash memory */
    int (*writeflash) (enum memory_map, unsigned long, unsigned long,
                       unsigned long *);
    /* pointer to function to erase memory (low level) */
    int (*eraseflash) (enum memory_map, unsigned long, unsigned long); 
#endif
    /* this will read multiple instruction words for one multiword instruction */
    int (*readmif) (enum memory_map, unsigned long, unsigned long *,int);
    /* unpacks memory into one bytes per word */
    int (*readbf) (enum memory_map, unsigned long, unsigned long *);
    /* reads memory into words */
    int (*readwf) (enum memory_map, unsigned long, unsigned long *);
    /* reads memory into longs */
    int (*readlf) (enum memory_map, unsigned long, unsigned long *);
    /* pointer to function to write byte value to memory */
    int (*writebf) (enum memory_map, unsigned long, unsigned long *);
    /* pointer to function to write word value to memory */
    int (*writewf) (enum memory_map, unsigned long, unsigned long *);
    /* pointer to function to write long value to memory */
    int (*writelf) (enum memory_map, unsigned long, unsigned long *);
};

/* register attribute values in initattr */
#define DSP_DIN 0X70L		/*0=OFF,1=ON,2=IF READ,3=IF WRITTEN,4=READ OR WRITTEN,5=NEVER */
#define DSP_DION 0X10L		/*1=ON Display enable */
#define DSP_DIREAD 0X20L	/*2=Display enable if register is READ */
#define DSP_DIWRITE 0X40L	/*3=Display enable if register is WRITTEN */
#define DSP_BRN 0X700L		/*1 IF READ, 2 IF WRITTEN, 3 IF BOTH ,0 IF NOT ACCESSED */
#define DSP_BRON 0X100L		/* Break enable 1=ON */
#define DSP_BRREAD 0X200L	/*2=break enable IF READ */
#define DSP_BRWRITE 0X400L	/*3=break enable IF WRITTEN */
#define DSP_DINOW 0X800L	/*DISPLAY DURING THIS DISPLAY */
#define DSP_DIAN 0XF000L	/*Display radix 0=BIN,1=DEC,2=FLOAT,3=HEX,4=UNSIGNED DEC */
#define DSP_DIABIN 0X0000L	/*0=BIN */
#define DSP_DIADEC 0X1000L	/*1=DEC */
#define DSP_DIAFLOAT 0X2000L	/*2=FLOAT or Fractional */
#define DSP_DIAHEX 0X4000L	/*3=HEX */
#define DSP_DIAUNS 0X8000L	/*4=UNSIGNED DEC */
#define DSP_BRSN 0X30000L	/*1 IF READ, 2 IF WRITTEN, 3 IF BOTH ,0 IF NONE */
#define DSP_BRSREAD 0X10000L	/*1 Signal if READ since last break check */
#define DSP_BRSWRITE 0X20000L	/*2 Signal if WRITTEN since last break check */
#define DSP_DISN 0XC0000L	/*1 IF READ, 2 IF WRITTEN, 3 IF BOTH ,0 IF NONE */
#define DSP_DISREAD 0X40000L	/*1 Signal IF READ since last display */
#define DSP_DISWRITE 0X80000L	/*2 Signal IF WRITTEN since last display */
#define DSP_DIREGHLP 0X100000L	/* REGISTER HELP AVAILABLE */
#define DSP_INIT 0X200000L	/* used to flag use of initialized registers */
#define DSP_VA_IFILE 0x400000L  /* input file assigned to register */
#define DSP_VA_OFILE 0x800000L  /* untimed output file assigned to register */
#define DSP_VA_TOFILE 0x1000000L  /* timed output file assigned to register */
#define DSP_DIALOG    0X2000000L	/*LOGICAL */
#define DSP_VA_TIFILE 0x4000000L  /* timed input file assigned to register */

/* fixed attributes for register in fixedattr */
#define DSP_FA_WRDN 0X7L	/*  must be same as DSP_WRDN */
#define DSP_FA_WRD1 0X1L	/* must be same as DSP_WRD1 */
#define DSP_FA_WRD2 0X2L	/* must be same as DSP_WRD2 */
#define DSP_FA_WRD3 0X4L	/* must be same as DSP_WRD3 */
#define DSP_FA_DINEVER 0X10L	/*Display NEVER - HIDDEN VAR EOF, JUMP, ETC. */
#define DSP_FA_RENAB 0X20L	/* Register can be read using memory read */
#define DSP_FA_WENAB 0X40L	/* Register can be written using memory write */
#define DSP_FA_WMULT 0X80L	/* Write has effect on multiple peripherals */
#define DSP_FA_RDONLY 0X100L	/* read only register  */
#define DSP_FA_WRONLY 0X200L	/* write only register  */
#define DSP_FA_FIXEDRADIX 0x400l	/* radix changes not allowed */
#define DSP_FA_IENABLE 0x800l           /* input files enabled */
#define DSP_FA_OENABLE 0x1000l          /* output files enabled */
#define DSP_FA_DILIMIT 0x2000l          /* limit display field width */
#define DSP_FA_SIZEN  0xfffc0000l	/* register size bits - all of the below */

#define DSP_FA_FP16   0x00040000l       /* for 16 bit arithmetic mode of 56301 */
#define DSP_FA_SIZE96 0x00080000l	/* 96 bit register size */
#define DSP_FA_SIZE56 0X00100000L	/* 56 bit register size */
#define DSP_FA_SIZE40 0X00200000L	/* 40 bit register size */
#define DSP_FA_SIZE64 0X00400000L	/* 64 bit register size */
#define DSP_FA_SIZE48 0X00800000L	/* 48 bit register size */
#define DSP_FA_SIZE36 0x01000000l	/* 36 bit register size */
#define DSP_FA_SIZE32 0X02000000L	/* 32 bit register size */
#define DSP_FA_SIZE24 0X04000000L	/* 24 bit register size */
#define DSP_FA_SIZE20 0x08000000L
#define DSP_FA_SIZE16 0X10000000L	/* 16 bit register size */
#define DSP_FA_SIZE12 0x20000000L
#define DSP_FA_SIZE8  0X40000000L	/* 8 bit register size */
#define DSP_FA_SIZE4  0X80000000L	/* 4 bit register size */

struct dt_regid
{
    char *regname;
    unsigned long maskval;
    unsigned long regxmem;	/* cross reference to x memory io address (or 0) */
    unsigned long initattr;	/* values used to initialize variable regattr */
    unsigned long fixedattr;	/* register size and other fixed attributes */
    char **reg_help;
    unsigned long adsreg;
};

/* VALUES FOR dt_periph.initattr and sv_var->periph[n].perattr */
#define DSP_IO_ENABLED 0X1L	/* PERIPHERAL ATTRIBUTE TO ENABLE I/O */
#define DSP_IO_SYNCED  0X2L	/* PERIPHERAL TIMED IO SYNCED TO PERIPHERAL */
#define DSP_IO_VALID  0X4L	/* PERIPHERAL IO VALID TO THIS PERIPHERAL */
#define DSP_IO_BUSY  0x8L	/* PERIPHERAL IS PROCESSING IO */
#define DSP_IO_START  0x10L	/* TIMED PERIPHERAL IO JUST STARTED */
#define DSP_IO_STACK  0x20L	/* STACK MODE PERIPHERAL UNTIMED INPUT */

#define DSP_IDLE (-2l)		/* Special I/O values for ports */
#define DSP_BREAK (-3l)

struct dt_periph
{
    /* pointer to function to read value from register */
    int (*readf) (int, int, unsigned long *);
    /* pointer to function to write value to register */
    int (*writef) (int, int, unsigned long *);
    /* pointer to function to read value from x io memory */
    void (*xreadf) (int, unsigned long, unsigned long *, int);
    /* pointer to function to write value to x io memory */
    int (*xwritef) (int, unsigned long, unsigned long, int);
    /* pointer to function to execute cycle */
    void (*cyclef) (int);
#if BLM
    /* pointer to function to execute cycle phase 0 */
    void (*phase0f) (int);
    /* pointer to function to execute cycle phase 1 */
    void (*phase1f) (int);
    /* pointer to function to execute for asynchronous inputs */
    void (*asyncf) (int);
#endif
    /* pointer to function that responds to device reset */
    void (*resetf) (int, int, int);
    /* pointer to function to check interrupts */
    int (*intchf) (int);
    /* pointer to function to clear interrupts */
    void (*intclearf) (int, int);
    unsigned long initattr;	/* initial value for perattr */
    int numreg;			/* number of registers */
    int numdregs;		/* number of registers names in regid  */
    struct dt_regid *regid;	/* describes regs. includes name,memory add,mask */
    /* pointer to function to check dma triggers */
    unsigned long (*triggchf) (int, unsigned long);
    /* pointer to function to read value from y io memory */
    void (*yreadf) (int, unsigned long, unsigned long *, int);
    /* pointer to function to write value to y io memory */
    int (*ywritef) (int, unsigned long, unsigned long, int);
  /* SAMSON */
  struct vperiph_type* vp_type;   /* pointer to vcx peripheral type structure */
};

struct dt_vcx
{
    void (* periphs_initialize)(int inst_num);
    void (* periphs_t0_pos_edge)(int dev_ind);
    void (* periphs_t0_neg_edge)(int dev_ind);
    void (* periphs_t1_pos_edge)(int dev_ind);
    void (* periphs_t1_neg_edge)(int dev_ind);
    void (* periphs_terminate)(int inst_num);
    void (* enhanced_core_cycle)(int periph,int tick);
    int (* is_vcx_periph_addr) (unsigned int dev_ind,unsigned long addr,unsigned int where_mapped);
};

struct dt_mperiph
{
    struct dt_xpid periphid;
    unsigned long port_control_addr;	/* address of port control register */
    unsigned long port_control_mask;	/* bits of the port control register */
    unsigned long reg_addr;	/* start address of io register bank */
    unsigned long int_addr;	/* start address of interrupts */
    unsigned long int_addrb;	/* start address of second interrupts  */
    unsigned long int_request_mask;	/* mask value for bits used in ipr register */
    struct dt_periph *periph;
    char *rsufx;		/* add this suffix to register names for port */
    int int_mask_shift;
    unsigned long dma_trigg_mask; /* bits of the dma triggers */
    unsigned long dma_edge_trigg_msk ;  /* mask of edge dma triggers */
    int is_yio_mapped;			/* 0= x:i/o mapped, 1= y:i/o mapped */
  /* SAMSON */
  struct vperiph_info* vp_info;   /* pointer to vcx peripheral static info structure */
};

struct dt_memory
{
    char *name;			/* for example "p,x" - it can prefix memory address */
    enum memory_map maintype;	/* helps define memory heirarchy */
    unsigned long subtypes;	/* helps define memory heirarchy */
    unsigned long memstart;	/* start address of memory */
    unsigned long memend;	/* end address of memory */
    int memsize;		/* size of allocated on-chip memory block */
    unsigned long memattr;	/* memory attribute flags */
    unsigned long *romval;	/* initial values for rom type memory */
    unsigned long addrmask;	/* mask for address value wrap */
    unsigned long wordsize;      /* memory word size flags */
    int numadd;                 /* consecutive addresses occupied per word */
};

struct dt_xpin
{
    char *name;
    char *aname;		/* alternate name for alternate pin function */
    char *aname2;		/* alternate name for alternate pin function */
    int portindex;		/*port index used for xportval list */
    unsigned long pinmask;	/* mask of bit which represents pin in xport */
    unsigned long devnum;	/* same as dt_var.devnum - qualifies this pin */
};

struct dt_var
{				/* one of these for each device type */
    char *devname;		/* name for this device type */
    unsigned long devmagic;     /* used for loading coff files */
    unsigned long devnum;	/* device number flags used to qualify pin names */
    unsigned long devattr;	/* device attribute flags used by simulator */
    int operating_mode;		/* default device startup operating mode */
    int numperiph;		/* number of structures in periph array */
    struct dt_mperiph *mperiph;	/* pointer to peripheral descriptions */
    int nummemory;
    struct dt_memory *mem;	/* pointer to array of memory structures */
    char *vmemprefix;		/* virtual memory file prefix */
    struct dt_mfunc *memfunc;	/* pointer to functions which operate on mem */
    int numgsig;		/* number of gsig global signals */
    int numportval;		/* number of xportval structures */
    struct dev_xpdata *pinit;	/* initial input and output values for ports */
    int numpins;		/*number of dt_xpin structures */
    struct dt_xpin *xpin;	/* pointer to array of external pin name structures */
    int numports;		/* number of xpid stuctures */
    struct dt_xpid *xport;	/* pointer to array of external ports name stuctures */
    unsigned long *devmagic_alternates; /* additional coff magic numbers, ends in zero */
    int memxref[memory_map_maxp1];	/* size from coffaddr.h */
    char *ndapassword;          /* password which unlocked nda device */
  /* SAMSON */
    struct vdevice_type* vd_type;  /* pointer to vcx device type structure */
    struct dt_vcx *vcx; /* pointer to vcx functions */
    unsigned long (*get_devattr) (); /* for use with mode variable devattr */
};

struct dev_const
{
    char *revnum;		/* simulator rev number string */
    int numdt;			/* number of device types */
    struct dt_var **dt;
    int maxdevices;
    struct dev_var **sv;	/* pointers to data structures for each device */
    int CTRLBR;			/* global break signal */
    unsigned long bitset[32];
    /* nda device lookup function */
    int (*nda_func) (char *, char *);
#if ADSx    
    int hostaddr;               /* address of ads host interface board */
#endif /* ADSx */    
    int nodisplay;  /* flag to inhibit display */
};

#endif /* __simdev_h__ */



