/*
 ******************************************************************************
 *
 *                        Copyright (c) 1995 by Motorola Inc.
 *                        All rights reserved.
 *
 ******************************************************************************
 *
 * FILE:
 *   vcx_utils.h
 *   "@(#)vcx_utls.h	1.1; last changed 98/06/30 22:00:18"
 *
 * DESCRIPTION:
 *   Header file for vcx_utils.c.
 *
 * CONTENTS:
 *   (Macros and tokens)
 *   (Types)
 *   (Externals)
 */

#ifndef _VCX_UTILS_H
#define _VCX_UTILS_H


/*
 * Macros and tokens.
 */

/* Miscellaneous. */
#define BITS_PER_ASCII_CHAR 8
#define CHAR_MASK 0xff
#define MAX_BITS_PER_VECTOR 2048
#define MAX_CHARS_IN_STR (((MAX_BITS_PER_VECTOR-1)/BITS_PER_ASCII_CHAR)+1)
#define MAX_PLI_ARGS 64
#define MAX_TEMPORARIES (((MAX_BITS_PER_VECTOR-1)/32)+1)

/* Storage element set-up. */
#define seiv(se) \
  switch(seiv_control) \
    { \
      case 0: \
        se = 0x00000000; \
        break; \
      case 1: \
        se = 0xFFFFFFFF; \
        break; \
      default: \
        se = (unsigned int)mrand48(); \
    }

/* Shift left. */
#define sl(data,shift) ((unsigned int)(data)<<(shift))

/* Shift right. */
#define sr(data,shift) ((unsigned int)(data)>>(shift))

/* Read a quantity which is contained within one int. */
#define r1(src,msb,lsb) \
  ( \
    sr(sl((src).data[(lsb)/32],31-((msb)%32)),31-(msb)+(lsb)) \
  )

/* Read bit 0. */
#define r1b0(src) \
  ( \
    ((src).data[0])&1 \
  )

/* Read a 1-bit quantity, selected by a constant. */
#define r1bc(src,bit) \
  ( \
    sr((src).data[(bit)/32],(bit)%32)&1 \
  )

/* Read a 1-bit quantity, selected by an expression. */
#define r1be(src,bit) \
  ( \
    vcx_t[0]=bit, \
    sr((src).data[vcx_t[0]/32],vcx_t[0]%32)&1 \
  )

/* Read a quantity which is one int. */
#define r1w(src,word) \
  ( \
    (src).data[(word)] \
  )

/* Read a quantity which is contained within two int's. */
#define r2(src,msb,lsb) \
  ( \
    sr((src).data[(lsb)/32],(lsb)%32)| \
    sr(sl((src).data[(msb)/32],31-((msb)%32)),31-(msb)+(lsb)) \
  )

/* Write a quantity which is contained within one int. */
#define w1(dst,msb,lsb,src) \
  ( \
    (dst).data[(lsb)/32]= \
      ((~sr(sl(~0,31-(msb)+(lsb)),31-((msb)%32)))& \
      ((dst).data[(lsb)/32]))| \
      sr(sl((src),31-(msb)+(lsb)),31-((msb)%32)) \
  )

/* Write some bits of a quantity which is contained within one int. */
#define wz1(dst,msb,lsb,src,msk) \
  ( \
    vcx_t[0]=sr(sl((msk),31-(msb)+(lsb)),31-((msb)%32)), \
    (dst).data[(lsb)/32]= \
      (((~sr(sl(~0,31-(msb)+(lsb)),31-((msb)%32)))|(vcx_t[0]))& \
      ((dst).data[(lsb)/32]))| \
      (sr(sl((src),31-(msb)+(lsb)),31-((msb)%32))&(~vcx_t[0])) \
  )

/* Write bit 0. */
#define w1b0(dst,src) \
  ( \
    (dst).data[0]= \
      ((~1)& \
      ((dst).data[0]))| \
      ((src)&1) \
  )

/* Write a 1-bit quantity, selected by a constant. */
#define w1bc(dst,bit,src) \
  ( \
    (dst).data[(bit)/32]= \
      ((~sl(1,(bit)%32))& \
      ((dst).data[(bit)/32]))| \
      sl(((src)&1),(bit)%32) \
  )

/* Write a 1-bit quantity, selected by an expression. */
#define w1be(dst,bit,src) \
  ( \
    vcx_t[0]=(bit), \
    vcx_t[1]=vcx_t[0]/32, \
    vcx_t[2]=vcx_t[0]%32, \
    (dst).data[vcx_t[1]]= \
      ((~sl(1,vcx_t[2]))& \
      ((dst).data[vcx_t[1]]))| \
      sl(((src)&1),vcx_t[2]) \
  )

/* Write a quantity which is one int. */
#define w1w(dst,word,src) \
  ( \
    (dst).data[(word)]= \
      (src) \
  )

/* Write some bits of a quantity which is one int. */
#define wz1w(dst,word,src,msk) \
  ( \
    (dst).data[(word)]= \
      ((msk)& \
      (dst).data[(word)]) | \
      ((src)&(~(msk))) \
  )

/* Write a quantity which is contained within two int's. */
#define w2(dst,msb,lsb,src) \
  ( \
    vcx_t[0]=(src), \
    (dst).data[(lsb)/32]= \
      ((~(sl(~0,(lsb)%32)))& \
      ((dst).data[(lsb)/32]))| \
      sl(vcx_t[0],(lsb)%32), \
    (dst).data[(msb)/32]= \
      (sl(~0,1+((msb)%32))& \
      ((dst).data[(msb)/32]))| \
      sr(sl(vcx_t[0],31-(msb)+(lsb)),31-((msb)%32)) \
  )

/* Write some bits of a quantity which is contained within two int's. */
#define wz2(dst,msb,lsb,src,msk) \
  ( \
    vcx_t[0]=(src), \
    vcx_t[1]=sl((msk),(lsb)%32), \
    vcx_t[2]=sr(sl((msk),31-(msb)+(lsb)),31-((msb)%32)), \
    (dst).data[(lsb)/32]= \
      (((~(sl(~0,(lsb)%32)))|(vcx_t[1]))& \
      ((dst).data[(lsb)/32]))| \
      (sl(vcx_t[0],(lsb)%32)&(~vcx_t[1])), \
    (dst).data[(msb)/32]= \
      ((sl(~0,1+((msb)%32))|(vcx_t[2]))& \
      ((dst).data[(msb)/32]))| \
      (sr(sl(vcx_t[0],31-(msb)+(lsb)),31-((msb)%32))&(~vcx_t[2])) \
  )


/*
 * Types.
 */

typedef struct { unsigned char data[1]; } chars1;
typedef struct { unsigned int data[1]; } ints01;
typedef struct { unsigned int data[2]; } ints02;
typedef struct { unsigned int data[3]; } ints03;
typedef struct { unsigned int data[4]; } ints04;
typedef struct { unsigned int data[5]; } ints05;
typedef struct { unsigned int data[6]; } ints06;
typedef struct { unsigned int data[7]; } ints07;
typedef struct { unsigned int data[8]; } ints08;
typedef struct { unsigned int data[9]; } ints09;
typedef struct { unsigned int data[10]; } ints10;
typedef struct { unsigned int data[11]; } ints11;
typedef struct { unsigned int data[12]; } ints12;
typedef struct { unsigned int data[13]; } ints13;
typedef struct { unsigned int data[14]; } ints14;
typedef struct { unsigned int data[15]; } ints15;
typedef struct { unsigned int data[16]; } ints16;
typedef struct { unsigned int data[17]; } ints17;
typedef struct { unsigned int data[18]; } ints18;
typedef struct { unsigned int data[19]; } ints19;
typedef struct { unsigned int data[20]; } ints20;
typedef struct { unsigned int data[21]; } ints21;
typedef struct { unsigned int data[22]; } ints22;
typedef struct { unsigned int data[23]; } ints23;
typedef struct { unsigned int data[24]; } ints24;
typedef struct { unsigned int data[25]; } ints25;
typedef struct { unsigned int data[26]; } ints26;
typedef struct { unsigned int data[27]; } ints27;
typedef struct { unsigned int data[28]; } ints28;
typedef struct { unsigned int data[29]; } ints29;
typedef struct { unsigned int data[30]; } ints30;
typedef struct { unsigned int data[31]; } ints31;
typedef struct { unsigned int data[32]; } ints32;
typedef struct { unsigned int data[33]; } ints33;
typedef struct { unsigned int data[34]; } ints34;
typedef struct { unsigned int data[35]; } ints35;
typedef struct { unsigned int data[36]; } ints36;
typedef struct { unsigned int data[37]; } ints37;
typedef struct { unsigned int data[38]; } ints38;
typedef struct { unsigned int data[39]; } ints39;
typedef struct { unsigned int data[40]; } ints40;
typedef struct { unsigned int data[41]; } ints41;
typedef struct { unsigned int data[42]; } ints42;
typedef struct { unsigned int data[43]; } ints43;
typedef struct { unsigned int data[44]; } ints44;
typedef struct { unsigned int data[45]; } ints45;
typedef struct { unsigned int data[46]; } ints46;
typedef struct { unsigned int data[47]; } ints47;
typedef struct { unsigned int data[48]; } ints48;
typedef struct { unsigned int data[49]; } ints49;
typedef struct { unsigned int data[50]; } ints50;
typedef struct { unsigned int data[51]; } ints51;
typedef struct { unsigned int data[52]; } ints52;
typedef struct { unsigned int data[53]; } ints53;
typedef struct { unsigned int data[54]; } ints54;
typedef struct { unsigned int data[55]; } ints55;
typedef struct { unsigned int data[56]; } ints56;
typedef struct { unsigned int data[57]; } ints57;
typedef struct { unsigned int data[58]; } ints58;
typedef struct { unsigned int data[59]; } ints59;
typedef struct { unsigned int data[60]; } ints60;
typedef struct { unsigned int data[61]; } ints61;
typedef struct { unsigned int data[62]; } ints62;
typedef struct { unsigned int data[63]; } ints63;
typedef struct { unsigned int data[64]; } ints64;

typedef struct
  {
    int
      size,
      type;
    union
      {
        struct
          {
            unsigned int
              data[2];
          } readonly;
        struct
          {
            unsigned int
              data[2];
          } readwrite;
      } obj;
  } pli_arg_item;


/*
 * Externals.
 */
extern char
  **argv,
  *scc_stack[],
  *vcx_convert_to_filename_str(),
  *vcx_convert_to_str();
extern int
  argc,
  mc_index,
  pli_arg_count,
  scc_stack_ptr,
  seiv_control,
  seiv_i,
  seiv_mem,
  seiv_set,
  vcx_check_index(),
  vcx_cons_i,
  vcx_no_check,
  vcx_vcd_file_set,
  vcx_vcd_first_dump;
extern ints01
  *global_s1;
extern long
  mrand48();
extern pli_arg_item
  pli_arg[];
extern unsigned int
  mc_filedesc,
  vcx_t[],
  vcx_tmp[],
  vcx_fopen(),
  vcx_fopen_int(),
  vcx_shift_l(),
  vcx_shift_r();
extern void
  pli_endofcompile_calls(),
  pli_finish_calls(),
  vcx_bad_channel(),
  vcx_cmdline(),
  vcx_dumpfile(),
  vcx_fclose(),
  vcx_finish(),
  vcx_fwrite(),
  vcx_open_dumpfile(),
  vcx_pli_task_enable(),
  vcx_readmem(),
  vcx_readmem_int(),
  vcx_scc_error(),
  vcx_veriuser_version_str(),
  vcx_write_dumpfile_header(),
  vcx_write_vcd_change_record(),
  vcx_write_vcd_time();
extern FILE
  *file_table[],
  *mc_fp,
  *vcx_vcd_fp;

#endif  /* _VCX_UTILS_H */
