
#define DSPT_XAB1_800 5
#define DSPT_XAB2_800 6
#define DSPT_PAB_800 7
#define DSPT_XDB_800 8
#define DSPT_PDB_800 9
#define DSPT_GDB_800 10
      /*idec inputs */
#define DSPT_AXIOZ_800 11
#define DSPT_PRXRD_800 12
#define DSPT_PRXWR_800 13
       /* address alu */
#define DSPT_ASIZ_800 14	/* size of on-chip memory */
#define DSPT_ADRV_800 15	/* current instruction to rn is disabled (rising t2) provide off core */
#define DSPT_AXIM1Z_800 16	/* data memory */
#define DSPT_AXIM2Z_800 17
#define DSPT_PIVAB_800 18	/*BIU inputs */
#define DSPT_BPIMZ_800 19	/*BIU OUTPUTS */
#define DSPT_BGCOZ_800 20
#define DSPT_BWAITZ_800 21	/* if bcl is on-chip */
		    /* Interrupt Controller inputs */
#define DSPT_MIRQ_800 22	/* n=0..4 interrupt requests from peripherals */
#define DSPT_VAB_800 23		/* upper 5 bits of interrupt vector provided by peripheral */
#define DSPT_BCSTOP_800 24
#define DSPT_PIPRGB_800 25
#define DSPT_PIGBPR_800 26
#define DSPT_IREQAZ_800 27
#define DSPT_IREQBZ_800 28
		     /* interrupt controller outputs */
#define DSPT_PIACK_800 29	/* acknowledges peripheral interrupt is to be processed */
#define DSPT_PICNVSE_800 30	/* n=0..4 indicates which peripheral interrupt is to be processed */
#define DSPT_PMRVAB_800 31	/* gates value onto vab */
		   /* Ram inputs */
#define DSPT_PAOM_800 32	/* program memory */
#define DSPT_PMRPM_800 33
#define DSPT_PRPWR_800 34
#define DSPT_PMPMEN_800 35
#define DSPT_PRX2RD_800 36
	    /* other signals */
#define DSPT_RES_800 37
#define DSPT_IOMI_800 38

struct dt_gsig_56800
{
    unsigned long
    /* These are new ones that the simulator currently needs */
     omr,
     clk_free,
     flg_seqn,
     flg_stop,
     clk_state,			/* busses */
     xab1,
     xab2,
     pab,
     xdb,
     pdb,
     gdb,			/*idec inputs */
     axioz,
     prxrd,
     prxwr,			/* address alu */
     asiz,			/* size of on-chip memory */
     adrv,			/* current instruction to rn is disabled (rising t2) provide off core */
     axim1z,			/* data memory */
     axim2z,
     pivab,			/*BIU inputs */
     bpimz,			/*BIU OUTPUTS */
     bgcoz,
     bwaitz,			/* if bcl is on-chip */
    /* interrupt controller inputs */
     mirq,			/* n=0..4 interrupt requests from peripherals */
     vab,			/* upper 5 bits of interrupt vector provided by peripheral */
     bcstop,
     piprgb,
     pigbpr,
     ireqaz,
     ireqbz,			/* interrupt controller outputs */
     piack,			/* acknowledges peripheral interrupt is to be processed */
     picnvse,			/* n=0..4 indicates which peripheral interrupt is to be processed */
     pivrd,			/* gates value onto vab */
    /* Ram inputs */
     paom,			/* program memory */
     pmrpm,
     prpwr,
     pmpmen,
     prx2rd,			/* other signals */
     pires,
     iomi,
     res;
};

/* PIN MASK INFO */
#define DSPT_PIM_ZPRECLK_800 0x100000L

#define DSPT_PIM_EXTAL_800 0x200000L
#define DSPT_PIM_CLKO_800 0x400000L
#define DSPT_PIM_RD_800   0x800000L
#define DSPT_PIM_WR_800   0x1000000L
#define DSPT_PIM_CPRESZ_800 0x2000000L
#define DSPT_PIM_CXWKUP0_800 0x4000000L
#define DSPT_PIM_CXWKUP1_800 0x8000000L
#define DSPT_PIM_XTAL_800    0x10000000L

#define DSPT_PIM_RESET_800 0x8000L
#define DSPT_PIM_MODB_800 0x2000L
#define DSPT_PIM_IRQB_800 0x2000L
#define DSPT_PIM_MODA_800 0x1000L
#define DSPT_PIM_IRQA_800 0x1000L

#if 0
#define DSPT_PIM_BS_800 0x800L
#define DSPT_PIM_RW_800 0x400L
#endif

#define DSPT_PIM_PS_800 0x200L
#define DSPT_PIM_DS_800 0x100L

#if 0
#define DSPT_PIM_TA_800 0x80L
#define DSPT_PIM_BR_800 0x40L
#define DSPT_PIM_BG_800 0x20L
#define DSPT_PIM_BB_800 0x10L
#endif

#define DSPT_PIM_TRST_800 0x10L
#define DSPT_PIM_TCK_800 0x8L
#define DSPT_PIM_TMS_800 0x4L
#define DSPT_PIM_TDI_800 0x2L
#define DSPT_PIM_TDO_800 0x1L

/* Port Mask info */
#define DSPT_POM_CTRL_800 (DSPT_PIM_PS_800|DSPT_PIM_RD_800|DSPT_PIM_WR_800)
#define DSPT_POM_IMC_800 (DSPT_PIM_MODA_800|DSPT_PIM_MODB_800|DSPT_PIM_RESET_800)

#define DSP56800 0x1L
#define DSP56811 0x2L
#define DSP56812 0x4L
#define DSP56824 0x8L
#define DSP_PER_CLOCK 5 /* t0,1,2,3,phi0,1 */
#define DSP_PER_CTL 6 /*biordw,cxrqz6..0,piack,pivrd,picvse6..0,vab5..0,pires,ckinstop*/
#define DSP_PER_XAB 7 /* xab15..0 */
#define DSP_PER_GDB 8 /* pgdb15..0 */
#define DSP_PER_CXRQZ 9 /* cxrqz6..0 */
#define DSP_PER_PICVSE 10 /* picvse6..0*/
#define DSP_PER_VAB 11 /* vab5..0 */

#define DSPT_PIM_BIORDW_800 0x10L
#define DSPT_PIM_RES_800 0x8L
#define DSPT_PIM_CKINSTOP_800 0x4L
#define DSPT_PIM_PIACK_800 0x2L
#define DSPT_PIM_PMRVAB_800 0x1L
#define XAB2_MASK ((dx_var->devnum==DSP56824)? 0x1fffl: (dx_var->devnum==DSP56812)?0xfffl :0x7ffl)

