/*
Freely Distributable Java Applets

Copyright (c) 1996-2001 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Author: Dogu Arifler and Brian L. Evans
Version: @(#)WedsConfig.java	1.3  04/17/01

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084
*/

// This class is used for uploading the configuration file

package utexas.espl.weds.ui;

import java.io.*;
import java.util.*;
import java.net.*;

public class WedsConfig
{
private String m_szServer = null;
private String m_szURL = null;
private int m_nPort = 0;

public WedsConfig(String szBase) {
    try {
    URL configFile = new URL(szBase + "/../weds.cfg");
    InputStreamReader hFile = new InputStreamReader(configFile.openStream());
    BufferedReader reader = new BufferedReader(hFile);
    String szLine = null;
    String szServer = null;
    while ((szLine = reader.readLine()) != null) {
        ParseConfig(szLine);
    }
    }
    catch (IOException io) {}
  }

private void ParseConfig(String szLine) {
  StringTokenizer tokens = new StringTokenizer(szLine, " =");
  if (tokens.hasMoreTokens()) {
    String configParam = tokens.nextToken();
    if (tokens.hasMoreTokens()) {
      if (configParam.equals("SERVERNAME")) {
        m_szServer = tokens.nextToken();
      }
      else if (configParam.equals("URL")) {
        m_szURL = tokens.nextToken();
      }
      else if (configParam.equals("TCPPORT")) {
        String szTemp = tokens.nextToken();
        try {
	m_nPort = Integer.parseInt(szTemp);
        } catch (NumberFormatException e) {}
      }
     }
    }
}

public String getServer() {
        return m_szServer;
}

public String getURL() {
        return m_szURL;
}

public int getPort() {
        return m_nPort;
}
}

