/*

Freely Distributable Java Applets

Copyright (c) 1996-2001 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Author: Dogu Arifler, Saleem Marwat, and Brian Evans
Version: @(#)StateWindow.java	1.9  04/17/01

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

package utexas.espl.weds.ui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// Provides windows for showing various states of the simulator
public class StateWindow extends JDialog implements ActionListener {
    private TextArea text;
    private JButton button;
    private Simulator simulator;

    final int WINDOW_HEIGHT = 15;
    final int WINDOW_WIDTH = 80;

    // Constructor
    public StateWindow( MainWindow f, String windowTitle, Simulator sim) {
        super( f, windowTitle, false );

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                removeDialog();
            }
        });
        Container contentPane = getContentPane();
        simulator = sim;
        String result = new String( simulator.simulatorState() );
        text = new TextArea(result, WINDOW_HEIGHT, WINDOW_WIDTH);
        text.setEditable( false );
        button = new JButton( "Close" );
        button.setActionCommand("close");
        button.addActionListener(this);
        contentPane.add( "Center", text);
        contentPane.add( "South", button);
        setSize( 450, 300 );
        show();
    }

    public void actionPerformed( ActionEvent e ) {
        if (e.getActionCommand().equals("close")) {
            removeDialog();
        }
    }

    public void removeDialog() {
        hide();
        dispose();
    }
}
