/*

Freely Distributable Java Applets

Copyright (c) 1996-2001 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Author: Dogu Arifler and Saleem Marwat
Version:  @(#)ResponseWindow.java	1.9 04/17/01

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

package utexas.espl.weds.ui;

import java.applet.Applet;
import java.awt.*;
import javax.swing.*;

/* Build a component with a text area and a title */
public class ResponseWindow extends JPanel {
    private JTextArea comArea;

    final int TEXT_ROWS = 10;
    final int TEXT_COLUMNS = 20;

    // Constructor
    public ResponseWindow() {
        createWindow(TEXT_ROWS, TEXT_COLUMNS);
    }

    // Constructor
    public ResponseWindow(int rows, int columns) {
        createWindow(rows, columns);
    }

    private void createWindow(int rows, int columns) {
        comArea = new JTextArea(rows, columns);
        comArea.setFont(new Font("Courier", Font.PLAIN, 12));
        comArea.setEditable( false );
        comArea.setLineWrap(true);
        comArea.setWrapStyleWord(true);
        JScrollPane areaScrollPane = new JScrollPane(comArea);
        areaScrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        //areaScrollPane.setPreferredSize(new Dimension(250, 250));
        areaScrollPane.setBorder(
            BorderFactory.createCompoundBorder(
                BorderFactory.createCompoundBorder(
                                BorderFactory.createTitledBorder("Response Window"),
                                BorderFactory.createEmptyBorder(5,5,5,5)),
                areaScrollPane.getBorder()));
        add(areaScrollPane);
    }

    // Appends new text
    public void appendText(String s) {
        comArea.append(s);
    }

    // Reads the text in text field
    public String getText() {
        return comArea.getText();
    }

    public void setText( String s ) {
        comArea.setText( s );
    }
}
