/*

Freely Distributable Java Applets

Copyright (c) 1996-2001 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Author: Dogu Arifler
Version: @(#)HistoryWindow.java	1.6  04/17/01

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

package utexas.espl.weds.ui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// Provides window for Command History
public class HistoryWindow extends JDialog implements ActionListener {

    private java.awt.List cmdList;
    private JButton button;
    private CommandWindow commwin;

    // Constructor
    public HistoryWindow( MainWindow f, CommandWindow comWin,
                          String[] cmds, int size ) {
        super( f, "Command History" , false );

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                removeDialog();
            }
        });
        Container contentPane = getContentPane();
        commwin = comWin;
        cmdList = new java.awt.List( 12, false );
        cmdList.addActionListener(this);
        buildMenu( cmds, size );
        button = new JButton( "Close" );
        button.setActionCommand("close");
        button.addActionListener(this);
        contentPane.add( "Center", cmdList );
        contentPane.add( "South", button );
        setSize( 400, 300 );
        show();
    }

    void buildMenu( String[] cmds, int itemCount ) {
     for ( int i = 0; i < itemCount; i++ ) {
         cmdList.add( cmds[i] );
     }
    }

    public void actionPerformed( ActionEvent e ) {
        if (e.getActionCommand().equals("close")) {
            removeDialog();
            return;
        }
        // If the ActionEvent is not from button, then it is from the List
        String selectedCommand = cmdList.getSelectedItem();
        commwin.appendText( selectedCommand + "\n" );
    }

    public void removeDialog() {
        hide();
        dispose();
    }
}


