/*

Freely Distributable Java Applets

Copyright (c) 1996-2001 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Author: Dogu Arifler and Brian Evans
Version: @(#)CommandMenu.java	1.7  04/17/01

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

/* Class to implement a command menu */

package utexas.espl.weds.ui;

import java.awt.*;
import java.util.*;
import javax.swing.*;

public class CommandMenu extends JPanel {
    private java.awt.List choiceMenu;

    private int itemCount = 0;
    private String itemArray[];

    // Constructor
    public CommandMenu( String listOfCommands ) {
      // Parses the result into a list of commands and
      // puts them into itemArray and sets itemCount
      parseCommandsList(listOfCommands);

      // Builds the choice of commands menu
      choiceMenu = new java.awt.List(itemCount, false);
      buildMenu();

      // Layout the menu
      Panel panel = new Panel();
      Label title = new Label( "Command Menu" );
      panel.setLayout( new BorderLayout() );
      panel.add( "North", title );
      panel.add( "South", choiceMenu );
      add( panel );
   }

   public int getItemCount() {
      return itemCount;
   }

   public String getItem(int i) {
      String returnValue = null;
      if ((i >= 0) && (i < itemCount)) {
          returnValue = new String( itemArray[i] );
      }
      return returnValue;
   }

   // Parser.
   private void parseCommandsList(String text) {
     // Find the set of '{' and '}' delimiters
     int startIndex = text.indexOf('{');
     int endIndex = text.indexOf('}');
     if ((startIndex < 0) && (endIndex < 0)) {
       startIndex = 0;
       endIndex = text.length() - 1;
     }
     if ((startIndex >= 0) && (endIndex >= 0) && (startIndex < endIndex)) {
       StringTokenizer tokens =
         new StringTokenizer( text.substring(startIndex+1, endIndex) );

       // reads the tokens into an array of items
       itemCount = tokens.countTokens();
       itemArray = new String[itemCount];
       for ( int k = 0; k < itemCount; k++ ) {
         itemArray[k] = new String(tokens.nextToken());
       }
     }
   }

   public void buildMenu() {
     for ( int i = 0; i < itemCount; i++ ) {
         choiceMenu.add( itemArray[i] );
     }
   }

    public java.awt.List getList() {
      return choiceMenu;
    }
}
