; crt0.s
; gcc crt0.s module
;
; When using gcc for linking, a module crt0_xxx.o is always linked. gcc
; assumes that it contains the startup code. The letters xxx are
; generated from various options used for compiling different versions
; of the same code.
; (c4x gcc <1.9.62 or so supported only one crt0.o file)
;
; The GNU linker (ld) by default starts execution at _start, the TI
; linker (lnk30) at _c_int00. The TI run-time-library's startup code
; starts at _c_int00 (later jumps to _main).
;
; This code just jumps from _start to _c_int00. It works with the TI
; startup code as well as any other startup code starting at _c_int00,
; as long as that startup code finally jumps to _main.
;
; Volker Kuhlmann
;   12 Sep; 21 Nov 1997
;   20 Feb 1998
;

	.global	_c_int00
	.global	_start
	
_start:	br	_c_int00
