;       File:           piddrive_h.s
;
;       Contains:       VL16C551 serial driver (header file)
;
;       Written by:     Stephane THOMAS
;
;       Copyright:      1991 by VLSI Technology, Inc., all rights reserved.
;
;       Change History (most recent first):
;       V1.00   16 Jan 92       matches ARM S/W
;       V1.00   17 Dec 91       first draft




;-----------------------------
; 16C551 Serial Port Registers
;-----------------------------

SerialPortBase  EQU     IOBase + &20

; offsets from the base
RBR             EQU     &0      ; Receive Buffer Reg.                   R/O
THR             EQU     &0      ; Transmitter Holding Reg.              W/O
IER             EQU     &4      ; Interrupt Enable Reg.                 R/W
IIR             EQU     &8      ; Interrupt Identificatio Reg.          R/O
FCR             EQU     &8      ; FIFO Control Reg.                     W/O
LCR             EQU     &C      ; Line Control Reg.                     R/W
MCR             EQU     &10     ; Modem Control Reg.                    R/W
LSR             EQU     &14     ; Line Status Reg.                      R/W
MSR             EQU     &18     ; Modem Status Reg.                     R/W
SCR             EQU     &1C     ; Scratch Reg.                          R/W

DLL             EQU     &0      ; Divisor Latch (LSB)                   R/W
DLM             EQU     &4      ; Divisor Latch (MSB)                   R/W

;----------------------------
; Line Control Register (LCR)
;----------------------------

DLAccess                EQU     &80     ; 0DAccess Rx buffer,1=Div. latch access
ForceBreak              EQU     &40     ; 0=break disable, 1=break enable
StickParity             EQU     &20     ; 0=disable, 1=enable
EvenParity              EQU     &10     ; 0=odd, 1=even
ParityEnable            EQU     &8      ; 0=disable, 1=enable
StopSelect              EQU     &4      ; 0D1 stop bit, 1=2 stop bits
WordLength              EQU     &3      ; 3=8 bits, 2=7 bits, 1=6 bits, 0=5 bits

; value for LCR :
; - word length      -> 8 bits
; - stop bits        -> 1
; - Parity           -> disabled
; -  arity select    -> odd
; - stick parity     -> disabled
; - Break Control    -> Enabled
; - Div latch access -> off
LCRvalue                EQU     WordLength


;-----------------------------
; Divisor Latch Register (DLR)
;-----------------------------
; clock = 1,8432 Mhz
BR1200                  EQU     96      ; 1200  baud
BR2400                  EQU     48      ; 2400  baud
BR9600                  EQU     12      ; 9600  baud
BR19200                 EQU     6       ; 19200 baud
BR38400                 EQU     3       ; 38400 baud

; value for DLR :
; - default is 9600 baud
DLLvalue                EQU     BR9600
DLMvalue                EQU     0

;--------------------------------
; Interrupt Enable Register (IER)
;--------------------------------

EnModemStatusInt        EQU       &8 ; 1=enable modem status interrupt
EnRxLineStatusInt       EQU       &4 ; 1=enables Rx line status interrupt
EnTxRegEmptyInt         EQU       &2 ; 1=enables Tx holding reg empty interrupt
EnRxDataAvailInt        EQU       &1 ; 1=enables Rx data available interrupt

; value for IER :
; - enable INT for Rx data available
; - enable INT for Rx line status
IERvalue                EQU     EnRxDataAvailInt + EnRxLineStatusInt

;----------------------------------------
; Interrupt Identification Register (IIR)
;----------------------------------------

RxAndTxFifoEnabled      EQU     &C0
FifoEnabled             EQU     &8
ModemStatus             EQU     (&0:SHL:1)
TxHoldingRegEmpty       EQU     (&1:SHL:1)
RxDataAvailable         EQU     (&2:SHL:1)
RxLineStatus            EQU     (&3:SHL:1)
IntTypeMask             EQU     (&3:SHL:1)      ; mask to keep b[2:1] only
InterruptPending        EQU     &1




;---------------------------
; Line Status Register (LSR)
;---------------------------

FifoError               EQU     &80
TransmitterEmpty        EQU     &40
TransmHoldRegEmpty      EQU     &20
RxBreakDetectError      EQU     &10
RxFramingError          EQU     &8
RxParityError           EQU     &4
RxOverrunError          EQU     &2
RxDataReady             EQU     &1

;----------------------------
; FIFO Control Register (FCR)
;----------------------------

RMode                   EQU     &8
TxFifoClear             EQU     &4
RxFifoClear             EQU     &2
EnableRxAndTxFifo       EQU     &1

;-----------------------------
; Modem Control Register (MCR)
;-----------------------------

LoopBackEnable          EQU     &10
MCRInterruptEnable      EQU     &8
RequestToSend           EQU     &2
DataTransmReady         EQU     &1

MCRValue        EQU     RequestToSend + DataTransmReady + MCRInterruptEnable



;----------------------
; Modem Status Register
;----------------------

DataSetReady            EQU     &20
DeltaDSR                EQU     &2







;-------------------------------
; 16C551 Parallel Port Registers
;-------------------------------

ParallelPortBase        EQU     IOBase + &60

; offsets from the base
PDRW                    EQU     &0      ; Parallel Data Read & Write Reg.
PSR                     EQU     &4      ; Parallel Status Reg.
PCR                     EQU     &8      ; Parallel Control Reg.
GPIO                    EQU     &C      ; General Purpope I/O Reg. (LEDs)

; LEDs definitions (in R0)
LED1                    EQU     &1
LED2                    EQU     &2
LED3                    EQU     &4
LED4                    EQU     &8


; ------------------
; INTC PGA Registers
; ------------------

IRQStatus       EQU     &0      ; Offset from IOBase
IRQReset        EQU     &0
IRQMask         EQU     &4
FIQStatus       EQU     &8
FIQMask         EQU     &C

SerialPortIT            EQU     &1      ; IRQ0
TimerIT                 EQU     &2      ; IRQ1
ParallelPortIT          EQU     &4      ; IRQ2
ExpSlotIRQ3             EQU     &8      ; IRQ3
ExpSlotIRQ4             EQU     &10     ; IRQ4
ExpSlotIRQ5             EQU     &20     ; IRQ5
ExpSlotIRQ6             EQU     &40     ; IRQ6
Panic                   EQU     &80     ; Panic


                END
