;;; stkcontig.s
;;; Copyright (C) 1991 Advanced RISC Machines Ltd.  All rights reserved.

;;; RCS $Revision: 1.6 $
;;; Checkin $Date: 93/10/13 15:37:30 $
;;; Revising $Author: hmeekings $

        GET     objmacs.s
        GET     h_stack.s
        GET     h_errors.s

        Module  StackContig

        DataArea

StaticData

initSL  Variable
initSP  Variable

        CodeArea

        EXPORT  |x$stack_overflow|
        EXPORT  |x$stack_overflow_1|
        EXPORT  |__rt_stkovf_split_small|
        EXPORT  |__rt_stkovf_split_big|

        IMPORT  |__rt_registerDump|
        IMPORT  |__rt_trap|
        IMPORT  |__rt_heapDesc|

        Function _Stack_Init
        ; r0 = address of a heap descriptor
        ; r1 = address of heap base
        ; r2 = required size of initial stack
        ; r3 = end of application workspace (= heap limit).
        ; stack description registers (sp, fp, sl) are not yet set up.
        ; so do them now.
        MOV     sp, r3
        SUB     sl, sp, r2
        MOV     fp, #0

        ; initialise the heap description (nothing allocated yet).
        MOV     r2, r1
        STMIA   r0, {r1, r2, sl}
        ADD     sl, sl, #SC_SLOffset  ; *after* the STMIA above

        ; remember initial stack state
        LoadStaticBase ip
        STMIA   ip, {sl, sp}
        Return  , "", LinkNotStacked

        Function _Stack_Validate
        ; r0 is a pointer to the heap description (base / hwm / limit)
        ; r1 is a pointer to a register save block.
        ; checks that the saved values for sp, fp and sl appear valid.
        ; if not, returns with r0 = 0:
        ; otherwise, r0 is unchanged
        ;            r12 is the sp value
        ;            r10 is the sl value
        ;            v1 is the fp value.
        LoadStaticBase r2
        LDR     r2, [r2, #O_initSP]
        LDR     v1, [r1, #fp*4]
        LDR     r12, [r1, #sp*4]
        CMP     r12, r2         ; want sp < workspace limit and ...
        LDR     r10, [r0, #8]
        CMPLO   r10, r12        ; > heap hwm
                                ; we could also check sl = heap limit+sloffset
        ADD     r10, r10, #SC_SLOffset
        MOVHS   r0, #0          ; invalid
        Return  , "", LinkNotStacked

        Function _Stack_GetSafe
        LoadStaticBase ip
        LDMIA   ip, {sl, sp}
        MOV     fp, #0
        Return  , "", LinkNotStacked

 ;*-------------------------------------------------------------------*
 ;* Stack overflow handling                                           *
 ;*-------------------------------------------------------------------*

|x$stack_overflow|
|__rt_stkovf_split_small|
;
; Enter here when a C function with frame size <= 256 bytes underflows
; the stack low-water mark + StackSlop (sl). The stack space required has
; already been claimed by decrementing sp, so we set the proposed sp (ip)
; to the actual sp and fall into the big-frame case.
        MOV     ip, sp

|x$stack_overflow_1|
|__rt_stkovf_split_big|
;
; Enter here when a C function with frame size > 256 bytes would underflow
; the stack low-water mark + StackSlop (sl). No stack space has been claimed
; but the proposed new stack pointer is in ip.

        SUB     ip, sp, ip                      ; frame size required...
        CMP     ip, #MinStackIncrement          ; rounded up to at least
        MOVLT   ip, #MinStackIncrement          ; the default increment

        SUB     sl, sl, ip
        SUB     sl, sl, #SC_SLOffset            ; new stack low-water mark

        LoadStaticAddress |__rt_heapDesc|, ip
        LDR     ip, [ip, #4]                    ; check not below heap hwm
        CMP     ip, sl
        BGT     overflow
        LoadStaticAddress |__rt_heapDesc|, ip
        STR     sl, [ip, #8]                    ; adjust heap limit
        ADD     sl, sl, #SC_SLOffset            ; restore safety margin
        Return  , "", LinkNotStacked

overflow
        LoadStaticAddress |__rt_registerDump|, ip
 [ LDM_MAX >= 15
        STMIA   ip!, {r0-r14}
 |
        STMIA   ip!, {r0,r1,r2}
        STMIA   ip!, {r3,r4,r5}
        STMIA   ip!, {r6,r7,r8}
        STMIA   ip!, {r9,r10,r11}
        STMIA   ip!, {r12,sp,r14}
 ]
        ADR     r0, E_StackOverflow
        SUB     r1, ip,#pc*4
        STR     r14, [ip]
        B       |__rt_trap|

        ErrorBlock StackOverflow, "Stack overflow"

        END
