; Lastedit: 27 Aug 92 9:58:45
;
; Purpose: ARMulator-hosted C-library Monitor.
;
; Copyright (C) Advanced RISC Machines Ltd., 1991.
;
; The terms and conditions under which this software is supplied to you and
; under which you may use it are described in your licence agreement with
; Advanced RISC Machines.

;;; RCS $Revision: 1.15 $
;;; Checkin $Date: 93/12/10 15:09:46 $
;;; Revising $Author: irickard $

        GET     objmacs.s
        GET     h_errors.s
        GET     h_os.s
        IMPORT  __errno
        IMPORT  __rt_trap
        DataArea

StaticData
__rt_registerDump       ExportedVariable 16
__ClockInit             Variable
        CodeArea

;
; Return, maybe setting errno first
;

        MACRO
        ErrorNEReturn
        BNE     seterrno
        Return ,, LinkNotStacked
        MEND

        MACRO
        ErrorEQReturn
        BEQ     seterrno
        Return ,, LinkNotStacked
        MEND

seterrno
        STMFD   sp!, {a1}
        SWI     SWI_GetErrno
        LDR     a2, =__errno
        STR     a1, [a2]
        LDMFD   sp!, {a1}
        Return ,, LinkNotStacked

;
; I/O Support, via SWI's to the host's OS
;

        Function clock
        SWI     SWI_Clock
        LDR     a2, =__ClockInit
        LDR     a2, [a2]
        SUB     a1, a1, a2
        Return ,, LinkNotStacked

        Function _clock_init
        SWI     SWI_Clock
        LDR     a2, =__ClockInit
        STR     a1, [a2]
        Return ,, LinkNotStacked

        Function time
        MOVS    a2, a1 ; store to memory too ?
        SWI     SWI_Time ; get the time
        STRNE   a1, [a2] ; store it to memory
        Return ,, LinkNotStacked

        Function system
        CMP     a1, #0 ; is there a system
        MOVEQ   a1, #1
        SWINE   SWI_CLI
        Return ,, LinkNotStacked

        Function getenv
        MOV     r0, #0
        Return ,, LinkNotStacked

        Function _sys_open
        SWI     SWI_Open
        CMP     a1, #0
        ErrorEQReturn

        Function _sys_iserror
        CMN     a1, #1
        MOVEQ   a1, #1
        MOVNE   a1, #0
        Return ,, LinkNotStacked

        Function _sys_close
        SWI     SWI_Close
        CMP     a1, #0
        ErrorNEReturn

        Function _sys_write
        SWI     SWI_Write
        CMP     a1, #0
        ErrorNEReturn

        Function _sys_read
        SWI     SWI_Read
        CMP     a1, #0
        ErrorNEReturn

        Function _sys_seek
        SWI     SWI_Seek
        CMN     a1, #1
        ErrorEQReturn

        Function _sys_flen
        SWI     SWI_Flen
        CMN     a1, #1
        ErrorEQReturn

        Function remove
        SWI     SWI_Remove
        CMP     a1, #0
        ErrorNEReturn

        Function rename
        SWI     SWI_Rename
        CMP     a1, #0
        ErrorNEReturn

        Function _ttywrch
        SWI     SWI_WriteC
        Return ,, LinkNotStacked

; this function is called from _sys_istty, and takes a FILEHANDLE rather
; than a FILE *. _sys_istty is in os.c

        Function __sys_istty
        SWI     SWI_IsTTY
        Return ,, LinkNotStacked

        Function _sys_tmpnam
        SWI     SWI_TmpNam
        Return ,, LinkNotStacked

;
; Floating Point Support
;
 [ :LNOT: linked_fpe

        Function __fp_initialise
        ; Determine whether FP is available (to decide whether fp regs need
        ; saving over _kernel_system and in setjmp).

        MOV     r0, #4
        LDR     r0, [r0]
        AND     r0, r0, #&ff000000      ; see if B somewhere
        CMP     r0, #&ea000000
        MOVEQ   r0, #1
        MOVNE   r0, #0
        Return  , "", LinkNotStacked


        Function __fp_finalise
        ; nothing to do.
        Return  , "", LinkNotStacked


        Function __fp_address_in_emulator
        ; determine whether r0 is an address inside the fp emulator,
        ; (to allow a data abort or address exception in a floating-point
        ; load or store to be reported as occurring at that instruction,
        ; rather than somewhere in the code of the emulator).

        SUB     r0, r0, #FPEStart
        CMP     r0, #(FPEEnd-FPEStart)
        MOVLO   r0, #1
        MOVHS   r0, #0
        Return  , "", LinkNotStacked
 ]
;
; Miscellaneous Support
;

        Function __osdep_traphandlers_init
        MOV     r0, #0
        ADR     r3, newVectors
01      ADR     r1, trapRegBlock
        LDR     r2, [r3, r0, LSL #2]
        CMP     r0, #2
        SWINE   SWI_InstallHandler      ; no SWI handler
        ADD     r0, r0, #1
        CMP     r0, #9
        BNE     %B01
        Return ,, LinkNotStacked

        Function __osdep_traphandlers_finalise
        Return ,, LinkNotStacked

newVectors
        & ResetHandler
        & UndefInstrHandler
        & 0
        & PrefAbortHandler
        & DataAbortHandler
        & AddrExceptHandler
        & IRQHandler
        & FIQHandler
        & ErrorHandler

        Function __osdep_heapsupport_init
        Return ,, LinkNotStacked

        Function __osdep_heapsupport_finalise
        Return ,, LinkNotStacked

        Function __osdep_heapsupport_extend
        MOV     r0,#0
        Return ,, LinkNotStacked

        Function _hostos_error_string
        ADR     a1, errorstring
        Return ,, LinkNotStacked

errorstring     = "Unknown Error",0
        ALIGN

ResetHandler
        STMIA   r11, {r0-r2}
        ADR     a1, E_BranchThroughZero
        B       CallTrap

UndefInstrHandler
        STMIA   r11, {r0-r2}
        ADR     a1, E_IllegalInstruction
        B       CallTrap

;SWIHandler
;        STMIA   r11, {r0-r2}
;        ADR     a1, E_UnknownSWI
;        B       CallTrap

PrefAbortHandler
        STMIA   r11, {r0-r2}
        ADR     a1, E_PrefetchAbort
        B       CallTrap

DataAbortHandler
        STMIA   r11, {r0-r2}
        ADR     a1, E_DataAbort
        B       CallTrap

AddrExceptHandler
        STMIA   r11, {r0-r2}
        ADR     a1, E_AddressException
        B       CallTrap

IRQHandler
FIQHandler
        STMIA   r11, {r0-r2}
        ADR     a1, E_UnknownIRQ
        B       CallTrap

ErrorHandler
        STMIA   r11, {r0-r2}
        MOV     a1, r10 ; ; get the error pointer
        B       CallTrap

CallTrap
        ; Max 3 registers at a time in the following LDM/STMs for
        ; lowest allowed interrupt latency (IRQs but not FIQs are
        ; disabled for most faults).
        MOV     r1, r11
        ADD     r2, r1, #3*4
 [ LDM_MAX >= 12
        LDMFD   sp!, {r10 - r12, r14}
        STMFD   r2, {r0-r14}^
 |
        LDMFD   sp!, {r10 - r12}
        LDMFD   sp!, {r14}
        STMIA   r2!, {r3,r4,r5}
        STMIA   r2!, {r6,r7}
        STMIA   r2, {r8,r9,r10}^
        ADD     r2,r2,#12
        STMIA   r2, {r11,r12,r13}^
        ADD     r2,r2,#12
        STMIA   r2, {r14}^
 ]
        STR     r14, [r1, #15*4]
        B       __rt_trap

;        ErrorBlock UnknownSWI, "Undefined SWI Instruction"
        ErrorBlock BranchThroughZero, "Branch Through Zero"
        ErrorBlock IllegalInstruction, "Undefined Instruction"
        ErrorBlock PrefetchAbort, "Prefetch Abort"
        ErrorBlock DataAbort, "Data Abort"
        ErrorBlock AddressException, "Address Exception"
        ErrorBlock UnknownIRQ, "Unhandled Interrupt"

trapRegBlock
        % 16 * 4

        END
