//---------------------------------------------------------------------------
//
// %FILE     uart.h
// %VSS-REV  $Revision: 9 $
// %CREATED  1996.04.09
// %REVISED  $Date: 4/18/97 4:25p $
// %AUTHOR   Michael C. Draeger 
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF (B0+), NS486SXL
// %SUMMARY  header for UART code
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:25p $ $Revision: 9 $
//
// DESCRIPTION
//
//   Header for uart.c.
//
// HISTORY
//
/*
 *
 * $History: uart.h $ 
 * 
 * *****************  Version 9  *****************
 * User: Miked        Date: 4/18/97    Time: 4:25p
 * Updated in $/nsdemo
 * Moved UART base to ns486cfg.h.   New header (comment) changes.
 * 
 * *****************  Version 8  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 7/23/96    Time: 2:26p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 4/18/96    Time: 10:59a
 * Updated in $/nsdemo
 * Added #ifdef UART_H_INC to header.
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 4/18/96    Time: 10:52a
 * Updated in $/nsdemo
 * Clean up for release.
 * 
 * *****************  Version 2  *****************
 * User: Miked        Date: 4/12/96    Time: 11:55a
 * Updated in $/nstest
 * Added <stdio.h> and "nsglobal.h".
 * Erased a worthless header.
 * 
 * *****************  Version 1  *****************
 * User: Miked        Date: 4/09/96    Time: 11:06a
 * Created in $/board test
 * UART header file
 *
 */
//
// COPYRIGHT
//
//      (c) 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef UART_H_INC
#define UART_H_INC

//---------------------------------------------------------------------------

// include files

#include "nsglobal.h"

//---------------------------------------------------------------------------
// function prototypes

extern USHORT UART_Initialize();
extern void uart_printf( const char *fmt, ... );
extern USHORT uart_outs( char * str );
extern USHORT uart_outc( char ch );

//---------------------------------------------------------------------------

#endif // #ifndef UART_H_INC

//---------------------------------------------------------------------------
// END       uart.h
//---------------------------------------------------------------------------
