//---------------------------------------------------------------------------
//
// %FILE     pit.h
// %VSS-REV  $Revision: 9 $
// %CREATED  1995.12.14
// %REVISED  $Date: 4/18/97 4:17p $
// %AUTHOR   Michael C. Draeger 
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF, NS486SXL 
// %SUMMARY  Programmable Interval Timer module header
//
// %VSS      $Author: Miked $ $Date: 4/18/97 4:17p $ $Revision: 9 $
//
// DESCRIPTION
//
//   This header contains definitions and structures used for the PIT
//   module.  This header also contains function prototypes for the
//   public functions that other modules can call.
//
// HISTORY
//
/*
 *
 * $History: pit.h $
 * 
 * *****************  Version 9  *****************
 * User: Miked        Date: 4/18/97    Time: 4:17p
 * Updated in $/nsdemo
 *  New header (comment) changes.
 * 
 * *****************  Version 8  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 4/18/96    Time: 10:35a
 * Updated in $/nsdemo
 * Cleanup for release.
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 4/17/96    Time: 11:32a
 * Updated in $/nsdemo
 * Renamed PITf_Delay to PIT_Delay.
 * 
 * *****************  Version 2  *****************
 * User: Miked        Date: 4/04/96    Time: 3:16p
 * Updated in $/board test
 * changed headers for VSS
 *
 */
//
// COPYRIGHT
//
//      (c) 1995, 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef PIT_H_INC
#define PIT_H_INC

//---------------------------------------------------------------------------
// Required headers

#include "nsglobal.h"

//---------------------------------------------------------------------------
// Function structures

typedef struct
{
  USHORT  Timer;     
  USHORT  Mode;      
  ULONG   Time;
  USHORT  Gate;
} PIT_SET;

typedef struct
{
  USHORT  Mode;
  ULONG   Time;
  BOOL    TimeValid;
  USHORT  Gate;
  BOOL    Output;
} PIT_STATUS;

typedef union
{
  WORD linear;
  struct
  {
    BYTE lsb;
    BYTE msb;
  } seg;
} SEGWORDU;

//---------------------------------------------------------------------------
// Register bit definitions

// Control Register (PIT_CONTROL)

  // bit definitions
  #define CONTROL_SELECT        0xC0
  #define CONTROL_COMMAND       0x30
  #define CONTROL_MODE          0x0E
  #define CONTROL_BCD           0x01
  #define CONTROL_READBACK      0x3F

  // SELECT values
  #define SELECT_Counter0       0
  #define SELECT_Counter1       0x40
  #define SELECT_Counter2       0x80
  #define SELECT_ReadBack       0xC0

  // COMMAND values
  #define COMMAND_Latch         0
  #define COMMAND_RWlsb         0x10
  #define COMMAND_RWmsb         0x20
  #define COMMAND_RWlsbmsb      0x30

  // MODE values
  #define MODE_0                0
  #define MODE_1                (1<<1)
  #define MODE_2                (2<<1)
  #define MODE_3                (3<<1)
  #define MODE_4                (4<<1)
  #define MODE_5                (5<<1)

  // BCD values
  #define BCD_Binary            0
  #define BCD_Decimal           0x01
  
  // READBACK values
  #define READBACK_LatchCount      (0<<5)
  #define READBACK_DontLatchCount  (1<<5)
  #define READBACK_LatchStatus     (0<<4)
  #define READBACK_DontLatchStatus (1<<4)
  #define READBACK_Counter2        (1<<3)
  #define READBACK_Counter1        (1<<2)
  #define READBACK_Counter0        (1<<1)

  // "STATUS" BYTE - read from PIT_CONTROL after READBACK command

  #define STATUS_Output       0x80
  #define STATUS_NULLCount    0x40
  #define STATUS_RWformat     0x30
  #define STATUS_Mode         0x0E
  #define STATUS_BCD          0x01

// Timer Clock Register (PIT_CLOCK)

  // bit definitions
  #define TCR_TCD       0x03

  // TCD values 
  #define TCD_Div4      0x00
  #define TCD_Div8      0x01
  #define TCD_Div16     0x02
  #define TCD_Div32     0x03

// Timer I/O Control Register (PIT_TICR)

  // bit definitions
  #define TICR_OUT1     0x80
  #define TICR_OUT0     0x40
  #define TICR_TG1      0x20
  #define TICR_TG0      0x10
  #define TICR_T1SEL    0x0C
  #define TICR_T0SEL    0x03

  // T1SEL and T0SEL values
  #define T1SEL_T0GATE  0x00
  #define T1SEL_T1GATE  0x01
  #define T1SEL_T1OUT   0x02
  #define T1SEL_T0CLK   0x03
  #define T0SEL_T0GATE  0x00
  #define T0SEL_T1GATE  0x01
  #define T0SEL_T0OUT   0x02
  #define T0SEL_T1CLK   0x03

//---------------------------------------------------------------------------
// Gate parameter options for PIT_Set

#define PIT_GateClear   0
#define PIT_GateSet     1
#define PIT_GateNA      2

//---------------------------------------------------------------------------
// Function prototypes

extern USHORT PIT_Initialize( void );
extern USHORT PIT_Set( PIT_SET * Set );
extern USHORT PIT_Cancel( USHORT channel );
extern USHORT PIT_Gate( USHORT channel, USHORT gate  );
extern USHORT PIT_Status( USHORT channel, PIT_STATUS * pStatus );
extern USHORT PIT_Delay( USHORT timer, ULONG time );

//---------------------------------------------------------------------------

#endif // #ifndef PIT_H_INC

//---------------------------------------------------------------------------
// END       pit.h
//---------------------------------------------------------------------------
