//---------------------------------------------------------------------------
//
// %FILE     pcmcia.h
// %VSS-REV  $Revision: 10 $
// %CREATED  1995.12.20
// %REVISED  $Date: 4/18/97 4:15p $
// %AUTHOR   Noreen Bell
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF (B0+)
// %SUMMARY  PCMCIA header module
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:15p $ $Revision: 10 $
//
// DESCRIPTION
//
//   This header file contains definitions for the PCMCIA Controller.
//
// HISTORY
//
/*
 *
 * $History: pcmcia.h $ 
 * 
 * *****************  Version 10  *****************
 * User: Miked        Date: 4/18/97    Time: 4:15p
 * Updated in $/nsdemo
 * Minor changes.   New header (comment) changes.
 * 
 * *****************  Version 8  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 5  *****************
 * User: Noreen       Date: 7/11/96    Time: 9:56a
 * Updated in $/nsdemo
 * Added definitions for setting and clearing of interrupt in general
 * control register.
 * 
 * *****************  Version 4  *****************
 * User: Noreen       Date: 5/07/96    Time: 3:30p
 * Updated in $/nstest
 * Implemented code to support interrupts based on card removal.
 * Added PCMCIA_Status function.
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 5/03/96    Time: 2:48p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 2  *****************
 * User: Noreen       Date: 4/18/96    Time: 12:35p
 * Updated in $/nsdemo
 * Updated comments for version release
 * 
 * *****************  Version 1  *****************
 * User: Noreen       Date: 4/17/96    Time: 12:43p
 * Created in $/nsdemo
 * Initial revision
 *
 */
//
// COPYRIGHT
//
//      (c) 1995, 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef PCMCIA_H_INC
#define PCMCIA_H_INC

//---------------------------------------------------------------------------
// Required headers

#include "nsglobal.h"
#include "pit.h"

//---------------------------------------------------------------------------
// Function structures

typedef struct {
	BOOL BatteryDead;
	BOOL BatteryWarn;
	BOOL CardChange;
	BOOL ReadyChange;
	BOOL GPIChange;
} PCM_STATUS;

//---------------------------------------------------------------------------
// PCMCIA Registers in the NS486 are accessed with an index. The following
// are the registers for each index.

#define PCM_ID_REV            0x00
#define PCM_INTERFACE_STATUS  0x01
#define PCM_POWER_CTRL        0x02
#define PCM_CARD_STATUS       0x04
#define PCM_WINDOW_ENABLE     0x06
#define PCM_GENERAL_CTRL      0x16
#define PCM_GLOBAL_CTRL       0x1e
#define PCM_INT3              0x03
#define PCM_INT5              0x05
#define PCM_MEM0_STARTLB      0x10
#define PCM_MEM0_STARTHB      0x11
#define PCM_MEM0_STOPLB       0x12
#define PCM_MEM0_STOPHB       0x13
#define PCM_MEM0_OFFSETLB     0x14
#define PCM_MEM0_OFFSETHB     0x15

//---------------------------------------------------------------------------
// Register Bit Definitions

// PCMCIA Clock Selection Bits
#define CPUCLK4 0x00
#define CPUCLK3 0x01
#define CPUCLK2 0x10

//---------------------------------------------------------------------------
// General Setup Registers Bit Definitions

// Interface Status Register (Read Only)
#define PCM_BVD1   (1 << 0)
#define PCM_BVD2   (1 << 1)
#define PCM_CD2    (1 << 2)
#define PCM_CD1    (1 << 3)
#define PCM_MWP    (1 << 4)
#define PCM_RDY    (1 << 5)
#define PCM_ACTIVE (1 << 6)
#define PCM_GPI    (1 << 7)

// Power and ResetDRV Control Register  (Read/Write)
#define PCM_VPP1_CRB0         (1 << 0)
#define PCM_VPP1_CRB1         (1 << 1)
#define PCM_VPP2_CRB0         (1 << 2)
#define PCM_VPP2_CRB1         (1 << 3)
#define PCM_CARD_ENABLE       (1 << 4)
#define PCM_AUTO_ENABLE       (1 << 5)
#define PCM_DISABLE_RESETDRV  (1 << 6)
#define PCM_OUTPUT_ENABLE     (1 << 7)

#define PCM_POWER_V_CTRL ( PCM_VPP1_CRB0 | PCM_CARD_ENABLE | PCM_OUTPUT_ENABLE )

// Address Window Enable Register (Read/Write)
#define PCM_MEM0_ENABLE     (1 << 0)
#define PCM_MEM1_ENABLE     (1 << 1)
#define PCM_MEM2_ENABLE     (1 << 2)
#define PCM_MEM3_ENABLE     (1 << 3)
#define PCM_MEM4_ENABLE     (1 << 4)
#define PCM_MEMCS16_DECODE  (1 << 5)
#define PCM_IO0_ENABLE      (1 << 6)
#define PCM_IO1_ENABLE      (1 << 7)

// Interrupt and General Control Register
#define PCM_IRQ0            (1 << 0)
#define PCM_IRQ1            (1 << 1)
#define PCM_IRQ2            (1 << 2)
#define PCM_IRQ3            (1 << 3)
#define PCM_INTR_ENABLE     (1 << 4)
#define PCM_CARD_TYPE       (1 << 5)
#define PCM_RESET_INACTIVE  (1 << 6)
#define PCM_RING_TYPE       (1 << 7)

#define PCM_SETINT ( PCM_INTR_ENABLE | PCM_CARD_TYPE )

#define PCM_CLEARINT 0x00

#define PCM_NOIRQ 0x0
#define PCM_CDIRQ 0xc8
#define PCM_CDE   0x10

//---------------------------------------------------------------------------
// Values for Address Mapping

#define WINDOW_START 0x07800000
#define WINDOW_SIZE 0x00800000
#define TARGET_BASE 0x00000000
#define WINDOW_STOP  ((WINDOW_START + WINDOW_SIZE) - 1)
#define WINDOW_OFFSET (TARGET_BASE - WINDOW_START)

// Status Bit Definitions
#define  NotDead            0
#define  Dead               1
#define  NoWarn             0
#define  Warn               1
#define  ChangeNotDetected  0
#define  ChangeDetected     1

//---------------------------------------------------------------------------
// Function Prototypes

extern USHORT PCMCIA_Enable(void);
extern USHORT PCMCIA_Status(PCM_STATUS *pStatus);

#endif  // #ifndef PCMCIA_H_INC

//---------------------------------------------------------------------------
// END       pcmcia.h
//---------------------------------------------------------------------------
