//---------------------------------------------------------------------------
//
// %FILE     nsglobal.h
// %VSS-REV  $Revision: 16 $
// %CREATED  1996.04.12
// %REVISED  $Date: 4/18/97 4:13p $
// %AUTHOR   Michael C. Draeger
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF, NS486SXL
// %SUMMARY  NSDEMO project header
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:13p $ $Revision: 16 $
//
// DESCRIPTION
//
//   Contains typedefs and externs for Globals so that each module can
//   include this file to access test wide globals.
//
//   Also contains macros and other definitions available to all modules.
//
// HISTORY
//
/*
 *
 * $History: nsglobal.h $ 
 * 
 * *****************  Version 16  *****************
 * User: Miked        Date: 4/18/97    Time: 4:13p
 * Updated in $/nsdemo
 * Added SXL stuff.  Changed dprintf definition.   New header (comment)
 * changes.
 * 
 * *****************  Version 15  *****************
 * User: Miked        Date: 4/07/97    Time: 2:38p
 * Updated in $/nsdemo
 * Removed semicolons from CPU_ macros so that the source code must
 * include a trailing semicolon.  Main reason: the lack of semicolons in
 * if/else blocks was confusing a code beautifier utility.
 * 
 * *****************  Version 14  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 13  *****************
 * User: Miked        Date: 8/05/96    Time: 6:03p
 * Updated in $/nsdemo
 * Added RTTarget support.  Eliminated Watcom differences by using __cdecl
 * in source code.
 * 
 * *****************  Version 12  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 11  *****************
 * User: Miked        Date: 7/23/96    Time: 11:45a
 * Updated in $/nsdemo
 * Got rid of IRETD macros.
 * 
 * *****************  Version 10  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 9  *****************
 * User: Miked        Date: 6/28/96    Time: 1:43p
 * Updated in $/nsdemo
 * Replaced inline assembly with calls to assembly functions.
 * 
 * *****************  Version 8  *****************
 * User: Miked        Date: 6/26/96    Time: 3:33p
 * Updated in $/nsdemo
 * Added STI and CLI macros.
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 5/21/96    Time: 3:00p
 * Updated in $/nsdemo
 * Added BORLANDC IO Macros.
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 4/18/96    Time: 11:36a
 * Updated in $/nsdemo
 * Clean up for release.
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 4/18/96    Time: 10:40a
 * Updated in $/nsdemo
 * Partial check in for dev. use.  Combines old IO.H and NSGLOBAL.H.
 * 
 * *****************  Version 3  *****************
 * User: Noreen       Date: 4/17/96    Time: 1:45p
 * Updated in $/nsdemo
 * Changed PCM_flag to BOOL
 * 
 * *****************  Version 2  *****************
 * User: Noreen       Date: 4/17/96    Time: 12:42p
 * Updated in $/nsdemo
 * Added PCM_flag
 * 
 * *****************  Version 1  *****************
 * User: Miked        Date: 4/12/96    Time: 1:16p
 * Created in $/nstest
 * Header for Globals
 *
 */
//
// COPYRIGHT
//
//      (c) 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef NSGLOBAL_H_INC
#define NSGLOBAL_H_INC

//---------------------------------------------------------------------------
// include files

#include "ns486cfg.h"   // put this one before ns486reg.h so that the
#include "ns486reg.h"   //  proper ECP, PCMCIA, and UART addresses are used
#include <conio.h>
#include <dos.h>
#include <stdarg.h>
#include <stdio.h>

#ifdef ONTIME
#include "rttarget.h"
#endif

//---------------------------------------------------------------------------
// definitions

#define FALSE           0
#define TRUE            1

#ifndef NULL
#define NULL            0
#endif

#define BOOL            unsigned int

#define PRIVATE         static

typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;

typedef unsigned short  USHORT;
typedef unsigned long   ULONG;

//---------------------------------------------------------------------------
// IO macros

#ifdef ONTIME
#undef inp
#undef inpw
#undef outp
#undef outpw
#define _inp RTIn
#define _inpw RTInW
#define _outp RTOut
#define _outpw RTOutW
#define inp RTIn
#define inpw RTInW
#define outp RTOut
#define outpw RTOutW
#define _inp RTIn
#define _inpw RTInW
#define _outp RTOut
#define _outpw RTOutW
#endif

#ifdef __BORLANDC__
#define IOW_BYTE        outp
#define IOW_WORD        outpw
#define IOR_BYTE        inp
#define IOR_WORD        inpw
#else
  #ifdef __WATCOMC__
  #define IOW_BYTE        outp
  #define IOW_WORD        outpw
  #define IOR_BYTE        inp
  #define IOR_WORD        inpw
  #else
    #define IOW_BYTE        _outp
    #define IOW_WORD        _outpw
    #define IOR_BYTE        _inp
    #define IOR_WORD        _inpw
  #endif
#endif

//---------------------------------------------------------------------------
// function return codes

enum ReturnCodes {
        SUCCESS,
        FAIL,
        INVALID_PARAMETER,
        NO_RESOURCE,
};

//---------------------------------------------------------------------------
// structure to hold device ID and revision

typedef struct {
    BYTE id;
    BYTE rev;
} gDEVICE_INFO;

#define ID_NS486SXF 1
#define SXF_REV_A   1
#define SXF_REV_B   2
#define SXF_REV_C   3

#define ID_NS486SXL 2
#define SXL_REV_A   1

//---------------------------------------------------------------------------
// structure to hold Target Info

typedef struct       
{
  BOOL   valid;
  DWORD  raw_cpu_speed;
  DWORD  raw_dram_size;
  int    cpu_speed;
  int    dram_size;
} gTARGET_INFO;

//---------------------------------------------------------------------------
// actual globals

extern gDEVICE_INFO gDeviceInfo;  // global to store device ID and Revision
extern gTARGET_INFO gTargetInfo;  // global to store target info

//---------------------------------------------------------------------------
// global functions

extern void debug_printf( const char *fmt, ... );
#define dprintf debug_printf

//---------------------------------------------------------------------------
// external Assembly functions

void __cdecl _cpu_cli();
void __cdecl _cpu_sti();
void __cdecl _cpu_disable_cache();
void __cdecl _cpu_enable_cache();

#define CPU_CLI _cpu_cli()
#define CPU_STI _cpu_sti()
#define CPU_DISABLE_CACHE _cpu_disable_cache()
#define CPU_ENABLE_CACHE _cpu_enable_cache()

//---------------------------------------------------------------------------

#endif // #ifndef NSGLOBAL_H_INC

//---------------------------------------------------------------------------
// END       nsglobal.h
//---------------------------------------------------------------------------
