//---------------------------------------------------------------------------
//
// %FILE     lm75.h
// %VSS-REV  $Revision: 3 $
// %CREATED  1997.03.04
// %REVISED  $Date: 4/16/97 3:04p $
// %AUTHOR   Rhinda Bal-Firpo 
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF, NS486SXL 
// %SUMMARY  Access.bus test module header
//     
// %VSS      $Author: Rhinda $ $Date: 4/16/97 3:04p $ $Revision: 3 $
//
// DESCRIPTION
//
//   This header file contains definitions and function prototypes for the 
//   file lm75.c 
// 
// HISTORY
//
/*
 *
 * $History: lm75.h $ 
 * 
 * *****************  Version 3  *****************
 * User: Rhinda       Date: 4/16/97    Time: 3:04p
 * Updated in $/nsdemo
 * needed it to do some testing
 * 
 * *****************  Version 2  *****************
 * User: Miked        Date: 4/11/97    Time: 6:28p
 * Updated in $/nsdemo
 * Formatting changes, and moved LM75 Address to this file (from i2c.h).
 * 
 * *****************  Version 1  *****************
 * User: Rhinda       Date: 3/21/97    Time: 4:04p
 * Created in $/nsdemo
 * Initial version of LM75 test code, which tests the I2C interface with a
 * National LM75 evaluation board.
 *
 */
//
// COPYRIGHT
//
//      (c) 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef LM75_H_INC
#define LM75_H_INC

//---------------------------------------------------------------------------
// include files

#include "i2c.h"

//---------------------------------------------------------------------------
// LM75 Address
//
// The three jumpers on the LM75 demo board set the low order three bits
// of the address.  The high order four bits must be 1001B on the LM75.
// Therefore, the address is:
//
//   1001abcX
// 
// Where a,b,c are the bits set by hte jumpers.  For this code, the jumpers
// must be all on for an address of 1001000X.
//
// Bit 0 is used to determine read or write accesses, so it not set here.

#define LM75_ADDRESS 0x90
 
//---------------------------------------------------------------------------
// LM75 registers

#define LM75_TEMP  0x00    // Temperature register; read-only; 2 bytes
#define LM75_CONT  0x01    // Configuration register; read-write, 1 byte
#define LM75_THYST 0x02    // Temperature at which the alarm goes away; 
                           //   read-write; 2 bytes
#define LM75_TOS   0x03    // Temperature alarm threshold; read-write; 2 bytes

//---------------------------------------------------------------------------
// function prototypes

extern USHORT LM75();
extern void LM75_Convert_Write(int convert_value_write, BYTE write_bytes[2]);
extern void LM75_Convert_to_Celsius(BYTE value_read[2], int *pDegree, 
                                    BOOL *pHalfDegree);

//---------------------------------------------------------------------------

#endif // #ifndef LM75_H_INC
