//---------------------------------------------------------------------------
//
// %FILE     i2c.h
// %VSS-REV  $Revision: 4 $
// %CREATED  1997.03.04
// %REVISED  $Date: 4/16/97 3:03p $
// %AUTHOR   Rhinda Bal-Firpo 
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF, NS486SXL 
// %SUMMARY  include file I2C modules
//     
// %VSS      $Author: Rhinda $ $Date: 4/16/97 3:03p $ $Revision: 4 $
//
// DESCRIPTION
//
//  This header file contains definitions and function prototypes for file i2c.c 
// 
// HISTORY
//
/*
 *
 * $History: I2C.H $ 
 * 
 * *****************  Version 4  *****************
 * User: Rhinda       Date: 4/16/97    Time: 3:03p
 * Updated in $/nsdemo
 * needed to do some testing
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 4/11/97    Time: 6:27p
 * Updated in $/nsdemo
 * Formatting changes.  Moved LM75 I2C address to LM75.h.
 * 
 * *****************  Version 2  *****************
 * User: Rhinda       Date: 3/21/97    Time: 4:03p
 * Updated in $/nsdemo
 * Made many changes to initial I2C code.
 *
 */
//
// COPYRIGHT
//
//      (c) 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef I2C_H_INC
#define I2C_H_INC

//----------------------------------------------------------------------
//include files

#include "nsglobal.h"

//----------------------------------------------------------------------
// bit definitions

// TWI_SDA - used when writing address to select read or write operation
#define I2C_SLAVE_READ                    0x01
#define I2C_SLAVE_WRITE                   0x00

// TWI_A_STATUS
#define I2C_BB                            0x08

// TWI_A_CONTROL register

#define I2C_MASTRQ                        0x10
#define I2C_ABINT                         0x08
#define I2C_STOP                          0x04
#define I2C_SET_BUSY                      0x02
#define I2C_ACK                           0x01

// TWI_A_CONTROL - bit value
#define I2C_BUSY                          0x00

//-------------------------------------------------------------------------
// sign for temperature

#define I2C_POSITIVE              1     //temperature zero or above zero
#define I2C_NEGATIVE              0     //temperatrue below zero

//-------------------------------------------------------------------------
// External Function Prototypes

extern USHORT I2C_Initialize();
extern USHORT I2C_Data_Read(BYTE SlaveAddress, int reg_read, int numberbytes, 
                            BYTE *data_read);
extern USHORT I2C_Data_Write(BYTE SlaveAddress, int reg_write, int bytes_write, 
                             BYTE *data_write);

//---------------------------------------------------------------------------

#endif // #ifndef I2C_H_INC

