//---------------------------------------------------------------------------
//
// %FILE     ns486reg.h
// %VSS-REV  $Revision: 6 $
// %VERSION  2.2
// %CREATED  1995.07.27
// %REVISED  $Date: 7/16/96 11:03a $
// %AUTHOR   Michael C. Draeger
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF (rev B0 and newer)
// %SUMMARY  NS486SXF Register locations
//     
// %VSS      $Author: Miked $ $Date: 7/16/96 11:03a $ $Revision: 6 $
//
// DESCRIPTION
//
//   This header file contains the locations of every register in the
//   NS486SXF.  It should be used in C/C++ language programs to
//   access registers symbolically.
//
//   For each register the file indicates (in the comment) the name of
//   the register, when it is readable, whether it is writeable, and the
//   width (8, 16, 32) of the register.
//
// NAMING CONVENTION
//
//   block_regname
//
//       block = block in NS486SXF
//       regname = Register abbreviation / name
//
//     blocks
//
//       BIU     Bus Interface Unit
//       DMA     DMA Controller
//       DRAM    DRAM Controller
//       ECP     ECP Port (IEEE 1284 Bidirectional Parallel Port)
//       LCD     LCD Controller
//       NS486   NS486 device ID registers
//       PCM     PCMCIA
//       PIC     Programmable Interrupt Controller
//       PIT     Programmable Interval Timer
//       PM      Power Management
//       RIO     Reconfigurable I/O
//       RTC     Real Time Clock
//       TWI     Three Wire Interface
//       UART    UART
//       WD      Watchdog Timer
//
// INPUTS
//
//   ECP_BASE -  can be defined as ECP_BASE1, ECP_BASE2, or ECP_BASE3
//               before including this header to indicate where the
//               ECP port is mapped in the part.  The three possible
//               values are:
//
//                 ECP_BASE1     0x00278
//                 ECP_BASE2     0x00378
//                 ECP_BASE3     0x003BC
//
//   PCM_BASE -  can be defined as PCM_BASE1 or PCM_BASE2 before including
//               this header to indicate where the PCMCIA controller is
//               mapped in the part.  The possible values are:
//
//                 PCM_BASE1     0x003E0
//                 PCM_BASE2     0x003E2
//
//   UART_BASE - can be defined as UART_COM1, UART_COM2, UART_COM3, or
//               UART_COM4 before including this header to indicate where
//               the UART is mapped in the part.  The possible values are:
//
//                 UART_COM1     0x003F8
//                 UART_COM2     0x002F8
//                 UART_COM3     0x003E8
//                 UART_COM4     0x002E8
//
// RELEASE HISTORY
//
//   1.0   1995.07.27  mcd  genesis
//   1.1   1995.07.31  mcd  fixed missing comments delimiters
//   1.2   1995.08.07  mcd  added alternate PCMCIA register locations
//                          and cleaned up some register names to make
//                          them more unique
//   1.3   1995.08.22  mcd  renamed misc registers
//   1.4   1995.09.28  mcd  modifed for MAW
//   1.5   1995.11.16  mcd  added two registers for the three wire interface
//   1.6   1995.12.01  mcd  updated DMA for rev B part
//   1.7   1996.01.31  mcd  removed E_ convention, added NS486_ for ID regs,
//                          removed designer notes, fixed DMA address and
//                          byte count registers for rev B
//   1.8   1996.02.06  mcd  cosmetic changes, based off "ns486"
//   1.9   1996.02.06  mcd  added comments to INPUTS section above
//   2.0   1996.04.16  mcd  VSS style headers and small changes to format
//   2.1   1996.05.03  mcd  added PIC_MISRn entries.  these are the same
//                          as the BIU_MIERn entries, but are in the PIC
//                          section where they appear in the datasheet
//   2.2   1996.07.16  mcd  simply changed header for correct part
//
//   (mcd = Michael C. Draeger)
//
// COPYRIGHT
//
//      (c) 1995, 1996 National Semiconductor Corporation
//
// NOTES
//
//---------------------------------------------------------------------------

#ifndef NS486REG_H_INC
#define NS486REG_H_INC

//---------------------------------------------------------------------------

// NS486SXF ID registers
//   entered mcd - 1995.08.22
//   NS486_ added mcd - 1996.01.31

#define NS486_ID      0x0EFC2  // r/    8  NS486SXF Device ID Register
#define NS486_REV     0x0EFC3  // r/    8  NS486SXF Revision Number

//---------------------------------------------------------------------------

// Bus Interface Unit
//   entered mcd - 1995.07.27

#define BIU_CONTROL1  0x0EF00  // r/w   8  BIU Control Register 1
#define BIU_CONTROL2  0x0EF01  // r/w   8  BIU Control Register 2
#define BIU_CS_EN     0x0EF02  // r/w   8  Chip Select Enable
#define BIU_CS_TYPE   0x0EF03  // r/w   8  Chip Select Type

			       // note: you can access as 16 bit registers
			       // (even addresses)
#define BIU_CSBAR1_0  0x0EF04  // r/w   8  CS Base Address Reg 1 byte 0
#define BIU_CSBAR1_1  0x0EF05  // r/w   8  CS Base Address Reg 1 byte 1
#define BIU_CSBAR1_2  0x0EF06  // r/w   8  CS Base Address Reg 1 byte 2
#define BIU_CSBAR1_3  0x0EF07  // r/w   8  CS Base Address Reg 1 byte 3
#define BIU_CSBAR2_0  0x0EF08  // r/w   8  CS Base Address Reg 2 byte 0
#define BIU_CSBAR2_1  0x0EF09  // r/w   8  CS Base Address Reg 2 byte 1
#define BIU_CSBAR2_2  0x0EF0A  // r/w   8  CS Base Address Reg 2 byte 2
#define BIU_CSBAR2_3  0x0EF0B  // r/w   8  CS Base Address Reg 2 byte 3
#define BIU_CSBAR3_0  0x0EF0C  // r/w   8  CS Base Address Reg 3 byte 0
#define BIU_CSBAR3_1  0x0EF0D  // r/w   8  CS Base Address Reg 3 byte 1
#define BIU_CSBAR3_2  0x0EF0E  // r/w   8  CS Base Address Reg 3 byte 2
#define BIU_CSBAR3_3  0x0EF0F  // r/w   8  CS Base Address Reg 3 byte 3
#define BIU_CSBAR4_0  0x0EF10  // r/w   8  CS Base Address Reg 4 byte 0
#define BIU_CSBAR4_1  0x0EF11  // r/w   8  CS Base Address Reg 4 byte 1
#define BIU_CSBAR4_2  0x0EF12  // r/w   8  CS Base Address Reg 4 byte 2
#define BIU_CSBAR4_3  0x0EF13  // r/w   8  CS Base Address Reg 4 byte 3
#define BIU_CSBAR5_0  0x0EF14  // r/w   8  CS Base Address Reg 5 byte 0
#define BIU_CSBAR5_1  0x0EF15  // r/w   8  CS Base Address Reg 5 byte 1
#define BIU_CSBAR5_2  0x0EF16  // r/w   8  CS Base Address Reg 5 byte 2
#define BIU_CSBAR5_3  0x0EF17  // r/w   8  CS Base Address Reg 5 byte 3
#define BIU_CSBAR6_0  0x0EF18  // r/w   8  CS Base Address Reg 6 byte 0
#define BIU_CSBAR6_1  0x0EF19  // r/w   8  CS Base Address Reg 6 byte 1
#define BIU_CSBAR6_2  0x0EF1A  // r/w   8  CS Base Address Reg 6 byte 2
#define BIU_CSBAR6_3  0x0EF1B  // r/w   8  CS Base Address Reg 6 byte 3
#define BIU_CSBAR7_0  0x0EF1C  // r/w   8  CS Base Address Reg 7 byte 0
#define BIU_CSBAR7_1  0x0EF1D  // r/w   8  CS Base Address Reg 7 byte 1
#define BIU_CSBAR7_2  0x0EF1E  // r/w   8  CS Base Address Reg 7 byte 2
#define BIU_CSBAR7_3  0x0EF1F  // r/w   8  CS Base Address Reg 7 byte 3
#define BIU_CSBAR8_0  0x0EF20  // r/w   8  CS Base Address Reg 8 byte 0
#define BIU_CSBAR8_1  0x0EF21  // r/w   8  CS Base Address Reg 8 byte 1
#define BIU_CSBAR8_2  0x0EF22  // r/w   8  CS Base Address Reg 8 byte 2
#define BIU_CSBAR8_3  0x0EF23  // r/w   8  CS Base Address Reg 8 byte 3

			       // note: you can access as 16 bit registers
			       // (even addresses)
#define BIU_CSARR1_0  0x0EF24  // r/w   8  CS Address Range Reg 1 byte 0
#define BIU_CSARR1_1  0x0EF25  // r/w   8  CS Address Range Reg 1 byte 1
#define BIU_CSARR1_2  0x0EF26  // r/w   8  CS Address Range Reg 1 byte 2
#define BIU_CSARR1_3  0x0EF27  // r/w   8  CS Address Range Reg 1 byte 3
#define BIU_CSARR2_0  0x0EF28  // r/w   8  CS Address Range Reg 2 byte 0
#define BIU_CSARR2_1  0x0EF29  // r/w   8  CS Address Range Reg 2 byte 1
#define BIU_CSARR2_2  0x0EF2A  // r/w   8  CS Address Range Reg 2 byte 2
#define BIU_CSARR2_3  0x0EF2B  // r/w   8  CS Address Range Reg 2 byte 3
#define BIU_CSARR3_0  0x0EF2C  // r/w   8  CS Address Range Reg 3 byte 0
#define BIU_CSARR3_1  0x0EF2D  // r/w   8  CS Address Range Reg 3 byte 1
#define BIU_CSARR3_2  0x0EF2E  // r/w   8  CS Address Range Reg 3 byte 2
#define BIU_CSARR3_3  0x0EF2F  // r/w   8  CS Address Range Reg 3 byte 3
#define BIU_CSARR4_0  0x0EF30  // r/w   8  CS Address Range Reg 4 byte 0
#define BIU_CSARR4_1  0x0EF31  // r/w   8  CS Address Range Reg 4 byte 1
#define BIU_CSARR4_2  0x0EF32  // r/w   8  CS Address Range Reg 4 byte 2
#define BIU_CSARR4_3  0x0EF33  // r/w   8  CS Address Range Reg 4 byte 3
#define BIU_CSARR5_0  0x0EF34  // r/w   8  CS Address Range Reg 5 byte 0
#define BIU_CSARR5_1  0x0EF35  // r/w   8  CS Address Range Reg 5 byte 1
#define BIU_CSARR5_2  0x0EF36  // r/w   8  CS Address Range Reg 5 byte 2
#define BIU_CSARR5_3  0x0EF37  // r/w   8  CS Address Range Reg 5 byte 3
#define BIU_CSARR6_0  0x0EF38  // r/w   8  CS Address Range Reg 6 byte 0
#define BIU_CSARR6_1  0x0EF39  // r/w   8  CS Address Range Reg 6 byte 1
#define BIU_CSARR6_2  0x0EF3A  // r/w   8  CS Address Range Reg 6 byte 2
#define BIU_CSARR6_3  0x0EF3B  // r/w   8  CS Address Range Reg 6 byte 3
#define BIU_CSARR7_0  0x0EF3C  // r/w   8  CS Address Range Reg 7 byte 0
#define BIU_CSARR7_1  0x0EF3D  // r/w   8  CS Address Range Reg 7 byte 1
#define BIU_CSARR7_2  0x0EF3E  // r/w   8  CS Address Range Reg 7 byte 2
#define BIU_CSARR7_3  0x0EF3F  // r/w   8  CS Address Range Reg 7 byte 3
#define BIU_CSARR8_0  0x0EF40  // r/w   8  CS Address Range Reg 8 byte 0
#define BIU_CSARR8_1  0x0EF41  // r/w   8  CS Address Range Reg 8 byte 1
#define BIU_CSARR8_2  0x0EF42  // r/w   8  CS Address Range Reg 8 byte 2
#define BIU_CSARR8_3  0x0EF43  // r/w   8  CS Address Range Reg 8 byte 3

#define BIU_RBSR      0x0EF44  // r/w   8  ROM BIOS Selection Register
#define BIU_ECSSR1    0x0EF45  // r/w   8  External CS Selection Reg 1
#define BIU_ECSSR2    0x0EF46  // r/w   8  External CS Selection Reg 2
#define BIU_ECSSR3    0x0EF47  // r/w   8  External CS Selection Reg 3
#define BIU_ECSSR4    0x0EF48  // r/w   8  External CS Selection Reg 4
#define BIU_ECSSR5    0x0EF49  // r/w   8  External CS Selection Reg 5
#define BIU_ECSSR6    0x0EF4A  // r/w   8  External CS Selection Reg 6
#define BIU_ECSSR7    0x0EF4B  // r/w   8  External CS Selection Reg 7
#define BIU_ECSSR8    0x0EF4C  // r/w   8  External CS Selection Reg 8

#define BIU_PBMAR     0x0EF4E  // r/w   8  PCMCIA Base Memory Address Reg.
#define BIU_PCLOCK    0x0EF4F  // r/w   8  PCMCIA Clock Selection Register

#define BIU_CSATR1    0x0EF50  // r/w   8  CS Access Time Register 1
#define BIU_CSATR2    0x0EF51  // r/w   8  CS Access Time Register 2
#define BIU_CSATR3    0x0EF52  // r/w   8  CS Access Time Register 3
#define BIU_CSATR4    0x0EF53  // r/w   8  CS Access Time Register 4

#define BIU_RBATR     0x0EF54  // r/w   8  ROM BIOS Access Time Register
#define BIU_CCSR      0x0EF55  // r/w   8  Cacheable Chip Selects Register
#define BIU_EMCSSR    0x0EF56  // r/w   8  External Master CS Sel. Reg.
#define BIU_P16LCSR   0x0EF57  // r/w   8  Programmed 16-bit Logical CS Reg.

#define BIU_MIER1     0x0EFB0  // r/w   8  Misc. Interrupt Enables Reg. 1
#define BIU_MIER2     0x0EFB2  // r/w   8  Misc. Interrupt Enables Reg. 2
#define BIU_MIER3     0x0EFB8  // r/w   8  Misc. Interrupt Enabled Reg. 3

//---------------------------------------------------------------------------

// DMA Controller
//   entered mcd - 1995.07.27
//   rev B TCS and COMMAND register change mcd - 1995.12.01
//   rev B changes in address/byte count mcd 1996.01.31

#define DMA_COMMAND   0x00008  // r/w   8  DMA Command Register
#define DMA_RQS       0x00009  // r/    8  Request Status Register
#define DMA_DMR0      0x00009  //  /w   8  Data Mode Register CH0-CH3
#define DMA_TCS       0x0000A  // r/w   8  TC Status Register
#define DMA_CMR0      0x0000B  //  /w   8  Channel Mode Register CH0-CH3
#define DMA_CLEAR     0x0000D  //  /w   8  Master Clear
#define DMA_CMASK     0x0000E  //  /w   8  Clear Mask
#define DMA_MASK      0x0000F  // r/w   8  Mask Register
#define DMA_CHAIN0    0x000DA  //  /w   8  Chaining Register CH0-CH3
#define DMA_DMR1      0x000DB  //  /w   8  Data Mode Register CH4-CH6
#define DMA_CMR1      0x000DC  //  /w   8  Channel Mode Register CH4-CH6
#define DMA_CHAIN1    0x000DD  //  /w   8  Chaining Register CH4-CH6
#define DMA_CMCSR     0x000DE  // r/    8  Chaining Mode Channel Status Reg.
#define DMA_CBESR     0x000DF  // r/    8  Chaining Base Empty Status Reg.
#define DMA_IDRSR     0x0EFE0  // r/w   8  Internal DMA Request Sel. Reg.
#define DMA_CDRR      0x0EFE1  // r/w   8  CPU DMA Request Register

			       //          (r current, w base)
#define DMA_BTA0      0x00000  // r/w  16  Base/Curr. Target Address 0
#define DMA_BTA1      0x00002  // r/w  16  Base/Curr. Target Address 1
#define DMA_BTA2      0x00004  // r/w  16  Base/Curr. Target Address 2
#define DMA_BTA3      0x00006  // r/w  16  Base/Curr. Target Address 3
#define DMA_BTA4      0x000C0  // r/w  16  Base/Curr. Target Address 4
#define DMA_BTA5      0x000C4  // r/w  16  Base/Curr. Target Address 5

			       //          (r current, w base)
#define DMA_BTALP0    0x00080  // r/w   8  Base/Curr. Target Addr. Low Page 0
#define DMA_BTALP1    0x00081  // r/w   8  Base/Curr. Target Addr. Low Page 1
#define DMA_BTALP2    0x00082  // r/w   8  Base/Curr. Target Addr. Low Page 2
#define DMA_BTALP3    0x00083  // r/w   8  Base/Curr. Target Addr. Low Page 3
#define DMA_BTALP4    0x00084  // r/w   8  Base/Curr. Target Addr. Low Page 4
#define DMA_BTALP5    0x00085  // r/w   8  Base/Curr. Target Addr. Low Page 5

			       //          (r current, w base)
#define DMA_BTAHP0    0x00018  // r/w   8  Base/Curr. Target Addr. High Pg. 0
#define DMA_BTAHP1    0x00019  // r/w   8  Base/Curr. Target Addr. High Pg. 1
#define DMA_BTAHP2    0x0001A  // r/w   8  Base/Curr. Target Addr. High Pg. 2
#define DMA_BTAHP3    0x0001B  // r/w   8  Base/Curr. Target Addr. High Pg. 3
#define DMA_BTAHP4    0x0001C  // r/w   8  Base/Curr. Target Addr. High Pg. 4
#define DMA_BTAHP5    0x0001D  // r/w   8  Base/Curr. Target Addr. High Pg. 5

			       //          (r current, w base)
#define DMA_BRA0      0x00010  // r/w  16  Base Requestor Address 0
#define DMA_BRA2      0x00012  // r/w  16  Base Requestor Address 2
#define DMA_BRA3      0x00016  // r/w  16  Base Requestor Address 3
#define DMA_BRA4      0x00014  // r/w  16  Base Requestor Address 4

			       //          (r current, w base)
			       //          (Note: 10 bit Registers)
#define DMA_BRAP0     0x00088  // r/w  16  Base/Curr. Requestor Address Pg. 0
#define DMA_BRAP2     0x0008A  // r/w  16  Base/Curr. Requestor Address Pg. 2
#define DMA_BRAP3     0x0008E  // r/w  16  Base/Curr. Requestor Address Pg. 3
#define DMA_BRAP4     0x0008C  // r/w  16  Base/Curr. Requestor Address Pg. 4

			       //          (r current, w base)
#define DMA_BBC0      0x000CC  // r/w  16  Base/Current Byte Count 0
#define DMA_BBC1      0x000CE  // r/w  16  Base/Current Byte Count 1
#define DMA_BBC2      0x000D0  // r/w  16  Base/Current Byte Count 2
#define DMA_BBC3      0x000D2  // r/w  16  Base/Current Byte Count 3
#define DMA_BBC4      0x000D4  // r/w  16  Base/Current Byte Count 4
#define DMA_BBC5      0x000D6  // r/w  16  Base/Current Byte Count 5

//---------------------------------------------------------------------------

// DRAM Controller
//   entered mcd - 1995.07.27

#define DRAM_CONTROL  0x0EF80  // r/w  16  DRAM Control Register
#define DRAM_REFRESH  0x0EF82  // r/w  16  Refresh Rate Register
#define DRAM_RAS      0x0EF84  // r/w  16  RAS* Timeout Register
#define DRAM_STATUS   0x0EF86  // r/w  16  DRAM Status Register
#define DRAM_BANK     0x0EF88  // r/w   8  DRAM Bank Size Register
#define DRAM_ADDR1    0x0EF89  // r/w   8  Bank 1 Address Register
#define DRAM_MASK0    0x0EF8A  // r/w   8  Bank 0 Mask Register
#define DRAM_MASK1    0x0EF8B  // r/w   8  Bank 1 Mask Register

//---------------------------------------------------------------------------

// ECP Port - IEEE 1284 Bidirectional Parallel Port
//   entered mcd - 1995.07.27
//   enclosed with #ifdef - 1995.09.28

#ifdef ECP_BASE

// ECP_BASE needs to be defined as one of the following in the file
// including this one.  This is because several possible bases are
// allowed, but only one is configured for use.

#define ECP_BASE1     0x00278  // */*  **  ECP option 1 register base
#define ECP_BASE2     0x00378  // */*  **  ECP option 2 register base
#define ECP_BASE3     0x003BC  // */*  **  ECP option 3 register base

//

#define ECP_DATAR     ECP_BASE + 0x0000  // r/w   8  DATAR Register
#define ECP_AFIFO     ECP_BASE + 0x0000  //  /w   8  AFIFO Register
#define ECP_DSR       ECP_BASE + 0x0001  // r/    8  DSR Register
#define ECP_DCR       ECP_BASE + 0x0002  // r/w   8  DCR Register
#define ECP_CFIFO     ECP_BASE + 0x0400  // r/w   8  CFIFO Register
#define ECP_DFIFO     ECP_BASE + 0x0400  //  /w   8  DFIFO Register
#define ECP_TFIFO     ECP_BASE + 0x0400  // r/w   8  TFIFO Register
#define ECP_CNFGA     ECP_BASE + 0x0400  // r/w   8  ECP CONFIG_A Register
#define ECP_CNFGB     ECP_BASE + 0x0401  // r/w   8  ECP CONFIG_B Register
#define ECP_ECR       ECP_BASE + 0x0402  // r/w   8  ECR Register
#define ECP_IPR       ECP_BASE + 0x0405  // r/w   8  IPR Register

#define ECP_INDEX     ECP_BASE + 0x0403  // r/w   8  ECP INDEX Register
#define ECP_SETUP     ECP_BASE + 0x0404  // r/w   8  ECP SETUP Register

//

#endif // #ifdef ECP_BASE

//---------------------------------------------------------------------------

// LCD Controller
//   entered mcd - 1995.07.27

#define LCD_CFG1      0x0EFA0  // r/w   8  LCD Configuration Reg. 1
#define LCD_CFG2      0x0EFA1  // r/w   8  LCD Configuration Reg. 2
#define LCD_CFG3      0x0EFA2  // r/w   8  LCD Configuration Reg. 3
#define LCD_CFG4      0x0EFA3  // r/w   8  LCD Configuration Reg. 4

//---------------------------------------------------------------------------

// PCMCIA Controller
//   entered mcd - 1995.07.27
//   alternate base address added mcd - 1995.08.07
//   enclosed with #ifdef - 1995.09.28

#ifdef PCM_BASE

// PCM_BASE needs to be defined as one of the following in the file
// including this one.  This is because several possible bases are
// allowed, but only one is configured for use.

#define PCM_BASE1     0x003E0  // */*  **  PCMCIA option 1 register base
#define PCM_BASE2     0x003E2  // */*  **  PCMCIA option 2 register base

//

#define PCM_INDEX     PCM_BASE + 0x00    // r/w   8  PCMCIA Index
#define PCM_DATA      PCM_BASE + 0x01    // r/w   8  PCMCIA Data

//

#endif // #ifdef PCM_BASE

//---------------------------------------------------------------------------

// Programmable Interrupt Controller (PIC)
//   entered mcd - 1995.07.27

#define PIC_MASTER0   0x00020  // r/w   8  Master PIC port 0
#define PIC_MASTER1   0x00021  // r/w   8  Master PIC port 1
#define PIC_SLAVE0    0x000A0  // r/w   8  Slave PIC port 0
#define PIC_SLAVE1    0x000A1  // r/w   8  Slave PIC port 1

#define PIC_M_ICW1    PIC_MASTER0        // r/w   8  Master ICW1
#define PIC_M_ICW2    PIC_MASTER1        // r/w   8  Master ICW2
#define PIC_M_ICW3    PIC_MASTER1        // r/w   8  Master ICW3
#define PIC_M_ICW4    PIC_MASTER1        // r/w   8  Master ICW4
#define PIC_M_OCW1    PIC_MASTER1        // r/w   8  Master OCW1
#define PIC_M_OCW2    PIC_MASTER0        // r/w   8  Master OCW2
#define PIC_M_OCW3    PIC_MASTER0        // r/w   8  Master OCW3

#define PIC_S_ICW1    PIC_SLAVE0         // r/w   8  Slave ICW1
#define PIC_S_ICW2    PIC_SLAVE1         // r/w   8  Slave ICW2
#define PIC_S_ICW3    PIC_SLAVE1         // r/w   8  Slave ICW3
#define PIC_S_ICW4    PIC_SLAVE1         // r/w   8  Slave ICW4
#define PIC_S_OCW1    PIC_SLAVE1         // r/w   8  Slave OCW1
#define PIC_S_OCW2    PIC_SLAVE0         // r/w   8  Slave OCW2
#define PIC_S_OCW3    PIC_SLAVE0         // r/w   8  Slave OCW3

#define PIC_M_IRR     PIC_M_OCW3         // r/w   8  Master IRR
#define PIC_M_IMR     PIC_M_OCW1         // r/w   8  Master IMR
#define PIC_M_ISR     PIC_M_OCW3         // r/w   8  Master ISR

#define PIC_S_IRR     PIC_S_OCW3         // r/w   8  Slave IRR
#define PIC_S_IMR     PIC_S_OCW1         // r/w   8  Slave IMR
#define PIC_S_ISR     PIC_S_OCW3         // r/w   8  Slave ISR

#define PIC_II1SR     0x0EFB1  // r/w   8  Internal Interrupt  1 Sel. Reg.
#define PIC_II3SR     0x0EFB3  // r/w   8  Internal Interrupt  3 Sel. Reg.
#define PIC_II4SR     0x0EFB4  // r/w   8  Internal Interrupt  4 Sel. Reg.
#define PIC_II5SR     0x0EFB5  // r/w   8  Internal Interrupt  5 Sel. Reg.
#define PIC_II6SR     0x0EFB6  // r/w   8  Internal Interrupt  6 Sel. Reg.
#define PIC_II7SR     0x0EFB7  // r/w   8  Internal Interrupt  7 Sel. Reg.
#define PIC_II9SR     0x0EFB9  // r/w   8  Internal Interrupt  9 Sel. Reg.
#define PIC_II10SR    0x0EFBA  // r/w   8  Internal Interrupt 10 Sel. Reg.
#define PIC_II11SR    0x0EFBB  // r/w   8  Internal Interrupt 11 Sel. Reg.
#define PIC_II12SR    0x0EFBC  // r/w   8  Internal Interrupt 12 Sel. Reg.
#define PIC_II13SR    0x0EFBD  // r/w   8  Internal Interrupt 13 Sel. Reg.
#define PIC_II14SR    0x0EFBE  // r/w   8  Internal Interrupt 14 Sel. Reg.
#define PIC_II15SR    0x0EFBF  // r/w   8  Internal Interrupt 15 Sel. Reg.

#define PIC_MISR1     0x0EFB0  // r/w   8  Misc. Interrupt Selection Reg. 1
#define PIC_MISR2     0x0EFB2  // r/w   8  Misc. Interrupt Selection Reg. 2
#define PIC_MISR3     0x0EFB8  // r/w   8  Misc. Interrupt Selection Reg. 3

//---------------------------------------------------------------------------

// Programmable Interval Timer (PIT)
//   entered mcd - 1995.07.27

#define PIT_COUNT0    0x00040  // r/w   8  Counter 0
#define PIT_COUNT1    0x00041  // r/w   8  Counter 1
#define PIT_COUNT2    0x00042  // r/w   8  Counter 2
#define PIT_CONTROL   0x00043  //  /w   8  Timer Control Register
#define PIT_TICR      0x00044  // r/w   8  Timer I/O Control Register
#define PIT_CLOCK     0x00045  // r/w   8  Timer Clock Register

//---------------------------------------------------------------------------

// Power Management
//   entered mcd - 1995.07.27

#define PM_PMR1       0x0EF90  // r/w   8  Power Management Register 1
#define PM_PMR2       0x0EF91  // r/w   8  Power Management Register 2
#define PM_PMR3       0x0EF92  // r/w   8  Power Management Register 3
#define PM_PMR4       0x0EF93  // r/w   8  Power Management Register 4

//---------------------------------------------------------------------------

// Reconfigurable I/O
//   entered mcd - 1995.07.27

#define RIO_CONTROL   0x0EFC0  // r/w   8  RIO Control Register

#define RIO_DD        0x0EFC4  // r/w  32  Data Direction Register
#define RIO_DD_WORD0  0x0EFC4  // r/w  16  Data Direction Word 0
#define RIO_DD_BYTE0  0x0EFC4  // r/w   8  Data Direction Byte 0
#define RIO_DD_BYTE1  0x0EFC5  // r/w   8  Data Direction Byte 1
#define RIO_DD_WORD1  0x0EFC6  // r/w  16  Data Direction Word 1
#define RIO_DD_BYTE2  0x0EFC6  // r/w   8  Data Direction Byte 2
#define RIO_DD_BYTE3  0x0EFC7  // r/w   8  Data Direction Byte 3

#define RIO_DI        0x0EFC8  // r/w  32  Data Port In Register
#define RIO_DI_WORD0  0x0EFC8  // r/w  16  Data Input Word 0
#define RIO_DI_BYTE0  0x0EFC8  // r/w   8  Data Input Byte 0
#define RIO_DI_BYTE1  0x0EFC9  // r/w   8  Data Input Byte 1
#define RIO_DI_WORD1  0x0EFCA  // r/w  16  Data Input Word 1
#define RIO_DI_BYTE2  0x0EFCA  // r/w   8  Data Input Byte 2
#define RIO_DI_BYTE3  0x0EFCB  // r/w   8  Data Input Byte 3

#define RIO_DO        0x0EFCC  // r/w  32  Data Port Out Register
#define RIO_DO_WORD0  0x0EFCC  // r/w  16  Data Output Word 0
#define RIO_DO_BYTE0  0x0EFCC  // r/w   8  Data Output Byte 0
#define RIO_DO_BYTE1  0x0EFCD  // r/w   8  Data Output Byte 1
#define RIO_DO_WORD1  0x0EFCE  // r/w  16  Data Output Word 1
#define RIO_DO_BYTE2  0x0EFCE  // r/w   8  Data Output Byte 2
#define RIO_DO_BYTE3  0x0EFCF  // r/w   8  Data Output Byte 3

//---------------------------------------------------------------------------

// Real Time Clock

#define RTC_INDEX     0x00070  // r/w   8  RTC Index
#define RTC_DATA      0x00071  // r/w   8  RTC Data

//---------------------------------------------------------------------------

// Three Wire Interface
//   entered mcd - 1995.07.27
//   added TWI_A_CTRL2 and TWI_U_SCS - 1995.11.16

#define TWI_CONTROL   0x00050  // r/w   8  3-Wire Control Register
#define TWI_SIO       0x00051  // r/w   8  3-Wire Serial I/O Register
#define TWI_U_CONTROL 0x00052  // r/w   8  Microwire Control Register
#define TWI_SDA       0x00053  // r/w   8  Serial Input/Output Data Register
#define TWI_A_STATUS  0x00054  // r/    8  Access.bus Status Register
#define TWI_A_CONTROL 0x00055  // r/w   8  Access.bus Control Register
#define TWI_A_ADDR    0x00056  // r/w   8  Access.bus Own Address Register
#define TWI_A_CTRL2   0x00057  // r/w   8  Access.bus Control Register 2
#define TWI_U_SCS     0x0EFC1  // r/w   8  Microwire Slave Chip Select Reg.

//---------------------------------------------------------------------------

// UART
//   entered mcd - 1995.07.27
//   enclosed with #ifdef - 1995.09.28

#ifdef UART_BASE

// UART_BASE needs to be defined as one of the following in the file
// including this one.  This is because several possible bases are
// allowed, but only one is configured for use.

#define UART_COM1     0x003F8  // */*  **  UART COM 1 register base
#define UART_COM2     0x002F8  // */*  **  UART COM 2 register base
#define UART_COM3     0x003E8  // */*  **  UART COM 3 register base
#define UART_COM4     0x002E8  // */*  **  UART COM 3 register base

//

#define UART_CLOCK    0x0EF70  // r/w   8  UART Clock Divisor Register
#define UART_MSC      0x0EF71  // r/w   8  Modem Signal Control Register

#define UART_RBR      UART_BASE + 0x00   // r/    8  Receiver Buffer Reg.
#define UART_THR      UART_BASE + 0x00   //  /w   8  Transmit Holding Reg.
#define UART_IER      UART_BASE + 0x01   // r/w   8  Interrupt Enable Reg.
#define UART_IIR      UART_BASE + 0x02   // r/    8  Interrupt Id. Reg.
#define UART_FCR      UART_BASE + 0x02   //  /w   8  FIFO Control Reg.
#define UART_LCR      UART_BASE + 0x03   // r/w   8  Line Control Reg.
#define UART_MCR      UART_BASE + 0x04   // r/w   8  Modem Control Reg.
#define UART_LSR      UART_BASE + 0x05   // r/w   8  Line Status Reg.
#define UART_MSR      UART_BASE + 0x06   // r/w   8  Modem Status Reg.
#define UART_SCR      UART_BASE + 0x07   // r/w   8  Scratch Pad Reg.
#define UART_DLL      UART_BASE + 0x00   // r/w   8  Divisor Latch LSB
#define UART_DLM      UART_BASE + 0x01   // r/w   8  Divisor Latch MSB

//

#endif // #ifdef UART_BASE

//---------------------------------------------------------------------------

// Watchdog Timer
//   entered mcd - 1995.07.27

#define WD_RETRIGGER  0x00046  // r/w  16  Watchdog Retrigger
#define WD_CONTROL    0x00047  // r/w   8  Watchdog Control Register

//---------------------------------------------------------------------------

#endif // #ifndef NS486REG_H_INC

//---------------------------------------------------------------------------
// END       ns486reg.h
//---------------------------------------------------------------------------
