;---------------------------------------------------------------------------
;
; %FILE     io.inc
; %VSS-REV  $Revision: 2 $
; %VERSION  1.1
; %CREATED  1995.07.27
; %REVISED  $Date: 10/31/96 10:32a $
; %AUTHOR   Michael C. Draeger 
; %PROJECT  NS486SXF evaluation board software
; %PART     NS486SXF 
; %SUMMARY  macros for I/O 
;     
; %VSS      $Author: Miked $ $Date: 10/31/96 10:32a $ $Revision: 2 $
;
; DESCRIPTION
;
;   Six useful IO macros for use in assembly language code.
;
;       outpb - output a byte to a port
;       outpw - output a word to a port
;       outpd - output a double word to a port
;       inpb  - input a byte from a port
;       inpw  - input a word from a port
;       inpd  - input a double word from a port
;
; RELEASE HISTORY
;
;   1.0   1995.08.01  mcd  genesis
;   1.1   1996.10.31  mcd  added double word macros
;
; COPYRIGHT
;
;      (c) 1995, 1996 National Semiconductor Corporation
;
;---------------------------------------------------------------------------

; outpb - outputs a byte to a I/O address
; dx and al destroyed

outpb MACRO addr, val
  mov dx, addr          ; address of port (16 bit value)
  mov al, val           ; value (8 bit)
  out dx, al            ; output byte
ENDM

; outpw - outputs a word to a I/O address
; dx and ax destroyed

outpw MACRO addr, val
  mov dx, addr          ; address of port (16 bit value)
  mov ax, val           ; value (16 bit)
  out dx, ax            ; output word
ENDM

; outpd - outputs a double word to a I/O address
; dx and eax destroyed

outpd MACRO addr, val
  mov dx,  addr          ; address of port (16 bit value)
  mov eax, val           ; value (32 bit)
  out dx,  eax           ; output double word
ENDM

; inpb - inputs a byte from a I/O address
; dx and al destroyed

inpb MACRO addr
  mov dx, addr          ; address of port (16 bit value)
  in  al, dx            ; input byte
ENDM

; inpw - inputs a word from a I/O address
; dx and ax destroyed

inpw MACRO addr
  mov dx, addr          ; address of port (16 bit value)
  in  ax, dx            ; input word
ENDM

; inpd - inputs a double word from a I/O address
; dx and eax destroyed

inpd MACRO addr
  mov dx, addr          ; address of port (16 bit value)
  in  eax, dx           ; input double word
ENDM

;---------------------------------------------------------------------------
; END       io.inc 
;---------------------------------------------------------------------------
