;---------------------------------------------------------------------------
;
; %FILE     ns486reg.inc
; %VSS-REV  $Revision: 4 $
; %VERSION  2.1
; %CLASS    release
; %CREATED  1995.07.27
; %REVISED  $Date: 5/06/96 10:17a $
; %AUTHOR   Michael C. Draeger
; %PROJECT  NS486SXF evaluation board software
; %PART     NS486SXF B0, B2
; %SUMMARY  NS486SXF Register locations
;     
; %VSS      $Author: Miked $ $Date: 5/06/96 10:17a $ $Revision: 4 $
;
; DESCRIPTION
;
;   This header file contains the locations of every register in the
;   NS486SXF.  It should be used in Assembly language programs to
;   access registers symbolically.
;
;   For each register the file indicates (in the comment) the name of
;   the register, when it is readable, whether it is writeable, and the
;   width (8, 16, 32) of the register.
;
; NAMING CONVENTION
;
;   block_regname
;
;       block = block in NS486SXF
;       regname = Register abbreviation / name
;
;     blocks
;
;       BIU     Bus Interface Unit
;       DMA     DMA Controller
;       DRAM    DRAM Controller
;       ECP     ECP Port (IEEE 1284 Bidirectional Parallel Port)
;       LCD     LCD Controller
;       NS486   NS486 device ID registers
;       PCM     PCMCIA
;       PIC     Programmable Interrupt Controller
;       PIT     Programmable Interval Timer
;       PM      Power Management
;       RIO     Reconfigurable I/O
;       RTC     Real Time Clock
;       TWI     Three Wire Interface
;       UART    UART
;       WD      Watchdog Timer
;
; INPUTS
;
;   ECP_BASE -  can be defined as ECP_BASE1, ECP_BASE2, or ECP_BASE3
;               before including this header to indicate where the
;               ECP port is mapped in the part.  The three possible
;               values are:
;
;                 ECP_BASE1     0x00278
;                 ECP_BASE2     0x00378
;                 ECP_BASE3     0x003BC
;
;   PCM_BASE -  can be defined as PCM_BASE1 or PCM_BASE2 before including
;               this header to indicate where the PCMCIA controller is
;               mapped in the part.  The possible values are:
;
;                 PCM_BASE1     0x003E0
;                 PCM_BASE2     0x003E2
;
;   UART_BASE - can be defined as UART_COM1, UART_COM2, UART_COM3, or
;               UART_COM4 before including this header to indicate where
;               the UART is mapped in the part.  The possible values are:
;
;                 UART_COM1     0x003F8
;                 UART_COM2     0x002F8
;                 UART_COM3     0x003E8
;                 UART_COM4     0x002E8
;
; RELEASE HISTORY
;
;   1.0   1995.07.27  mcd  genesis
;   1.1   1995.07.31  mcd  fixed missing comments delimiters
;   1.2   1995.08.07  mcd  added alternate PCMCIA register locations
;                          and cleaned up some register names to make
;                          them more unique
;   1.3   1995.08.22  mcd  renamed misc registers
;   1.4   1995.09.28  mcd  modifed for MAW
;   1.5   1995.11.16  mcd  added two registers for the three wire interface
;   1.6   1995.12.01  mcd  updated DMA for rev B part
;   1.7   1996.01.31  mcd  removed E_ convention, added NS486_ for ID regs,
;                          removed designer notes, fixed DMA address and
;                          byte count registers for rev B
;   1.8   1996.02.06  mcd  cosmetic changes, based off "ns486"
;   1.9   1996.02.06  mcd  added comments to INPUTS section above
;   2.0   1996.04.16  mcd  VSS style headers and small changes to format
;   2.1   1996.05.03  mcd  added PIC_MISRn entries.  these are the same
;                          as the BIU_MIERn entries, but are in the PIC
;                          section where they appear in the datasheet
;
;   (mcd = Michael C. Draeger)
;
; COPYRIGHT
;
;      (c) 1995, 1996 National Semiconductor Corporation
;
; NOTES
;
;---------------------------------------------------------------------------

IFNDEF NS486REG_INC_INC
NS486REG_INC_INC equ 1

;---------------------------------------------------------------------------

; NS486SXF ID registers
;   entered mcd - 1995.08.22
;   NS486_ added mcd - 1996.01.31

NS486_ID      equ 0EFC2h  ; r/    8  NS486SXF Device ID Register
NS486_REV     equ 0EFC3h  ; r/    8  NS486SXF Revision Number

;---------------------------------------------------------------------------

; Bus Interface Unit
;   entered mcd - 1995.07.27

BIU_CONTROL1  equ 0EF00h  ; r/w   8  BIU Control Register 1
BIU_CONTROL2  equ 0EF01h  ; r/w   8  BIU Control Register 2
BIU_CS_EN     equ 0EF02h  ; r/w   8  Chip Select Enable
BIU_CS_TYPE   equ 0EF03h  ; r/w   8  Chip Select Type

                               ; note: you can access as 16 bit registers
                               ; (even addresses)
BIU_CSBAR1_0  equ 0EF04h  ; r/w   8  CS Base Address Reg 1 byte 0
BIU_CSBAR1_1  equ 0EF05h  ; r/w   8  CS Base Address Reg 1 byte 1
BIU_CSBAR1_2  equ 0EF06h  ; r/w   8  CS Base Address Reg 1 byte 2
BIU_CSBAR1_3  equ 0EF07h  ; r/w   8  CS Base Address Reg 1 byte 3
BIU_CSBAR2_0  equ 0EF08h  ; r/w   8  CS Base Address Reg 2 byte 0
BIU_CSBAR2_1  equ 0EF09h  ; r/w   8  CS Base Address Reg 2 byte 1
BIU_CSBAR2_2  equ 0EF0Ah  ; r/w   8  CS Base Address Reg 2 byte 2
BIU_CSBAR2_3  equ 0EF0Bh  ; r/w   8  CS Base Address Reg 2 byte 3
BIU_CSBAR3_0  equ 0EF0Ch  ; r/w   8  CS Base Address Reg 3 byte 0
BIU_CSBAR3_1  equ 0EF0Dh  ; r/w   8  CS Base Address Reg 3 byte 1
BIU_CSBAR3_2  equ 0EF0Eh  ; r/w   8  CS Base Address Reg 3 byte 2
BIU_CSBAR3_3  equ 0EF0Fh  ; r/w   8  CS Base Address Reg 3 byte 3
BIU_CSBAR4_0  equ 0EF10h  ; r/w   8  CS Base Address Reg 4 byte 0
BIU_CSBAR4_1  equ 0EF11h  ; r/w   8  CS Base Address Reg 4 byte 1
BIU_CSBAR4_2  equ 0EF12h  ; r/w   8  CS Base Address Reg 4 byte 2
BIU_CSBAR4_3  equ 0EF13h  ; r/w   8  CS Base Address Reg 4 byte 3
BIU_CSBAR5_0  equ 0EF14h  ; r/w   8  CS Base Address Reg 5 byte 0
BIU_CSBAR5_1  equ 0EF15h  ; r/w   8  CS Base Address Reg 5 byte 1
BIU_CSBAR5_2  equ 0EF16h  ; r/w   8  CS Base Address Reg 5 byte 2
BIU_CSBAR5_3  equ 0EF17h  ; r/w   8  CS Base Address Reg 5 byte 3
BIU_CSBAR6_0  equ 0EF18h  ; r/w   8  CS Base Address Reg 6 byte 0
BIU_CSBAR6_1  equ 0EF19h  ; r/w   8  CS Base Address Reg 6 byte 1
BIU_CSBAR6_2  equ 0EF1Ah  ; r/w   8  CS Base Address Reg 6 byte 2
BIU_CSBAR6_3  equ 0EF1Bh  ; r/w   8  CS Base Address Reg 6 byte 3
BIU_CSBAR7_0  equ 0EF1Ch  ; r/w   8  CS Base Address Reg 7 byte 0
BIU_CSBAR7_1  equ 0EF1Dh  ; r/w   8  CS Base Address Reg 7 byte 1
BIU_CSBAR7_2  equ 0EF1Eh  ; r/w   8  CS Base Address Reg 7 byte 2
BIU_CSBAR7_3  equ 0EF1Fh  ; r/w   8  CS Base Address Reg 7 byte 3
BIU_CSBAR8_0  equ 0EF20h  ; r/w   8  CS Base Address Reg 8 byte 0
BIU_CSBAR8_1  equ 0EF21h  ; r/w   8  CS Base Address Reg 8 byte 1
BIU_CSBAR8_2  equ 0EF22h  ; r/w   8  CS Base Address Reg 8 byte 2
BIU_CSBAR8_3  equ 0EF23h  ; r/w   8  CS Base Address Reg 8 byte 3

                               ; note: you can access as 16 bit registers
                               ; (even addresses)
BIU_CSARR1_0  equ 0EF24h  ; r/w   8  CS Address Range Reg 1 byte 0
BIU_CSARR1_1  equ 0EF25h  ; r/w   8  CS Address Range Reg 1 byte 1
BIU_CSARR1_2  equ 0EF26h  ; r/w   8  CS Address Range Reg 1 byte 2
BIU_CSARR1_3  equ 0EF27h  ; r/w   8  CS Address Range Reg 1 byte 3
BIU_CSARR2_0  equ 0EF28h  ; r/w   8  CS Address Range Reg 2 byte 0
BIU_CSARR2_1  equ 0EF29h  ; r/w   8  CS Address Range Reg 2 byte 1
BIU_CSARR2_2  equ 0EF2Ah  ; r/w   8  CS Address Range Reg 2 byte 2
BIU_CSARR2_3  equ 0EF2Bh  ; r/w   8  CS Address Range Reg 2 byte 3
BIU_CSARR3_0  equ 0EF2Ch  ; r/w   8  CS Address Range Reg 3 byte 0
BIU_CSARR3_1  equ 0EF2Dh  ; r/w   8  CS Address Range Reg 3 byte 1
BIU_CSARR3_2  equ 0EF2Eh  ; r/w   8  CS Address Range Reg 3 byte 2
BIU_CSARR3_3  equ 0EF2Fh  ; r/w   8  CS Address Range Reg 3 byte 3
BIU_CSARR4_0  equ 0EF30h  ; r/w   8  CS Address Range Reg 4 byte 0
BIU_CSARR4_1  equ 0EF31h  ; r/w   8  CS Address Range Reg 4 byte 1
BIU_CSARR4_2  equ 0EF32h  ; r/w   8  CS Address Range Reg 4 byte 2
BIU_CSARR4_3  equ 0EF33h  ; r/w   8  CS Address Range Reg 4 byte 3
BIU_CSARR5_0  equ 0EF34h  ; r/w   8  CS Address Range Reg 5 byte 0
BIU_CSARR5_1  equ 0EF35h  ; r/w   8  CS Address Range Reg 5 byte 1
BIU_CSARR5_2  equ 0EF36h  ; r/w   8  CS Address Range Reg 5 byte 2
BIU_CSARR5_3  equ 0EF37h  ; r/w   8  CS Address Range Reg 5 byte 3
BIU_CSARR6_0  equ 0EF38h  ; r/w   8  CS Address Range Reg 6 byte 0
BIU_CSARR6_1  equ 0EF39h  ; r/w   8  CS Address Range Reg 6 byte 1
BIU_CSARR6_2  equ 0EF3Ah  ; r/w   8  CS Address Range Reg 6 byte 2
BIU_CSARR6_3  equ 0EF3Bh  ; r/w   8  CS Address Range Reg 6 byte 3
BIU_CSARR7_0  equ 0EF3Ch  ; r/w   8  CS Address Range Reg 7 byte 0
BIU_CSARR7_1  equ 0EF3Dh  ; r/w   8  CS Address Range Reg 7 byte 1
BIU_CSARR7_2  equ 0EF3Eh  ; r/w   8  CS Address Range Reg 7 byte 2
BIU_CSARR7_3  equ 0EF3Fh  ; r/w   8  CS Address Range Reg 7 byte 3
BIU_CSARR8_0  equ 0EF40h  ; r/w   8  CS Address Range Reg 8 byte 0
BIU_CSARR8_1  equ 0EF41h  ; r/w   8  CS Address Range Reg 8 byte 1
BIU_CSARR8_2  equ 0EF42h  ; r/w   8  CS Address Range Reg 8 byte 2
BIU_CSARR8_3  equ 0EF43h  ; r/w   8  CS Address Range Reg 8 byte 3

BIU_RBSR      equ 0EF44h  ; r/w   8  ROM BIOS Selection Register
BIU_ECSSR1    equ 0EF45h  ; r/w   8  External CS Selection Reg 1
BIU_ECSSR2    equ 0EF46h  ; r/w   8  External CS Selection Reg 2
BIU_ECSSR3    equ 0EF47h  ; r/w   8  External CS Selection Reg 3
BIU_ECSSR4    equ 0EF48h  ; r/w   8  External CS Selection Reg 4
BIU_ECSSR5    equ 0EF49h  ; r/w   8  External CS Selection Reg 5
BIU_ECSSR6    equ 0EF4Ah  ; r/w   8  External CS Selection Reg 6
BIU_ECSSR7    equ 0EF4Bh  ; r/w   8  External CS Selection Reg 7
BIU_ECSSR8    equ 0EF4Ch  ; r/w   8  External CS Selection Reg 8

BIU_PBMAR     equ 0EF4Eh  ; r/w   8  PCMCIA Base Memory Address Reg.
BIU_PCLOCK    equ 0EF4Fh  ; r/w   8  PCMCIA Clock Selection Register

BIU_CSATR1    equ 0EF50h  ; r/w   8  CS Access Time Register 1
BIU_CSATR2    equ 0EF51h  ; r/w   8  CS Access Time Register 2
BIU_CSATR3    equ 0EF52h  ; r/w   8  CS Access Time Register 3
BIU_CSATR4    equ 0EF53h  ; r/w   8  CS Access Time Register 4

BIU_RBATR     equ 0EF54h  ; r/w   8  ROM BIOS Access Time Register
BIU_CCSR      equ 0EF55h  ; r/w   8  Cacheable Chip Selects Register
BIU_EMCSSR    equ 0EF56h  ; r/w   8  External Master CS Sel. Reg.
BIU_P16LCSR   equ 0EF57h  ; r/w   8  Programmed 16-bit Logical CS Reg.

BIU_MIER1     equ 0EFB0h  ; r/w   8  Misc. Interrupt Enables Reg. 1
BIU_MIER2     equ 0EFB2h  ; r/w   8  Misc. Interrupt Enables Reg. 2
BIU_MIER3     equ 0EFB8h  ; r/w   8  Misc. Interrupt Enabled Reg. 3

;---------------------------------------------------------------------------

; DMA Controller
;   entered mcd - 1995.07.27
;   rev B TCS and COMMAND register change mcd - 1995.12.01
;   rev B changes in address/byte count mcd 1996.01.31

DMA_COMMAND   equ 00008h  ; r/w   8  DMA Command Register
DMA_RQS       equ 00009h  ; r/    8  Request Status Register
DMA_DMR0      equ 00009h  ;  /w   8  Data Mode Register CH0-CH3
DMA_TCS       equ 0000Ah  ; r/w   8  TC Status Register
DMA_CMR0      equ 0000Bh  ;  /w   8  Channel Mode Register CH0-CH3
DMA_CLEAR     equ 0000Dh  ;  /w   8  Master Clear
DMA_CMASK     equ 0000Eh  ;  /w   8  Clear Mask
DMA_MASK      equ 0000Fh  ; r/w   8  Mask Register
DMA_CHAIN0    equ 000DAh  ;  /w   8  Chaining Register CH0-CH3
DMA_DMR1      equ 000DBh  ;  /w   8  Data Mode Register CH4-CH6
DMA_CMR1      equ 000DCh  ;  /w   8  Channel Mode Register CH4-CH6
DMA_CHAIN1    equ 000DDh  ;  /w   8  Chaining Register CH4-CH6
DMA_CMCSR     equ 000DEh  ; r/    8  Chaining Mode Channel Status Reg.
DMA_CBESR     equ 000DFh  ; r/    8  Chaining Base Empty Status Reg.
DMA_IDRSR     equ 0EFE0h  ; r/w   8  Internal DMA Request Sel. Reg.
DMA_CDRR      equ 0EFE1h  ; r/w   8  CPU DMA Request Register

                               ;          (r current, w base)
DMA_BTA0      equ 00000h  ; r/w  16  Base/Curr. Target Address 0
DMA_BTA1      equ 00002h  ; r/w  16  Base/Curr. Target Address 1
DMA_BTA2      equ 00004h  ; r/w  16  Base/Curr. Target Address 2
DMA_BTA3      equ 00006h  ; r/w  16  Base/Curr. Target Address 3
DMA_BTA4      equ 000C0h  ; r/w  16  Base/Curr. Target Address 4
DMA_BTA5      equ 000C4h  ; r/w  16  Base/Curr. Target Address 5

                               ;          (r current, w base)
DMA_BTALP0    equ 00080h  ; r/w   8  Base/Curr. Target Addr. Low Page 0
DMA_BTALP1    equ 00081h  ; r/w   8  Base/Curr. Target Addr. Low Page 1
DMA_BTALP2    equ 00082h  ; r/w   8  Base/Curr. Target Addr. Low Page 2
DMA_BTALP3    equ 00083h  ; r/w   8  Base/Curr. Target Addr. Low Page 3
DMA_BTALP4    equ 00084h  ; r/w   8  Base/Curr. Target Addr. Low Page 4
DMA_BTALP5    equ 00085h  ; r/w   8  Base/Curr. Target Addr. Low Page 5

                               ;          (r current, w base)
DMA_BTAHP0    equ 00018h  ; r/w   8  Base/Curr. Target Addr. High Pg. 0
DMA_BTAHP1    equ 00019h  ; r/w   8  Base/Curr. Target Addr. High Pg. 1
DMA_BTAHP2    equ 0001Ah  ; r/w   8  Base/Curr. Target Addr. High Pg. 2
DMA_BTAHP3    equ 0001Bh  ; r/w   8  Base/Curr. Target Addr. High Pg. 3
DMA_BTAHP4    equ 0001Ch  ; r/w   8  Base/Curr. Target Addr. High Pg. 4
DMA_BTAHP5    equ 0001Dh  ; r/w   8  Base/Curr. Target Addr. High Pg. 5

                               ;          (r current, w base)
DMA_BRA0      equ 00010h  ; r/w  16  Base Requestor Address 0
DMA_BRA2      equ 00012h  ; r/w  16  Base Requestor Address 2
DMA_BRA3      equ 00016h  ; r/w  16  Base Requestor Address 3
DMA_BRA4      equ 00014h  ; r/w  16  Base Requestor Address 4

                               ;          (r current, w base)
                               ;          (Note: 10 bit Registers)
DMA_BRAP0     equ 00088h  ; r/w  16  Base/Curr. Requestor Address Pg. 0
DMA_BRAP2     equ 0008Ah  ; r/w  16  Base/Curr. Requestor Address Pg. 2
DMA_BRAP3     equ 0008Eh  ; r/w  16  Base/Curr. Requestor Address Pg. 3
DMA_BRAP4     equ 0008Ch  ; r/w  16  Base/Curr. Requestor Address Pg. 4

                               ;          (r current, w base)
DMA_BBC0      equ 000CCh  ; r/w  16  Base/Current Byte Count 0
DMA_BBC1      equ 000CEh  ; r/w  16  Base/Current Byte Count 1
DMA_BBC2      equ 000D0h  ; r/w  16  Base/Current Byte Count 2
DMA_BBC3      equ 000D2h  ; r/w  16  Base/Current Byte Count 3
DMA_BBC4      equ 000D4h  ; r/w  16  Base/Current Byte Count 4
DMA_BBC5      equ 000D6h  ; r/w  16  Base/Current Byte Count 5

;---------------------------------------------------------------------------

; DRAM Controller
;   entered mcd - 1995.07.27

DRAM_CONTROL  equ 0EF80h  ; r/w  16  DRAM Control Register
DRAM_REFRESH  equ 0EF82h  ; r/w  16  Refresh Rate Register
DRAM_RAS      equ 0EF84h  ; r/w  16  RAS* Timeout Register
DRAM_STATUS   equ 0EF86h  ; r/w  16  DRAM Status Register
DRAM_BANK     equ 0EF88h  ; r/w   8  DRAM Bank Size Register
DRAM_ADDR1    equ 0EF89h  ; r/w   8  Bank 1 Address Register
DRAM_MASK0    equ 0EF8Ah  ; r/w   8  Bank 0 Mask Register
DRAM_MASK1    equ 0EF8Bh  ; r/w   8  Bank 1 Mask Register

;---------------------------------------------------------------------------

; ECP Port - IEEE 1284 Bidirectional Parallel Port
;   entered mcd - 1995.07.27
;   enclosed with IFDEF - 1995.09.28

IFDEF ECP_BASE

; ECP_BASE needs to be defined as one of the following in the file
; including this one.  This is because several possible bases are
; allowed, but only one is configured for use.

ECP_BASE1     equ 00278h  ; */*  **  ECP option 1 register base
ECP_BASE2     equ 00378h  ; */*  **  ECP option 2 register base
ECP_BASE3     equ 003BCh  ; */*  **  ECP option 3 register base

;

ECP_DATAR     equ ECP_BASE + 0000h  ; r/w   8  DATAR Register
ECP_AFIFO     equ ECP_BASE + 0000h  ;  /w   8  AFIFO Register
ECP_DSR       equ ECP_BASE + 0001h  ; r/    8  DSR Register
ECP_DCR       equ ECP_BASE + 0002h  ; r/w   8  DCR Register
ECP_CFIFO     equ ECP_BASE + 0400h  ; r/w   8  CFIFO Register
ECP_DFIFO     equ ECP_BASE + 0400h  ;  /w   8  DFIFO Register
ECP_TFIFO     equ ECP_BASE + 0400h  ; r/w   8  TFIFO Register
ECP_CNFGA     equ ECP_BASE + 0400h  ; r/w   8  ECP CONFIG_A Register
ECP_CNFGB     equ ECP_BASE + 0401h  ; r/w   8  ECP CONFIG_B Register
ECP_ECR       equ ECP_BASE + 0402h  ; r/w   8  ECR Register
ECP_IPR       equ ECP_BASE + 0405h  ; r/w   8  IPR Register

ECP_INDEX     equ ECP_BASE + 0403h  ; r/w   8  ECP INDEX Register
ECP_SETUP     equ ECP_BASE + 0404h  ; r/w   8  ECP SETUP Register

;

ENDIF ; IFDEF ECP_BASE

;---------------------------------------------------------------------------

; LCD Controller
;   entered mcd - 1995.07.27

LCD_CFG1      equ 0EFA0h  ; r/w   8  LCD Configuration Reg. 1
LCD_CFG2      equ 0EFA1h  ; r/w   8  LCD Configuration Reg. 2
LCD_CFG3      equ 0EFA2h  ; r/w   8  LCD Configuration Reg. 3
LCD_CFG4      equ 0EFA3h  ; r/w   8  LCD Configuration Reg. 4

;---------------------------------------------------------------------------

; PCMCIA Controller
;   entered mcd - 1995.07.27
;   alternate base address added mcd - 1995.08.07
;   enclosed with IFDEF - 1995.09.28

IFDEF PCM_BASE

; PCM_BASE needs to be defined as one of the following in the file
; including this one.  This is because several possible bases are
; allowed, but only one is configured for use.

PCM_BASE1     equ 003E0h  ; */*  **  PCMCIA option 1 register base
PCM_BASE2     equ 003E2h  ; */*  **  PCMCIA option 2 register base

;

PCM_INDEX     equ PCM_BASE + 00h    ; r/w   8  PCMCIA Index
PCM_DATA      equ PCM_BASE + 01h    ; r/w   8  PCMCIA Data

;

ENDIF ; IFDEF PCM_BASE

;---------------------------------------------------------------------------

; Programmable Interrupt Controller (PIC)
;   entered mcd - 1995.07.27

PIC_MASTER0   equ 00020h  ; r/w   8  Master PIC port 0
PIC_MASTER1   equ 00021h  ; r/w   8  Master PIC port 1
PIC_SLAVE0    equ 000A0h  ; r/w   8  Slave PIC port 0
PIC_SLAVE1    equ 000A1h  ; r/w   8  Slave PIC port 1

PIC_M_ICW1    equ PIC_MASTER0        ; r/w   8  Master ICW1
PIC_M_ICW2    equ PIC_MASTER1        ; r/w   8  Master ICW2
PIC_M_ICW3    equ PIC_MASTER1        ; r/w   8  Master ICW3
PIC_M_ICW4    equ PIC_MASTER1        ; r/w   8  Master ICW4
PIC_M_OCW1    equ PIC_MASTER1        ; r/w   8  Master OCW1
PIC_M_OCW2    equ PIC_MASTER0        ; r/w   8  Master OCW2
PIC_M_OCW3    equ PIC_MASTER0        ; r/w   8  Master OCW3

PIC_S_ICW1    equ PIC_SLAVE0         ; r/w   8  Slave ICW1
PIC_S_ICW2    equ PIC_SLAVE1         ; r/w   8  Slave ICW2
PIC_S_ICW3    equ PIC_SLAVE1         ; r/w   8  Slave ICW3
PIC_S_ICW4    equ PIC_SLAVE1         ; r/w   8  Slave ICW4
PIC_S_OCW1    equ PIC_SLAVE1         ; r/w   8  Slave OCW1
PIC_S_OCW2    equ PIC_SLAVE0         ; r/w   8  Slave OCW2
PIC_S_OCW3    equ PIC_SLAVE0         ; r/w   8  Slave OCW3

PIC_M_IRR     equ PIC_M_OCW3         ; r/w   8  Master IRR
PIC_M_IMR     equ PIC_M_OCW1         ; r/w   8  Master IMR
PIC_M_ISR     equ PIC_M_OCW3         ; r/w   8  Master ISR

PIC_S_IRR     equ PIC_S_OCW3         ; r/w   8  Slave IRR
PIC_S_IMR     equ PIC_S_OCW1         ; r/w   8  Slave IMR
PIC_S_ISR     equ PIC_S_OCW3         ; r/w   8  Slave ISR

PIC_II1SR     equ 0EFB1h  ; r/w   8  Internal Interrupt  1 Sel. Reg.
PIC_II3SR     equ 0EFB3h  ; r/w   8  Internal Interrupt  3 Sel. Reg.
PIC_II4SR     equ 0EFB4h  ; r/w   8  Internal Interrupt  4 Sel. Reg.
PIC_II5SR     equ 0EFB5h  ; r/w   8  Internal Interrupt  5 Sel. Reg.
PIC_II6SR     equ 0EFB6h  ; r/w   8  Internal Interrupt  6 Sel. Reg.
PIC_II7SR     equ 0EFB7h  ; r/w   8  Internal Interrupt  7 Sel. Reg.
PIC_II9SR     equ 0EFB9h  ; r/w   8  Internal Interrupt  9 Sel. Reg.
PIC_II10SR    equ 0EFBAh  ; r/w   8  Internal Interrupt 10 Sel. Reg.
PIC_II11SR    equ 0EFBBh  ; r/w   8  Internal Interrupt 11 Sel. Reg.
PIC_II12SR    equ 0EFBCh  ; r/w   8  Internal Interrupt 12 Sel. Reg.
PIC_II13SR    equ 0EFBDh  ; r/w   8  Internal Interrupt 13 Sel. Reg.
PIC_II14SR    equ 0EFBEh  ; r/w   8  Internal Interrupt 14 Sel. Reg.
PIC_II15SR    equ 0EFBFh  ; r/w   8  Internal Interrupt 15 Sel. Reg.

PIC_MISR1     equ 0EFB0h  ; r/w   8  Misc. Interrupt Selection Reg. 1
PIC_MISR2     equ 0EFB2h  ; r/w   8  Misc. Interrupt Selection Reg. 2
PIC_MISR3     equ 0EFB8h  ; r/w   8  Misc. Interrupt Selection Reg. 3

;---------------------------------------------------------------------------

; Programmable Interval Timer (PIT)
;   entered mcd - 1995.07.27

PIT_COUNT0    equ 00040h  ; r/w   8  Counter 0
PIT_COUNT1    equ 00041h  ; r/w   8  Counter 1
PIT_COUNT2    equ 00042h  ; r/w   8  Counter 2
PIT_CONTROL   equ 00043h  ;  /w   8  Timer Control Register
PIT_TICR      equ 00044h  ; r/w   8  Timer I/O Control Register
PIT_CLOCK     equ 00045h  ; r/w   8  Timer Clock Register

;---------------------------------------------------------------------------

; Power Management
;   entered mcd - 1995.07.27

PM_PMR1       equ 0EF90h  ; r/w   8  Power Management Register 1
PM_PMR2       equ 0EF91h  ; r/w   8  Power Management Register 2
PM_PMR3       equ 0EF92h  ; r/w   8  Power Management Register 3
PM_PMR4       equ 0EF93h  ; r/w   8  Power Management Register 4

;---------------------------------------------------------------------------

; Reconfigurable I/O
;   entered mcd - 1995.07.27

RIO_CONTROL   equ 0EFC0h  ; r/w   8  RIO Control Register

RIO_DD        equ 0EFC4h  ; r/w  32  Data Direction Register
RIO_DD_WORD0  equ 0EFC4h  ; r/w  16  Data Direction Word 0
RIO_DD_BYTE0  equ 0EFC4h  ; r/w   8  Data Direction Byte 0
RIO_DD_BYTE1  equ 0EFC5h  ; r/w   8  Data Direction Byte 1
RIO_DD_WORD1  equ 0EFC6h  ; r/w  16  Data Direction Word 1
RIO_DD_BYTE2  equ 0EFC6h  ; r/w   8  Data Direction Byte 2
RIO_DD_BYTE3  equ 0EFC7h  ; r/w   8  Data Direction Byte 3

RIO_DI        equ 0EFC8h  ; r/w  32  Data Port In Register
RIO_DI_WORD0  equ 0EFC8h  ; r/w  16  Data Input Word 0
RIO_DI_BYTE0  equ 0EFC8h  ; r/w   8  Data Input Byte 0
RIO_DI_BYTE1  equ 0EFC9h  ; r/w   8  Data Input Byte 1
RIO_DI_WORD1  equ 0EFCAh  ; r/w  16  Data Input Word 1
RIO_DI_BYTE2  equ 0EFCAh  ; r/w   8  Data Input Byte 2
RIO_DI_BYTE3  equ 0EFCBh  ; r/w   8  Data Input Byte 3

RIO_DO        equ 0EFCCh  ; r/w  32  Data Port Out Register
RIO_DO_WORD0  equ 0EFCCh  ; r/w  16  Data Output Word 0
RIO_DO_BYTE0  equ 0EFCCh  ; r/w   8  Data Output Byte 0
RIO_DO_BYTE1  equ 0EFCDh  ; r/w   8  Data Output Byte 1
RIO_DO_WORD1  equ 0EFCEh  ; r/w  16  Data Output Word 1
RIO_DO_BYTE2  equ 0EFCEh  ; r/w   8  Data Output Byte 2
RIO_DO_BYTE3  equ 0EFCFh  ; r/w   8  Data Output Byte 3

;---------------------------------------------------------------------------

; Real Time Clock

RTC_INDEX     equ 00070h  ; r/w   8  RTC Index
RTC_DATA      equ 00071h  ; r/w   8  RTC Data

;---------------------------------------------------------------------------

; Three Wire Interface
;   entered mcd - 1995.07.27
;   added TWI_A_CTRL2 and TWI_U_SCS - 1995.11.16

TWI_CONTROL   equ 00050h  ; r/w   8  3-Wire Control Register
TWI_SIO       equ 00051h  ; r/w   8  3-Wire Serial I/O Register
TWI_U_CONTROL equ 00052h  ; r/w   8  Microwire Control Register
TWI_SDA       equ 00053h  ; r/w   8  Serial Input/Output Data Register
TWI_A_STATUS  equ 00054h  ; r/    8  Access.bus Status Register
TWI_A_CONTROL equ 00055h  ; r/w   8  Access.bus Control Register
TWI_A_ADDR    equ 00056h  ; r/w   8  Access.bus Own Address Register
TWI_A_CTRL2   equ 00057h  ; r/w   8  Access.bus Control Register 2
TWI_U_SCS     equ 0EFC1h  ; r/w   8  Microwire Slave Chip Select Reg.

;---------------------------------------------------------------------------

; UART
;   entered mcd - 1995.07.27
;   enclosed with IFDEF - 1995.09.28

IFDEF UART_BASE

; UART_BASE needs to be defined as one of the following in the file
; including this one.  This is because several possible bases are
; allowed, but only one is configured for use.

UART_COM1     equ 003F8h  ; */*  **  UART COM 1 register base
UART_COM2     equ 002F8h  ; */*  **  UART COM 2 register base
UART_COM3     equ 003E8h  ; */*  **  UART COM 3 register base
UART_COM4     equ 002E8h  ; */*  **  UART COM 3 register base

;

UART_CLOCK    equ 0EF70h  ; r/w   8  UART Clock Divisor Register
UART_MSC      equ 0EF71h  ; r/w   8  Modem Signal Control Register

UART_RBR      equ UART_BASE + 00h  ; r/    8  Receiver Buffer Reg.
UART_THR      equ UART_BASE + 00h  ;  /w   8  Transmit Holding Reg.
UART_IER      equ UART_BASE + 01h  ; r/w   8  Interrupt Enable Reg.
UART_IIR      equ UART_BASE + 02h  ; r/    8  Interrupt Id. Reg.
UART_FCR      equ UART_BASE + 02h  ;  /w   8  FIFO Control Reg.
UART_LCR      equ UART_BASE + 03h  ; r/w   8  Line Control Reg.
UART_MCR      equ UART_BASE + 04h  ; r/w   8  Modem Control Reg.
UART_LSR      equ UART_BASE + 05h  ; r/w   8  Line Status Reg.
UART_MSR      equ UART_BASE + 06h  ; r/w   8  Modem Status Reg.
UART_SCR      equ UART_BASE + 07h  ; r/w   8  Scratch Pad Reg.
UART_DLL      equ UART_BASE + 00h  ; r/w   8  Divisor Latch LSB
UART_DLM      equ UART_BASE + 01h  ; r/w   8  Divisor Latch MSB

;

ENDIF ; IFDEF UART_BASE

;---------------------------------------------------------------------------

; Watchdog Timer
;   entered mcd - 1995.07.27

WD_RETRIGGER  equ 00046h  ; r/w  16  Watchdog Retrigger
WD_CONTROL    equ 00047h  ; r/w   8  Watchdog Control Register

;---------------------------------------------------------------------------

ENDIF ; IFNDEF NS486REG_INC_INC

;---------------------------------------------------------------------------
; END       ns486reg.inc
;---------------------------------------------------------------------------
