;
; ASCENDING WHISTLE FOR COP800.
; OUTPUT ON TIMER I/O (TIO) PIN.  
; USES TIMER INTERRUPT. 
; USE 20MHz XTAL, 1us INSTR CYCLE FOR THIS DEMO.
;
; WRITTEN BY:  JERRY LEVENTER
; DATE:	       OCTOBER 4, 1989
;
;		
	.TITLE WHISTLE2
	.CHIP	820
        .SECT   MAIN,ROM,ABS=0
;
	PORTGC	=   0D5 	; PORT G CONFIGURATION
	TMRLO	=   0EA 	; TIMER LOW BYTE
	TMRHI	=   0EB 	; TIMER HIGH BYTE
	TAULO	=   0EC 	; TIMER REGISTER LOW BYTE
	TAUHI	=   0ED 	; TIMER REGISTER HIGH BYTE
	CNTRL	=   0EE 	; CONTROL REGISTER
	PSW	=   0EF 	; PSW REGISTER
	TRUN	=   4
	TPND	=   5
	BUSY	=   2
	GIE	=   0
;
;  ****  SPECIAL REGISTERS AND CONSTANTS  ****
;
	WSLO	=	0FF	; TIMER VALUES
	WSLHI	=	001
	MAXFREQ	=	00A	; LAST FREQUENCY CONSTANT
	FCNTR	=	0F0	; TIMER COUNT REGISTER
	  FCNT =	010	; COUNTER CONSTANT
;
; ****************************
; **** BEGIN PROGRAM HERE ****
; ****************************
;
MAIN:	LD	SP,#02F 	; DEFAULT INITIALIZATION OF SP
	JSR	WHISTLE2	; *** CALLING ROUTINE DEMO ***
	JP	.		
WHISTLE2:
	LD	PORTGC,#008	; TIO PIN (G3) AS OUTPUT
	LD	CNTRL,#0A0	; PWM WITH TIO TOGGLE
	LD	TMRLO,#WSLO	; WHISTLE VALUE FOR TIMER
	LD	TMRHI,#WSLHI
	LD	TAULO,#WSLO
	LD	TAUHI,#WSLHI
	LD	FCNTR,#FCNT	; INITIALIZE COUNTER
LUP:	LD	PSW,#011	; ENTI, GIE = 1, TPND = 0
	SBIT	TRUN,CNTRL	; START TIMER
	JP	.		; SELF LOOP UNTIL TIMER
	JP	LUP		; INTERRUPT 
;
;  **** INTERRUPT ROUTINE ****
; 
	.=0FF			
	IFBIT	TPND,PSW	; TEST TIMER PENDING FLAG
	JP	TIMOUT
	JP	.
TIMOUT:	RBIT	TRUN,CNTRL	; STOP THE TIMER
	IFBIT	5,FCNTR		; FREQUENCY TIMED OUT ?
	JP	TM		; YES, CHANGE FREQUENCY
	LD	A,FCNTR		; NO, KEEP GOING
	INC	A		; INCREMENT COUNT
	X 	A,FCNTR
	RETSK			; RETURN 
TM:	LD	FCNTR,#FCNT	; RESET COUNTER
	LD	A,TAULO		; CHANGE FREQUENCY
	IFEQ	A,#MAXFREQ	; TIMER = MAX FREQUENCY ?
	JP	DONE		; YES
	ADD	A,#0FF		; INCREMENT FREQUENCY
	X	A,TAULO		; STORE FREQ IN AUTORELOAD
	RETSK
DONE:	LD	A,#WSLO		; START WHISTLE OVER
	X	A,TAULO
	LD	A,SP		; *** RESTORE STACK POINTER ***
	ADD	A,#002		; *** AND RETURN TO CALLING ***
	X 	A,SP		; *** ROUTINE.		   ***
 	RET
	.END
