;---------------------------------------------------------------
;
; THIS PROGRAM DISPLAYS FOUR DIGITS OF THE RAM SPECIFIED BY
; THE ADDRESS POINTER "HEAD" ON A 4 DIGIT 3 DECIMAL POINT (MULTIPLEXED)
; LCD DISPLAY. THE DATA STREAM IS SENT OUT SERIALLY THROUGH THE
; MICROWIRE/PLUS INTERFACE TO THE COP472 LCD DISPLAY DRIVER.
; NOTE: THE RAM CONTENTS SHOULD BE BETWEEN "0" AND "F".
;---------------------------------------------------------------
;
; EDITTED MAY 11, 1994 - REVISED FOR NEW ASSEMBLER (ASMCOP v4.2) 

          .TITLE    LCD
          .CHIP     820
	  .SECT     MAIN,ROM,INPAGE
;
;
          PORTGD    =         0D4       ;PORT G DATA REGISTER
          PORTGC    =         0D5       ;PORT G CONFIGURATION
;
;
          SIO       =         0E9       ;MICROWIRE SHIFT REGISTER
;
;
          PSW       =         0EF       ;PSW REGISTER
          CNTRL     =         0EE       ;CNTRL REGISTER
;
;
          CONTRL    =         04        ;MEMORY LOCATION FOR THE
;                                       ;COP472 CONTROL WORD     
          HEAD      =         00        ;STARTING MEMORY LOC FOR
                                        ;DATA TO BE DISPLAYED      
          MEMSTR    =         05        ;STARTING MEMORY LOC FOR
                                        ;STORING SEGMENT DATA     
          MEMEND    =         08        ;MEMORY LOC FOR LAST
                                        ;SEGMENT DATA
;
;
START:    LD        CNTRL,#08           ;SET MSEL BIT IN CNTRL
          LD        PORTGC,#032         ;SET G5,G4& G1 AS OUTPUTS
          LD        CONTRL,#0FC         ;SET COP472 IN STAND ALONE MODE
;                                       ;     
;                                       ;
;------------------------------------------------------------------
;
; THIS ROUTINE  GETS THE SEGMENT DATA FOR RAM DIGITS POINTED
; BY B REGISTER AND STORES IN RAM MEMORY POINTED BY X REGISTER
;
;-------------------------------------------------------------------
AGAIN:    LD        B,#HEAD             ;POINTER TO START ADDRESS
          LD        X,#MEMSTR           ;POINTER TO STORE ADDRESS
NEXDIG:   LD        A,[B+]              ;LOAD A WITH RAM DIGIT AND
                                        ;INCREMENT B POINTER      
          ADD       A,#0F0              ;ADD OFFSET TO THE DIGIT
          LAID                          ;LOOKUP SEGMENT DATA TO A
          X         A,[X+]              ;STORE IN MEMORY 
          IFBNE     #0E                 ;CHECK FOR END OF FOUR
                                        ;DIGITS AND REPEAT 

          JP        NEXDIG              ;IF NECESSARY

;----------------------------------------------------------------
;
; THIS ROUTINE DISPLAYS THE CONTENTS OF FOUR MEMORY LOCATION     
; ON THE LCD DISPLAY.
;
;----------------------------------------------------------------
DSP:      LD        B,#MEMEND           ;LOAD THE START ADDRESS
          RBIT      1,PORTGD            ;BIT G1 IS USED TO SELECT
                                        ;COP472 (PIN 4) 
REPEAT:   LD        A,[B-]              ;SEGMENT DATA TO A
          X         A,SIO               ;LOAD THE SIO REGISTER
          SBIT      #2,PSW              ;SET BUSY BIT IN PSW
WAIT:     IFBIT     #2,PSW              ;WAIT TILL SHIFTING IS
          JP        WAIT                ;COMPLETE
          IFBNE     #03                 ;CHECK FOR END OF FOUR
          JP        REPEAT              ;DIGITS AND REPEAT 
          SBIT      1,PORTGD            ;DESELECT COP472
LOOP:     JP        LOOP                ;DONE DISPLAYING
;
;    
;----------------------------------------------------------------
;
; STORE THE LOOKUP TABLE FOR SEGMENT DATA IN ROM LOCATION 0F0
;
;----------------------------------------------------------------
;
          .=0F0
;
          .BYTE     03F,006,05B,04F     ;DATA FOR 0,1,2,3
          .BYTE     066,06D,07D,07      ;DATA FOR 4,5,6,7
          .BYTE     07F,067,077,07C     ;DATA FOR 8,9,A,B
          .BYTE     039,05E,079,071     ;DATA FOR C,D,E,F
;
;            
          .END 
;
