program palasm2(input,output);
{program palasm2(input,output,SPECS,SPECSTRE);}
const
   nstrtab = 20;
   maxid = 15;
   maxtk = 300;
   tkeof = -1;
   reinit  = -2;
   tkid   = 1;
   tkconst = 4;
   tkchip  = 100;
   tkarray = 131;
   tkrange = 133;
   tkstate = 200;
   tkand  = 136;
   tkor   = 137;
   tkxor  = 138;
   tkxnor = 139;
   tkexpor= 70;
   tkexpand = 71;
   tklbra = 20;
   tkrbra = 21;
   tklpre = 22;
   tkrpre = 23;
   tkquot = 24;
   tkcomma = 25;
   tkdot   = 26;
   tknot  = 140;
   assequ  = 121;
   clkequ  = 122;
   tkif    = 104;
   tknc    = 27;
   tkto    = 28;
   tkbin   = 29;
   tkend   = 30;
   tkfor   = 31;
   tkgnd   = 32;
   tkset   = 33;
   tksim   = 34;
   tkvcc   = 35;
   tkplus  = 49;
   tksub   = 50;
   tkmult  = 51;
   tkdiv   = 52;
   tkelse  = 36;
   tkequ   = 55;
   tkclk   = 56;
   tktrst  = 57;
   tkreset = 58;
   tkthen  = 176;
   tkbegin = 177;
   tkcheck = 107;
   tkclock = 119;
   tkwhile = 106;
   tkstring= 179;
   tkgener = 120;
   tktraon = 117;
   tktraoff= 118;
   maxres  = 50;
   tab  = CHR(9);

type
   idconstr = packed array [1..maxid] of char;
   treptr = ^trerec;
   trerec = record
               kind : integer;
               text : idconstr;
               child,sibling : treptr
            end;
   tokenrec = record
               token : integer;
               idconst : idconstr;
            end;
   tokentab = array [0..maxtk] of tokenrec;

var
   filename : idconstr;
   specs,specstre : text;
   root,tree : treptr;
   strtab : array [1..nstrtab] of treptr;
   tkind,token : integer;
   tktab : tokentab;
   reserv : array [1..maxres] of idconstr;
   restk  : array [1..maxres] of integer;
   sch : char;

   procedure initial;
   var
      i : integer;
      ch : char;
   begin
      assign(specstre,'specstre.dat');
      rewrite(specstre);
      ch := ' ';
      i := 1;
      filename := '               ';
      write(' Enter input file - [specs.dat] : ');
      while not(eoln) and (i < 15) do
         begin
             read(ch);
             filename[i] := ch;
             i := i + 1;
        end;
      if (filename = '               ')
      then
         begin
            assign(specs,'specs.dat');
            reset(specs);
            writeln(specstre,'specs');
        end
     else
         begin
            assign(specs,filename);
            reset(specs);
            i := 1;
            while (i < 15) and (filename[i] <> '.') do
               begin
                  write(specstre,filename[i]);
                  i := i + 1;
               end;
            writeln(specstre);
         end;
      tkind := 0;
      sch := ' ';
      tktab[1].token := reinit;
      tktab[maxtk].token := reinit;
      reserv[1]  := 'if             ';
      reserv[2]  := 'nc             ';
      reserv[3]  := 'or             ';
      reserv[4]  := 'to             ';
      reserv[5]  := 'and            ';
      reserv[6]  := 'bin            ';
      reserv[7]  := 'clk            ';
      reserv[8]  := 'div            ';
      reserv[9]  := 'end            ';
      reserv[10] := 'equ            ';
      reserv[11] := 'for            ';
      reserv[12] := 'gnd            ';
      reserv[13] := 'set            ';
      reserv[14] := 'sim            ';
      reserv[15] := 'sub            ';
      reserv[16] := 'vcc            ';
      reserv[17] := 'chip           ';
      reserv[18] := 'else           ';
      reserv[19] := 'mult           ';
      reserv[20] := 'plus           ';
      reserv[21] := 'then           ';
      reserv[22] := 'trst           ';
      reserv[23] := 'begin          ';
      reserv[24] := 'check          ';
      reserv[25] := 'clock          ';
      reserv[26] := 'reset          ';
      reserv[27] := 'state          ';
      reserv[28] := 'while          ';
      restk[1]  := tkif;
      restk[2]  := tknc;
      restk[3]  := tkexpor;
      restk[4]  := tkto;
      restk[5]  := tkexpand;
      restk[6]  := tkbin;
      restk[7]  := tkclk;
      restk[8]  := tkdiv;
      restk[9]  := tkend;
      restk[10] := tkequ;
      restk[11] := tkfor;
      restk[12] := tkgnd;
      restk[13] := tkset;
      restk[14] := tksim;
      restk[15] := tksub;
      restk[16] := tkvcc;
      restk[17] := tkchip;
      restk[18] := tkelse;
      restk[19] := tkmult;
      restk[20] := tkplus;
      restk[21] := tkthen;
      restk[22] := tktrst;
      restk[23] := tkbegin;
      restk[24] := tkcheck;
      restk[25] := tkclock;
      restk[26] := tkreset;
      restk[27] := tkstate;
      restk[28] := tkwhile;
   end; (* end of procedure initial *)

   procedure lexi(var token,tkind : integer);

       procedure scanner(var tktab : tokentab);
       var
         ch : char;
         done : boolean;
         tindex : integer;

         procedure idreserv(var tindex : integer; var ch : char);
         var
            id : idconstr;
            i : integer;

            procedure bsearch(id:idconstr; var token:integer;top,down:integer);
            var
               curr : integer;
            begin
               while (top <= down) do
                  begin
                     curr := (top + down) DIV 2;
                     if (id < reserv[curr])
                     then
                        down := curr -1
                     else
                        if (id > reserv[curr])
                        then top := curr + 1
                        else top := down + 1;
                 end; (* end of while *)
                 if id = reserv[curr]
                 then token := restk[curr];
               end; (* end of procedure bsearch *)




              (* main program of procedure idreserv *)

         begin
            token := 0;
            id := '               ';
            i := 1;
            repeat
              if ch in ['A'..'Z']
              then ch := chr( ord('a') + ord(ch) - ord('A') );
              id[i] := ch;
              i := i + 1;
              read(specs,ch)
            until not(ch in ['A'..'Z','a'..'z','0'..'9','_']);
            if (i in [3..7,9,10])
            then
               case i of
                  3 : bsearch(id,token,1,4);
                  4 : bsearch(id,token,5,16);
                  5 : bsearch(id,token,17,22);
                  6 : bsearch(id,token,23,28);
                  7 : if id = 'string         '
                      then token := tkstring;
                 10 : if id = 'trace_off      '
                      then token := tktraoff;
                  9 : if id = 'trace_on       '
                      then token := tktraon
                      else
                         if id = 'generate       '
                         then token := tkgener;
              end; (* end of case *)
           if token = 0
           then
              begin
                 tktab[tindex].token := tkid;
                 tktab[tindex].idconst := id;
              end
           else
              tktab[tindex].token := token;
       end; (* end of procedure idreserv *)


       procedure contk(tindex : integer; var  ch : char);
       var
          i : integer;
          cstr : idconstr;
       begin
          cstr := '               ';
          i := 1;
          repeat
            cstr[i] := ch;
            i := i + 1;
            read(specs,ch)
         until not(ch in ['0'..'9']);
         tktab[tindex].token := tkconst;
         tktab[tindex].idconst := cstr;
     end; (* end of procedure contk *)



     procedure singtk(var tindex : integer; var ch : char);




         (* main program of procedure  *)

         begin
            if ch in[':','.',';']
            then
               case ch of
                  ':' : begin
                           read(specs,ch);
                           case ch of
                              '=' : tktab[tindex].token := clkequ;
                              '+' : begin
                                       read(specs,ch);
                                       if ch = ':'
                                       then tktab[tindex].token := tkxor;
                                    end;
                              '*' : begin
                                       read(specs,ch);
                                       if ch = ':'
                                       then tktab[tindex].token := tkxnor;
                                    end;
                           end; (* end of case *)
                           read(specs,ch);
                        end;
                  ';' : readln(specs);
                  '.' : begin
                           read(specs,ch);
                           if ch = '.'
                           then
                              begin
                                 tktab[tindex].token := tkrange;
                                 read(specs,ch);
                              end
                           else tktab[tindex].token := tkdot;
                        end;
               end (* end of case *)
            else
               begin
                  case ch of
                     '[' : tktab[tindex].token := tklbra;
                     ']' : tktab[tindex].token := tkrbra;
                     '(' : tktab[tindex].token := tklpre;
                     ')' : tktab[tindex].token := tkrpre;
                    '''' : tktab[tindex].token := tkquot;
                     '/' : tktab[tindex].token := tknot;
                     '*' : tktab[tindex].token := tkand;
                     '+' : tktab[tindex].token := tkor;
                     '=' : tktab[tindex].token := assequ;
                     ',' : tktab[tindex].token := tkcomma;
                 end; (* end of case *)
                 read(specs,ch);
              end;  (* end of else *)
         end; (* end of procedure  *)



      (* main program of procedure scanner *)

      begin
         ch := sch;
         tindex := 1;
         repeat
            done := false;

            (*          this parts is to skip elon or blank or comments    *)
            (*          until it reach the char which is not blank or ';'  *)

            if ch in [' ',';',tab] then while not(done or eof(specs)) do
                begin
                  read(specs,ch);
                  if eoln(specs) then readln(specs);
                  if ch = ';' then readln(specs);
                  if not (ch in [' ',tab]) then done := true;
               end;

            (*  this part is begin to cnovert the characters to
                 tktab[tindex].tk  tab[tindex].token *)

            if eof(specs)
            then tktab[tindex].token := tkeof
            else
               if (ch in ['A'..'Z','a'..'z'])
               then idreserv(tindex,ch)
               else
                  if (ch in ['0'..'9'])
                  then contk(tindex,ch)
                  else singtk(tindex,ch);
            tindex := tindex + 1;
         until eof(specs) or (tindex = maxtk);

         (* this part is to insert tkeof    *)
         (* at the end of token table       *)
         if eof(specs)
         then tktab[tindex].token := tkeof
         else sch := ch;
      end; (* end of procedure scanner *)


   (* main program of lexi *)

   begin
      tkind := tkind + 1;
      token := tktab[tkind].token;
      if (token = reinit)
      then
         begin
            scanner(tktab);
            token := tktab[1].token;
            tkind := 1;
         end;
  end; (* end of procedure lexi *)



     procedure idarray(var tree : treptr; var token,tkind : integer);
     var
        tr1,tr2 : treptr;
        id : idconstr;


         procedure barray(var tree : treptr; id : idconstr);
         var
            tr1,tr2 : treptr;
         begin
            new(tr1);
            tr1^.kind := tkarray;
            tr1^.text := id;
            tr1^.child := nil;
            tr1^.sibling := nil;
            tree := tr1;
            lexi(token,tkind);
            new(tr1);
            tr1^.text := tktab[tkind].idconst;
            tr1^.child := nil;
            tr1^.sibling := nil;
            tree ^.child := tr1;
            lexi(token,tkind);
            if (token = tkrange)
            then
               begin
                  tr1^.kind := tkrange;
                  lexi(token,tkind);
                  new(tr2);
                  tr2^.kind := tkrange;
                  tr2^.text := tktab[tkind].idconst;
                  tr2^.child := nil;
                  tr2^.sibling := nil;
                  tr1^.sibling := tr2;
                  lexi(token,tkind);
               end
            else
               tr1^.kind := tkconst;
        end; (* end of procedure barray *)




     begin
        id := tktab[tkind].idconst;
        lexi(token,tkind);
        if (token = tklbra)
        then
           begin
              barray(tr1,id);
              lexi(token,tkind);
           end
        else
           begin
              new(tr1);
              tr1^.text := id;
              tr1^.kind := tkid;
              tr1^.child := nil;
              tr1^.sibling := nil;
           end;
        if (token = tkdot)
        then
           begin
              lexi(token,tkind);
              new(tr2);
              tr2^.kind := token;
              tr2^.child := tr1;
              tr2^.sibling := nil;
              tree := tr2;
              lexi(token,tkind);
           end
        else
           tree := tr1;
     end; (* end of procedure idarray *)


   procedure dochip(var root,tree : treptr; var tkind : integer);
   var
      first : boolean;
      tr1 : treptr;


       procedure chipnode(var root,tree : treptr; first : boolean);
       var
          trc : treptr;
       begin
          if first
          then
             begin
                new(root);
                root^.kind := tkchip;
                tree := root
             end
          else
             begin
                new(trc);
                trc^.kind := tkchip;
                tree^.child := trc;
                tree := trc
             end
      end; (* end of procedure chipnode *)

   (* main program of procedure dochip *)

   begin
      first := true;
      lexi(token,tkind);
      repeat
        if (token = tkid)
        then
           begin
              idarray(tr1,token,tkind);
              tree^.sibling := tr1;
              tree := tr1;
           end
        else
           if (token = tknot)
           then
              begin
                 new(tr1);
                 tr1^.kind := tknot;
                 tr1^.sibling := nil;
                 lexi(token,tkind);
                 idarray(tr1^.child,token,tkind);
                 tree^.sibling := tr1;
                 tree := tr1;
              end
           else
              begin
                 if (token in [tkgnd,tknc,tkvcc])
                 then
                    begin
                       new(tr1);
                       tr1^.kind := token;
                       tr1^.child := nil;
                       tr1^.sibling := nil;
                       tree^.sibling := tr1;
                       tree := tr1;
                    end
                 else
                    if (token = tkchip)
                    then chipnode(root,tree,first);
                 lexi(token,tkind);
              end;
      until (token = tkequ);
   end; (* end of proceudre dochip *)



   procedure doequ(var tree : treptr; var tkind : integer);
   const
     maxst = 50;
   type
      treestack = array [1..maxst] of treptr;
   var
      top : integer;
      trstack : treestack;
      tr1,tr2 : treptr;
     procedure push(var tree : treptr; var top : integer);
     begin
        if (top = maxst)
        then writeln(' stack overflow ')
        else
           begin
              top := top + 1;
              trstack[top] := tree;
           end;
     end; (* end of procedure push *)

     procedure reduce(var top : integer);
     var
        i,j : integer;
     begin
        i := top - 1;
        j := top - 2;
        trstack[j]^.sibling := trstack[top];
        trstack[i]^.child := trstack[j];
        trstack[j] := trstack[i];
        top := j;
    end; (* end of procedure reduce *)




     procedure doidarray(var top,token,tkind:integer);
     var
        tr1 : treptr;
     begin
        idarray(tr1,token,tkind);
        if (top > 0)
        then
          begin
            if (trstack[top]^.kind = tknot) and (trstack[top]^.child = nil)
            then trstack[top]^.child := tr1
            else push(tr1,top);
            if (top > 2)
            then
              if (trstack[top-1]^.kind = tkand) and (trstack[top-1]^.child=nil)
              then reduce(top);
         end (* end of then *)
       else push(tr1,top);
    end; (* end of procedure doidarray *)


     procedure bequtr(var tree : treptr; var top,token : integer);
     var
        tr1,tr2 : treptr;
        topm1 : integer;
     begin
        topm1 := top - 1;
        while (topm1 > 2) do
           reduce(topm1);
        tree^.child^.sibling := trstack[1];
        new(tr1);
        tr1^.kind := token;
        tr1^.text := '               ';
        tr1^.child := nil;
        tr1^.sibling := nil;
        new(tr2);
        tr2^ := trstack[top]^;
        tr1^.child := tr2;
        tree^.sibling := tr1;
        tree := tr1;
        top := 0;
     end; (* end of proc bequtr *)









             procedure dopraren(var top : integer);


             (* main program of proceudre dopraren *)

             begin
                while (trstack[top-1]^.kind <> tklpre) do
                   reduce(top);
                trstack[top-1] := trstack[top];
                top := top - 1;
                if (top > 1)
                then
                   begin
                      if (trstack[top - 1]^.kind = tknot)
                      then
                         begin
                            trstack[top - 1]^.child := trstack[top];
                            top := top - 1;
                         end;
                      if (top > 2)
                      then
                         if (trstack[top - 1]^.kind = tkand)
                         then reduce(top);
                   end; (* end of then *)
             end; (* end of procedure dopraren *)


    procedure shiftred(var top : integer );
    var
       sroot : treptr;
    begin
       lexi(token,tkind);
       repeat
         if (token = tkid)
         then doidarray(top,token,tkind)
         else
           begin
             case token of
                tklpre,tkand,tknot,
                tknc,tkgnd,tkvcc       : begin
                                            new(sroot);
                                            sroot^.child := nil;
                                            sroot^.sibling := nil;
                                            sroot^.kind := token;
                                            sroot^.text := '               ';
                                            push(sroot,top);
                                         end;
                tkrpre                 : dopraren(top);
                tkor                   : begin
                                            new(sroot);
                                            sroot^.kind := token;
                                            sroot^.child := nil;
                                            sroot^.text := '               ';
                                            sroot^.sibling := nil;
                                            if (top > 2)
                                            then
                                               if trstack[top-1]^.kind = tkor
                                               then reduce(top);
                                            push(sroot,top);
                                         end;
                assequ,clkequ          : bequtr(tree,top,token);
                otherwise ;
              end; (* end of case *)
              lexi(token,tkind);
          end; (* end of else *)
      until (token = tkeof);
   end; (* end of proceudre shiftred *)







(* main program of procedure doequ *)

   begin
      top := 0;
      tree := root;
      while (tree^.child <> nil) do
         tree := tree^.child;
      new(tr1);
      tr1^.kind := tkequ;
      tr1^.child := nil;
      tr1^.sibling := nil;
      tree^.child := tr1;
      tree := tr1;
      lexi(token,tkind);
      if (token = tknot)
      then
         begin
            new(tr1);
            tr1^.kind := token;
            tr1^.child := nil;
            tr1^.sibling := nil;
            lexi(token,tkind);
            idarray(tr2,token,tkind);
            tr1^.child := tr2;
         end
      else
         idarray(tr1,token,tkind);
      new(tr2);
      tr2^.kind := token;
      tr2^.child := tr1;
      tr2^.sibling := nil;
      tree^.sibling := tr2;
      tree := tr2;
      shiftred(top);
      while (top > 2) do
         reduce(top); (* do the last equation *)
      tree^.child^.sibling := trstack[1];
   end; (* end of proceudre doequ *)


procedure put_tree(tree : treptr);
const
   maxstack = 30;
var
    stack : array [1.. maxstack] of record
                                        tree : treptr;
                                        level : integer;
                                    end;
    top,level : integer;




   procedure pop(var tree : treptr; var level,top : integer);
   begin
      if (top <= 1)
      then
        writeln(' the stack underflow ')
      else
        begin
           top := top - 1;
           tree := stack[top].tree;
           level := stack[top].level;
        end
   end;



   procedure descend(tree : treptr; var level,top : integer);
   var
      temtre : treptr;

   procedure push(tree : treptr; var level,top : integer);
   begin
      if (top >= maxstack)
      then
         writeln(' the stack overflow ')
      else
         begin
            stack[top].tree := tree;
            stack[top].level := level;
            top := top + 1
         end
   end;

     procedure p_node(tr_ptr : treptr;level : integer);
     var
        i,j : integer;

     begin
        with tr_ptr^ do
               writeln(specstre,level,'     ',kind,'     ',text);
     end;


   begin
      while (tree <> nil) do
         begin
            if (tree^.sibling <> nil)
            then
               push(tree^.sibling,level,top);
            p_node(tree,level);
            level := level + 1;
            tree := tree^.child;
        end;
  end; (* end of procedure descend *)




begin
    if (tree <> nil)
    then
       begin
          top := 1;
          level := 1;
          descend(tree,level,top);
          while (top > 1) do
             begin
                pop(tree,level,top);
                 descend(tree,level,top);
             end;
       end ;
 end; (* end of procedure put_tree *)



(* main program of parser *)

begin
 WRITELN ('PALASM V1.9A - (C) COPYRIGHT 1984, MONOLITHIC MEMORIES INC.');
 WRITELN ('PARSER FOR 20RA10 & 20RP10');
 WRITELN;
   initial;
   dochip(root,tree,tkind);
   doequ(tree,tkind);
   put_tree(root);
   writeln(specstre,'-1       -1');
 WRITELN('Parse successful - please run backend program (RA or RP)');
end.
tree(root);
   writeln(specstre,'-1       -1');
 WRITELN('Parse successful - please run 