C
      INTEGER FUNCTION MOD(A,B)
      INTEGER A,B
      MOD=A-(A/B)*B
      RETURN
      END
C
      INTEGER FUNCTION KCLOS(LUN)
      INTEGER*1 LUN
      LOGICAL FLAG
      FLAG=IOCLOS (LUN)
      KCLOS=0
      IF (FLAG) KCLOS=1
      RETURN
      END
C
      INTEGER FUNCTION KREAD(LUN,L1,L2,FILE)
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 FILE(20)
      LOGICAL FLAG
      J=21
10    J=J-1
      IF (J .EQ. 0) GOTO 20
      IF (FILE(J) .NE. ' ') GOTO 20
      FILE(J)=0
      GOTO 10
20    FLAG=IOREAD (LUN,L1,L2,FILE)
      KREAD=0
      IF (FLAG) KREAD=1
      RETURN
      END
C
      INTEGER FUNCTION KWRIT(LUN,L1,L2,FILE)
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 FILE(20)
      LOGICAL FLAG
      J=21
10    J=J-1
      IF (J .EQ. 0) GOTO 20
      IF (FILE(J) .NE. ' ') GOTO 20
      FILE(J)=0
      GOTO 10
20    FLAG=IOWRIT (LUN,L1,L2,FILE)
      KWRIT=0
      IF (FLAG) KWRIT=1
      RETURN
      END
C
C************************************
C
C     THIS SUBROUTINE ALLOWS CUSTOMER CHANGES OF ARRAY SIZE
C     ALLOCATIONS & I/O UNIT NUMBERS WITHOUT RECOMPILING MAIN
C     PROGRAM - TO BE SUPPLIED TO ALL MMI CUSTOMERS
C
C     AUTHOR NICK SCHMITZ - 1/22/84
C
      SUBROUTINE IOINIT
      IMPLICIT INTEGER*1 (A-Z)
C
C     9999 CHARACTERS     MAX IN PLE DEFINITIONS FILE
C     350 LINES           MAX IN PLE DEFINITIONS FILE
C     80 CHARACTERS/LINE  MAX IN PLE DEFINITIONS FILE
C
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
C     I/O UNIT ASSIGNMENTS
C
      CONINP=1
      CONOUT=1
      FILINP=10
      FILOUT=11
C
      RETURN
      END
C
C***PLEASM***PLEASM***PLEASM***PLEASM***PLEASM***PLEASM***PLEASM***PLEASM***
C
C   PLEASM - TRANSLATES SYMBOLIC EQUATIONS INTO PROM OBJECT CODE FORMATTED
C            FOR DIRECT INPUT TO STANDARD PROM PROGRAMMERS.
C
C INPUT:     THE PLE DESIGN SPECIFICATION IS ASSIGNED TO RPD.
C            OPERATION CODES ARE ASSIGNED TO ROP.
C OUTPUT:    ECHO, SIMULATION, AND TRUTH TABLES ARE ASSIGNED TO POF.
C            HEX AND BINARY PROGRAMMING FORMATS ARE ASSIGNED TO PDF.
C            PROMPTS AND ERROR MESSAGES ARE ASSIGNED TO PMS.
C
C PART NUMBER: THE PLE PART NUMBER MUST APPEAR IN COLUMN ONE OF LINE ONE 
C            IN THE MEMORY ORGANIZATION FORM, I.E. PLE5P8
C
C PIN        24 SYMBOLIC PIN NAMES MUST APPEAR ASSIGNMENTS: 
C            STARTING ON LINE FIVE.
C
C EQUATIONS: STARTING FIRST LINE AFTER THE PIN LIST IN THE FOLLOWING FORMS:
C
C            A = E*F + G
C            B := H*/I + /J*K
C            C = L + M :+: N
C            D = (O:*:P) + /Q
C
C ALL CHARACTERS FOLLOWING ';' ARE IGNORED UNTIL THE NEXT LINE.
C            BLANKS ARE IGNORED.
C
C OPERATORS:   ( IN HIERARCHY OF EVALUATION )
C
C            ;    COMMENT FOLLOWS
C            .    MACRO DEFINITION FOLLOWS
C            ,
C            /    COMPLEMENT
C            :*:   XNOR (EXCLUSIVE NOR)
C            *    AND (PRODUCT)
C            +    OR (SUM)
C            :+:   XOR (EXCLUSIVE OR)
C            .*.   MULTIPLY (TIMES)
C            .+.   ADD (PLUS)
C            ( )   FIXED SYMBOL
C            =    EQUALITY
C            :=    REPLACED BY (AFTER CLOCK)
C
C FUNCTION   L AND H ARE VALID FUNCTION
C            TABLE:     TABLE VECTOR ENTRIES.
C
C REFERENCE: A COMPLETE USERS GUIDE FOR DESIGNING PLES USING PLEASM WILL
C            BE PROVIDED IN THE MONOLITHIC MEMORIES PLE HANDBOOK.
C
C SUBROUTINES: GETSYM,INCR,MATCH,SIM,ARITH,BINC,HEXBC,HEXDC,DECC,BINDC,
C            ADCON,ECHO,FUNCT,TRUTH,CAT,HEX
C
C REV LEVEL:  VERSION 1.2D 6/27/84 - VAX & IBM PC VERSION
C
C AUTHORS:   VINCENT J. COLI, RANJIT PADMANABHAN & NICK SCHMITZ
C            MONOLITHIC MEMORIES INC.
C            2175 MISSION COLLEGE BOULEVARD
C            SANTA CLARA, CALIFORNIA 95050
C            (408) 970-9700
C
C FINE PRINT: MONOLITHIC MEMORIES TAKES NO RESPONSIBILITY FOR THE OPERATION
C             OR MAINTENANCE OF THIS PROGRAM. THE SOURCE CODE AS PRINTED HERE
C             PRODUCED THE OBJECT CODE OF THE EXAMPLES IN THE APPLICATIONS
C             SECTION ON A VAX/VMS 11/780 COMPUTER WITH FORTRAN 77 AND A
C             NATIONAL CSS IBM SYSTEM/370 WITH FORTRAN IV (LEVEL G).
C
C************************************
C
C     MAIN PROGRAM
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      INTEGER*1 FILE1(20),FILE2(20)
C
      INTEGER*1 CWORD(5),CTWORD(4,12),CWIDE(2),CTWIDE(10),CSYM(8,24),
     1          CBUF(8,24),CMACRO(8,24),DAT(16),BADDR(12)
      INTEGER IC,IL,IC1,J,K,I,NWD,NWIDE,UWORD,UWIDE
      INTEGER IDESC,IEND,IFUNCT,ILEQ,SINGLE
      LOGICAL LBLANK,LDOT,LSLASH,LCOMMA,LAND,LOR,LXOR,LXNOR,LADD,LSUB,
     1        LMULT,LDIV,LLEFT,LRIGHT,LEQUAL,LREQ,LPHASE(24),LMACRO(24)
      COMMON  LBLANK,LDOT,LSLASH,LCOMMA,LAND,LOR,LXOR,LXNOR,LADD,LSUB,
     1        LMULT,LDIV,LLEFT,LRIGHT,LEQUAL,LREQ
      COMMON /ILINE/ ILEQ,IFUNCT,IDESC,IEND
C
      DATA CA/'A'/,CB/'B'/,CC/'C'/,CD/'D'/,CE/'E'/,CF/'F'/,CH/'H'/,
     1     CI/'I'/,CL/'L'/,CN/'N'/,CO/'O'/,CP/'P'/,CQ/'Q'/,CR/'R'/,
     2     CS/'S'/,CT/'T'/,CU/'U'/,CX/'X'/,C0/'0'/,C1/'1'/,C2/'2'/,
     3     C3/'3'/,C4/'4'/,C5/'5'/,C6/'6'/,C7/'7'/,C8/'8'/,C9/'9'/,
     4     CLO/'L'/,CHI/'H'/
      DATA CBLANK/' '/,CHN/'N'/,CHY/'Y'/,FFEED/012/,TAB/09/
C
      CALL IOINIT
C
    8 WRITE(CONOUT,1)
    1 FORMAT(/,' MONOLITHIC MEMORIES PLEASM (tm) VERSION 1.2D',
     1       /' (C) COPYRIGHT 1984 MONOLITHIC MEMORIES')
C
C     ASSIGNMENT OF DATA SET REFERENCES
C     RPD - PLE DESIGN SPECIFICATION (INPUT FROM DATA FILE)
C     ROC - OPERATION CODE (INPUT FROM TERMINAL)
C     POF - ECHO, SIMULATION AND TRUTH TABLES (OUTPUT)
C     PDF - HEX AND BINARY PROGRAMMING FORMATS (OUTPUT)
C     PMS - PROMPTS AND ERROR MESSAGES (OUTPUT TO TERMINAL)
C
      ROC=CONINP
      PMS=CONOUT
    4 WRITE(CONOUT,2)
    2 FORMAT(/,' WHAT IS THE SOURCE FILENAME (d:filename.ext) ?: '$)
      READ(CONINP,3) (FILE1(I),I=1,20)
    3 FORMAT(20A1)
      IF(KREAD(FILINP,2,0,FILE1).NE.0) GO TO 130
      WRITE(CONOUT,333)
  333 FORMAT(/,' OUTPUT FILENAME -',
     1         ' PRESS <ENTER> FOR NO OUTPUT FILE ?: '$)
      READ(CONINP,3) (FILE2(I),I=1,20)
      LUN=CONOUT
      IF(FILE2(1).EQ.CBLANK) GO TO 9
      IF(KWRIT(FILOUT,2,0,FILE2).NE.0) GO TO 130
      LUN=FILOUT
    9 RPD=FILINP
      POF=LUN
      PDF=LUN
      IFUNCT=0
      IDESC=0
C
C     READ IN PLE DESIGN SPECIFICATION
C
      WRITE(CONOUT,9000)
9000  FORMAT(/,1X,'READING INPUT FILE ',/)
      LNPTR=0
      LNMAX=0
10    READ(RPD,5,ENDFILE=15) (CLN(IC),IC=1,80)
5     FORMAT(80A1)
      WRITE(CONOUT,9001)
      LNMAX=LNMAX+1
C
      CLN(80)=CBLANK
      J=81
11    J=J-1
      IF (CLN(J) .EQ. TAB) CLN(J)=CBLANK
      IF (CLN(J) .EQ. FFEED) CLN(J)=CBLANK
      IF (J.GT. 1 .AND. CLN(J).EQ.CBLANK) GOTO 11
C
      LOF(LNMAX)=LNPTR
      LLN(LNMAX)=J
      J=0
      SINGLE=0
12    J=J+1
      IF (CLN(J) .EQ. TAB) CLN(J)=CBLANK
      IF (CLN(J) .EQ. FFEED) CLN(J)=CBLANK
      IF (CLN(J) .NE. CBLANK) SINGLE=0
      IF (CLN(J) .EQ. CBLANK) SINGLE=SINGLE+1
C      IF (SINGLE .GE. 2) GOTO 12
      LNPTR=LNPTR+1
      CPG(LNPTR)=CLN(J)
      IF (J.LT. LLN(LNMAX)) GOTO 12
C      IF (J.LT. LLN(LNMAX) .AND. CLN(J) .NE. ';') GOTO 12
C
      LNPTR=LNPTR+1
      CPG(LNPTR)=CBLANK
      LLN(LNMAX)=LNPTR-LOF(LNMAX)
C
      IF (LNPTR .GT. 9999) WRITE (PMS,13)
13    FORMAT (' ',/,1X,'TOO MANY CHARACTERS IN INPUT FILE')
C     CHECK FOR 'FUNCTION TABLE' AND SAVE ITS LINE NUMBER
C     IF IT DOES NOT EXIST, ABORT ASSEMBLY
      IF(.NOT.(CLN(1).EQ.CF.OR.CLN(1).EQ.CD)) GO TO 10
      IF(   IFUNCT.EQ.0 .AND.CLN(1).EQ.CF.AND.
     1    CLN(2).EQ.CU.AND.CLN(3).EQ.CN.AND.
     2    CLN(4).EQ.CC.AND.CLN(5).EQ.CT.AND.
     3    CLN(6).EQ.CI.AND.CLN(7).EQ.CO.AND.
     4    CLN(8).EQ.CN.AND.CLN(10).EQ.CT.AND.
     5    CLN(12).EQ.CB.AND.CLN(14).EQ.CE ) IFUNCT=LNMAX
C     CHECK FOR 'DESCRIPTION' AND SAVE ITS LINE NUMBER
C     IF IT DOES NOT EXIST, ABORT ASSEMBLY
      IF(    IDESC.EQ.0 .AND.CLN(1).EQ.CD.AND.
     1    CLN(2).EQ.CE.AND.CLN(3).EQ.CS.AND.
     2    CLN(4).EQ.CC.AND.CLN(5).EQ.CR.AND.
     3    CLN(6).EQ.CI.AND.CLN(7).EQ.CP.AND.
     4    CLN(8).EQ.CT.AND.CLN(9).EQ.CI.AND.
     5    CLN(10).EQ.CO.AND.CLN(11).EQ.CN ) IDESC=LNMAX
C
      GOTO 10
C
C     SAVE THE LAST LINE NUMBER OF THE PLE DESIGN SPECIFICATION
C
9001  FORMAT(1X,'.'$)
   15 IEND=LNMAX
      WRITE(PMS,16) LNMAX,LNPTR
16    FORMAT (' ',/,' PLE DESIGN FILE READ - ',I5,' LINES',I6,
     2 ' CHARACTERS (MAXIMUM 9999)')
      IF(IFUNCT.NE.0) GO TO 102
      WRITE(PMS,101)
  101 FORMAT(/,' *** KEYWORD "FUNCTION TABLE" MISSING. ASSEMBLY',
     1       ' TERMINATED',/)
      GO TO 115
  102 CONTINUE
      IF(IDESC.NE.0) GO TO 104
      WRITE(PMS,103)
  103 FORMAT(/,' *** KEYWORD "DESCRIPTION" MISSING. ASSEMBLY',
     1       ' TERMINATED',/)
      GO TO 115
  104 CONTINUE
C     DETERMINE PLE PART TYPE
      IL=1
      IC=1
   20 IF( CPG(LOF(IL)+IC).EQ.CP.AND.CPG(LOF(IL)+IC+1).EQ.CLO.AND.
     1    CPG(LOF(IL)+IC+2).EQ.CE) GO TO 25
      CALL INCR(IC,IL)
      GO TO 20
   25 IC=IC+3
      IC1=IC-1
      NWD=0
      NWIDE=0
      IF( CPG(LOF(IL)+IC).EQ.C5 ) NWD=5
      IF( CPG(LOF(IL)+IC).EQ.C8 ) NWD=8
      IF( CPG(LOF(IL)+IC).EQ.C9 ) NWD=9
      IF( NWD.NE.0) GO TO 30
      IF( CPG(LOF(IL)+IC).EQ.C1.AND.CPG(LOF(IL)+IC+1).EQ.C0 ) NWD=10
      IF( CPG(LOF(IL)+IC).EQ.C1.AND.CPG(LOF(IL)+IC+1).EQ.C1 ) NWD=11
      IF( CPG(LOF(IL)+IC).EQ.C1.AND.CPG(LOF(IL)+IC+1).EQ.C2 ) NWD=12
      IC=IC+1
   30 IC=IC+1
      IF(.NOT.(CPG(LOF(IL)+IC).EQ.CP.OR.CPG(LOF(IL)+IC).EQ.CR) ) NWD=0
      IC=IC+1
      IF( CPG(LOF(IL)+IC).EQ.C4 ) NWIDE=4
      IF( CPG(LOF(IL)+IC).EQ.C8 ) NWIDE=8
      IF( NWD.NE.0.AND.NWIDE.NE.0 ) GO TO 40
      WRITE(PMS,35) (CPG(LOF(IL)+IC+IC1),IC=1,4)
   35 FORMAT(/,' PLE PART TYPE PLE',4A1,' IS INCORRECT')
      GO TO 115
C     GET ADDRESS PIN NAMES FOLLOWING .ADDRESS (MAXIMUM OF 12 ALLOWED)
   40 IC=0
      IL=5
   45 CALL INCR(IC,IL)
      IF(.NOT.LDOT) GO TO 45
      CALL GETSYM(LMACRO,CMACRO,1,IC,IL)
      DO 50 I=1,NWD
          CALL GETSYM(LPHASE,CSYM,I,IC,IL)
          UWORD=I
          IF(LDOT) GO TO 65
   50 CONTINUE
C     IF THE DATA PINS ARE NOT NAMED AFTER "NWD" ADDRESS PINS
C     ARE NAMED,AN ERROR IS REPORTED AND ASSEMBLY IS ABORTED
      WRITE(PMS,60)
   60 FORMAT(/,' *** TOO MANY PIN NAMES IN INPUT PIN LIST ***',/)
      GO TO 115
C     GET DATA PIN NAMES FOLLOWING .DATA (MAX. OF 12 ALLOWED)
   65 CALL GETSYM(LMACRO,CMACRO,1,IC,IL)
      DO 70 I=1,NWIDE
          J=I+12
          CALL GETSYM(LPHASE,CSYM,J,IC,IL)
          IF( LDOT.OR.LEQUAL.OR.LREQ ) GO TO 75
          UWIDE=I
   70 CONTINUE
      CALL GETSYM(LMACRO,CMACRO,1,IC,IL)
      IF(LDOT.OR.LEQUAL.OR.LREQ.OR.LCOMMA) GO TO 75
C     IF THE EQUATIONS DO NOT START AFTER "NWIDE" DATA PINS ARE
C     NAMED,AN ERROR IS REPORTED AND ASSEMBLY IS TERMINATED
      WRITE(PMS,73)
   73 FORMAT(/,' *** TOO MANY PIN NAMES IN OUTPUT PIN LIST ***',/)
      GO TO 115
   75 ILEQ=IL
   80 WRITE(PMS,90)
   90 FORMAT(' ',/,' E=ECHO INPUT  S=SIMULATE  T=TRUTH TABLE  B=BRIEF',
     1' TABLE',/,' A=HEX TABLE   I=INTEL HEX H=ASCII HEX',
     2'    C=CATALOG  Q=QUIT')
      WRITE(PMS,95)
   95 FORMAT(/,' ENTER OPERATION CODE: '$)
      COP=CBLANK
C      REWIND(ROC)
      READ(ROC,100,ENDFILE=350) COP
  100 FORMAT(A1)
  350 CONTINUE
      IF (COP .GT. CHY) COP=COP-32
C     INITIALIZE BINARY ADDRESS (BADDR) TO ZERO
      DO 105 I=1,12
          BADDR(I)=CLO
  105 CONTINUE
      IF(POF.NE.CONOUT) WRITE(POF,110)
  110 FORMAT('1')
      IF(COP.EQ.CE) CALL ECHO
      IF(COP.EQ.CS) CALL FUNCT(NWD,NWIDE,UWORD,UWIDE,CSYM)
      IF(COP.EQ.CT) CALL TRUTH(NWD,NWIDE,BADDR,LPHASE,CSYM,CBUF,CT)
      IF(COP.EQ.CB) CALL TRUTH(UWORD,UWIDE,BADDR,LPHASE,CSYM,CBUF,CB)
      IF(COP.EQ.CA) CALL TRUTH(NWD,NWIDE,BADDR,LPHASE,CSYM,CBUF,CA)
      IF(COP.EQ.CI) CALL HEX(NWD,NWIDE,BADDR,LPHASE,CSYM,CBUF,CI)
      IF(COP.EQ.CH) CALL HEX(NWD,NWIDE,BADDR,LPHASE,CSYM,CBUF,CH)
      IF(COP.EQ.CC) CALL CAT
      IF(COP.NE.CQ) GO TO 80
  115 I=KCLOS(FILINP)
      IF(LUN.NE.CONOUT) I=KCLOS(FILOUT)
  120 WRITE(PMS,125)
  125 FORMAT(1X,'RESTART PLEASM (Y/N) ?: '$)
      READ(CONINP,3) (FILE1(I),I=1,20)
      IF(FILE1(1).EQ.CHY) GO TO 8
      IF(FILE1(1).EQ.CBLANK) STOP
      IF(FILE1(1).NE.CHN) GO TO 120
      STOP
  130 WRITE(PMS,135)
  135 FORMAT(/,' DISK I/O ERROR - MAYBE WRONG FILENAME ???')
      GO TO 120
      END
C
C************************************
C
      SUBROUTINE GETSYM(LPHASE,CSYM,J,IC,IL)
C     THIS SUBROUTINE GETS THE PIN NAME, / IF COMPLEMENT LOGIC, AND
C      THE FOLLOWING OPERATOR IF ANY
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER I,J,IC,IL
      INTEGER*1 CSYM(8,24)
      LOGICAL LBLANK,LDOT,LSLASH,LCOMMA,LAND,LOR,LXOR,LXNOR,LADD,LSUB,
     1        LMULT,LDIV,LLEFT,LRIGHT,LEQUAL,LREQ,LPHASE(24),LXOR1
      COMMON  LBLANK,LDOT,LSLASH,LCOMMA,LAND,LOR,LXOR,LXNOR,LADD,LSUB,
     1        LMULT,LDIV,LLEFT,LRIGHT,LEQUAL,LREQ
C
C     CHANGE THIS DATA STATMENT IF AN ALTERNATE SET OF OPERATORS IS
C      DESIRED
      DATA CBLANK/' '/,COMENT/';'/,CDOT/'.'/,CSLASH/'/'/,COMMA/','/,
     1     CAND/'*'/,COR/'+'/,CDASH/'-'/,COLON/':'/,CLEFT/'('/,
     2     CRIGHT/')'/,CEQUAL/'='/
C
      IF  (LDOT.OR.LCOMMA.OR.LAND.OR.LOR.OR.LXOR.OR.LXNOR.OR.
     1   LADD.OR.LSUB.OR.LMULT.OR.LDIV.OR.LLEFT.OR.LRIGHT.OR.
     2   LEQUAL.OR.LREQ)  CALL INCR(IC,IL)
      LPHASE(J)=( .NOT.LSLASH )
      IF( .NOT.LPHASE(J) ) CALL INCR(IC,IL)
      DO 920 I=1,8
  920     CSYM(I,J)=CBLANK
  925 DO 930 I=1,7
  930     CSYM(I,J)=CSYM(I+1,J)
      CSYM(8,J)=CPG(LOF(IL)+IC)
C
      LBLANK=.FALSE.
    5 IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
      IF( IC.LE.LLN(IL).AND. CTMP.NE.COMENT ) GO TO 20
      IL=IL+1
      IC=0
      GO TO 5
   20 IF(CTMP.NE.CBLANK) GO TO 25
      LBLANK= .TRUE.
      GO TO 5
   25 LDOT  = .FALSE. 
      LXNOR = .FALSE.
      LXOR  = .FALSE.
      LMULT = .FALSE.
      LDIV  = .FALSE.
      LADD  = .FALSE. 
      LSUB  = .FALSE.
      LREQ  = .FALSE.
      IF(CTMP.NE.COLON) GO TO 30
      IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
      LXNOR =( CTMP .EQ. CAND  )
      LXOR  =( CTMP .EQ. COR   )
      LREQ  =( CTMP .EQ. CEQUAL )
      IF(LXNOR.OR.LXOR) IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
   30 IF( CTMP.NE.CDOT) GO TO 35
      IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
      LMULT =( CTMP .EQ. CAND  )
      LDIV  =( CTMP .EQ.CSLASH )
      LADD  =( CTMP .EQ. COR   )
      LSUB  =( CTMP .EQ.CDASH  )
      LDOT  =( .NOT.(LMULT.OR.LDIV.OR.LADD.OR.LSUB) )
      IF(     LDOT) IC=IC-1
      IF(.NOT.LDOT) IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
   35 LSLASH=( CTMP .EQ.CSLASH )
      LCOMMA=( CTMP .EQ.COMMA  )
      LAND  =( CTMP .EQ. CAND  )
      LOR   =( CTMP .EQ. COR   )
      LLEFT =( CTMP .EQ.CLEFT  )
      LRIGHT=( CTMP .EQ.CRIGHT )
      LEQUAL=( CTMP .EQ.CEQUAL )
C
      IF( LBLANK.OR.LDOT.OR.LCOMMA.OR.LXNOR.OR.LAND.OR.LOR.OR.LXOR.OR.
     1    LMULT.OR.LDIV.OR.LADD.OR.LSUB.OR.LLEFT.OR.LRIGHT.OR.
     2    LEQUAL.OR.LREQ ) RETURN
      GO TO 925
      END
C
C************************************
C
C
      SUBROUTINE MATCH(CSYM,CBUF,IMATCH)
C     THIS SUBROUTINE FINDS A MATCH BETWEEN THE PIN NAME IN THE EQUATION
C      AND THE PIN NAME IN THE PIN LIST OR FUNCTION TABLE PIN LIST
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CSYM(8,24),CBUF(8,24)
      INTEGER I,J,IMATCH
      LOGICAL LMATCH
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      J=0
5     J=J+1
      LMATCH=.TRUE.
      I=9
10    I=I-1
      IF (I .LE. 0) GOTO 30
      IF (CBUF(I,1).EQ.CSYM(I,J)) GOTO 10
      IF (J .LT. 24) GOTO 5
      WRITE(PMS,15) (CBUF(I,1),I=1,8)
   15 FORMAT(/,' ERROR SYMBOL = ',8A1)
      IMATCH=0
      RETURN
C
   30 IMATCH=J
      RETURN
      END
C
C************************************
C
      SUBROUTINE INCR(IC,IL)
C     THIS SUBROUTINE INCREMENTS COLUMN AND LINE POINTERS
C      BLANKS AND CHARACTERS AFTER ';' ARE IGNORED
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER IC,IL
      LOGICAL LBLANK,LDOT,LSLASH,LCOMMA,LAND,LOR,LXOR,LXNOR,LADD,LSUB,
     1        LMULT,LDIV,LLEFT,LRIGHT,LEQUAL,LREQ,LXOR1
      COMMON  LBLANK,LDOT,LSLASH,LCOMMA,LAND,LOR,LXOR,LXNOR,LADD,LSUB,
     1        LMULT,LDIV,LLEFT,LRIGHT,LEQUAL,LREQ
C     CHANGE THIS DATA STATMENT IF AN ALTERNATE SET OF OPERATORS IS
C      DESIRED
      DATA CBLANK/' '/,COMENT/';'/,CDOT/'.'/,CSLASH/'/'/,COMMA/','/,
     1     CAND/'*'/,COR/'+'/,CDASH/'-'/,COLON/':'/,CLEFT/'('/,
     2     CRIGHT/')'/,CEQUAL/'='/
C
      LBLANK=.FALSE.
    5 IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
      IF( IC.LE.LLN(IL).AND. CTMP.NE.COMENT ) GO TO 20
      IL=IL+1
      IC=0
      GO TO 5
   20 IF(CTMP.NE.CBLANK) GO TO 25
      LBLANK= .TRUE.
      GO TO 5
   25 LDOT  = .FALSE. 
      LXNOR = .FALSE.
      LXOR  = .FALSE.
      LMULT = .FALSE.
      LDIV  = .FALSE.
      LADD  = .FALSE. 
      LSUB  = .FALSE.
      LREQ  = .FALSE.
      IF(CTMP.NE.COLON) GO TO 30
      IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
      LXNOR =( CTMP .EQ. CAND  )
      LXOR  =( CTMP .EQ. COR   )
      LREQ  =( CTMP .EQ. CEQUAL )
      IF(LXNOR.OR.LXOR) IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
   30 IF( CTMP.NE.CDOT) GO TO 35
      IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
      LMULT =( CTMP .EQ. CAND  )
      LDIV  =( CTMP .EQ.CSLASH )
      LADD  =( CTMP .EQ. COR   )
      LSUB  =( CTMP .EQ.CDASH  )
      LDOT  =( .NOT.(LMULT.OR.LDIV.OR.LADD.OR.LSUB) )
      IF(     LDOT) IC=IC-1
      IF(.NOT.LDOT) IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
   35 LSLASH=( CTMP .EQ.CSLASH )
      LCOMMA=( CTMP .EQ.COMMA  )
      LAND  =( CTMP .EQ. CAND  )
      LOR   =( CTMP .EQ. COR   )
      LLEFT =( CTMP .EQ.CLEFT  )
      LRIGHT=( CTMP .EQ.CRIGHT )
      LEQUAL=( CTMP .EQ.CEQUAL )
      RETURN
      END
C
C************************************
C
      SUBROUTINE SIM(NWIDE,BADDR,BDAT,CSYM,CBUF,LPHASE)
C     THIS SUBROUTINE PERFORMS BOOLEAN ALGEBRA ON THE LOGIC EQUATIONS
C      GIVEN A BINARY ADDRESS (BADDR) AS INPUT, IT WILL GENERATE BINARY
C      DATA (BDAT) AS OUTPUT.
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER*1 CSYM(8,24),CBUF(8,24),BADDR(12),BDAT(12)
      INTEGER IC,IL,I,NWIDE,IDESC,IEND,IFUNCT,ILEQ,NADDR,NDAT,COUNT
      LOGICAL LBLANK,LDOT,LSLASH,LCOMMA,LAND,LOR,LXOR,LXNOR,LADD,LSUB,
     1        LMULT,LDIV,LLEFT,LRIGHT,LEQUAL,LREQ,LMATCH,LPHASE(24),
     2        LBUF(24),LDAT,LADDR,LOUT,LXNOR1,LAND1,LXOR1,LOR1
      LOGICAL PRNDOT
      COMMON  LBLANK,LDOT,LSLASH,LCOMMA,LAND,LOR,LXOR,LXNOR,LADD,LSUB,
     1        LMULT,LDIV,LLEFT,LRIGHT,LEQUAL,LREQ
      COMMON /ILINE/ ILEQ,IFUNCT,IDESC,IEND
      DATA CLO/'L'/,CHI/'H'/
      IC=0
      IL=ILEQ
      LXNOR1=.FALSE.
      LAND1=.FALSE.
      LXOR1=.FALSE.
      LOR1=.FALSE.
      PRNDOT=BADDR(1).EQ.CLO.AND.BADDR(2).EQ.CLO.AND.POF.NE.CONOUT
      IF(PRNDOT) WRITE(CONOUT,9000)
9000  FORMAT(1X,'.'$)
      DO 5 I=1,NWIDE
    5 BDAT(I)=CLO
      CALL INCR(IC,IL)
   10 CALL GETSYM(LBUF,CBUF,1,IC,IL)
      IF(LCOMMA) GO TO 65
   15 IF(.NOT.LEQUAL) GO TO 10
      CALL MATCH(CSYM,CBUF,NDAT)
      LOUT=( (     LPHASE(NDAT)).AND.(     LBUF(1)).OR.
     1       (.NOT.LPHASE(NDAT)).AND.(.NOT.LBUF(1)) )
   20 CALL GETSYM(LBUF,CBUF,1,IC,IL)
      CALL MATCH(CSYM,CBUF,NADDR)
C     DETERMINE POLARITY AND THEN VALUE (H OR L) OF INPUT
      LADDR=( (     LPHASE(NADDR)).AND.(     LBUF(1)).OR.
     1        (.NOT.LPHASE(NADDR)).AND.(.NOT.LBUF(1)) )
C     ASSUME LOW
      SIGNAL=CLO
      IF( BADDR(NADDR).EQ.CHI.AND.(     LADDR) ) SIGNAL=CHI
      IF( BADDR(NADDR).EQ.CLO.AND.(.NOT.LADDR) ) SIGNAL=CHI
      IF(.NOT.LXNOR1) GO TO 25
C     EVALUATE 'XNOR'FUNCTION - ASSUME LOW
      TEMP=CLO
      IF(SIGNAL.EQ.XPROD) TEMP=CHI
      SIGNAL=TEMP
      LXNOR1=.FALSE.
   25 IF(.NOT.LXNOR) GO TO 30
      XPROD=SIGNAL
      LXNOR1=.TRUE.
      GO TO 20
   30 IF(.NOT.LAND1) GO TO 35
C     EVALUATE 'AND' FUNCTION
      IF(PROD.EQ.CLO) SIGNAL=CLO
      LAND1=.FALSE.
   35 IF(.NOT.LAND) GO TO 40
      PROD=SIGNAL
      LAND1=.TRUE.
      GO TO 20
   40 IF(.NOT.LXOR1) GO TO 45
C     EVALUATE 'XOR' FUNCTION - ASSUME LOW
      TEMP=CLO
      IF(SIGNAL.NE.XSUM) TEMP=CHI
      SIGNAL=TEMP
      LXOR1=.FALSE.
   45 IF(.NOT.LXOR) GO TO 50
      XSUM=SIGNAL
      LXOR1=.TRUE.
      GO TO 20
   50 IF(.NOT.LOR1) GO TO 55
C     EVALUATE 'OR' FUNCTION
      IF(SUM.EQ.CHI) SIGNAL=CHI
      LOR1=.FALSE.
   55 IF(.NOT.LOR) GO TO 60
      LOR1=.TRUE.
      SUM=SIGNAL
      GO TO 20
   60 BDAT(NDAT-12)=SIGNAL
      IF( SIGNAL.EQ.CLO.AND.(.NOT.LOUT) ) BDAT(NDAT-12)=CHI
      IF( SIGNAL.EQ.CHI.AND.(.NOT.LOUT) ) BDAT(NDAT-12)=CLO
      IF (IL.LT.IFUNCT)  GO TO 15
      RETURN
C     CALL ARITH SUBROUTINE TO EVALUATE ARITHMETIC FUNCTIONS
   65 CALL ARITH(NWIDE,BADDR,BDAT,CSYM,CBUF,LPHASE)
      RETURN
      END
C
C************************************
C
      SUBROUTINE ARITH(NWIDE,BADDR,BDAT,CSYM,CBUF,LPHASE)
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER*1 CSYM(8,24),CBUF(8,24),BADDR(12),BDAT(12),
     1          NADDRA(12),NDATA(12),BDATA(12),BADDRA(12)
      INTEGER IC,IL,ISUM,DECC,I,NWIDE,ID,IDESC,IEND,IFUNCT,ILEQ,IA
      INTEGER NDAT,NADDR
      LOGICAL LBLANK,LDOT,LSLASH,LCOMMA,LAND,LOR,LXOR,LXNOR,LADD,LSUB,
     1        LMULT,LDIV,LLEFT,LRIGHT,LEQUAL,LREQ,LMATCH,LPHASE(24),
     2        LBUF(24),LDAT,LADDR,LDATA(12),LMULTP,LADDP,LFIRST
      COMMON  LBLANK,LDOT,LSLASH,LCOMMA,LAND,LOR,LXOR,LXNOR,LADD,LSUB,
     1        LMULT,LDIV,LLEFT,LRIGHT,LEQUAL,LREQ,LADDP,LMULTP,LFIRST
      COMMON /ILINE/ ILEQ,IFUNCT,IDESC,IEND
      DATA CLO/'L'/,CHI/'H'/
      IC=0
      IL=ILEQ
      DO 5 I=1,NWIDE
    5 BDAT(I)=CLO
      LADDP=.FALSE.
      LMULTP=.FALSE.
      LFIRST=.TRUE.
      ID=0
      CALL INCR(IC,IL)
   10 CALL GETSYM(LBUF,CBUF,1,IC,IL)
      CALL MATCH(CSYM,CBUF,NDAT)
      ID=ID+1
      NDATA(ID)=NDAT
      LDATA(ID)=( (     LPHASE(NDAT)).AND.(     LBUF(1)).OR.
     1            (.NOT.LPHASE(NDAT)).AND.(.NOT.LBUF(1)) )
   15 IF(.NOT.LEQUAL) GO TO 10
      DO 20 I=1,ID
   20 BDATA(I)=CLO
   25 IA=0
   30 CALL GETSYM(LBUF,CBUF,1,IC,IL)
      CALL MATCH(CSYM,CBUF,NADDR)
      IA=IA+1
      NADDRA(IA)=NADDR
      LADDR=( (     LPHASE(NADDR)).AND.(     LBUF(1)).OR.
     1        (.NOT.LPHASE(NADDR)).AND.(.NOT.LBUF(1)) )
      IF( BADDR(NADDR).EQ.CLO.AND.(     LADDR) ) BADDRA(IA)=CLO
      IF( BADDR(NADDR).EQ.CHI.AND.(     LADDR) ) BADDRA(IA)=CHI
      IF( BADDR(NADDR).EQ.CLO.AND.(.NOT.LADDR) ) BADDRA(IA)=CHI
      IF( BADDR(NADDR).EQ.CHI.AND.(.NOT.LADDR) ) BADDRA(IA)=CLO
      IF(LCOMMA) GO TO 30
      IF(LFIRST.OR.LADD.OR.LADDP) ISUM = DECC(ID,BDATA,.TRUE.) +
     1                                   DECC(IA,BADDRA,.TRUE.)
      IF(LMULTP) ISUM = DECC(ID,BDATA,.TRUE.) * DECC(IA,BADDRA,.TRUE.)
      CALL BINDC(ID,ISUM,BDATA)
      LADDP =LADD
      LMULTP=LMULT
      LFIRST=.FALSE.
      IF(LADD.OR.LSUB.OR.LMULT.OR.LDIV) GO TO 25
      DO 35 I=1,ID
          NDAT=NDATA(I) - 12
          IF( BDATA(I).EQ.CLO.AND.(.NOT.LDATA(I)) ) BDATA(I)=CHI
          IF( BDATA(I).EQ.CHI.AND.(.NOT.LDATA(I)) ) BDATA(I)=CLO
          BDAT(NDAT)=BDATA(I)
   35 CONTINUE
      IF(LEQUAL) GO TO 15
      IF (IL.LT.IFUNCT) GO TO 15
      RETURN
      END
C
C************************************
C
      SUBROUTINE BINC(BADDR)
C     THIS SUBROUTINE COUNTS IN BINARY (BADDR) TO GENERATE THE NEXT
C      ADDRESS
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I
      INTEGER*1 BADDR(12)
      DATA CLO/'L'/,CHI/'H'/
      I=0
    5 I=I+1
      IF(I .LT. 12 .AND. BADDR(I).EQ.CHI ) GO TO 5
      BADDR(I)=CHI
   10 I=I-1
      IF(I.EQ.0) RETURN
      BADDR(I)=CLO
      GO TO 10
      END
C
C************************************
C
      SUBROUTINE HEXBC(N,BIT,ZHEX)
C     THIS SUBROUTINE CONVERTS BINARY BITS INTO HEX NUMBERS
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,N,J,IHEX
      INTEGER*1 ZTABLE(16),BIT(12),ZHEX(4)
      DATA CHI/'H'/,ZTABLE/'0','1','2','3','4','5','6','7',
     1                     '8','9','A','B','C','D','E','F'/
      DO 5 I=1,2
    5     ZHEX(I+1)=ZTABLE(1)
      J=0
      DO 10 I=1,N,4
          J=J+1
          IHEX=0
          IF( BIT(I + 0).EQ.CHI ) IHEX=IHEX+1
          IF( BIT(I + 1).EQ.CHI ) IHEX=IHEX+2
          IF( BIT(I + 2).EQ.CHI ) IHEX=IHEX+4
          IF( BIT(I + 3).EQ.CHI ) IHEX=IHEX+8
          ZHEX(J)=ZTABLE(IHEX+1)
   10 CONTINUE
      RETURN
      END
C
C************************************
C
      SUBROUTINE HEXDC(DEC,ZHEX)
C     THIS SUBROUTINE CONVERTS DECIMAL NUMBERS INTO HEX NUMBERS
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 ZTABLE(16),ZHEX(5)
      INTEGER I,DEC,ZTEMP
      DATA ZTABLE/'0','1','2','3','4','5','6','7',
     1            '8','9','A','B','C','D','E','F'/
      DO 5 I=1,5
          ZTEMP=DEC-16*(DEC/16)
          ZHEX(6-I)=ZTABLE(ZTEMP+1)
          DEC=DEC/16
    5 CONTINUE
      RETURN
      END
C
C************************************
C
      FUNCTION DECC(N,BIT,LMODE)
C     THIS SUBFUNCTION CONVERTS N BINARY BITS (BIT) INTO A DECIMAL
C      NUMBER
C     NOTE: LMODE=TRUE  MEANS EXPECT MSB IN FIRST BINARY BIT
C      AND  LMODE=FALSE MEANS EXPECT LSB IN FIRST BINARY BIT
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 BIT(12)
      INTEGER I,N,DECC,DTMP1,DTMP2
      LOGICAL LMODE
      DATA CHI/'H'/
      DECC=0
C
      DTMP2=1
      DTMP1=1
      DO 4 I=1,N
4     DTMP2=2*DTMP2
C
      DO 5 I=1,N
          DTMP2=DTMP2/2
          IF( BIT(I).EQ.CHI.AND.(     LMODE) ) DECC=DECC+DTMP2
          IF( BIT(I).EQ.CHI.AND.(.NOT.LMODE) ) DECC=DECC+DTMP1
          DTMP1=2*DTMP1
    5 CONTINUE
      RETURN
      END
C
C************************************
C
      SUBROUTINE BINDC(NWD,ADDR,BADDR)
C     THIS SUBROUTINE CONVERTS A DECIMAL NUMBER (ADDR) INTO NWIDE BITS
C      OF BINARY DATA (BDAT) WITH MSB FIRST.
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER ADDR,I,NWD,DEC,DTEMP,DTMP
      INTEGER*1 BADDR(12)
      DATA CLO/'L'/,CHI/'H'/
      DEC=ADDR
      DTMP=1
      DO 4 I=1,NWD
4     DTMP=2*DTMP
C
      DO 5 I=1,NWD
          BADDR(I)=CLO
          DTMP=DTMP/2
          DTEMP=DEC-DTMP
          IF(DTEMP.LT.0) GO TO 5
          BADDR(I)=CHI
          DEC=DTEMP
    5 CONTINUE
      RETURN
      END
C
C************************************
C
      SUBROUTINE ADCON(INT,CHAR)
C     THIS SUBROUTINE CONVERTS AN INTEGER (INT) INTO A CHARACTER (CHAR)
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER INT
      INTEGER*1 CC(13)
      DATA CC/'0','1','2','3','4','5','6','7','8','9','A','B','C'/
      CHAR=CC(INT+1)
      RETURN
      END
C
C************************************
C
      SUBROUTINE ECHO
C     THIS SUBROUTINE PRINTS THE PLE DESIGN SPECIFICATION INPUT FILE
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER IC,IL
C
15    DO 200 IL=1,LNMAX
200   WRITE(POF,205) (CPG(IC),IC=(LOF(IL)+1),(LOF(IL)+LLN(IL)))
205   FORMAT (1X,79A1)
C
      RETURN
      END
C
C************************************
C
      SUBROUTINE FUNCT(IWORD,IWIDE,UIWORD,UIWIDE,CSYM)
C     THIS SUBROUTINE PERFORMS THE SIMULATION
C     THE FUNCTION TABLE IS PARSED AND ALL THE CASES IN
C     THE FUNCTION TABLE ARE SIMULATED THROUGH REPEATED CALLS
C     TO THE SUBROUTINE "SIM".ERROR CONDITIONS ARE REPORTED
C     AS DESCRIBED IN THE COURSE OF THE SUBROUTINE.THIS SUB-
C     ROUTINE GETS ALL ITS PARAMETERS FROM THE MAIN PROGRAM
C     AND SENDS ITS OUTPUT TO THE DESIRED OUTPUT FILE,DEFAULTING
C     TO THE SCREEN.
C     AUTHOR:RANJIT PADMANABHAN
C
      IMPLICIT INTEGER*1 (A-Z)
      LOGICAL FTIS,LGOOF,LTEMP,LDASH,LERR,LPH(24),LBUF(24)
      INTEGER UIWORD,UIWIDE,IC,IL,I,IFTST,IFTEND,L,K,J,NUML,NUMF
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER*1 XADDR(12),DATCHK(12),XDAT(12),CSYM(8,24),CBUF(8,24)
      INTEGER*1 AMATCH(24),POSN(24),PBUF(80)
      INTEGER ILEQ,IFUNCT,IDESC,IEND,IWIDE,UWIDE,IWORD,UWORD,IPOS,IGOOF
      COMMON /ILINE/ ILEQ,IFUNCT,IDESC,IEND
      DATA CBLANK/' '/,CDASH/'-'/,CQUEST/'?'/,CX/'X'/,CLO/'L'/,CHI/'H'/
      DATA COMENT/';'/
C     INITIALIZE THE FUNCTION TABLE ARRAYS.
C     "XADDR" AND "DATCHK" GET THE INPUT AND OUTPUT LOGIC
C     VALUES RESPECTIVELY FROM THE FUNCTION TABLE. "XADDR"
C     IS PASSED TO SUBROUTINE "SIM" WHICH RETURNS THE CAL-
C     CULATED OUTPUT VALUES IN "XDAT".
      DO 1 I=1,12
      XADDR(I)=CBLANK
      XDAT(I)=CBLANK
      DATCHK(I)=CBLANK
      FTIS=.FALSE.
    1 CONTINUE
C     CHECK FOR FUNCTION TABLE NECESSARY FOR SIMULATION
      DO 2 K=IFUNCT,IDESC
    2 IF(CPG(LOF(K)+1).EQ.CDASH) FTIS=.TRUE.
      IF(FTIS) GO TO 10
      WRITE(PMS,5)
    5 FORMAT(/,' FUNCTION TABLE MUST BE SUPPLIED IN ORDER TO PERFORM',
     1         ' SIMULATION',/)
      RETURN
C     INITIALIZE FLAGS AND ERROR COUNT VARIABLES
   10 LERR=.FALSE.
      LGOOF=.FALSE.
      LTEMP=.FALSE.
      IGOOF=0
      IF(POF.NE.CONOUT) WRITE(CONOUT,9000)
C     BEGIN COUNTING LINES BACKWARDS FROM KEYWORD "DESCRIPTION"
C     TO LOCATE THE END OF THE FUNCTION TABLE "IFTEND"
      IL=IDESC
   11 IL=IL-1
      IC=1
      LDASH=(CPG(LOF(IL)+IC).EQ.CDASH)
      IF (.NOT.LDASH) GO TO 11
      IFTEND=IL-1
C     COUNT LINES FORWARD FROM KEYWORD "FUNCTION TABLE" TO
C     LOCATE THE FUNCTION TABLE PIN LIST
      IL=IFUNCT
      IC=15
      LDASH=.FALSE.
      NUMF=0
   22 IF (LDASH) GO TO 34
C     GET EACH PIN NAME AND COMPARE IT TO THE NAMES DECLARED
C     IN "CSYM"
      CALL INCR(IC,IL)
      CALL GETSYM(LBUF,CBUF,1,IC,IL)
      CALL MATCH(CSYM,CBUF,IPOS)
C     IF A SYMBOL DECLARED IN THE FUNCTION TABLE PIN LIST DOES
C     NOT MATCH ANY OF THE NAMES DECLARED,TERMINATE SIMULATION
      IF(IPOS.EQ.0) RETURN
C     IF "-" IS ENCOUNTERED PIN LIST IS COMPLETE
      LDASH=(CPG(LOF(IL)+IC).EQ.CDASH)
C     COMPENSATE FOR EXTRA COLUMN TRAVERSED IN PERFORMING
C     PREVIOUS OPERATIONS
      IC=IC-1
C     INCREMENT NUMBER OF PIN NAMES "NUMF"
      NUMF=NUMF+1
C     IF MORE PINS ARE NAMED THAN ARE DECLARED FLAG AN ERROR
      IF(NUMF.GT.UIWORD+UIWIDE) GO TO 32
C     REARRANGE THE FUNCTION TABLE PIN LIST NAMES TO CORRESPOND
C     TO THE ORDER IN THE DECLARATIVE PART OF THE SPECIFICATIONS
      LPH(IPOS)=LBUF(1)
      AMATCH(NUMF)=IPOS
      GO TO 22
C     PRINT DIAGNOSTIC ERROR MESSAGE
   32 WRITE(PMS,33)
   33 FORMAT(/,' *** TOO MANY PIN NAMES IN FUNCTION TABLE PIN
     1 LIST ***',/)
      RETURN 
C     STORE THE FIRST FUNCTION TABLE LINE NUMBER IN "IFTST"
C     PRINT THE FIRST FEW LINES OF THE FUNCTION TABLE UPTO
C     BUT NOT INCLUDING THE LOGIC VALUE ENTRIES
   34 IFTST=IL
      DO 43 IL=IFUNCT,IFTST
      WRITE(POF,42) (CPG(LOF(IL)+K),K=1,LLN(IL))
   42 FORMAT(1X,80A1)
   43 CONTINUE
C     CALCULATE THE NUMBER OF LINES IN THE FUNCTION TABLE
C     "NUML",AND USE IT FOR A COUNTER
      IL=IFTST+1
      NUML=IFTEND-IL+1
C     IF THERE ARE ANY COMMENTS IN THE FUNCTION TABLE,REDUCE
C     THE LINE COUNT WITHIN THE FUNCTION TABLE BY 1
      DO 435 K=IFTST,IFTEND
  435 IF(CPG(LOF(K)+1).EQ.COMENT) NUML=NUML-1
      IC=0
      DO 70 J=1,NUML
      CALL INCR(IC,IL)
      DO 44 I=1,NUMF
C     STORE THE COLUMN POSITION OF EACH ELEMENT IN AN ARRAY
C     USED FOR EASY ERROR READING IN OUTPUT
      POSN(I)=IC
C     STORE THE INPUT PIN VALUES IN "XADDR" AND THE EXPECTED
C     OUTPUT PIN VALUES IN "DATCHK".THESE CAN BE DIFFERENTIATED
C     BY THE PIN NAME POSITIONS AVAILABLE IN "AMATCH"
      IF (AMATCH(I).LE.12) XADDR(AMATCH(I))=CPG(LOF(IL)+IC)
      IF (AMATCH(I).GT.12) DATCHK(AMATCH(I)-12)=CPG(LOF(IL)+IC)
      IF(I.LT.NUMF) CALL INCR(IC,IL)
   44 CONTINUE
      K=1
C
C     COUNT THE NUMBER OF PINS ACTUALLY BEING USED,"UWORD"
C     AND "UWIDE",IN THE FUNCTION TABLE.THESE VARIABLES ARE
C     LATER USED TO DELIMIT COUNTS IN THE COMPARISON LOOP
C     AHEAD.THE VARIABLES ARE FOUND BY COUNTING THE NON-
C     BLANK CHARACTERS IN "XADDR" AND "DATCHK".ALSO DETECT
C     ENTRIES THAT ARE NOT "L","H",OR "X" AND CONVERT ALL
C     "X"'S (DONT CARES) TO "L"'S BEFORE PASSING TO "SIM"
C
   45 IF(XADDR(K).EQ.CBLANK) GO TO 46
      IF(XADDR(K).EQ.CX) XADDR(K)=CLO
      IF(XADDR(K).NE.CLO.AND.XADDR(K).NE.CHI) GO TO 47
      K=K+1
      IF (K .LE. 12) GO TO 45
   46 UWORD=K-1
      GO TO 48
   47 WRITE(PMS,52) XADDR(K),J
      RETURN
   48 K=1
   49 IF(DATCHK(K).EQ.CBLANK) GO TO 50
      IF(DATCHK(K).NE.CLO.AND.DATCHK(K).NE.CHI) GO TO 51
      K=K+1
      IF (K .LE. 12) GO TO 49
   50 UWIDE=K-1
      GO TO 53
   51 WRITE(PMS,52) DATCHK(K),J
   52 FORMAT(/,' ERROR SYMBOL ***',A1,'*** IN LINE ',I3,' OF FUNCTION
     1 TABLE')
      RETURN
   53 CALL SIM(IWIDE,XADDR,XDAT,CSYM,CBUF,LPH)
C
C     STORE THE CURRENT FUNCTION TABLE LINE IN "PBUF". IF
C     ANY PIN IS SIMULATED AND FOUND TO HAVE BEEN ASSIGNED
C     A WRONG LOGIC VALUE,THE CORRESPONDING ENTRY IN THE
C     THE FUNCTION TABLE SENT TO THE OUTPUT IS A QUESTION
C     MARK.THIS IS DONE USING ARRAY "POSN" FILLED EARLIER
C
      IF(POF.NE.CONOUT) WRITE(CONOUT,9001)
9001  FORMAT(1X,'.'$)
C     INITIALIZE CURRENT-LINE BUFFER TO ALL BLANKS
      DO 535 K=1,80
  535 PBUF(K)=CBLANK
C     STORE CURRENT LINE IN THE BUFFER
      DO 54 K=1,LLN(IL)
   54 PBUF(K)=CPG(LOF(IL)+K)
C     COMPARE ACTUAL AND EXPECTED DATA SETTING ERROR FLAGS
C     IF APPROPRIATE, DEMARCATING THE LOOP CORRESPONDING TO
C     THE NUMBER OF DATA ADDRESSES
      DO 66 I=UWORD+1,NUMF
      L=AMATCH(I)-12
      IF(DATCHK(L).EQ.XDAT(L)) GO TO 66
C     OVERALL ERROR FLAG
      LGOOF=.TRUE.
C     ERROR IN CURRENT LINE FLAG
      LERR=.TRUE.
C     ERROR IN CURRENT FUNCTION TABLE ENTRY FLAG
      LTEMP=.TRUE.
C     INCREMENT COUNT OF FUNCTION TABLE ERRORS
      IGOOF=IGOOF+1
      WRITE(POF,55) J,(CSYM(K,L+12),K=1,8),DATCHK(L),XDAT(L)
   55 FORMAT(/,' FUNCTION TABLE ERROR IN LINE',I3,' PIN =',8A1,
     1' EXPECTED ',A1,' ACTUAL ',A1)
      LTEMP=.FALSE.
      PBUF(POSN(I))=CQUEST
   66 CONTINUE
C     OUTPUT FUNCTION TABLE LINE WITH DIAGNOSTICS IF ANY
      K=81
   67 K=K-1
      IF(PBUF(K).EQ.CBLANK.AND.K.GT.1) GO TO 67
      WRITE(POF,68) (PBUF(L),L=1,K)
   68 FORMAT(1X,80A1)
      IL=IL+1
      IC=0
      LERR=.FALSE.
   70 CONTINUE
C     WRITE THE LINE OF DASHES AT THE END OF THE FUNCTION TABLE
      WRITE(POF,78) (CPG(LOF(IFTEND+1)+I),I=1,LLN(IFTEND+1))
   78 FORMAT(1X,80A1)
C     WRITE THE FUNCTION TABLE ERROR COUNT IF ANY
      IF (LGOOF) WRITE(POF,79) IGOOF
   79 FORMAT(/,' ERRORS IN FUNCTION TABLE = ',I4)
C     IF NO ERRORS OUTPUT SUCCESSFUL SIMULATION MESSAGE
      IF(.NOT.LGOOF) WRITE(POF,80)
   80 FORMAT(/,' PASS SIMULATION')
9000  FORMAT(/,1X,'SIMULATING ',/)
      RETURN
      END
C
C************************************
C
      SUBROUTINE TRUTH(IWORD,IWIDE,BADDR,LPHASE,CSYM,CBUF,COP)
C     THIS SUBROUTINE GENERATES THE PLE TRUTH TABLE
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER*1 CSYM(8,24),CBUF(8,24),BADDR(12),BDAT(12),
     1          ZADDR(4),ZDAT(4),ZCSUM(5),CLINE(76)
      INTEGER IWORD,IWIDE,IADDR,NADDR,IAD,CSUM,DECC,N,J,I,IL,ILE
      LOGICAL LPHASE(24)
      INTEGER ILEQ,IFUNCT,IDESC,IEND,INT
      COMMON /ILINE/ ILEQ,IFUNCT,IDESC,IEND
      DATA CBLANK/' '/,CDASH/'-'/,CA/'A'/,CB/'B'/,CD/'D'/,CO/'O'/,
     1     CT/'T'/
      NADDR=1
      DO 4 I=1,IWORD
4     NADDR=2*NADDR
C
      IF(POF.NE.CONOUT) WRITE(CONOUT,9000)
9000  FORMAT(/,1X,'GENERATING TRUTH TABLE ',/)
      ILE=ILEQ-1
      DO 5 I=1,75
    5     CLINE(I)=CBLANK
      DO 20 IL=3,ILE
          IF(IL.EQ.4) GO TO 20
          WRITE(POF,15) (CPG(LOF(IL)+I),I=1,LLN(IL))
   15     FORMAT(1X,80A1)
   20 CONTINUE
      N = 8 + 3*(IWORD+IWIDE)
      IF(COP.EQ.CA) N = 36
      CLINE(2)=CA
      CLINE(3)=CD
      CLINE(4)=CD
      J=6
      DO 25 I=1,IWORD
          J=J+2
          CLINE(J)=CA
          J=J+1
          INT=I-1
          CALL ADCON(INT,CHAR)
          CLINE(J)=CHAR
   25 CONTINUE
      J=J+1
      DO 30 I=1,IWIDE
          J=J+2
          CLINE(J)=CO
          J=J+1
          INT=I
          CALL ADCON(INT,CHAR)
          CLINE(J)=CHAR
   30 CONTINUE
      IF(COP.NE.CA) WRITE(POF,35) (CLINE(I),I=1,J)
   35 FORMAT(1X,80A1)
      IF(COP.EQ.CA) WRITE(POF,40) (CLINE(I),I=1,4)
   40 FORMAT(1X,4A1,6X,'HEX ADDRESS',6X,'HEX DATA')
      DO 45 I=1,75
   45     CLINE(I)=CBLANK
      WRITE(POF,50) (CDASH,I=1,N)
   50 FORMAT(1X,80A1)
      DO 85 IADDR=1,NADDR
          IAD=IADDR-1
          CALL SIM(IWIDE,BADDR,BDAT,CSYM,CBUF,LPHASE)
          CSUM=CSUM+DECC(IWIDE,BDAT,.FALSE.)
          IF(COP.EQ.CA) GO TO 70
          J=1
          DO 55 I=1,IWORD
              J=J+3
              CLINE(J)=BADDR(I)
   55     CONTINUE
          J=J+1
          DO 60 I=1,IWIDE
              J=J+3
              CLINE(J)=BDAT(I)
   60     CONTINUE
          WRITE(POF,65) IAD,(CLINE(I),I=1,J)
   65     FORMAT(1X,I4,76A1)
          GO TO 80
   70     CALL HEXBC(IWORD,BADDR,ZADDR)
          CALL HEXBC(IWIDE,BDAT,ZDAT)
          WRITE(POF,75) IAD,(ZADDR(4-I),I=1,3),(ZDAT(5-I),I=1,4)
   75     FORMAT(1X,I4,10X,3A1,12X,4A1)
   80     CALL BINC(BADDR)
   85 CONTINUE
      WRITE(POF,50) (CDASH,I=1,N)
      CALL HEXDC(CSUM,ZCSUM)
      IF(COP.NE.CB) WRITE(POF,90) ZCSUM
   90 FORMAT(/,' HEX CHECK SUM = ',5A1)
      IF(COP.EQ.CB) WRITE(POF,95) ZCSUM
   95 FORMAT(/,' PARTIAL HEX CHECK SUM = ',5A1)
      RETURN
      END
C
C************************************
C
      SUBROUTINE CAT
C     THIS SUBROUTINE PRINTS THE PLEASM CATALOG
      IMPLICIT INTEGER*1 (A-Z)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      DATA BEL/007/
C
    8 WRITE(CONOUT,1) BEL
    1 FORMAT(/,' MONOLITHIC MEMORIES PLEASM (tm) VERSION 1.2D',
     1       /' (C) COPYRIGHT 1984 MONOLITHIC MEMORIES',A1)
      WRITE(PMS,10)
   10 FORMAT(/,' PLEASM --PLE ASSEMBLER-- PROVIDES THE FOLLOWING',
     1       ' OPTIONS :')
      WRITE(PMS,21)
   21 FORMAT(/,'  C  CATALOG      - PRINTS THE PLEASM CATALOG OF',
     1       ' OPERATIONS')
      WRITE(PMS,11)
   11 FORMAT('  E  ECHO INPUT   - PRINTS THE PLE DESIGN',
     1       ' SPECIFICATIONS')
      WRITE(PMS,13)
   13 FORMAT('  T  TRUTH TABLE  - PRINTS THE ENTIRE TRUTH TABLE')
      WRITE(PMS,14)
   14 FORMAT('  B  BRIEF TABLE  - PRINTS ONLY USED ADDRESSES IN',
     1       ' THE TRUTH TABLE')
      WRITE(PMS,15)
   15 FORMAT('  A  HEX TABLE    - PRINTS THE TRUTH TABLE IN HEX FORM')
      WRITE(PMS,12)
   12 FORMAT(/,'  S  SIMULATE     - EXERCISES THE FUNCTION TABLE IN',
     1       ' THE LOGIC EQUATIONS')
      WRITE(PMS,16)
   16 FORMAT(/,'  I  INTEL HEX    - GENERATES INTEL HEX PROGRAMMING',
     1       ' FORMAT')
      WRITE(PMS,17)
   17 FORMAT('  H  ASCII HEX    - GENERATES ASCII HEX PROGRAMMING',
     1       ' FORMAT')
      WRITE(PMS,22)
   22 FORMAT(/,'  Q  QUIT         - EXITS PLEASM')
      RETURN
      END
C
C************************************
C
      SUBROUTINE HEX(NWD,NWIDE,BADDR,LPHASE,CSYM,CBUF,COP)
C
C     THIS SUBROUTINE GENERATES HEX PROGRAMMING FORMATS AND CHECK SUM.
C     BASED ON THE CHOICE OF OPERATION CODE, THIS SUBROUTINE GENERATES
C     EITHER THE ASCII HEX PROGRAMMING FORMAT, OR THE INTEL HEX
C     PROGRAMMING FORMAT WITH APPROPRIATE CHECKSUMS
C     AUTHOR:RANJIT PADMANABHAN
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CSYM(8,24),CBUF(8,24),BADDR(12),BDAT(12),ZTEMP(5),
     1          ZHEX(2,32),ZCSUM(5),ZCHSUM(5),ZADDR(5)
      INTEGER ADDR,IADDR,NHEX,NADDR,CSUM,DECC,CHSUM,TEMP,I,J
      INTEGER K,NWD,NWIDE
      LOGICAL LPHASE(24)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      DATA CH/'H'/,CI/'I'/,CLO/'L'/
      DATA SOH/001/,STX/002/,ETX/003/
C     2**NWD LINES FOR NWD INPUTS IN THE TRUTH TABLE
      IF(PDF.NE.CONOUT) WRITE(CONOUT,9000)
      NADDR=1
      DO 9 K=1,NWD
9     NADDR=2*NADDR
C
C     INITIALIZE THE OVERALL CHECKSUM
      CSUM=0
C     "NHEX" IS GOING TO BE USED SINCE ALL OPERATIONS REGARDLESS OF THE
C     DATA WIDTH ARE 8-BIT OPERATIONS.
      NHEX=8
C*** NOTE: SOME PROM PROGRAMMERS NEED A START CHARACTER.
C*** MODIFY OR DELETE THESE START CHARACTERS AS REQUIRED.
C     OUTPUT START CHARACTERS FOR THE FORMATS THAT NEED THEM. HERE INTEL
C     HEX DOES NOT. IN MOST CASES WHERE THESE ARE NOT REQUIRED THEY ARE
C     IGNORED.
      IF(COP.EQ.CH) WRITE(PDF,15) STX,SOH
   15 FORMAT(1X,2A1)
C     STORE THE TRUTH TABLE INFORMATION (DATA) IN 16 WORD BLOCKS WHERE
C     EACH WORD IS 8 BITS WIDE.
      DO 45 IADDR=1,NADDR,16
C     STORE THE ADDRESS FOR THE INTEL HEX FORMAT
      ADDR=IADDR-1
C
C     INITIALIZE LINE CHECKSUM FOR INTEL HEX. 
C
        CHSUM=0
C
C     FOR EACH 16 WORD STREAM OF DATA SEND "SIM" THE ADDRESSES INCREMENTED
C     EACH TIME AND STORE THE RETURNED RESULT IN HEX IN THE ARRAY "ZHEX".
C     FOR THE INTEL HEX CHECKSUMS ADD THE RECORD LENGTH AND ADDRESSES AT
C     EACH STEP.MAINTAIN THE CUMULATIVE CHECKSUM, "CSUM".
C
          DO 20 J=1,16
              CALL SIM(NWIDE,BADDR,BDAT,CSYM,CBUF,LPHASE)
C     BLANK OUT THE UNWANTED PART OF "BDAT"
          DO 21 K=NWIDE+1,12
   21       BDAT(K)=CLO
              IF(POF.NE.CONOUT) WRITE(CONOUT,9001)
              CALL HEXBC(NHEX,BDAT,ZTEMP)
              ZHEX(1,J)=ZTEMP(2)
              ZHEX(2,J)=ZTEMP(1)
              TEMP=DECC(NWIDE,BDAT,.FALSE.)
              CHSUM=CHSUM+TEMP
              CSUM=CSUM+TEMP
              CALL BINC(BADDR)
   20     CONTINUE
C      GET THE ADDRESSES AND CHECKSUMS AND CONVERT THEM TO THE 2'S COMPLEMENT
C      MODULO 256 FOR THE PROPER INTEL HEX CHECKSUM FORMAT. THEN CALL THE
C      SUBROUTINE "HEXDC" TO CONVERT THE DECIMAL CALCULATED VALUES TO HEX
          CHSUM=CHSUM+ADDR/256+MOD(ADDR,256)+16
          CHSUM=MOD(CHSUM,256)
          CHSUM=MOD(256-CHSUM,256)
          CALL HEXDC(ADDR,ZADDR)
          CALL HEXDC(CHSUM,ZCHSUM)
C     OUTPUT THE RESULTS WITH THE PROPER FORMAT.
          IF(COP.EQ.CH) WRITE(PDF,30) ((ZHEX(I,J),I=1,2),J=1,16)
   30     FORMAT(1X,16(2A1,' '),'.')
          IF(COP.EQ.CI) WRITE(PDF,42) (ZADDR(J),J=2,5),
     1    ((ZHEX(I,J),I=1,2),J=1,16),(ZCHSUM(J),J=4,5)
   42     FORMAT(' :10',4A1,'00',32A1,2A1)
   45 CONTINUE
C     OUTPUT ETX AND CHECKSUMS FOR ASCII HEX
      IF(COP.EQ.CI) GO TO 52
      WRITE(PDF,50) ETX
   50 FORMAT(1X,A1)
      CALL HEXDC(CSUM,ZCSUM)
      WRITE(PDF,51) ZCSUM
   51 FORMAT(1X,5A1)
C     OUTPUT THE END-OF-TEXT STRING FOR THE INTEL HEX FORMAT
   52 IF(COP.EQ.CI) WRITE(PDF,53)
   53 FORMAT(' :00000001FF') 
9000  FORMAT(/,1X,'GENERATING PROGRAMMING FORMAT',/)
9001  FORMAT(1X,'.'$)
      RETURN
      END
C
C***********END PROGRAM*********
