

C$$ PAL40.FOR
C**PALASM40**PALASM40**PALASM40**PALASM40**PALASM40**PALASM40**PALASM40*
C
C PALASM 40  -  TRANSLATES SYMBOLIC EQUATIONS INTO PAL OBJECT CODE
C   FORMATTED FOR DIRECT INPUT TO STANDARD PROM AND PAL PROGRAMMERS.
C
C
C REV LEVEL: VERSION 1.8C 7/6/84 (C) COPYRIGHT 1983 MONOLITHIC MEMORIES
C
C  V1.8A - 2/23/84 - INITIAL RELEASE - INCORRECT PINOUT
C  V1.8B - 5/11/84 - CORRECT PINOUT, ANNOTATE FUSE PLOT, ADD FLUSH TO JEDEC
C  V1.8C - 7/6/84 - COMPRESS INPUT, ALLOW TABS,FFEED.
C
C INPUT:  PAL DESIGN SPECIFICATION ASSIGNED TO RPD.
C         OPERATION CODES ARE ASSIGNED TO ROP.
C
C OUTPUT: ECHO, SIMULATION, AND FUSE PATTERN ARE ASSIGNED TO POF.
C         JEDEC, HEX, AND BINARY PROGRAMMING FORMATS ARE ASSIGNED TO PDF
C         PROMPTS & ERROR MESSAGES ARE ASSIGNED TO PMS.
C
C PART NUMBER: THE PAL PART NUMBER MUST APPEAR IN COLUMN ONE OF LINE ONE.
C
C PIN LIST:  40 SYMBOLIC PIN NAMES MUST APPEAR STARTING ON LINE FIVE.
C
C EQUATIONS: STARTING FIRST LINE AFTER THE PIN LIST IN THE FOLLOWING FORMS:
C
C          A = B*C + D
C          A := B*C + D
C          IF( A*B )  C = D + E
C
C ALL CHARACTERS FOLLOWING ';' ARE IGNORED UNTIL THE NEXT LINE.
C          BLANKS ARE IGNORED.
C
C OPERATORS:   ( IN HIERARCHY OF EVALUATION )
C
C             ;    COMMENT FOLLOWS
C             /    COMPLEMENT
C             *    AND (PRODUCT)
C             +    OR (SUM)
C             :+:   XOR (EXCLUSIVE OR)
C             ( )   CONDITIONAL THREE-STATE
C             =    EQUALITY
C             :=    REPLACED BY (AFTER CLOCK)
C
C FUNCTION     L, H, X, Z, AND C ARE VALID
C TABLE:     FUNCTION TABLE VECTOR ENTRIES.
C
C REFERENCE:   A COMPLETE USERS GUIDE TO DESIGNING WITH PALS USING PALASM
C              IS PROVIDED IN THE MONOLITHIC MEMORIES PAL HANDBOOK.
C
C SUBROUTINES: INITLZ,GETSYM,INCR,MATCH,IXLATE,ECHO,CAT,PINOUT,FZPLT
C  PLOTF,SUMCHK,ICONV,HEX,SUMCHK,TWEEK,BINR,SLIP, FANTOM,TEST,INTEL
C
C AUTHORS:   JOHN BIRKNER AND VINCENT COLI
C            FAULT TESTING BY IMTIYAZ BENGALI
C            REVISED JEDEC FORMAT BY NICK SCHMITZ
C            MONOLITHIC MEMORIES INC.
C            2175 MISSION COLLEGE
C            SANTA CLARA, CALIFORNIA 95050
C            (408) 970-9700
C
C FINE PRINT: MONOLITHIC MEMORIES TAKES NO RESPONSIBILITY FOR THE OPERATION
C             OR MAINTENANCE OF THIS PROGRAM. THE SOURCE CODE AS PRINTED HERE
C             PRODUCED THE OBJECT CODE OF THE EXAMPLES IN THE APPLICATIONS
C             SECTION ON A VAX/VMS 11/780 COMPUTER WITH FORTRAN 77 AND A
C             NATIONAL CSS IBM SYSTEM/370 WITH FORTRAN IV (LEVEL G).
C
C*********************************************************
C
C     MAIN PROGRAM
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      INTEGER*1 FILE1(20),FILE2(20)
      INTEGER IC,IL,IC1,J,K,I,I88PRO,I8PRO,OUTPIN,IONE
      INTEGER IPROD,COUNT,IBLOW,ILL,ILERR,IIL,IINPUT,ILE,ORCNT,IMATCH
C
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
     1  ,ISYM(8,40),IBUF(8,40),IPCNT(80),DDD(64),PPP(40)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
C
      INTEGER*1 TSTVEC(350,40),ANDAR(128,32)
      INTEGER*2 PARRY(350)
      LOGICAL LSA01(350,2)
      COMMON /TEST/ TSTVEC,LSA01,PARRY,ANDAR
      INTEGER*1 ISAVE(128,64)
      COMMON /FPLOT/ ISAVE
C
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LFIRST,
     1        LMATCH,LPHASE(40),LBUF(40),LPROD(128),FLFUSE(2,2),FLFLAG,
     3        LSAME,LACT,LOPERR,LINP,LERR,ODFLG,EVFLG,LFEED(40),DOIT
C
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR
      LOGICAL LFUSES(64,128),LORARY(2,128),LPOLAR(40),LBYPAS(40)
      COMMON /LFUSE/LFUSES,LORARY,LPOLAR,LBYPAS
      INTEGER IDESC,IFUNCT,IEND,SINGLE
      COMMON /FTEST/IFUNCT,IDESC,IEND
C
      DATA E/'E'/,O/'O'/,T/'T'/,P/'P'/,B/'B'/,D/'D'/,H/'H'/,S/'S'/,
     1     L/'L'/,N/'N'/,C/'C'/,Q/'Q'/,U/'U'/,F/'F'/,Y/'Y'/,JJ/'J'/
      DATA BB/'B'/,CC/'C'/,DD/'D'/,EE/'E'/,FF/'F'/,II/'I'/,NN/'N'/,
     1     OO/'O'/,PP/'P'/,RR/'R'/,SS/'S'/,TT/'T'/,UU/'U'/,JJ/'J'/
      DATA BEL/007/,IBLANK/' '/,IONE/1/,CHN/'N'/,CHY/'Y'/
      DATA TAB/9/,FFEED/12/
C
      CALL IOINIT
C
    8 WRITE(CONOUT,1)
    1 FORMAT(/,' MONOLITHIC MEMORIES 40 PIN PALASM (tm) VERSION 1.8C',
     1       /' (C) COPYRIGHT 1984 MONOLITHIC MEMORIES')
C
C     ASSIGNMENT OF DATA SET REFERENCES
C     RPD - PAL DESIGN SPECIFICATION (INPUT FROM DATA FILE)
C     ROC - OPERATION CODE (INPUT FROM TERMINAL)
C     POF - ECHO, SIMULATION AND TRUTH TABLES (OUTPUT)
C     PDF - HEX AND BINARY PROGRAMMING FORMATS (OUTPUT)
C     PMS - PROMPTS AND ERROR MESSAGES (OUTPUT TO TERMINAL)
C
      ROC=CONINP
      PMS=CONOUT
    4 WRITE(CONOUT,2)
    2 FORMAT(/,' WHAT IS THE SOURCE FILENAME (d:filename.ext) ?: '$)
      READ(CONINP,3) (FILE1(I),I=1,20)
    3 FORMAT(20A1)
      IF(KREAD(FILINP,2,0,FILE1) .NE. 0) GO TO 130
      WRITE(CONOUT,333)
  333 FORMAT(/,' OUTPUT FILENAME -',
     1         ' PRESS <ENTER> FOR NO OUTPUT FILE ?: '$)
      READ(CONINP,3) (FILE2(I),I=1,20)
      LUN=CONOUT
      IF(FILE2(1).EQ.IBLANK) GO TO 9
      IF(KWRIT(FILOUT,2,0,FILE2) .NE. 0) GO TO 130
      LUN=FILOUT
    9 RPD=FILINP
      POF=LUN
      PDF=LUN
      IFUNCT=0
      IDESC=0
C
C
C     INITIALIZE FUSE PLOT INFORMATION
      DO 8335 I=1,128
      LPROD(I)=.FALSE.
      DO 8335 J=1,64
 8335 ISAVE(I,J)=IBLANK
C
C     INITIALISE FLFUSE TO BE INTACT AND ALL OUTPUTS ARE ASSUMED
C     TO BE REGISTERED AND NOT USED IN FEEDBACK
      FLFUSE(1,1)=.FALSE.
      FLFUSE(1,2)=.FALSE.
      FLFUSE(2,1)=.FALSE.
      FLFUSE(2,2)=.FALSE.
      DO 6 I=1,40
      LFEED(I)=.FALSE.
    6 LBYPAS(I)=.FALSE.
C     INITIALIZE LSAME AND LACT TO FALSE (ACTIVE HIGH/LOW ERROR)
      LSAME=.FALSE.
      LACT=.FALSE.
C     INITIALIZE LOPERR TO FALSE (OUTPUT PIN ERROR)
      LOPERR=.FALSE.
C     INITIALISE LPRD TO FALSE (PRODUCT LINE ERROR)
      LPRD=.FALSE.
C
C     READ IN FIRST 4 LINES OF PAL DESIGN SPECIFICATION
C
      READ(RPD,7) IPAL,INAME,(REST(J),J=1,72),
     1 (PATN(J),J=1,79),(TITLE(J),J=1,79),(COMP(J),J=1,79)
   7  FORMAT(3A1,5A1,72A1,/,79A1,/,79A1,/,79A1)
C
      DO 1115 J=1,72
C     SECURITY FUSE 
1115      IF ((REST(J).EQ.SS).AND.(REST(J+1).EQ.EE)
     1 .AND.(REST(J+2).EQ.CC))     DOIT =.TRUE. 
C
      LNPTR=0
      LNMAX=0
10    READ(RPD,5,ENDFILE=15) (CLN(IC),IC=1,80)
5     FORMAT(80A1)
      WRITE (CONOUT,9001)
9001  FORMAT (1X,'.'$)
      LNMAX=LNMAX+1
C
      CLN(80)=IBLANK
      J=81
11    J=J-1
      IF (CLN(J) .EQ. TAB) CLN(J)=IBLANK
      IF (CLN(J) .EQ. FFEED) CLN(J)=IBLANK
      IF (J.GT. 1 .AND. CLN(J).EQ.IBLANK) GOTO 11
C
      LOF(LNMAX)=LNPTR
      LLN(LNMAX)=J
      J=0
      SINGLE=0
12    J=J+1
      IF (CLN(J) .EQ. TAB) CLN(J)=IBLANK
      IF (CLN(J) .EQ. FFEED) CLN(J)=IBLANK
      IF (CLN(J) .NE. IBLANK) SINGLE=0
      IF (CLN(J) .EQ. IBLANK) SINGLE=SINGLE+1
      IF (SINGLE .GE. 2) GOTO 12
      LNPTR=LNPTR+1
      CPG(LNPTR)=CLN(J)
C      IF (J.LT. LLN(LNMAX)) GOTO 12
      IF (J.LT. LLN(LNMAX) .AND. CLN(J) .NE. ';') GOTO 12
C
      LNPTR=LNPTR+1
      CPG(LNPTR)=IBLANK
      LLN(LNMAX)=LNPTR-LOF(LNMAX)
C
      IF (LNPTR .GT. 9000) WRITE (PMS,13)
13    FORMAT (1X,'TOO MANY CHARACTERS IN INPUT FILE')
C
C     CHECK FOR 'FUNCTION TABLE' AND SAVE ITS LINE NUMBER
C
      IF(.NOT.(CLN(1).EQ.FF.OR.CLN(1).EQ.DD)) GO TO 10
      IF(   IFUNCT.EQ.0 .AND.CLN(1).EQ.FF.AND.
     1    CLN(2).EQ.UU.AND.CLN(3).EQ.NN.AND.
     2    CLN(4).EQ.CC.AND.CLN(5).EQ.TT.AND.
     3    CLN(6).EQ.II.AND.CLN(7).EQ.OO.AND.
     4    CLN(8).EQ.NN.AND.CLN(10).EQ.TT.AND.
     5    CLN(12).EQ.BB.AND.CLN(14).EQ.EE ) IFUNCT=LNMAX
C
C     CHECK FOR 'DESCRIPTION' AND SAVE ITS LINE NUMBER
C
      IF(    IDESC.EQ.0 .AND.CLN(1).EQ.DD.AND.
     1    CLN(2).EQ.EE.AND.CLN(3).EQ.SS.AND.
     2    CLN(4).EQ.CC.AND.CLN(5).EQ.RR.AND.
     3    CLN(6).EQ.II.AND.CLN(7).EQ.PP.AND.
     4    CLN(8).EQ.TT.AND.CLN(9).EQ.II.AND.
     5    CLN(10).EQ.OO.AND.CLN(11).EQ.NN ) IDESC=LNMAX
C
      GOTO 10
C
C     SAVE THE LAST LINE NUMBER OF THE PAL DESIGN SPECIFICATION
C
   15 IEND=LNMAX
      WRITE(PMS,16) LNMAX,LNPTR
16    FORMAT (1X,'PAL DESIGN FILE READ - ',I5,' LINES',I6,' CHARACTERS'
     2 ' (MAXIMUM: 9000)',/)
C
      CALL INITLZ(INAME,ITYPE,IPCNT,IC,IL,IBLOW)
C     PRINT ERROR MESSAGE FOR INVALID PAL PART TYPE
      IF(ITYPE.NE.0) GO TO 17
      WRITE(PMS,18) IPAL,INAME
   18 FORMAT(/,' PAL PART TYPE ',3A1,5A1,' IS INCORRECT')
      STOP
C     GET 40 PIN NAMES
   17 DO 20 J=1,40
   20     CALL GETSYM(LPHASE,ISYM,J,IC,IL,FLFLAG)
          IF(.NOT.(LEQUAL.OR.LLEFT.OR.LAND.OR.LOR.OR.LRIGHT)) GO TO 24
              WRITE(PMS,23)
   23         FORMAT(/, ' LESS THAN 40 PIN NAMES IN PIN LIST')
              STOP
   24 ILE=IL
C     BYPASS FUSE PLOT ASSEMBLY IF HAL ('H' IN LINE 1, COLUMN 1)
      IF( IPAL(1).EQ.H ) GO TO 108
   25 CALL GETSYM(LBUF,IBUF,IONE,IC,IL,FLFLAG)
   28     IF(.NOT.LEQUAL) GO TO 25
      WRITE (CONOUT,9001)
          EVFLG=.FALSE.
          ODFLG=.FALSE.
          COUNT=0
          ORCNT=0
          ILL=IL
          CALL MATCH(IMATCH,IBUF,ISYM)
          IF( IMATCH.EQ.0 ) GO TO 100
C         CHECK WHETHER THEE OUTPUT IS BYPASED OR NOT. ALSO
C         AN ERROR IS REPORTED IF THRE IS A CONFLICT IN A 
C         SET OF OUTPUT
          CALL BYPAS(FLFUSE,FLFLAG,LFEED,ISYM,IMATCH)
C         CHECK FOR VALID POLARITY (ACTIVE LOW)
          LSAME = ( (     LPHASE(IMATCH)).AND.(     LBUF(1)).OR.
     1              (.NOT.LPHASE(IMATCH)).AND.(.NOT.LBUF(1)) )
          IF(LSAME) LPOLAR(IMATCH)=.TRUE.
          IF(.NOT.LSAME) LPOLAR(IMATCH)=.FALSE.
C         CHECK FOR VALID OUTPUT PIN
          IF((ITYPE.EQ.1).AND.((IMATCH.GE.5.AND.IMATCH.LE.16)
     1    .OR.(IMATCH.GE.25.AND.IMATCH.LE.36))) LOPERR=.TRUE.
C         IF THE OUTPIN IS ODD E.G. PIN17, PIN19 ETC. THEN THE 
C         PRODUCT TERMS ARE COUNTED FROM TOP TO BOTTOM
          OUTPIN=IMATCH
          IF(IMATCH.LE.24.AND.(MOD(IMATCH,2).NE.0))
     1       I88PRO=8*IMATCH-136
          IF (MOD(IMATCH,2).NE.0) ODFLG=.TRUE.
          IF (MOD(IMATCH,2).EQ.0) EVFLG=.TRUE. 
C         IF THE OUPUT PIN IS EVEN E.G. PIN18, PIN20 ETC.
C         THEN THE PRODUCT TERMS ARE COUNTED FROM BOTTOM TO TOP
          IF (IMATCH.LE.24.AND.(MOD(IMATCH,2).EQ.0))
     1        I88PRO=8*IMATCH-127
C         CALCULATING THE OFFSET I88PRO FOR OUTPINS 37..40 & 1..4
          IF(IMATCH.EQ.37.OR.IMATCH.EQ.39)
     1        I88PRO=8*IMATCH-232
          IF(IMATCH.EQ.38.OR.IMATCH.EQ.40)
     1        I88PRO=8*IMATCH-223
          IF(IMATCH.EQ.1.OR.IMATCH.EQ.3)
     1      I88PRO=8*IMATCH+88
          IF(IMATCH.EQ.2.OR.IMATCH.EQ.4)
     1        I88PRO=8*IMATCH+97
          IC=0
   30       CALL INCR(IC,IL,FLFLAG)
            IF( .NOT.(LEQUAL.OR.LLEFT) ) GO TO 30
C
          DO 70 I8PRO=1,16
              COUNT=COUNT+1
          IF (ODFLG)IPROD=I88PRO + I8PRO
          IF (EVFLG)IPROD=I88PRO-I8PRO
C
C         THE TOTAL NUMBER OF PRODUCT TERMS ASSOCIATED WITH A PARTICULAR 
C         OUTPUT. THIS IS TO CHECK FOR MAXIMUM OF 16 PRDCT TERMS FOR A PAIR 
C         OF OUTPUTS. ORCNT IS THE NUMBER OF PRODUCT TERMS FOR A PAIR OF
C         OUTPUTS.
C
              IPCNT(OUTPIN)=IPCNT(OUTPIN)+1
              IF(MOD(OUTPIN,2).NE.0)ORCNT=IPCNT(OUTPIN)+IPCNT(OUTPIN+1)
              IF(MOD(OUTPIN,2).EQ.0)ORCNT=IPCNT(OUTPIN)+IPCNT(OUTPIN-1) 
              LPROD(IPROD)=.TRUE.
              LFIRST=.TRUE.
   50           ILL=IL
                CALL GETSYM(LBUF,IBUF,IONE,IC,IL,FLFLAG)
C         CHECK FOR EXACT NUMBER OF PRODUCT TERMS PER PAIR OF OUTPUTS.
C         IF THE TOTAL NUMBER OF PRODUCT TERMS EXCEED 16 THEN LPRD
C         IS TRUE AND FLAG ERROR MESSAGE. 
               IF (ORCNT.GT.16) LPRD=.TRUE.
               IF (.NOT.LPRD) GO TO 69
          WRITE(PMS,118) BEL
  118     FORMAT(1X,A1)
          WRITE(PMS,119) IMATCH          
  119     FORMAT(' TOO MANY PRODUCT TERMS SPECIFIED FOR'
     1           ' THIS OUTPUT PAIR ' I2 )   
          WRITE(PMS,117) ORCNT
  117     FORMAT(/,' THE PRODUCT TERMS ARE  ' I2 )
          STOP      
   69           CALL MATCH(IMATCH,IBUF,ISYM)
C         IF THE PARICULAR SIGNAL IS AN OUTPUT AND USED IN
C         FEEDBACK THEN SET THE CORRESPONDING FLAG IN LFEED TRUE
          IF((IMATCH.GE.1.AND.IMATCH.LE.4).OR.(IMATCH.GE.17.AND.
     1    IMATCH.LE.24).OR.(IMATCH.GE.37.AND.IMATCH.LE.40))
     2    LFEED(IMATCH)=.TRUE.
C               CHECK FOR INVALID INPUT PIN
          IF((ITYPE.EQ.1).AND.((IMATCH.GE.1.AND.IMATCH.LE.5).OR.
     1    (IMATCH.EQ.10).OR.(IMATCH.GE.15.AND.IMATCH.LE.25).OR.
     2    (IMATCH.EQ.30).OR.(IMATCH.GE.35.AND.IMATCH.LE.40))
     3    .AND.(.NOT.LFEED(IMATCH))) LINP=.TRUE.
                ILL=IL
                IF(LINP) GO TO 100
                IF(IMATCH.EQ.0) GO TO 100
                IF(IMATCH.EQ.30) GO TO 64
                IF(.NOT.LFIRST) GO TO 58
C
C     WHEN THE PRODUCT TERM IS FIRST TIME TO BE USED, THE 
C     CORESPONDING FUSES IN THE ORARRAY ARE  BLOWN 
C     DEPENDING ON ODD OR EVEN OUTPUT PIN. THE ODD PIN
C     IS CONNECTED TO THE FIRST COLUMN OF OR ARRAY. IF
C     THE FUSE IN THE FIRST COLUMN IS NOT BLOWN AND THE PRODUCT TERM
C     IS USED THEN THE FUSE IN THE SECOND COLUMN IS BLOWN. IF THE 
C     PRODUCT TERM IS NOT USED BOTH FUSES ARE LEFT INTACT.   
C
      IF((ODFLG).AND.(LFIRST).AND.LPROD(IPROD))
     1     LORARY(1,IPROD)=.FALSE.
      IF((ODFLG).AND.(LFIRST).AND.(LPROD(IPROD)))
     1              LORARY(2,IPROD)=.TRUE.
      IF((EVFLG).AND.(LFIRST).AND.LPROD(IPROD))
     1              LORARY(2,IPROD)=.FALSE.
      IF((EVFLG).AND.(LFIRST).AND.(LPROD(IPROD)))
     1              LORARY(1,IPROD)=.TRUE.
                IBLOW = IBLOW+1    
                    LFIRST=.FALSE.
                    DO 56 I=1,64
                        IBLOW = IBLOW + 1
   56                   LFUSES(I,IPROD)=.TRUE.
   58           CALL IXLATE(IINPUT,LPHASE,IMATCH,LBUF,ISYM,ITYPE)
                IF(IINPUT.LE.0) GO TO 60
                IBLOW = IBLOW - 1
                LFUSES(IINPUT,IPROD)=.FALSE.
                CALL FZPLT(LBUF,IBUF,IPROD,ITYPE,LPROD,IOP,IBLOW)
   60           IF(LAND) GO TO 50
   64           IF(.NOT.LRIGHT) GO TO 68
   66           CALL INCR(IC,IL,FLFLAG)
                IF(.NOT.LEQUAL) GO TO 66
   68         IF( .NOT.(LOR.OR.LEQUAL) ) GO TO 74
   70         CONTINUE
   74     ILL=IL
          CALL GETSYM(LBUF,IBUF,IONE,IC,IL,FLFLAG)
C
           IF(LLEFT.OR.LEQUAL) GO TO 28
  100 IF( ILL.EQ.IFUNCT.OR.ILL.EQ.IDESC.OR.ILL.EQ.IEND ) GO TO 108
C     PRINT AN ERROR MESSAGE FOR AN UNRECOGNIZABLE SYMBOL
      ILERR=ILL+4
      WRITE(PMS,99) BEL
   99 FORMAT(1X,A1)
      WRITE(PMS,101) (IBUF(I,1),I=1,8),ILERR,
     1 (CPG(I),I=LOF(ILL),(LOF(IIL)+LLN(ILL)))
  101 FORMAT(/,' ERROR SYMBOL =  ',8A1,'      IN LINE NUMBER ',I3,
     1       /,1X,79A1)
C     PRINT AN ERROR MESSAGE FOR ACTIVE HIGH/LOW ERRORS
      IF( (LACT).AND.(.NOT.LOPERR) ) WRITE(PMS,103) IPAL,INAME
  103 FORMAT(' OUTPUT MUST BE INVERTED SINCE ',3A1,5A1,
     1       ' IS AN ACTIVE LOW DEVICE')
C     PRINT AN ERROR MESSAGE FOR AN INVALID OUTPUT PIN
      IF( (LOPERR).AND.IMATCH.NE.0 ) WRITE(PMS,105) IMATCH,IPAL,INAME
  105 FORMAT(' THIS PIN, NUMBER ',I2,' IS AN INVALID OUTPUT PIN',
     1       ' FOR ',3A1,5A1)
C     PRINT AN ERROR MESSAGE FOR AN INVALID INPUT PIN
      IF(LINP) WRITE(PMS,115) IMATCH,IPAL,INAME
  115 FORMAT(' THIS PIN NUMBER ',I2,' IS AN INVALID INPUT PIN',
     1       ' FOR ',3A1,5A1)
      STOP
108   WRITE(PMS,107)
  107 FORMAT(/,' E=ECHO INPUT    O=PINOUT     P=PLOT ',
     1       /,' D=DOCUMENT      S=SIMULATE   T=TEST GENERATE',
     2       /,' J=JEDEC FORMAT  C=CATALOG    Q=QUIT')
      WRITE(PMS,110)
  110 FORMAT(/,' ENTER OPERATION CODE: ',$)
      READ(ROC,120) IOP
  120 FORMAT(A1)
C
      IF (IOP .GT. Y) IOP=IOP-32
      IF(POF.NE.CONOUT) WRITE(POF,125)
  125 FORMAT('1')
      IF(IOP.EQ.E) CALL ECHO
      IF(IOP.EQ.O) CALL PINOUT
      IF(IOP.EQ.P) CALL XPLOT(FLFUSE,IBLOW)
      IF(IOP.EQ.C) CALL CAT
C
      IF(IOP.EQ.JJ) CALL JEDEC(DOIT,FLFUSE)
C      IF(IOP.EQ.T) CALL TSTGEN
C      IF(IOP.EQ.S) CALL TEST(LPHASE,ISYM,IC,IL,ILE,FLFUSE)
      IF(IOP.NE.Q) GOTO 108
C
  315 I=KCLOS(FILINP)
      IF(LUN.NE.CONOUT) I=KCLOS(FILOUT)
  320 WRITE(PMS,325)
  325 FORMAT(1X,'RESTART PALASM (Y/N) ?: '$)
      READ(CONINP,3) (FILE1(I),I=1,20)
      IF(FILE1(1).EQ.CHY) GO TO 8
      IF(FILE1(1).EQ.IBLANK) STOP
      IF(FILE1(1).NE.CHN) GO TO 320
      STOP
  130 WRITE(PMS,335)
  335 FORMAT(/,' DISK I/O ERROR - MAYBE WRONG FILENAME ???')
      GO TO 315
      END
C
C$$ X4.FOR
C*************************   
      SUBROUTINE TSTGEN
C     THIS SUBROUTINE GENERATES TEST VECTORS AUTOMATICALLY
C     FOR THE FUSEPLOT PERSONALISED FOR A PARTICULAR APPLICATION
      IMPLICIT INTEGER*1 (A-Z)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      LOGICAL LTST(350)
C
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
      LOGICAL LFUSES(64,128),LORARY(2,128),LPOLAR(40),LBYPAS(40)
      COMMON /LFUSE/LFUSES,LORARY,LPOLAR,LBYPAS
      INTEGER*1 TSTVEC(350,40),ANDAR(128,32)
      INTEGER*2 PARRY(350)
      LOGICAL LSA01(350,2)
      COMMON /TEST/ TSTVEC,LSA01,PARRY,ANDAR
C
      INTEGER PT1,PT11,PT12,I,J,K,OUT,OUTTEM,TSTCNT
      DATA    L/'L'/,H/'H'/,DASH/'-'/,CROSS/'X'/,ZERO/'0'/,
     1        ONE/'1'/,DONT/'D'/
C     INITIALISE THE LAND TO LOGICAL DONT CARE 
      DO 5 I=1,128
      DO 5 J=1,32
      ANDAR(I,J)=DONT
    5 CONTINUE
      TSTCNT=0
C    MAPPING LFUSES INTO LAND WHICH REPRESENTS THE LOGICAL
C    1 OR 0 FOR A PRESENCE OR ABSENCE OF A FUSE UNDER AN INPUT PIN.
C    FOR E.G. A 'X' UNDER /PIN 1 IN LFUSES IS LOGICAL 0 IN LAND.
C    SIMILAIRLY A 'X' UNDER PIN 1 IN LFUSES IS LOGICAL 1 IN LAND.
      DO 10 J=1,128
      K=1
      DO 10 I=1,64,2
      IF((I.EQ.1).OR.(I.EQ.3).OR.(I.EQ.5).OR.(I.EQ.7).OR.(I.EQ.9)
     1 .OR.(I.EQ.11).OR.(I.EQ.13).OR.(I.EQ.15).OR.(I.EQ.49)
     2 .OR.(I.EQ.51).OR.(I.EQ.53).OR.(I.EQ.55).OR.(I.EQ.57)
     3 .OR.(I.EQ.59).OR.(I.EQ.61).OR.(I.EQ.63)) GO TO 11
      IF((I.EQ.17).OR.(I.EQ.19).OR.(I.EQ.21).OR.(I.EQ.23)
     1 .OR.(I.EQ.25).OR.(I.EQ.27).OR.(I.EQ.29).OR.(I.EQ.31)
     2 .OR.(I.EQ.33).OR.(I.EQ.35).OR.(I.EQ.37).OR.(I.EQ.39)
     3 .OR.(I.EQ.41).OR.(I.EQ.43).OR.(I.EQ.45).OR.(I.EQ.47))
     4    GO TO 12
   10 CONTINUE 
      WRITE(POF,1)(TITLE(I),I=1,79)
    1 FORMAT(/,1X,79A1,/)
      WRITE(POF,2)
    2 FORMAT(/,'  TEST VECTORS')
      WRITE(POF,3)
    3 FORMAT(/,' PIN',' PDCT','  ','         11111111112222222222',
     1         '33333333334',/,
     2         '           12345678901234567890123456789',
     3         '01234567890','  ',' LSA0',' LSA1')

      GO TO 13
   11 IF((LFUSES(I,J)).AND.(.NOT.LFUSES(I+1,J)))
     1    ANDAR(J,K)=ONE
      IF((.NOT.LFUSES(I,J)).AND.(LFUSES(I+1,J)))
     2    ANDAR(J,K)=ZERO
      K=K+1
      GO TO 10
   12 IF((LFUSES(I,J)).AND.(.NOT.LFUSES(I+1,J)))
     1    ANDAR(J,K)=ZERO
      IF((.NOT.LFUSES(I,J)).AND.(LFUSES(I+1,J)))
     2    ANDAR(J,K)=ONE
      K=K+1
      GO TO 10
C      
   13 DO 15 OUT=17,24
      IF ((OUT.EQ.17).OR.(OUT.EQ.18)) K=1
      IF ((OUT.EQ.19).OR.(OUT.EQ.20)) K=17
      IF ((OUT.EQ.21).OR.(OUT.EQ.22)) K=33
      IF ((OUT.EQ.23).OR.(OUT.EQ.24)) K=49
C     INITIALISING THE FAULTS COVERED BY A TEST VECTOR AS FALSE
C     ALL THE TEST VECTORS ARE INITIALISED TO DONT CARE VALUES
      DO 6 I=1,400
      DO 6 J=1,40
      TSTVEC(I,J)=DONT
      PARRY(I)=ZERO
      LTST(I)=.FALSE.
      LSA01(I,1)=.FALSE.
      LSA01(I,2)=.FALSE.
    6 CONTINUE 
C
      PT1=1
      CALL TEST1(LTST,K,OUT,PT1,PT11)
      CALL TEST2(LTST,K,OUT,PT1,PT11,PT12)
      CALL EXCLSV(PT11,PT12,PT1)
      CALL PROUT(PT11,PT12,PT1,OUT,TITLE)
      TSTCNT=TSTCNT+PT1-1
      IF (PT11 .GE. 400) WRITE (PMS,8015) 
8015  FORMAT (' ERROR: TOO MANY TEST VECTORS FOR TSTVEC ARRAY SIZE')
   15 CONTINUE 
      DO 20 OUTTEM=1,8
      OUT=OUTTEM-4
      IF(OUTTEM.LE.4) OUT=OUTTEM+36
      IF((OUT.EQ.37).OR.(OUT.EQ.38)) K=65
      IF((OUT.EQ.39).OR.(OUT.EQ.40)) K=81
      IF((OUT.EQ.1).OR.(OUT.EQ.2)) K=97
      IF((OUT.EQ.3).OR.(OUT.EQ.4)) K=113
C     INITIALISING THE FAULTS COVERED BY A TEST VECTOR AS FALSE
C     ALL THE TEST VECTORS ARE INITIALISED TO DONT CARE VALUES
      DO 16 I=1,400
      DO 16 J=1,40
      TSTVEC(I,J)=DONT
      PARRY(I)=ZERO
      LTST(I)=.FALSE.
      LSA01(I,1)=.FALSE.
      LSA01(I,2)=.FALSE.
   16 CONTINUE 
C
      PT1=1
      CALL TEST1(LTST,K,OUT,PT1,PT11)
      CALL TEST2(LTST,K,OUT,PT1,PT11,PT12)
      CALL EXCLSV(PT11,PT12,PT1)
      CALL PROUT(PT11,PT12,PT1,OUT)
      TSTCNT=TSTCNT+PT1-1
      IF (PT11 .GE. 400) WRITE (PMS,8015) 
   20 CONTINUE
      WRITE(POF,25) TSTCNT
   25 FORMAT(/,' TOTAL NUMBER OF TEST VECTORS ARE',I4)  
      RETURN
      END
C*****************************
      SUBROUTINE XFER(I,PT1)
C     THIS SUBTOUTINE TRANSFERS THE VECTOR IN LAND MATRIX TO 
C     APPROPRIATE PLACES IN THE TSTVEC MATRIX
      IMPLICIT INTEGER*1 (A-Z)
C
      INTEGER I,J,PT1
      INTEGER*1 TSTVEC(350,40),ANDAR(128,32),XRA(32),XRB(32)
      INTEGER*2 PARRY(350)
      LOGICAL LSA01(350,2)
      COMMON /TEST/ TSTVEC,LSA01,PARRY,ANDAR
C
      DATA XRA /1,2,3,4,7,8,9,10,11,12,13,14,16,17,18,19,21,
     1 22,23,24,27,28,29,30,31,32,33,34,36,37,38,39/
      DATA XRB /1,3,5,7,8,6,4,2,15,13,11,9,10,12,14,16,18,20,
     1 22,24,23,21,19,17,32,30,28,26,25,27,29,31/
      DO 100 J=1,32
100   TSTVEC(PT1,XRA(J))=ANDAR(I,XRB(J))
      RETURN
      END                                       
C**********************   
      SUBROUTINE TEST1(LTST,K,OUT,PT1,PT11)
C     THIS SUBROUTINE GENERATES THE FIRST SET OF TEST VECTORS
C     THESE TEST VECTORS ARE GNERATED SUCH THAT FOR EVERY OUTPUT
C     EACH PRODUCT TERM IS SUCCESSIVELY 'TURNED ON'. THUS THESE
C     VECTORS IN EFFECT TEST FOR A FUSELINK SA0
      IMPLICIT INTEGER*1 (A-Z)
      LOGICAL  LTST(350),COVERF
      INTEGER I,K,L,OUT,PT1,PT11
C
      LOGICAL LFUSES(64,128),LORARY(2,128),LPOLAR(40),LBYPAS(40)
      COMMON /LFUSE/LFUSES,LORARY,LPOLAR,LBYPAS
      INTEGER*1 TSTVEC(350,40),ANDAR(128,32)
      INTEGER*2 PARRY(350)
      LOGICAL LSA01(350,2)
      COMMON /TEST/ TSTVEC,LSA01,PARRY,ANDAR
C
      DATA     ZERO/'0'/,ONE/'1'/,DONT/'D'/
C     CHECK WHETHER A PARTICULAR PRODUCT TERM IS USED OR NOT FOR  
C     THAT PARTICULAR OUTPUT 
      L=K+15
      DO 15 I=K,L
      IF((MOD(OUT,2).NE.0).AND.(.NOT.LORARY(1,I)).AND.(LORARY(2,I)))
     1 GO TO 10
      IF((MOD(OUT,2).EQ.0).AND.(LORARY(1,I)).AND.(.NOT.LORARY(2,I)))
     2 GO TO 10
   15 CONTINUE
      PT11=PT1-1
      RETURN
   10 CALL XFER(I,PT1)
      LTST(PT1)=.TRUE.
      PARRY(PT1)=I
      LSA01(PT1,1)=.TRUE.
      LSA01(PT1,2)=.FALSE.
      PT1=PT1+1
      GO TO 15           
      END
C********************************
C
      SUBROUTINE TEST2(LTST,K,OUT,PT1,PT11,PT12)
C     THIS SUBROUTINE GENERATES TEST VECTORS FOR STEP2. EACH
C     FUSELINK IS TESTED FOR SA1 TEST. THUS VECTORS IN THIS 
C     SET OF TEST VECTORS WILL TEST FOR EACH FUSE FOR SA1 
C     TEST. THE FAULT FREEE OUTPUT SHOULD BE ZERO.
      IMPLICIT INTEGER*1 (A-Z)
      LOGICAL LTST(350)
      INTEGER I,J,K,L,OUT,PT1,PT11,PT12
C
      LOGICAL LFUSES(64,128),LORARY(2,128),LPOLAR(40),LBYPAS(40)
      COMMON /LFUSE/LFUSES,LORARY,LPOLAR,LBYPAS
      INTEGER*1 TSTVEC(350,40),ANDAR(128,32)
      INTEGER*2 PARRY(350)
      LOGICAL LSA01(350,2)
      COMMON /TEST/ TSTVEC,LSA01,PARRY,ANDAR
C
      DATA    ZERO/'0'/,ONE/'1'/,DONT/'D'/
      L=K+15
      DO 15 I=K,L
      IF((MOD(OUT,2).EQ.0).AND.(LORARY(1,I))
     1 .AND.(.NOT.LORARY(2,I))) GO TO 10
      IF((MOD(OUT,2).NE.0).AND.(.NOT.LORARY(1,I))
     1 .AND.(LORARY(2,I))) GO TO 10
   15 CONTINUE
      PT12=PT11+1
      RETURN
   10 DO 11 J=1,32
C     COMPLEMENTING EACH FUSE 
      IF ((ANDAR(I,J) .EQ.DONT)) GO TO 11
      IF((ANDAR(I,J).EQ.ONE)) GO TO 20
      IF((ANDAR(I,J).EQ.ZERO)) GO TO 21
   24 CALL XFER(I,PT1)
C     CHANGING THE FUSE BIT TO ORIGINAL VALUE
      IF((ANDAR(I,J).EQ.ZERO)) GO TO 22
      IF((ANDAR(I,J).EQ.ONE))  GO TO 23
   25 LSA01(PT1,1)=.FALSE.
      LSA01(PT1,2)=.TRUE.
      LTST(PT1)=.TRUE.
      PARRY(PT1)=I
      PT1=PT1+1
   11 CONTINUE
      GO TO 15
   20 ANDAR(I,J)=ZERO
      GO TO 24   
   21 ANDAR(I,J)=ONE
      GO TO 24
   22 ANDAR(I,J)=ONE
      GO TO 25
   23 ANDAR(I,J)=ZERO
      GO TO 25   
      END
C
C***************
C
      SUBROUTINE EXCLSV(PT11,PT12,PT1)
C
C     THIS SUBROUTINE MAKES EACH VECTOR GENERATED IN TEST 1
C     MUTUALLY EXCLUSIVE. FOR E.G. IF IN VECTOR V1 THERE IS
C     '1' OR '0' IN BIT 1 AND 'X' IN VECTOR 2 AT THE SAME BIT,
C     THEN VECTORS V1 AND V2 ARE MADE MUTUALLY EXCLSIVE BY 
C     CHANGING 'X' TO '0' OR '1'
C
      IMPLICIT INTEGER*1 (A-Z)
      LOGICAL  COVERF
      INTEGER I,J,PT11,L,PT12,PT1
      INTEGER*1 TSTVEC(350,40),ANDAR(128,32)
      INTEGER*2 PARRY(350)
      LOGICAL LSA01(350,2)
      COMMON /TEST/ TSTVEC,LSA01,PARRY,ANDAR
C
      DATA    ZERO/'0'/,ONE/'1'/,DONT/'D'/
C
      IF ((PT11+PT1) .LT. 400) GOTO 3
      WRITE (6,8005) PT11,PT12,PT1
8005  FORMAT (' ERROR: TOO MANY VECOTORS TO MAKE EXCLUSIVE:',3I5)
      GOTO 25
C
C     MAKE A COPY OF TEST VECTORS
3     DO 5 I=1,PT11
      DO 5 J=1,40
    5 TSTVEC(350-I,J)=TSTVEC(I,J)  
C
      DO 25  I=1,PT11
      DO 25  J=1,PT11
      IF (J.EQ.I) GO TO 25
C     INITIALLY ALL VECTORS ARE ASSUMED TO BE COVERED
      COVERF=.TRUE.
      DO 10 L=1,40
      IF(((TSTVEC(350-I,L).EQ.ZERO).AND.(TSTVEC(350-J,L).EQ.ONE))
     1  .OR.((TSTVEC(350-I,L).EQ.ONE).AND.(TSTVEC(350-J,L).EQ.ZERO)))
     2 COVERF=.FALSE.
   10 CONTINUE     
      IF (.NOT.COVERF) GO TO 25
   15 DO 20 L=1,40
      IF ((TSTVEC(350-I,L).EQ.DONT).AND.(TSTVEC(350-J,L).EQ.ZERO)
     1 .AND.(COVERF)) GO TO 22
      IF((TSTVEC(350-I,L).EQ.DONT).AND.(TSTVEC(350-J,L).EQ.ONE)
     1 .AND.(COVERF)) GO TO 24
   20 CONTINUE
      IF(COVERF) GO TO 25
   22 TSTVEC(I,L)=ONE
      COVERF=.FALSE.
      GO TO 25
   24 TSTVEC(I,L)=ZERO
      COVERF=.FALSE.
      GO TO 25
   25 CONTINUE
      RETURN
      END
C
C***************************
      SUBROUTINE PROUT(PT11,PT12,PT1,OUT)
      IMPLICIT INTEGER*1 (A-Z)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER I,J,L,PT,PT12,PT1,PT11,OUT
      INTEGER*1 TSTVEC(350,40),ANDAR(128,32)
      INTEGER*2 PARRY(350)
      LOGICAL LSA01(350,2)
      COMMON /TEST/ TSTVEC,LSA01,PARRY,ANDAR
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
C
      INTEGER*1 TEMP(42)
      DATA    ZERO/'0'/,ONE/'1'/,DONT/'D'/,DASH/'-'/,CROSS/'X'/
      DO 35 I=1,PT11
      WRITE(POF,16)OUT,PARRY(I)-1
   16 FORMAT(/,1X,I3,1X,I3)
      DO 17 L=1,40
      TEMP(L)=TSTVEC(I,L)
      IF ((L.EQ.15).OR.(L.EQ.16).OR.(L.EQ.25).OR.(L.EQ.35)
     1    .OR.(L.EQ.36).OR.(L.EQ.5).OR.(L.EQ.30))TEMP(L)=ZERO
      IF(L.EQ.10) TEMP(L)=ONE
   17 CONTINUE
      DO 18 L=1,2
      IF(LSA01(I,L))TEMP(L+40)=CROSS
      IF(.NOT.LSA01(I,L)) TEMP(L+40)=DASH
   18 CONTINUE
      IF (LSA01(I,1) .NE. LSA01(I,2)) WRITE(POF,19)TEMP
   19 FORMAT(9X,'  ',40A1,'  ',2('   ',A1))
      DO 20 J=PT12,PT1
      IF(PARRY(J).EQ.PARRY(I)) GO TO 22
   20 CONTINUE
   35 CONTINUE
      PT=PT1-1
C     WRITE(POF,40)PT
C  40 FORMAT(/,' TOTAL NUMBER OF TEST  VECTORS ARE ',I3)
      RETURN
   22 DO 23 L=1,40
      TEMP(L)=TSTVEC(J,L)
      IF ((L.EQ.15).OR.(L.EQ.16).OR.(L.EQ.25).OR.(L.EQ.35)
     1    .OR.(L.EQ.36).OR.(L.EQ.5).OR.(L.EQ.30))TEMP(L)=ZERO
      IF(L.EQ.10) TEMP(L)=ONE
   23 CONTINUE
      DO 24 L=1,2
      IF(LSA01(J,L)) TEMP(L+40)=CROSS
      IF(.NOT.LSA01(J,L)) TEMP(L+40)=DASH
   24 CONTINUE
      WRITE(POF,30)TEMP
   30 FORMAT(9X,'  ',40A1,'  ',2('   ',A1))
      GO TO 20
      END        
C
C*****************
      SUBROUTINE BYPAS(FLFUSE,FLFLAG,LFEED,ISYM,IMATCH)
C
C     THIS SUBROUTINE DETERMINS WHETHER A PARTICULAR OUTPUT
C     SET IS TO BE BYPASED OR NOT.  A SET OF OUTPUTS 7-14 AND 27-34
C     CAN BE EITHER BYPASED OR NOT AS A SET. AN ERROR IS REPORTED
C     IF A SET OF OUTPUT IS TO BE BYPASED AND ALSO REGISTERED AT THE
C     SAME TIME. NO FEEDBACK PATHS ARE ALLOWED FROM BYPASED OUTPUTS
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 ISYM(8,40)
      INTEGER I,J,IMATCH
      LOGICAL FLFUSE(2,2), FLFLAG,LFEED(40)
C
      LOGICAL LFUSES(64,128),LORARY(2,128),LPOLAR(40),LBYPAS(40)
      COMMON /LFUSE/LFUSES,LORARY,LPOLAR,LBYPAS
C
      IF((IMATCH.GE.17).AND.(IMATCH.LE.24)) GO TO 10
      IF((IMATCH.GE.37.AND.IMATCH.LE.40).OR.(IMATCH.GE.1.AND.
     1  IMATCH.LE.4)) GO TO 20
      RETURN
C     IF THE PRESENT OUTPUT IS BYPASED AND PREVIOUS OUTPUT IS REGISTERED
C     AN ERROR IS FLAGED.  
  10  IF((FLFLAG).AND.(FLFUSE(1,1))) GO TO 11
C     IF THE PRESENT OUTPUT IS BYPASED AND PREVIOUSLY USED IN
C     FEEDBACK THEN FLAG AN ERROR
      IF((FLFLAG).AND.(LFEED(IMATCH))) GO TO 19
C     PRESENT OUTPUT IS BYPASED AND THIS IS THE FIRST OUTPUT
      IF((FLFLAG).AND.(.NOT.FLFUSE(1,1)).AND.(.NOT.FLFUSE(1,2)))
     1 GO TO 12
C     PRESENT OUTPUT REGISTERED AND PREVIOUS OUTPUT IS BYPASED. ERROR
      IF((.NOT.FLFLAG).AND.(FLFUSE(1,2))) GO TO 14
C     PRESENT OUTPUT IS REGISTERED AND THIS IS THE FIRST OUTPUT
      IF((.NOT.FLFLAG).AND.(.NOT.FLFUSE(1,1)).AND.(.NOT.FLFUSE(1,2)))
     1 GO TO 15 
      RETURN
   20 IF ((FLFLAG).AND.(FLFUSE(2,1))) GO TO 11
      IF((FLFLAG).AND.(LFEED(IMATCH))) GO TO 19
      IF ((FLFLAG).AND.(.NOT.FLFUSE(2,1)).AND.(.NOT.FLFUSE(2,2))) 
     1 GO TO 16
      IF ((.NOT.FLFLAG).AND.(FLFUSE(2,2))) GO TO 14
      IF ((.NOT.FLFLAG).AND.(.NOT.FLFUSE(2,1)).AND.(.NOT.FLFUSE(2,2)))
     1 GO TO 18
      RETURN
   11 WRITE(POF,30)IMATCH
   30 FORMAT(/,'OUTPUT PIN ',I2,' CANNOT BE BYPASED')
      STOP
   12 FLFUSE(1,2)=.TRUE.
      DO 13 I=17,24 
   13 LBYPAS(I)=.TRUE.
      RETURN 
   14 WRITE(POF,31)IMATCH
   31 FORMAT(/,' OUTPUT PIN ',I2,' CANNOT BE REGISTERED ')
      STOP
   15 FLFUSE(1,1)=.TRUE.
      RETURN
   16 FLFUSE(2,2)=.TRUE.
      DO 17 I=1,4
      LBYPAS(I+36)=.TRUE.
   17 LBYPAS(I)=.TRUE.
      RETURN
   18 FLFUSE(2,1)=.TRUE.
      RETURN
   19 WRITE(POF,32) IMATCH
   32 FORMAT(/,' OUTPUT PIN ',I2,' CANNOT BE USED IN FEEDBACK')
      STOP
      END
C 
C********************
      SUBROUTINE GETVEC(LPHASE,LPHAS1,IPIN,IMAX,FVECT,FCVECT,IC,IL)
C
C     THIS SUBROUTINE GETS A VECTOR FROM THE FUNCTION TABLE AND LOADS
C     IN THE FVECT AND FCVECT. THE FVECT CONTAINS ALL THE I/O VALUES
C     ARANGED IN THE ASCENDING ORDER OF I/O PINLIST. AT THE SAME TIME
C     PROPER POLARITY IS CONSIDERED BY EVALUATING THE LPHASE AND LPHAS1.        

     
      IMPLICIT INTEGER*1 (A-Z)
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      INTEGER*1  IPIN(40),FVECT(32),FCVECT(6)
      INTEGER I,IMAX,IC,IL,J,V
      LOGICAL  LPHASE(40),LPHAS1(40)    
      DATA     H/'H'/,L/'L'/,X/'X'/,Z/'Z'/,C/'C'/,DASH/'-'/
      DATA     COMENT/';'/,BLANK/' '/,ONE/'1'/,ZERO/'0'/,DONT/'D'/
C     GO PASSED THE COMMENT LINES
    5 IF(CPG(LOF(IL)+IC).NE.COMENT) GO TO 6
      IL=IL+1
    6 CONTINUE
C     GET VECTORS FROM FUNCTION TABLE
      IC=IC-1
      DO 10 I=1,IMAX
      IC=IC+1
    7 IF(CPG(LOF(IL)+IC).NE.BLANK) GO TO 8
      IC=IC+1
      GO TO 7
    8 CTMP=CPG(LOF(IL)+IC)
C     REARRANGING THE FUNCTION TABLE VECTORS IN THE RIGHT ORDER
C     AND POLARITY. ALSO SEPARATING THE CONTROL VECTORS  
      J=IPIN(I) 
      IF((J.GE.11).AND.(J.LE.14)) V=J-10
      IF((J.GE.26).AND.(J.LE.29)) V=J-21
      IF((J.GE.31).AND.(J.LE.34)) V=J-22
      IF((J.GE.6).AND.(J.LE.9)) V=J+7
      IF((J.GE.17).AND.(J.LE.24)) V=J
      IF((J.GE.37).AND.(J.LE.40)) V=J-12
      IF((J.GE.1).AND.(J.LE.4)) V=J+28
      IF(J.EQ.15) V=1
      IF(J.EQ.16) V=2
      IF(J.EQ.25) V=3
      IF(J.EQ.35) V=4
      IF(J.EQ.36) V=5
      IF(J.EQ.5) V=6
C
      IF(CTMP.EQ.X) FVECT(V)=DONT
      IF(CTMP.EQ.Z) FVECT(V)=Z
      IF((CTMP.EQ.H).AND.(LPHASE(J).NE.LPHAS1(I))) FVECT(V)=ZERO
      IF((CTMP.EQ.H).AND.(LPHASE(J).EQ.LPHAS1(I))) FVECT(V)=ONE
      IF((CTMP.EQ.L).AND.(LPHASE(J).NE.LPHAS1(I))) FVECT(V)=ONE
      IF((CTMP.EQ.L).AND.(LPHASE(J).EQ.LPHAS1(I))) FVECT(V)=ZERO
10    CONTINUE
      RETURN
      END   
C
C**********************
      SUBROUTINE ANDMAP
C
C THIS SUBROUTINE GENERATES A LOGICAL ANDMAP FOR THE FUSE PLOT.
C A PRESENCE OR AN ABSENCE OF A FUSE IS PRESENTED BY A '1' OR '0'
C UNDER AN INPUT PIN. FOR E.G. 'X' UNDER /PIN1 IS LOGICAL '0' IN
C IN THE ANDAR AND 'X' UNDER PIN1 IS LOGICAL '1' IN THE ANDAR
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,J,K
      LOGICAL LFUSES(64,128),LORARY(2,128),LPOLAR(40),LBYPAS(40)
      COMMON /LFUSE/LFUSES,LORARY,LPOLAR,LBYPAS
      INTEGER*1 TSTVEC(350,40),ANDAR(128,32)
      INTEGER*2 PARRY(350)
      LOGICAL LSA01(350,2)
      COMMON /TEST/ TSTVEC,LSA01,PARRY,ANDAR
C
      DATA    ONE/'1'/, ZERO/'0'/
      DO 10 J=1,128
      K=1
      DO 10 I=1,64,2
      IF((I.EQ.1).OR.(I.EQ.3).OR.(I.EQ.5).OR.(I.EQ.7).OR.(I.EQ.9)
     1  .OR.(I.EQ.11).OR.(I.EQ.13).OR.(I.EQ.15).OR.(I.EQ.49)
     2  .OR.(I.EQ.51).OR.(I.EQ.53).OR.(I.EQ.55).OR.(I.EQ.57)
     3  .OR.(I.EQ.59).OR.(I.EQ.61).OR.(I.EQ.63)) GO TO 11
      IF((I.EQ.17).OR.(I.EQ.19).OR.(I.EQ.21).OR.(I.EQ.23).OR.
     1   (I.EQ.25).OR.(I.EQ.27).OR.(I.EQ.29).OR.(I.EQ.31).OR.
     2   (I.EQ.33).OR.(I.EQ.35).OR.(I.EQ.37).OR.(I.EQ.39).OR.
     3   (I.EQ.41).OR.(I.EQ.43).OR.(I.EQ.45).OR.(I.EQ.47)) GO TO 12
   10 CONTINUE
      RETURN
   11 IF((LFUSES(I,J)).AND.(.NOT. LFUSES(I+1,J)))       
     1  ANDAR(J,K)=ONE
      IF((.NOT.LFUSES(I,J)).AND.(LFUSES(I+1,J)))
     2  ANDAR(J,K)=ZERO
      K=K+1
      GO TO 10 
   12 IF((LFUSES(I,J)).AND.(.NOT. LFUSES(I+1,J)))       
     1  ANDAR(J,K)=ZERO
      IF((.NOT.LFUSES(I,J)).AND.(LFUSES(I+1,J)))
     2  ANDAR(J,K)=ONE
      K=K+1
      GO TO 10 
      END
C***********************
C
      SUBROUTINE TWEEK1(FPOLAR)
C
C     THIS SUBROUTINE REARANGES THE ANDAR,ORARY,LPOLAR IN THE 
C     ORDER OF INPUT PINS AND OUTPUT PINS. THIS IS DONE TO FACILITATE
C     SIMULATION ALGORITHM.
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,J
      LOGICAL FPOLAR(16)
      INTEGER*1 MAP(32)
      INTEGER*1 TSTVEC(350,40),ANDAR(128,32)
      INTEGER*2 PARRY(350)
      LOGICAL LSA01(350,2)
      COMMON /TEST/ TSTVEC,LSA01,PARRY,ANDAR
C
      LOGICAL LFUSES(64,128),LORARY(2,128),LPOLAR(40),LBYPAS(40)
      COMMON /LFUSE/LFUSES,LORARY,LPOLAR,LBYPAS
      LOGICAL LVECT(32)          
      DATA  DONT/'D'/
      DATA MAP /1,20,2,19,3,18,4,17,24,5,23,6,22,7,21,8,28,9,27,
     1 10,26,11,25,12,13,32,14,31,15,30,16,29/
C     INITIALISE THE ANDAR TO DONT CARES
      DO 4 J=1,128
      DO 4 I=1,32
    4 ANDAR(J,I)=DONT
      CALL ANDMAP
C     TWEEKING THE ANDARY
      DO 10 I=1,128
      DO 5  J=1,32
      LVECT(MAP(J))=ANDAR(I,J)
    5 CONTINUE
      DO 6 J=1,32
    6 ANDAR(I,J)=LVECT(J)
   10 CONTINUE
C     TWEEKING THE POLAR ARRAY
      J=1
      DO 15 I=1,40
      IF(.NOT.(((I.GE.17).AND.(I.LE.24)).OR.((I.GE.37).AND.
     1  (I.LE.40)).OR.((I.GE.1).AND.(I.LE.4)))) GO TO 15
      FPOLAR(J)=LPOLAR(I)
      J=J+1   
   15 CONTINUE
      RETURN
      END
C           
C************************
C
      SUBROUTINE TEST(LPHASE,ISYM,IC,IL,ILE,FLFUSE)
C     THIS SUBROUTINE PERFORMS THE FUNCTION TABLE SIMULATION
C      AND GENERATES TEST VECTORS
      IMPLICIT INTEGER*1 (A-Z)
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
C
      INTEGER*1 ISYM(8,40),ISYM1(8,40),IBUF(8,40),FVECT(32),FCVECT(6),
     1      IPIN(40),FPRE(16),FINPUT(16),FOUTPT(16),OUTPUT(16),
     3      IPIN1(40),PREOUT(16)
      INTEGER I,J,K,IMAX,NVECT,NTEST,IC,IC1,ERROR
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LSAME,
     1    XORFND,LERR,LPHASE(40),LPHAS1(40),FLAG1,FLAG2,FLFUSE(2,2),
     3    LTEST(16),LMATCH
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR
      INTEGER IFUNCT,IDESC,IEND,IL,IL1,ILE,IMATCH
      COMMON /FTEST/ IFUNCT,IDESC,IEND
      INTEGER*1 TSTVEC(350,40),ANDAR(128,32)
      INTEGER*2 PARRY(350)
      LOGICAL LSA01(350,2)
      COMMON /TEST/ TSTVEC,LSA01,PARRY,ANDAR
C
      LOGICAL LFUSES(64,128),LORARY(2,128),LPOLAR(40),LBYPAS(40)
      COMMON /LFUSE/LFUSES,LORARY,LPOLAR,LBYPAS
      DATA IDASH/'-'/,L/'L'/,H/'H'/,X/'X'/,C/'C'/,Z/'Z'/,N0/'0'/,
     1     N1/'1'/,ERR/'?'/,IBLANK/' '/,COMENT/';'/,DONT/'D'/
      DATA BEL/007/
      DO 1 I=1,40
        IPIN1(I)=0
   1  CONTINUE          
      ERROR=0   
      CALL TWEEK1(FPOLAR)
      NTEST = 0
C     PRINT AN ERROR MESSAGE IF NO FUNCTION TABLE IS SUPPLIED
      IF(IFUNCT.NE.0) GO TO 3
      WRITE(PMS,2)
    2 FORMAT(/,' FUNCTION TABLE MUST BE SUPPLIED IN ORDER TO PERFORM',
     1         ' SIMULATION') 
      STOP
C     PRINT (TITLE(I),I=1,79)
    3 WRITE(POF,4) (TITLE(I),I=1,79)
    4 FORMAT(/,1X,79A1,/)
C     INITIALIZE LERR (FUNCTION TABLE ERROR FLAG) TO NO ERROR
      LERR=.FALSE.
C     INITIALIZE NERR (NUMBER OF FUNCTION TABLE ERRORS) TO NO ERROR
      NERR=0
C     SET THE STARTING POINT OF THE FUNCTION TABLE TO COLUMN 0
C      AND IFUNCT + 1
      IC=0
      IL=IFUNCT + 1
C     MAKE A DUMMY CALL TO INCR
      CALL INCR(IC,IL,FLFLAG)
C     GET THE FUNCTION TABLE PIN LIST (UP TO 38)
C      GO ONE MORE THAN MAX TO LOOK FOR DASHED LINE
C
      DO 10 I=1,38
      CALL GETSYM(LPHAS1,ISYM1,I,IC,IL,FLFLAG)
         DO 5 J=1,8
    5    IBUF(J,1)=ISYM1(J,I)
      IF(IBUF(8,1).EQ.IDASH) GO TO 12
      CALL MATCH(IMATCH,IBUF,ISYM)
      IF(IMATCH.NE.0) GO TO 9 
      WRITE(PMS,6) (IBUF(J,1),J=1,8)
    6 FORMAT(/,' FUNCTION TABLE PIN LIST ERROR AT', 8A1) 
      STOP
    9 IPIN(I)=IMATCH 
      IPIN1(IMATCH)=I
   10 CONTINUE  
C     ALL SIGNAL NAMES FOR THE FUNCTIONAL TEST HAVE BEEN READ IN
C      ADJUST COUNT
   12 IMAX=I-1
      NVECT=0
C
C     CALL GETVECTOR SUBROUTINE. THIS SUBROUTINE GETS A VECTOR FROM
C     THE FUNCTION TABLE AND ARANGES IN AN ORDER OF INPUT/OUTPUT PINS
C     AND ALSO DETERMINES THE STATE OF THE SIGNAL DEPENDING UPON THE 
C     VALUES IN LPHASE AND LPHASE1.THE CONTROL PINS (LOAD,CLOCK AND ENABLE)
C     ARE SEPARATED AND STORED IN FCVECT.
C     
C     START MAIN LOOP FOR SIMULATION 
   90 NVECT=NVECT+1
      IC1=0
      IL1=ILE
      DO 13 I=1,32 
   13 FVECT(I)=DONT 
      DO 14 I=1,6
   14 FCVECT(I)=DONT   
C     GO PASSED COMMENT LINES 
   15 IF(CPG(LOF(IL)+IC).NE.COMENT) GO TO  16
      IL=IL+1
      GO TO 15
   16 CONTINUE
C     IF THE FIRST VECTOR THAN LOAD PREVIUS VECTOR TO DONT CARES
      IF(NVECT.NE.1) GO TO 17
      DO 18 K=1,16
        FPRE(K)=DONT
   18 CONTINUE
   17 IF((CPG(LOF(IL)+IC).EQ.IDASH).AND.(NVECT.NE.1)) GO TO 80
      CALL GETVEC(LPHASE,LPHAS1,IPIN,IMAX,FVECT,FCVECT,IC,IL)
C      WRITE(PMS,11) FCVECT
C  11 FORMAT(/,'CVECTOR IS    ', 6('  ',A1))    
C     CALL WRITOUT(ANDAR)
C     ADVANCE LINE COUNT TO SKIP FUNCTION TABLE COMMENTS
      IL=IL+1
      IC=0
      CALL DEVIDE(FVECT,FINPUT,FOUTPT)
      CALL CREOUT(FINPUT,FPRE,ORARY,OUTPUT)
      CALL CPOUT(OUTPUT,PREOUT)       
      CALL CHKCON(FOUTPT,OUTPUT,FCVECT,FPRE,FLAG1,FLAG2)
      CALL FLUPOL(FLFUSE,FPOLAR,OUTPUT,FPRE)
      CALL OUTMTC(OUTPUT,FOUTPT,LTEST,FLAG1,FLAG2)
      CALL ARANGE(ISYM,IPIN1,FVECT,OUTPUT,LPHAS1,LTEST,
     1             NVECT,FCVECT,LPHASE,ERROR)
C     IF(.NOT.LMATCH) GO TO 20
      IF((FLAG1.AND.FLFUSE(1,2)).OR.
     1  (FLAG2.AND.FLFUSE(2,2)))GO TO 300
      IF((FLAG1).AND.(FLAG2)) GO TO 44  
      CALL LODOUT(FPRE,PREOUT,FLAG1,FLAG2)
C  46 WRITE(PMS,43)OUTPUT
C  43 FORMAT(/,' EVALUATED OUTPUTS:     ', 16('  ',A1))          
C     WRITE(PMS,45)FOUTPT
C  45 FORMAT(/,' FUNCTION TABLE OUTPUTS:', 16('  'A1))             
      GO TO 90
C
 44   DO 8044 I=1,16
          FPRE(I)=FOUTPT(I)
 8044  CONTINUE
      GO TO 90
C
   80 IF(ERROR.NE.0)GO TO 95
      WRITE(PMS,96)
   96 FORMAT(/,' SIMULATION PASSED')
      RETURN
   95 WRITE(PMS,19)ERROR
   19 FORMAT(/,' ERROR IN SIMULATION:  NUMBER OF ERRORS DETECTED ',I3)  
C  22 WRITE(PMS,23)OUTPUT
C  23 FORMAT(/,' EVALUATED OUTPUTS:     ', 16('  ',A1))          
C  24 WRITE(PMS,25)FOUTPT
C  25 FORMAT(/,' FUNCTION TABLE OUTPUTS:', 16('  'A1))             
C
C       LOADS OUTPUT WITH DONT CARES AFTER ONE TEST VECTOR IS DONE
C
        DO 8803 I=1,16
          OUTPUT(I)=DONT
8803    CONTINUE
C
       RETURN
  300 WRITE(PMS,301)
  301 FORMAT(/,' ERROR:  NO PRELOAD IS ALLOWED 
     1         WHEN OUTPUTS ARE BYPASED')
      RETURN    
       END
C
C***********************
C
        SUBROUTINE DEVIDE(FVECT,FINPUT,FOUTPT)
C
C       THIS SUBROUTINE DEVIDES FVECTOR INTO FINPUT AND FOUTPT
C
        INTEGER*1 FVECT(32),FINPUT(16),FOUTPT(16)
C

        DO 10 I=1,16
          FINPUT(I)=FVECT(I)
          M=16+I
          FOUTPT(I)=FVECT(M)
 10     CONTINUE
        RETURN
        END
C
        SUBROUTINE CREOUT(FINPUT,FPRE,ORARY,OUTPUT)
C
C       THIS SUBROUTINE CREATES AN OUTPUT VECTOR BASED ON THE FINPUT,
C       FPRE,ANDARRAY AND ORARRAY.
C       TWO OUTPUT PINS CAN SHARES 16 PRODUCT TERMS,THE ORARRAY TELLS WHICH  
C       PRODUCT TERM IS CONNECTED TO WHICH OUTPUT.THE ORARRAY HAS TWO 
C       COLUMNS. A TRUE IN COLUNM ONE MEANS THE CORRESPONDING ROW(PRODUCT TERM)
C       IS CONNECTED TO AN ODD NUMBER PIN. A TRUE IN COLUMN 2 MEANS THE 
C       CORRESPONDING ROW IS CONNECTED TO AN EVEN NUMBER PIN.
C       TWO FALSE IN BOTH COLUMNS MEANS THE PRODUCT TERM IS NOT USED.
C                       
C       INDEX->POINTS AT THE NEXT LOCATION IN THE OUTPUT
C
C       COUNT->KEEPS TRACK OF WHICH OUTPUT PAIR IS BEING WORKED UPON
C
C       TEST-->TRUE WHEN THE INPUT VECTOR IS MATCHED WITH ONE OF THE
C              VCETORS IN THE ANDARRAY  
C       ODD--->TRUE WHEN THE ODD NUMBERD OUTPUT PIN HAS BEEN SET
C
C
C       THE PROGRAM COMPARES THE ANDARRAY WITH FCOMB,IF THE ROW IS
C       MATCHED,IT FIRST CHECKS IF THE ODD NUMBER PIN HAD ALREAD
C       BEEN LOADED,IF NOT,THE PROGRAM CHECKS WHICH OUTPUT PIN IS
C       CONNECTED. IF ODD NUMBER PIN IS CONNECTED,THE CORRESPONDING
C       OUTPUT IS LOADED WITH 1. THEN IT SKIPS THE ROWS THAT IS CONNECTED
C       TO THE ODD NUMBER PIN,AND CHECKS FOR THE TERMS LEFT FOR THE
C       EVEN NUMBER PIN.
C       IF ODD NUMBER PIN IS NOT CONNECTED AND EVEN NUMBER PIN IS
C       CONNECTED,IT MEANS WE HAVE PASSED ALL THE PRODUCT TERMS 
C       CONNECTED TO THE ODD NUMBER PIN.SO,ODD NUMBER PIN GETS A LOW
C       AND EVEN NUMBER PIN GETS A HIGH
C       IF THE ODD NUMBER PIN HAD ALREADY BEEN LOADED,EVEN NUMBER PIN
C       IS LOADED WITH A HIGH
C
C
C***********************
 
        IMPLICIT INTEGER*1 (A-Z)
        COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER*1 TSTVEC(350,40),ANDAR(128,32)
      INTEGER*2 PARRY(350)
      LOGICAL LSA01(350,2)
      COMMON /TEST/ TSTVEC,LSA01,PARRY,ANDAR
C
      INTEGER*1 FINPUT(16),FPRE(16),FCOMB(32),OUTPUT(16)
      INTEGER I,J,M,INDEX,COUNT
      LOGICAL  ODD,TEST,ORARY(2,128)
      DATA H/'H'/,L/'L'/,D/'D'/,ZERO/'0'/,ONE/'1'/
C 
C
      INDEX=1
      COUNT=1
      TEST=.TRUE.
      ODD=.FALSE.                     
C     COMBINE FINPUT AND FPRE INTO ONE VECTOR
      DO 1 I=1,16
      FCOMB(I)=FINPUT(I)              
  1   CONTINUE
      DO 2 I=1,16
      FCOMB(I+16)=FPRE(I)           
  2   CONTINUE
C     START MATCHING
C     WRITE (PMS,11) FCOMB
C 11  FORMAT(/,' FCOBM IS   ', 32('  ',A1))
      I=0
  5   I=I+1
      IF (I.GT.128) GO TO 120
      DO 10 J=1,32
C     CHECK THE NEXT CHAR IF MATCHED
      IF (FCOMB(J).EQ.ANDAR(I,J)) GO TO 10 
      IF((ANDAR(I,J).EQ.D).OR.(FCOMB(J).EQ.D)) GO TO 10       
      TEST=.FALSE.
  10  CONTINUE
C     MATCHED,CHECK FOR THE OUTPUT PINS
      IF (TEST) GO TO 50      
C  20 I=I+1         
C     NOT MATCHED,CHECK THE NEXT ONE
  30  TEST=.TRUE.     
C     NOT FINISHED WITH A PAIR OF OUTPUTS,GO ON CHECKING
  31  IF (I.LT.(16*COUNT)) GO TO 5 
C     NO MATCH,SET THE EVEN PIN IF ODD PIN HAS BEEN SET
      IF (ODD) GO TO 100      
C     NO MATCH FOR THIS PAIR OF OUTPUTS,LOAD THE
C     OUTPUT WITH LOW
      OUTPUT(INDEX)=ZERO
      INDEX=INDEX+1           
      OUTPUT(INDEX)=ZERO              
C     POINTING AT THE NEXT COLUMN
      INDEX=INDEX+1           
      COUNT=COUNT+1
C     GO BACK AND CHECK THE NEXT PAIR OF OUTPUTS
      GO TO 5                 
C     ODD # PIN HAS BEEN SET,ONLY EVEN # PIN NEEDS TO BE SET
  50  IF (ODD) GO TO 60               
C     IF THE PRODUCT TERM IS NOT USED,SKIP LOADIND THE OUTPUT AND GO ON CHECK 
      IF ((.NOT.ORARY(1,I)).AND.(.NOT.ORARY(2,I)))GO TO 31
C     ODD # PIN IS CONNECTED,SET IT UP FIRST
      IF (.NOT. ORARY(1,I)) GO TO 70 
C     ODD PIN HAS BEEN PASSED->UNCONNECTED  
C     SO PUT A LOW IN THE ODD PIN
      OUTPUT(INDEX)=ZERO         
      INDEX=INDEX+1                   
C     EVEN PIN IS CONNECTED,SET IT TO 1
      OUTPUT(INDEX)=ONE               
C     POINTING AT THE NEXT COLUMN
      INDEX=INDEX+1           
      COUNT=COUNT+1
C     GO ON CHECKING
      GO TO 5                 
C     SET EVEN # PIN TO 1
  60  OUTPUT(INDEX)=ONE               
      INDEX=INDEX+1
      ODD=.FALSE.
C     DONE WITH THIS PAIR,GET TO THE START NUMBER OF THE NEXT PAIR
      I=16*COUNT+1            
      COUNT=COUNT+1           
C     AND KEEP ON CHECKING
      GO TO 5                 
  70  ODD=.TRUE.              
C     ODD # PIN IS CONNECTED,SO SET IT TO 1
      OUTPUT(INDEX)=ONE
      INDEX=INDEX+1           
C     POINTING AT THE NEXT COLUMN
      M=I
  80  M=M+1                   
C     SKIP THE VECTORS UNTIL EVEN # PIN ARE CONNECTED OR THE END OF 
C     THE PRODUCT TERMS IS REACHED
      IF (M.LE.16*COUNT.AND.(.NOT.ORARY(1,M))) GO TO 80  
      I=M-1
C     CHECK FOR THE EVEN # PIN IF THE EVEN PIN IS CONNECTED
      IF (M.LE.16*COUNT.AND.ORARY(1,M)) GO TO 30  
C     EVEN PIN IS NOT CONNECTED,SET IT TO 0
      OUTPUT(INDEX)=ZERO              
      INDEX=INDEX+1
      I=I*COUNT+1
      COUNT=COUNT+1
      GO TO 5
C     ODD PIN HAS BEEN SET,EVEN PIN IS NOT CONNECTED
  100 OUTPUT(INDEX)=ZERO
      INDEX=INDEX+1
      COUNT=COUNT+1
      ODD=.FALSE.
      GO TO 5
  120 RETURN
      END
C
        SUBROUTINE CPOUT(OUTPUT,PREOUT)
C
C       THIS SUBROUTINE SAVES A COPY OF THE OUTPUT TO BE USED 
C       WHEN THERE IS PRELOADING
C
C****************
C
        INTEGER*1 OUTPUT(16),PREOUT(16)
        INTEGER I
        DO 1 I=1,16
          PREOUT(I)=OUTPUT(I)
  1      CONTINUE
        RETURN
        END
C
        SUBROUTINE CHKCON(FOUTPT,OUTPUT,CVECT,FPRE,FLAG1,FLAG2)
C
C       THIS SUBROUTINE CHECKS THE CONTROL VECTOR.
C       IF THERE IS A PRELOAD,THE CORRESPONDING OUTPUT IS SET TO
C       "Z" AND THE FPRE IS SET TO THE VALUES OF FOUTPT.
C       FOUTPT IS THE OUTPUT OBTAINED FROM FUNCTION TABLE.
C       OUTPUT IS THE OUTPUT CREATED IN SUBROUTINE CREOUT.
C
C********************* 
        IMPLICIT INTEGER*1 (A-Z)
        COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
        INTEGER*1  OUTPUT(16),FOUTPT(16),CVECT(6),FPRE(16)
        DATA Z/'Z'/,ZERO/'0'/,ONE/'1'/
        INTEGER I
        LOGICAL FLAG1,FLAG2
        FLAG1=.FALSE.
        FLAG2=.FALSE.
C               ERROR MESSAGE WHEN ENABLED AND PRELOAD AT THE SAME TIME
        IF ((CVECT(1).EQ.ZERO).AND.(CVECT(3).EQ.ZERO)) GO TO 500
C               ENABLED
        IF (CVECT(1).EQ.ONE.AND.CVECT(3).EQ.ZERO) GO TO 40
C               DISABLED
        IF (CVECT(1).EQ.ONE.AND.CVECT(3).EQ.ONE) GO TO 20
C               PRELOAD
        DO 10 I=1,8
           OUTPUT(I)=Z
           FPRE(I)=FOUTPT(I)
 10     CONTINUE
        FLAG1=.TRUE.
        GO TO 40
C               DISABLED
 20     DO 30 I=1,8
          OUTPUT(I)=Z
 30     CONTINUE
C               OUTPUT IS ENABLED AND THERE IS NO PRELOAD,GO ON TO THE
C               NEXT OUTPUT BANK
 40     IF((CVECT(4).EQ.ZERO).AND.(CVECT(6).EQ.ZERO)) GO TO 500
        IF(CVECT(4).EQ.ONE.AND.CVECT(6).EQ.ZERO) GO TO 1500
        IF(CVECT(4).EQ.ONE.AND.CVECT(6).EQ.ONE) GO TO 60
        DO 50 I=9,16
          OUTPUT(I)=Z
          FPRE(I)=FOUTPT(I)
 50     CONTINUE
        FLAG2=.TRUE.
        IF(((CVECT(5).EQ.ONE).AND.(CVECT(4).EQ.ZERO)).OR.
     1    ((CVECT(2).EQ.ONE).AND.(CVECT(1).EQ.ZERO))) GO TO 1000
        GO TO 1500
 60     DO 70 I=9,16
          OUTPUT(I)=Z                   
 70     CONTINUE
        GO TO 1500
 500    WRITE (PMS,510)
 510    FORMAT('ERROR: OUTPUT CANNOT BE ENABLED WHEN PRELOADING')
 1000   WRITE (PMS,1100)
 1100   FORMAT('WARNING: NO CLOCK IS NEEDED WHEN PRELOADING')   
 1500   RETURN
        END
C
        SUBROUTINE FLUPOL(FLFUSE,FPOLAR,OUTPUT,FPRE)
C
C       THIS SUBROUTINE CHECKS THE BYPAS VECTOR AND LPOLAR VECTOR.
C       IF THE OUTPUT IS BYPASED,THE CORRESPONDING FPRE WOULD BE
C       FILLED WITH "D"
C       IF THE LPOLAR IS TRUE,THERE IS NO POLARITY CHANGE.
C       IF THE LPOLAR IS FALSE,THE CORRESPONDINGO UTPUT IS INVERTED   
C
C*********************
C
        IMPLICIT INTEGER*1 (A-Z)
        INTEGER*1 OUTPUT(16),FPRE(16)
        INTEGER I
        LOGICAL BYPAS(2,2),LPOLAR(16),FLFUSE(2,2)
        DATA L/'L'/,H/'H'/,D/'D'/,ZERO/'0'/,ONE/'1'/
C
C
        DO 10 I=1,16
          IF (LPOLAR(I)) GO TO 10
          IF (OUTPUT(I).EQ.L)GO TO 20
          OUTPUT(I)=ZERO
          GO TO 10
 20       OUTPUT(I)=ONE
 10     CONTINUE
        IF (.NOT.BYPAS(1,2)) GO TO 40
        DO 30 I=1,8
          FPRE(I)=D
 30     CONTINUE
 40     IF (.NOT. BYPAS(2,2)) GO TO 60
        DO 50 I=9,16
          FPRE(I)=D
 50     CONTINUE
 60     RETURN
        END
C
        SUBROUTINE OUTMTC(OUTPUT,FOUTPT,LTEST,FLAG1,FLAG2)
C
C       THIS SUBROUTINE TRIES TO MATCH OUTPUT AND FOUTPT.
C       LTEST KEEPS TRACK OF WHICH OUTPUT IS NOT MATCHED. IT IS LATER
C       CHECKED IN SUBROUTINE ARANGE TO PUT A QUESTION MARK IN THE OUTPUT
C       WHEN LTEST IS FALSE
C
C******************
        IMPLICIT INTEGER*1 (A-Z)
        INTEGER*1 OUTPUT(16),FOUTPT(16)
        INTEGER I
        LOGICAL LTEST(16)
        DATA D/'D'/
C
        DO 1 I=1,16
          LTEST(I)=.TRUE.
 1      CONTINUE        
        IF ((FLAG1).OR.(FLAG2)) GO TO 20
        DO 10 I=1,16
          IF (OUTPUT(I).EQ.FOUTPT(I)) GO TO 10
          IF ((OUTPUT(I).EQ.D).OR.(FOUTPT(I).EQ.D)) GO TO 10
          LTEST(I)=.FALSE.
 10     CONTINUE
        GO TO 50
 20     IF((FLAG1).AND.(FLAG2)) GO TO 50
        IF (FLAG2) GO TO 30
        DO 25 I=9,16
          IF (OUTPUT(I).EQ.FOUTPT(I)) GO TO 25
          IF ((OUTPUT(I).EQ.D).OR.(FOUTPT(I).EQ.D)) GO TO 25
          LTEST(I)=.FALSE.
 25     CONTINUE
        GO TO 50
 30     DO 35 I=1,8
          IF (OUTPUT(I).EQ.FOUTPT(I)) GO TO 35
          IF ((OUTPUT(I).EQ.D).OR.(FOUTPT(I).EQ.D)) GO TO 35
          LTEST(I)=.FALSE.
 35     CONTINUE 
 50     RETURN
        END
C       
        SUBROUTINE ARANGE(ISYM,IPIN1,FVECT,OUTPUT,LPHAS1,LTEST,NVECT,
     1                      CVECT,LPHASE,ERROR)
C
C       THIS SUBROUTINE TAKES THE OUTPUT AND ARANGES THE INPUT
C       AND OUTPUT ACCORDING TO THE FUNCTION TABLE LIST ORDER.
C       IT ALSO PRINT OUT AN ERROR MESSAGE IF THE OUTPUTS ARE
C       NOT MATCHED
C
C********************
C
        IMPLICIT INTEGER*1 (A-Z)
        COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
        INTEGER*1 IPIN1(40),FVECT(32),OUTPUT(16),FNCTBL,TEMP(40),
     1   ACTUAL(40),EXPECT(40),NVECT,TMPBUF(9),ISYM(8,40),CVECT(6)
        INTEGER ERROR,I,N,J,K
        LOGICAL LPHASE(40),LPHAS1(40),CHECK(40),LTEST(16),TMPHAS(40)
        DATA MARK/'?'/,DONT/'D'/,ZERO/'0'/,ONE/'1'/,LOW/'L'/,
     1       HIGH/'H'/,X/'X'/,BLANK/' '/
C
        DO 5 I=1,40
          TEMP(I)=DONT
          CHECK(I)=.TRUE.
          TMPHAS(I)=.TRUE.
   5    CONTINUE 
        CALL GTCVEC(IPIN1,TEMP,CVECT,LPHASE,LPHAS1,TMPHAS)
        DO 1 I=11,14
          FNCTBL=IPIN1(I)
          IF(FNCTBL.EQ.0)GO TO 6
          IF(((.NOT.LPHASE(I)).AND.LPHAS1(FNCTBL)).OR.(LPHASE(I).AND.
     1       (.NOT.LPHAS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
          TEMP(FNCTBL)=FVECT(I)
   6      J=15+I
          FNCTBL=IPIN1(J)
          IF(FNCTBL.EQ.0)GO TO 7
          IF(((.NOT.LPHASE(J)).AND.LPHAS1(FNCTBL)).OR.(LPHASE(J).AND.
     1       (.NOT.LPHAS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
          INDEX=I+4
          TEMP(FNCTBL)=FVECT(INDEX)
   7      J=20+I
          FNCTBL=IPIN1(J)
          IF(FNCTBL.EQ.0)GO TO 8 
          IF(((.NOT.LPHASE(J)).AND.LPHAS1(FNCTBL)).OR.(LPHASE(J).AND.
     1       (.NOT.LPHAS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
          INDEX=I+8     
          TEMP(FNCTBL)=FVECT(INDEX)               
   8      J=I-5
          FNCTBL=IPIN1(J)
          IF(FNCTBL.EQ.0)GO TO 1
          IF(((.NOT.LPHASE(J)).AND.LPHAS1(FNCTBL)).OR.(LPHASE(J).AND.
     1      (.NOT.LPHAS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
          INDEX=I+12
          TEMP(FNCTBL)=FVECT(INDEX)
 1      CONTINUE
C
C       LOAD THE OUTPUT INTO THE TEMP
C
        DO 2 I=1,8
          J=I+16
          FNCTBL=IPIN1(J)
          INDEX=I+16
          IF(FNCTBL.EQ.0)GO TO 22  
          IF(((.NOT.LPHASE(J)).AND.LPHAS1(FNCTBL)).OR.(LPHASE(J).AND.
     1       (.NOT.LPHAS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
          IF (.NOT.LTEST(I)) GO TO 20
          TEMP(FNCTBL)=FVECT(INDEX)
          GO TO 22
 20       ACTUAL(FNCTBL)=FVECT(INDEX)
          EXPECT(FNCTBL)=OUTPUT(I)      
          CHECK(FNCTBL)=.FALSE.
 22       J=I+36
          IF(I.GT.4) J=I-4
          K=I+8
          INDEX=I+24
          FNCTBL=IPIN1(J)
          IF(FNCTBL.EQ.0)GO TO 2
          IF(((.NOT.LPHASE(J)).AND.LPHAS1(FNCTBL)).OR.(LPHASE(J).AND.
     1       (.NOT.LPHAS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
          IF (.NOT.LTEST(K)) GO TO 30
          TEMP(FNCTBL)=FVECT(INDEX)
          GO TO 2
 30       ACTUAL(FNCTBL)=FVECT(INDEX)
          EXPECT(FNCTBL)=OUTPUT(K)
          CHECK(FNCTBL)=.FALSE.
 2      CONTINUE
        DO 3 I=1,40
          IF(CHECK(I)) GO TO 3
          TEMP(I)=MARK
 3      CONTINUE
C
C      CONVERT REPRESENTATION OF ZERO/ONE TO LOW/HIGH
C
        DO 8801 I=1,40
          IF(TEMP(I).EQ.ZERO) TEMP(I)=LOW
          IF(TEMP(I).EQ.ONE) TEMP(I)=HIGH
          IF(TEMP(I).EQ.DONT) TEMP(I)=X
8801    CONTINUE
C
C
C       USE TMPHAS CREATED IN SUBROUTINE CHKPHS
C       WHICH TELLS WHETHER THE PHASE IN MAIN PIN LIST IS THE SAME
C       WITH THE PHASE IN THE FUNCTION TABLE PIN LIST.IF THEY ARE NOT
C       INVERT THE CORRESPONDING OUTPUT
C
        DO 8802 I=1,40
          IF(TMPHAS(I)) GO TO 8802
          IF(TEMP(I).EQ.LOW) TEMP(I)=HIGH
          IF(TEMP(I).EQ.HIGH) TEMP(I)=LOW
8802    CONTINUE
C
C
        WRITE(PMS,33) NVECT,TEMP
 33     FORMAT('  ',I3,'       ',40A1)  
        DO 4 I=1,40       
          IF (CHECK(I)) GO TO 4
          ERROR=ERROR+1
          CALL CHKPHS(IPIN1,LPHAS1,ISYM,I,TMPBUF)
          IF((ACTUAL(I).EQ.ZERO).AND.TMPHAS(I)) ACTUAL(I)=LOW
          IF((ACTUAL(I).EQ.ZERO).AND.(.NOT.TMPHAS(I)))
     1       ACTUAL(I)=HIGH
          IF((ACTUAL(I).EQ.ONE).AND.TMPHAS(I)) ACTUAL(I)=HIGH
          IF((ACTUAL(I).EQ.ONE).AND.(.NOT.TMPHAS(I)))
     1       ACTUAL(I)=LOW      
          IF((EXPECT(I).EQ.ZERO).AND.TMPHAS(I)) EXPECT(I)=LOW
          IF((EXPECT(I).EQ.ZERO).AND.(.NOT.TMPHAS(I)))
     1       EXPECT(I)=HIGH             
          IF((EXPECT(I).EQ.ONE).AND.TMPHAS(I)) EXPECT(I)=HIGH
          IF((EXPECT(I).EQ.ONE).AND.(.NOT.TMPHAS(I)))
     1       EXPECT(I)=LOW
          WRITE(PMS,44)TMPBUF,ACTUAL(I),EXPECT(I)
 44       FORMAT('  ERROR:',9A1,'    ACTUAL=',A1,'    EXPECT=',A1)
          DO 66 N=1,9
            TMPBUF(N)=BLANK
 66       CONTINUE
 4      CONTINUE        
        RETURN
        END      
C
        SUBROUTINE GTCVEC(IPIN1,TEMP,CVECT,LPHASE,LPHAS1,TMPHAS)
C
C       THIS SUBROUTINE PUTS THE CVECT INTO TEMP WHICH IS IN FUNCTION
C       TABLE LISTING ORDER
C
C**********************
C
        INTEGER*1 TEMP(40),IPIN1(40),CVECT(6)
        INTEGER FNCTBL
        LOGICAL LPHASE(40),LPHAS1(40),TMPHAS(40)
        FNCTBL=IPIN1(15)
        IF(FNCTBL.EQ.0)GO TO 1
        IF(((.NOT.LPHASE(15)).AND.LPHAS1(FNCTBL)).OR.(LPHASE(15)
     1     .AND.(.NOT.LPHAS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.        
        TEMP(FNCTBL)=CVECT(1)
  1     FNCTBL=IPIN1(16)
        IF(FNCTBL.EQ.0)GO TO 2
        IF(((.NOT.LPHASE(16)).AND.LPHAS1(FNCTBL)).OR.(LPHASE(16)
     1     .AND.(.NOT.LPHAS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.        
        TEMP(FNCTBL)=CVECT(2)
  2     FNCTBL=IPIN1(25)
        IF(FNCTBL.EQ.0)GO TO 3
        IF(((.NOT.LPHASE(25)).AND.LPHAS1(FNCTBL)).OR.(LPHASE(25).AND.
     1     (.NOT.LPHAS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.        
        TEMP(FNCTBL)=CVECT(3)   
  3     FNCTBL=IPIN1(35)
        IF(FNCTBL.EQ.0)GO TO 4
        IF(((.NOT.LPHASE(35)).AND.LPHAS1(FNCTBL)).OR.(LPHASE(35)
     1     .AND.(.NOT.LPHAS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.        
        TEMP(FNCTBL)=CVECT(4)
  4     FNCTBL=IPIN1(36)
        IF(FNCTBL.EQ.0)GO TO 5
        IF(((.NOT.LPHASE(36)).AND.LPHAS1(FNCTBL)).OR.(LPHASE(36)
     1     .AND.(.NOT.LPHAS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.        
        TEMP(FNCTBL)=CVECT(5)
  5     FNCTBL=IPIN1(5)
        IF(FNCTBL.EQ.0)GO TO 6
        TEMP(FNCTBL)=CVECT(6)
  6     RETURN
        END             
C
        SUBROUTINE CHKPHS(IPIN1,LPHAS1,ISYM,FPTR,TMPBUF)
C
C       THIS SUBROUTINE CHECKS THE PHASE OF THE INPUTS AND OUTPUTS
C       OF BOTH MAIN PIN LIST AND FUNCTION TABLE PIN LIST AND PUTS IN
C       A BAR IN THE PRINT OUT IF NECESSARY. 
C
C******************
C
        IMPLICIT INTEGER*1 (A-Z)
        INTEGER*1 TMPBUF(9),ISYM(8,40),IPIN1(40)
        INTEGER I,FPTR,SPTR,J
        LOGICAL LPHAS1(40),LBAR
        DATA BAR/'/'/,BLANK/' '/
        LBAR=.FALSE.
        DO 1 I=1,40
        IF (IPIN1(I).EQ.FPTR)GO TO 10
  1     CONTINUE
  10    SPTR=I
        IF (LPHAS1(FPTR)) GO TO 20
        DO 2 I=1,9
          IF(ISYM(I,SPTR).EQ.BLANK)GO TO 2
          IF(LBAR) GO TO 3
          J=I-1
          TMPBUF(J)=BAR
          LBAR=.TRUE.
  3       TMPBUF(I)=ISYM(I,SPTR)
  2     CONTINUE
        RETURN
  20    DO 30 I=1,8
          J=I+1
          TMPBUF(J)=ISYM(I,SPTR)
  30    CONTINUE
        RETURN
        END     
        
        SUBROUTINE LODOUT(FPRE,PREOUT,FLAG1,FLAG2)
C
C       THIS SUBROUTINE IS CALLED WHEN THE OUTPUTS ARE MATCHED.
C       IT FILLS FPRE WITH THE VALUES OF OUTPUT         
C
C*********************
        IMPLICIT INTEGER*1 (A-Z)
        INTEGER*1 FPRE(16),OUTPUT(16),PREOUT(16)
        INTEGER I
        LOGICAL FLAG1,FLAG2
C
        DATA D/'D'/,Z/'Z'/
C
        IF(.NOT.FLAG1.AND.(.NOT.FLAG2)) GO TO 10
        IF(FLAG1) GO TO 20
        DO 30 I=1,8
          FPRE(I)=PREOUT(I)
  30    CONTINUE
        RETURN
  20    DO 40 I=9,16
          FPRE(I)=PREOUT(I)
  40    CONTINUE
        RETURN
  10    DO 50 I=1,16
          FPRE(I)=PREOUT(I)
  50    CONTINUE
        RETURN
        END
C
C
C*************************************
      SUBROUTINE FZPLT(LBUF,IBUF,IPROD,ITYPE,LPROD,IOP,IBLOW)
      IMPLICIT INTEGER*1 (A-Z)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
C
      INTEGER*1 IBUF(8,40),IOUT(90),ISAVE(128,64),IDATA(64)
      INTEGER IPROD,IBLOW,I,J,I88PRO,I8PRO   
      LOGICAL LBUF(40),LDUMP,LPROD(128),FLAG1,FLAG2
      LOGICAL LFUSES(64,128),LORARY(2,128),LPOLAR(40),LBYPAS(40)
      COMMON /LFUSE/LFUSES,LORARY,LPOLAR,LBYPAS
      COMMON /FPLOT/ ISAVE
      DATA IAND/'*'/,IOR/'+'/,ISLASH/'/'/,
     1     IDASH/'-'/,X/'X'/,IBLANK/' '/,P/'P'/,B/'B'/,
     2     D/'D'/,ZERO/'0'/,ONE/'1'/,FX/'0'/,FIDASH/'O'/
      IF(ISAVE(IPROD,1).NE.IBLANK) RETURN
      IF(LBUF(1)) GO TO 5
      DO 30 J=1,63
   30     ISAVE(IPROD,J)=ISAVE(IPROD,J+1)
      ISAVE(IPROD,63)=ISLASH
    5 DO 20 I=1,8
         IF( ISAVE(IPROD,1).NE.IBLANK ) RETURN
          IF( IBUF(I,1).EQ.IBLANK ) GO TO 20
          DO 10 J=1,63
   10         ISAVE(IPROD,J)=ISAVE(IPROD,J+1)
          ISAVE(IPROD,64)=IBUF(I,1)
   20     CONTINUE
      IF(ISAVE(IPROD,1).NE.IBLANK) RETURN
   40 DO 50 J=1,63
   50     ISAVE(IPROD,J)=ISAVE(IPROD,J+1)
      ISAVE(IPROD,64)=IAND
      RETURN
      END
C*****************************
C
      SUBROUTINE XPLOT(FLFUSE,IBLOW)
      IMPLICIT INTEGER*1 (A-Z)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      LOGICAL FLFUSE(2,2)
      LOGICAL LFUSES(64,128),LORARY(2,128),LPOLAR(40),LBYPAS(40)
      COMMON /LFUSE/LFUSES,LORARY,LPOLAR,LBYPAS
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
C
      INTEGER*1  D(64),P(16),OR(2),F(2)
      INTEGER  IBLOW,I88PRO,I,K,J,IPROD
      DATA     DASH/'-'/,CROSS/'X'/,H/'H'/,L/'L'/
C
C     THIS SUBROUTINE DISPPALYS THE FUSEPLOT IN '-' AND 'X'
C     FORMAT. THE INPUT/FEEDBACK PINS ARE GROUPED IN 8. THE
C     PRODUCT TERMS ARE GROUPED IN 16 FOR EACH PAIR OF OUTPUTS.
C     NEXT TO THE FUSE PLOT IS INDICATED THE ORARRAY FUSE LINKS
C
      WRITE(POF,10) IPAL,INAME,(TITLE(I),I=1,79)
   10 FORMAT(/,' PAL40 V1.8C - ',3A1,5A1,' - ',79A1,//,
     1       '                111111 11112222 22222233 ',
     2       '33333333 44444444 44555555 55556666','    ',/,
     3       '     01234567 89012345 67890123 45678901 ',
     4       '23456789 01234567 89012345 67890123','  ','01')
      F(1)=CROSS
      F(2)=CROSS
      IF(FLFUSE(1,2)) F(1)=DASH
      IF(FLFUSE(2,2)) F(2)=DASH
      IF(FLFUSE(1,2)) IBLOW=IBLOW+1
      IF(FLFUSE(2,2)) IBLOW=IBLOW+1
      IPROD=0
      DO 30 J=1,128,16
      IF (POF .NE. CONOUT) WRITE (CONOUT,9001)
9001  FORMAT (1X,'.'$)
      DO 20 I=1,16
      COUNT=I-1
      IPROD=J+COUNT
      DO 5 K=1,64
      IF(LFUSES(K,IPROD)) D(K)=DASH
      IF(.NOT.LFUSES(K,IPROD)) D(K)=CROSS
    5 CONTINUE
      DO 6 K=1,2
      IF(LORARY(K,IPROD)) OR(K)=DASH
      IF(.NOT.LORARY(K,IPROD)) OR(K)=CROSS
    6 CONTINUE
      IPROD=IPROD-1
      WRITE(POF,15)IPROD,D,OR
   15 FORMAT(I4,8(1X,8A1),'  ',2A1)
   20 CONTINUE
      IPROD=0
      WRITE(POF,25)
   25 FORMAT(1X)
   30 CONTINUE
      WRITE(POF,35)
   35 FORMAT(1X)
      WRITE(POF,40)
   40 FORMAT(/,' OUTPIN POLARITY: ','   1111122233333',/,
     1         '                  ','7890123478901234')
      DO 45 I=17,24
      IF(LPOLAR(I)) P(I-16)=DASH
      IF(.NOT.LPOLAR(I))P(I-16)=CROSS
   45 CONTINUE
      DO 46 I=37,40
      IF(LPOLAR(I)) P(I-28)=DASH
      IF(.NOT.LPOLAR(I)) P(I-28)=CROSS
   46 CONTINUE
      DO 47 I=1,4
      IF(LPOLAR(I)) P(I+12)=DASH
      IF(.NOT.LPOLAR(I)) P(I+12)=CROSS
   47 CONTINUE
      WRITE(POF,50) P
   50 FORMAT(/,18X,16A1)
      WRITE(POF,52)
   52 FORMAT(/,' OUTPUT SET:   17-24   37-04')
      WRITE(POF,53) F
   53 FORMAT(' BYPAS FUSE:    ',A1,'        ',A1)  
      WRITE(POF,55) IBLOW
   55 FORMAT(//,' FUSES BLOWN: ',I6)
      RETURN
      END
C
C$$ Y4.FOR
C******************
C
C     THIS SUBROUTINE ALLOWS CUSTOMER CHANGES OF ARRAY SIZE
C     ALLOCATIONS & I/O UNIT NUMBERS WITHOUT RECOMPILING MAIN
C     PROGRAM - TO BE SUPPLIED TO ALL MMI CUSTOMERS
C
C     AUTHOR NICK SCHMITZ - 1/22/84
C
      SUBROUTINE IOINIT
      IMPLICIT INTEGER*1 (A-Z)
C
C     9000 CHARACTERS    MAX IN PAL DEFINITIONS FILE
C     300 LINES           MAX IN PAL DEFINITIONS FILE
C     80 CHARACTERS/LINE  MAX IN PAL DEFINITIONS FILE
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
C     I/O UNIT ASSIGNMENTS
C
      CONINP=1
      CONOUT=1
      FILINP=10
      FILOUT=11
C
      RETURN
      END
C***************
C
      SUBROUTINE INITLZ(INAME,ITYPE,IPCNT,IC,IL,IBLOW)
C     THIS SUBROUTINE INITIALIZIES VARIABLES AND MATCHES PAL PART
C     NUMBER WITH ITYPE
      IMPLICIT INTEGER*1 (A-Z)
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
C
      INTEGER*1 INAME(5),INFO(6),IPCNT(40)
      INTEGER I,J,IC,IL,IBLOW
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LMATCH,LXOR
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR
      LOGICAL LFUSES(64,128),LORARY(2,128),LPOLAR(40),LBYPAS(40)
      COMMON /LFUSE/LFUSES,LORARY,LPOLAR,LBYPAS
      DATA INFO
     1    /'3','2','R','1','6',1/
C
C     INITIALISE LPOLAR. ALL OUTPUTS ARE ASSUMED TO BE ACTIVE LOW
      DO 10 J=1,40
   10 LPOLAR(J)=.FALSE.
C     INITIALISE THE ORARRAY. THE ORARRAY IS ASSUMED TO BE CONNECTED
C     TO BOTH THE OUTPUTS OF A PARTICULAR PAIR. i.e. PRODUCT TERMS
C     1 TO 16 ARE CONNECTED TO PINS 7 AND 8.
      DO 15 J=1,128 
      DO 15 I=1,2
   15 LORARY(I,J)=.FALSE.
C     INITIALISE THE IPCNT ARRAY TO 0. AT START NO PRODUCT TERMS
C     ARE CONNECTED TO THE OUTPUTS      
      DO 20 I=1,40
   20 IPCNT(I)=0
C     INITIALIZE LFUSES ARRAY (FUSE ARRAY)
      DO 30 J=1,128
         DO 30 I=1,64
   30       LFUSES(I,J)=.FALSE.
C     INITIALIZE IBLOW (NUMBER OF FUSES BLOWN)
      IBLOW=0
      IPCTR=0
C     INITIALIZE IC AND IL (COLUMN AND LINE POINTERS)
      IC=0
      IL=1
C     INITIALIZE ITYPE (PAL PART TYPE)
      ITYPE=0
C     ITYPE IS ASSIGNED THE FOLLOWING VALUES FOR THESE PAL PART TYPES:
C     PAL32R16 =  1   
      LMATCH=.TRUE.    
      DO 40 I=1,5
   40    IF(INAME(I).NE.INFO(I)) LMATCH=.FALSE.
         IF(LMATCH) ITYPE=INFO(6)
         IF (LMATCH) GO TO 50
      IF(ITYPE.EQ.0) RETURN
   50 CALL INCR(IC,IL,FLFLAG)
      RETURN
      END
C
C***************
C
      SUBROUTINE GETSYM(LPHASE,ISYM,J,IC,IL,FLFLAG)
C     THIS SUBROUTINE GETS THE PIN NAME, / IF COMPLEMENT LOGIC, AND
C      THE FOLLOWING OPERATION SYMBOL IF ANY
      IMPLICIT INTEGER*1 (A-Z)
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
C
      INTEGER*1 ISYM(8,40)
      INTEGER I,IC,IL,J
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,
     1        FLFLAG,LPHASE(40)
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR
      DATA IBLANK/' '/
      IF( (LLEFT.OR.LAND.OR.LOR.OR.LEQUAL.OR.LRIGHT) ) 
     2  CALL INCR(IC,IL,FLFLAG)
      LPHASE(J)=(.NOT.LSLASH)
      IF(.NOT. LPHASE(J)) CALL INCR(IC,IL,FLFLAG)
      DO 20 I=1,8
   20     ISYM(I,J)=IBLANK
   25 DO 30 I=1,7
C
   30     ISYM(I,J)=ISYM(I+1,J)
      ISYM(8,J)=CPG(LOF(IL)+IC)
      CALL INCR(IC,IL,FLFLAG)
      IF( LLEFT.OR.LBLANK.OR.LAND.OR.LOR.OR.LRIGHT.OR.LEQUAL ) RETURN
      GO TO 25
      END
C
C**************
C
      SUBROUTINE INCR(IC,IL,FLFLAG)
C     THIS SUBROUTINE INCREMENTS COLUMN AND LINE POINTERS
C      BLANKS AND CHARACTERS AFTER ';' ARE IGNORED. IT ALSO SETS
C     A BYPAS FLAG TRUE IF THE OUTPUT IS BYPASED
      IMPLICIT INTEGER*1 (A-Z)
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
C
      INTEGER IC,IL
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,TAB,
     1        LXOR1,FLFLAG,LCOLON
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR
      COMMON /LUNIT/ PMS,POF,PDF
      DATA IBLANK/' '/,ILEFT/'('/,IAND/'*'/,IOR/'+'/,COMENT/';'/,
     1        ISLASH/'/'/,IEQUAL/'='/,IRIGHT/')'/,ICOLON/':'/,TAB/009/
C     INITIALLY THE OUTPUT IS ASSUMED TO BE BYPASED BY SETTING FLFLAG
C     TRUE
      FLFLAG=.TRUE.     
      LCOLON=.FALSE.
      LBLANK=.FALSE.
      LXOR=.FALSE.
      LXOR1=.FALSE.
   10 IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
      IF( IC.LE.LLN(IL).AND.CTMP.NE.COMENT ) GO TO 30
      IL=IL+1
      IC=0
      GO TO 10
   30 IF ((CTMP.NE.IBLANK).AND.(CTMP.NE.TAB)) GO TO 31
      LBLANK=.TRUE.
      GO TO 10
   31 IF(CTMP.NE.ICOLON) GO TO 32
      IF(LXOR) GO TO 33
C     IF THERE IS A COLON PRESENT LCOLON IS SET TRUE
      LCOLON=.TRUE.
      LXOR1=.TRUE.
      GO TO 10
   33 LOR=.TRUE.
      RETURN
   32 IF( .NOT.(CTMP.EQ.IOR.AND.(LXOR1)) ) GO TO 34
      LXOR=.TRUE.
      GO TO 10
   34 LLEFT =(CTMP.EQ.ILEFT)
      LAND  =(CTMP.EQ.IAND)
      LOR   =(CTMP.EQ.IOR)
      LSLASH=(CTMP.EQ.ISLASH)
      LEQUAL=(CTMP.EQ.IEQUAL)
      LRIGHT=(CTMP.EQ.IRIGHT)
C     IF THERE IS COLON AND EQUAL THEN FLFLAG IS RESET, INDICATING
C     THE PARTICULAR OUTPUT IS REGISTERED 
      IF((LCOLON).AND.(LEQUAL)) FLFLAG=.FALSE.
      RETURN
      END
C
C***************
C
      SUBROUTINE MATCH(IMATCH,IBUF,ISYM)
C
C      REWRITTEN FOR SPEED - NICK SCHMITZ - 2/16/84
C
C     THIS SUBROUTINE FINDS A MATCH BETWEEN THE PIN NAME IN THE EQUATION
C      AND THE PIN NAME IN THE PIN LIST OR FUNCTION TABLE PIN LIST
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 IBUF(8,40),ISYM(8,40)
      INTEGER I,J,IMATCH
      LOGICAL LMATCH
C
      J=0
5     J=J+1
      LMATCH=.TRUE.
      I=9
10    I=I-1
      IF (I .LE. 0) GOTO 30
      IF (IBUF(I,1).EQ.ISYM(I,J)) GOTO 10
      IF (J .LT. 40) GOTO 5
      IMATCH=0
      RETURN
C
   30 IMATCH=J
      RETURN
      END
C
C******************
C
      SUBROUTINE IXLATE(IINPUT,LPHASE,IMATCH,LBUF,ISYM,ITYPE)
C     THIS SUBROUTINE FINDS A MATCH BETWEEN INPUT PIN NUMBER AND
C      THE INPUT LINE NUMBER FOR A SPECIFIC PAL.  ADD 1 TO THE INPUT
C      LINE NUMBER IF THE PIN IS A COMPLEMENT
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 ITABLE(40),ISYM(8,40)
      INTEGER IMATCH
      LOGICAL LPHASE(40),LBUF(40)
C
      LOGICAL LFUSES(64,128),LORARY(2,128),LPOLAR(40),LBYPAS(40)
      COMMON /LFUSE/LFUSES,LORARY,LPOLAR,LBYPAS
      DATA    ITABLE/
     1 64,60,56,52,0,50,54,58,62,0,2,6,10,14,0,0,16,12,8,4,29,25,
     2 21,17,0,19,23,27,31,0,35,39,43,47,0,0,45,41,37,33/
      IBUBL=0
C     FINDING THE PROPER PIN REFERENCE IN THE FUSE ARRAY
C     IF THE PIN IS BYPASED THAN THERE SHOULD NOT BE
C     ANY FEEDBACK. IF THERE IS THAN REPORT ERROR
      IF(((IMATCH.GE.11.AND.IMATCH.LE.14).OR.(IMATCH.GE.17.AND.
     1  IMATCH.LE.20).OR.(IMATCH.GE.1.AND.IMATCH.LE.4).OR.
     2  (IMATCH.GE.6.AND.IMATCH.LE.9)).AND.
     3  (.NOT.LBYPAS(IMATCH))) GO TO 10
      IF(((IMATCH.GE.21.AND.IMATCH.LE.24).OR.(IMATCH.GE.26.AND.
     1  IMATCH.LE.29).OR.(IMATCH.GE.31.AND.IMATCH.LE.34).OR.
     2  (IMATCH.GE.37.AND.IMATCH.LE.40)).AND.
     3  (.NOT.LBYPAS(IMATCH))) GO TO 20
      WRITE(PMS,30)IMATCH
   30 FORMAT(/,' PIN SYMBOL  ',I2, ' IS BYPASED AND CANT HAVE',
     1         '  FEEDBACK')
      STOP
   10 IF(((LPHASE(IMATCH)).AND.(.NOT.LBUF(1))).OR.
     1   ((.NOT.LPHASE(IMATCH)).AND.(LBUF(1)))) IBUBL=-1
      GO TO 25
   20 IF(((LPHASE(IMATCH)).AND.(.NOT.LBUF(1))).OR.
     1   ((.NOT.LPHASE(IMATCH)).AND.(LBUF(1)))) IBUBL=1  
      GO TO 25
   25 IINPUT=ITABLE(IMATCH)+IBUBL
      RETURN
      END
C
C***************
C
      SUBROUTINE ECHO
C     THIS SUBROUTINE PRINTS THE PAL DESIGN SPECIFICATION INPUT FILE
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER IC,IL,J
C
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
C
      WRITE (POF,5) IPAL,INAME,(REST(J),J=1,71),
     1 (PATN(J),J=1,79),(TITLE(J),J=1,79),(COMP(J),J=1,79)
    5 FORMAT(/,1X,3A1,5A1,71A1,/,1X,79A1,/,1X,79A1,/,1X,79A1)
C
15    DO 200 IL=1,LNMAX
200   WRITE(POF,205) (CPG(IC),IC=(LOF(IL)+1),(LOF(IL)+LLN(IL)))
205   FORMAT (1X,79A1)
C
      RETURN
      END
C
C***************
C
      SUBROUTINE CAT
C     THIS SUBROUTINE PRINTS THE PALASM CATALOG
      IMPLICIT INTEGER*1 (A-Z)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      WRITE(PMS,10) 
   10 FORMAT(/,' MONOLITHIC MEMORIES 40-PIN PALASM VERSION 1.8C')
      WRITE(PMS,15) 7
   15 FORMAT(' (C) COPYRIGHT 1983 MONOLITHIC MEMORIES',A1)
      WRITE(PMS,20)
   20 FORMAT(/,'    ECHO (E)     - PRINTS THE PAL DESIGN SPECIFICATION',
     4       /,'    PINOUT (O)   - PRINTS THE PINOUT OF THE PAL',
     5       /,'    SIMULATE (S) - EXERCISES THE FUNCTION TABLE VECTORS',
     6       / '    TSTGEN (T)   - GENERATES TEST VECTORS')
      WRITE(PMS,30)
   30 FORMAT(  '    PLOT (P)     - PRINTS THE ENTIRE FUSE PLOT',
     1       /,'    JEDEC (J)    - GENERATES JEDEC PROGRAMMING FORMAT',
     6       /,'    CATALOG (C)  - PRINTS THE PALASM CATALOG',
     7       /,'    QUIT (Q)     - EXIT PALASM')
      RETURN
      END
C
C***************
C
      SUBROUTINE PINOUT
C     THIS SUBROUTINE PRINTS THE PINOUT OF THE PAL
      IMPLICIT INTEGER*1 (A-Z)
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
      INTEGER I,J,II,IC,IL
      INTEGER*1 PIN(20,40),IIN(8,2)
      DATA IBLANK/' '/,ISTAR/'*'/
      DO 10 J=1,40
          DO 5 I=1,20
    5         PIN(I,J)=IBLANK
C
   10 CONTINUE
   15 DO 25 J=1,2
          DO 20 I=1,8
   20         IIN(I,J)=IBLANK
   25 CONTINUE
      IIN(2,1)=IPAL(1)
      IIN(4,1)=IPAL(2)
      IIN(6,1)=IPAL(3)
      IIN(1,2)=INAME(1)
      IIN(3,2)=INAME(2)
      IIN(5,2)=INAME(3)
      IIN(7,2)=INAME(4)
      IIN(8,2)=INAME(5)
      J=0
      IL=0
   30 IC=0
      IL=IL+1
   35 IC=IC+1
   40 IF( IC.GT.LLN(IL) ) GO TO 30
      IF( CPG(LOF(IL)+IC).EQ.IBLANK ) GO TO 35
      J=J+1
      IF(J.GT.40) GO TO 60
      DO 55 I=1,20
          PIN(I,J)=CPG(LOF(IL)+IC)
          IC=IC+1
          IF( IC.GT.LLN(IL) ) GO TO 40
          IF( CPG(LOF(IL)+IC).EQ.IBLANK ) GO TO 40
   55     CONTINUE
   60 DO 75 J=1,20
          II=0
   65     II=II+1
          IF(II.EQ.21) GO TO 75
          IF( PIN(II,J).NE.IBLANK ) GO TO 65
          I=21
   70     I=I-1
          II=II-1
          PIN(I,J)=PIN(II,J)
          PIN(II,J)=IBLANK
          IF(II.NE.1) GO TO 70
   75 CONTINUE
      WRITE(POF,76) (TITLE(I),I=1,79)
   76 FORMAT(/,1X,79A1)
      WRITE(POF,78)
   78 FORMAT(/,1X,20X,14('*'),3X,14('*'),
     1       /,1X,20X,'*',13X,'*',1X,'*',13X,'*')
      JJ=40
      DO 88 J=1,20
C          WRITE(POF,82)
          WRITE(POF,81) (PIN(I,J),I=7,20),ISTAR,J,ISTAR,
     1         (IIN(I,1),I=1,8),ISTAR,JJ,ISTAR,(PIN(I,JJ),I=1,20)
   81     FORMAT(1X,14A1,3X,A1,I2,A1,11X,8A1,10X,A1,I2,A1,3X,20A1)
C          WRITE(POF,82)
   82     FORMAT(1X,17X,4('*'),29X,4('*'))
C
          WRITE(POF,84) ISTAR,(IIN(I,2),I=1,8),ISTAR
   84     FORMAT(1X,20X,A1,11X,8A1,10X,A1)
          DO 86 II=1,2
              DO 85 I=1,8
   85             IIN(I,II)=IBLANK
   86     CONTINUE
          JJ=JJ-1
   88 CONTINUE
      WRITE(POF,90)
   90 FORMAT(1X,20X,31('*'))
      RETURN
      END
C
C*****************************
C
      SUBROUTINE JEDEC(DOIT,FLFUSE)
C     THIS SUBROUTINE GENERATES THE JEDEC PROGRAMMING FORMAT WHICH IS
C      COMPATIBLE WITH THE DATA I/O PROGRAMMABLE LOGIC PAK (PLDS)
C
      IMPLICIT INTEGER*1 (A-Z)
      LOGICAL FLFUSE(2,2)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      INTEGER*1 IPBUF(64), IDECIO(4)
      INTEGER NT,NFUSE,NTEST,IADR,IPT,IINP,PINOUT,I,J,J1,J2,IGH,IMP
      LOGICAL LFUSES(64,128),LORARY(2,128),LPOLAR(40),LBYPAS(40)
      COMMON /LFUSE/LFUSES,LORARY,LPOLAR,LBYPAS
      INTEGER*1 TSTVEC(350,40),ANDAR(128,32)
      INTEGER*2 PARRY(350)
      LOGICAL LSA01(350,2)
      COMMON /TEST/ TSTVEC,LSA01,PARRY,ANDAR
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
C
      DATA ZERO/'0'/,ONE/'1'/,SOH/1/,STX/2/,ETX/3/,BEL/7/,STAR/'*'/
C
      IADR=0
      WRITE(PDF,10) BEL,BEL,SOH,STX
   10 FORMAT(1X,4A1)
C
      WRITE (PDF,5) IPAL,INAME,(REST(J),J=1,71),
     1 (PATN(J),J=1,79),(TITLE(J),J=1,79),(COMP(J),J=1,79)
    5 FORMAT(/,1X,3A1,5A1,71A1,/,1X,79A1,/,1X,79A1,/,1X,79A1)
      WRITE(PDF,11) 40
   11 FORMAT(1X,'*D22',I2,'*')
C
C     SECURITY FUSE CONDITION (DOIT)
      IF (DOIT) WRITE(PDF,101)
  101 FORMAT(1X,'G1*F0*')
      IF (.NOT.DOIT) WRITE(PDF,102)
  102 FORMAT(1X,'G0*F0*')
C
      DO 300 IPT=1,128
      IF (PDF .NE. CONOUT) WRITE (CONOUT,9001)
9001  FORMAT (1X,'.'$)
      NFUSE = 0
      DO 50 IINP=1,64
      NFUSE = NFUSE + 1
      IPBUF(NFUSE)=ZERO
      IF (LFUSES(IINP,IPT)) IPBUF(NFUSE)=ONE
   50 CONTINUE
C
      CALL ENCD(IDECIO,IADR)
      WRITE(PDF,201) IDECIO,(IPBUF(I),I=1,NFUSE)
  201 FORMAT(' L',4A1,1X,64A1,'*')
  250 IADR=IADR+NFUSE
  300 CONTINUE
C
C       OUTPUT POLARITY FUSES
C
      DO 3650 NFUSE=17,24
      IPBUF(NFUSE-16)=ZERO
3650  IF (LPOLAR(NFUSE)) IPBUF(NFUSE-16)=ONE
C
      DO 3660 NT=1,8
      NFUSE=NT+36
      IF(NT.GT.4) NFUSE=NT-4
      IPBUF(NT+8)=ZERO
3660  IF (LPOLAR(NFUSE)) IPBUF(NT+8)=ONE
      CALL ENCD(IDECIO,IADR)
      WRITE(PDF,2010) IDECIO,(IPBUF(I),I=1,16)
2010  FORMAT(' L',4A1,1X,16A1,'*')
      IADR=IADR+16
C
C     PRODUCT SHARING FUSES
C
      DO 510 IPT=0,127,16
      NFUSE = 0
      DO 500 IMP=1,16
      DO 450 IINP=1,2
      NFUSE = NFUSE + 1
      IPBUF(NFUSE)=ZERO
      IF (LORARY(IINP,IPT+IMP)) IPBUF(NFUSE)=ONE
450   CONTINUE
  500 CONTINUE
      CALL ENCD(IDECIO,IADR)
      WRITE(PDF,201) IDECIO,(IPBUF(I),I=1,NFUSE),STAR
      IADR=IADR+NFUSE
  510 CONTINUE
C
      DO 520 I=1,2
      IPBUF(I)=ZERO
      IF(FLFUSE(I,2)) IPBUF(I)=ONE
520   CONTINUE
      CALL ENCD(IDECIO,IADR)
      WRITE(PDF,525) IDECIO,(IPBUF(I),I=1,2)
525   FORMAT(' L',4A1,1X,2A1,'*')
C
C     TEST VECTORS
C
      CALL ENCD(IDECIO,IADR)
C      WRITE(PDF,410) IDECIO,(TSTVEC(I,J),I=1,20)
410   FORMAT(' V',4I1,1X,20A1,' *')
      WRITE(PDF,400) ETX
  400 FORMAT(1X,A1,'0000',/)
      RETURN
      END
C
C*****************************
C
      SUBROUTINE ENCD(IDECIO,IADDR)
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 ICNV(16),IDECIO(4)
      INTEGER J,IADDR,IDEC(4)
      DATA ICNV/'0','1','2','3','4','5','6','7','8','9',
     1  'A','B','C','D','E','F'/
C
      IDEC(4)=IADDR
      DO 100 J=4,2,-1
      IDEC(J-1)=IDEC(J)/10
      IDEC(J)=IDEC(J)-10*IDEC(J-1)
100   IDECIO(J)=ICNV(IDEC(J)+1)
      IDECIO(1)=ICNV(IDEC(1)+1)
      RETURN
      END
C
C**************************

$ 
100   IDECIO(J)=ICNV(IDEC(J)+1)
      IDECIO(1)=ICNV(IDEC(1)+1)
      RETURN
      END
C
C***********************