echo off
rem November 1987
rem BPLPL.BAT = PLPL V2.2 batch file for PC-DOS 2.0+
rem Batch file will process test vectors and perform simulation.
rem Modify this file to suit your application
if .%1==. goto usage
if not exist %1.pld goto nofile
if exist %1.int del %1.int
if exist %1.opt del %1.opt
if exist %1.jed del %1.jed
if exist %1.tst del %1.tst
if exist %1.sim del %1.sim
if exist %1.lst del %1.lst
if exist %1.wav del %1.wav
rem Start processing
echo Compiling [%1.pld] into [%1.int]
plc -i %1.pld -o %1.int -p
if errorlevel 1 goto plcerr
echo Optimizing [%1.int] into [%1.opt]
optimize -i %1.int -o %1.opt
if errorlevel 1 goto opterr
echo Generating JEDEC map [%1.jed] from [%1.opt]
jm -i %1.opt -l %1.lst -o %1.jed
if errorlevel 1 goto maperr
echo Looking for test vectors in [%1.pld]
testv -i %1.pld -o %1.tst
if errorlevel 1 goto novctr
echo Simulating [%1.jed] with vectors in [%1.tst]
sim -i %1.jed %1.tst -w %1.wav -o %1.sim
if errorlevel 1 goto simerr
rem Concatenate the test vector and JEDEC files
echo Combining [%1.jed] with [%1.tst]
jm -a %1.jed %1.tst
if errorlevel 1 goto caterr
goto status
:plcerr
echo Compilation error
goto batcherr
:opterr
echo Optimization error
goto batcherr
:maperr
echo JEDEC map generation error
goto batcherr
:simerr
echo Simulation error
goto batcherr
:caterr
echo Cannot concatenate the test vector and JEDEC files
goto batcherr
:novctr
echo No test vectors specified
echo [%1.pld] compiled
echo - Optimized File [%1.opt]
echo - Equation List  [%1.lst]
echo - JEDEC File     [%1.jed]
goto complete
:usage
echo BPLPL.BAT = PLPL V2.2 Batch program
echo        Usage: bplpl srcfile
echo SRCFILE must have extension [.PLD]
goto complete
:nofile
echo File [%1.pld] does not exist
goto complete
:batcherr
echo Batch processing terminated
goto complete
:status
echo [%1.pld] compiled
echo - Optimized File       [%1.opt]
echo - Equation List        [%1.lst]
echo - Simulation Results   [%1.sim]
echo - Waveform Output File [%1.wav]
echo - JEDEC File w/vectors [%1.jed]
:complete
echo on
