TITLE 'APEEL FILE: PEEL18CV8 CHANGE-OF-STATE INPUT PORT WITH INTERRUPT
DESIGNER: Robin Jigour, ICT
DATE: 9/4/87'

PEEL18CV8

"DESCRIPTION

"                      PEEL18CV8

"       Change-of-State Input Port with Interrupt
"                     ____  ____
"                    |    \/    |
"               CLK  { 1     20 }  Vcc
"                I0  { 2     19 }- D0
"                I1  { 3     18 }- D1
"                I2  { 4     17 }- D2       ( - = output )
"                I3  { 5     16 }- D3
"                I4  { 6     15 }- D4
"                I5  { 7     14 }- INTR
"                I6  { 8     13 }  /RD
"                I7  { 9     12 }  /CS
"               GND  {10     11 }  A0
"                    |__________|


" This application uses the PEEL18CV8 as an 8-bit input port
" of which 4 of its inputs can detect a change-of-state.
" When detected, the INTR output is set for interrupting a CPU.
" The state change is latched by four pseudo-buried registers
" which can be read by the CPU on D0-D3 as listed in the address
" table below.  Once read, unless another change has occurred,
" the INTR will be reset.  The D4 output can be used for status
" polling of any remaining state change.  The I4-7 inputs do not
" detect state changes but can be read as a standard input port.

" Address        Data Outputs
" -----------    ---------------------------------------
" A0  CS  RD     D0-3                D4
"  X   1   X     Hi-Z                Hi-Z
"  X   X   1     Hi-Z                Hi-Z
"  0   0   0     Read I0-I3 Change   I0-I3 Pending Change Status
"  1   0   0     Read I4-I7 Inputs   Don't care


"PIN DEFINITIONS"

"Inputs"

CLK      pin 1   "Must be connected to pin 14, INTR.
I0       pin 2   "I0-I3 inputs can detect change-of-state.
I1       pin 3
I2       pin 4
I3       pin 5
I4       pin 6   "I4-I7 are standard inputs.
I5       pin 7
I6       pin 8
I7       pin 9
A0       pin 11
!CS      pin 12  "Use as inputs only.
!RD      pin 13  "Default macro configuration = pos com feed_pin.


"Outputs"

INTR     pin 14 = pos com feed_or
D4       pin 15 = pos com feed_or   "Internal feedback.
D3       pin 16 = pos com feed_reg
D2       pin 17 = pos com feed_reg
D1       pin 18 = pos com feed_reg
D0       pin 19 = pos com feed_reg  "Pseudo buried registers.


EQUATIONS

D0 = I0 & !CS #               "I0 to D0 register.
     I0 &  CS & !RD #         "I0 to D0 register.
     D0 &  CS & RD & !A0 #    "Read D0 register.
     I4 &  CS & RD & A0       "Read I4.
     Enable D0 = CS & RD      "Enable onto data bus.

D1 = I1 & !CS #               "I1 to D1 register.
     I1 &  CS & !RD #         "I1 to D1 register.
     D1 &  CS & RD & !A0 #    "Read D1 register.
     I5 &  CS & RD &  A0      "Read I5.
     Enable D1 = CS & RD      "Enable onto data-bus.

D2 = I2 & !CS #               "I2 to D2 register.
     I2 &  CS & !RD #         "I2 to D2 register.
     D2 &  CS & RD & !A0 #    "Read D2 register.
     I6 &  CS & RD &  A0      "Read I6.
     Enable D2 = CS & RD      "Enable onto data-bus.

D3 = I3 & !CS #               "I3 to D3 register.
     I3 &  CS & !RD #         "I3 to D3 register.
     D3 &  CS &  RD & !A0 #   "Read D3 register.
     I7 &  CS &  RD &  A0     "Read I7.
     Enable D3 = CS & RD      "Enable onto data-bus.

D4 = I0 & !D0 # !I0 & D0 #    "Compare I0-3 with D0-3 registers.
     I1 & !D1 # !I1 & D1 #    "D4=1 if I0-3 and D0-3 are not equal.
     I2 & !D2 # !I2 & D2 #
     I3 & !D3 # !I3 & D3
     Enable D4 = CS & RD      "Enable onto data-bus for status.

INTR = D4   & !CS #  "Latch not-equal status uP interrupt and
       D4   & !RD #  "PEEL clock. Clear interrupt when registers
       D4   &  A0 #  "are read and there are no more input state
       INTR & !CS #  "changes, that is, when D4, CS, RD and A0
       INTR & !RD #  "are all 0.
       INTR &  A0


TEST_VECTORS "Test change-of-state input port I0-4 operation"

(  CLK  I0 I1 I2 I3  A0  CS  RD   ->   D0 D1 D2 D3  D4  INTR  )
     0   0  0  0  0   X   0   X   ->    Z  Z  Z  Z   Z    0
     0   0  0  0  0   0   1   1   ->    X  X  X  X   0    0
     0   1  0  0  0   X   0   0   ->    Z  Z  Z  Z   Z    H
     1   1  0  0  0   X   0   0   ->    Z  Z  Z  Z   Z    H
     1   1  0  0  0   0   1   0   ->    Z  Z  Z  Z   Z    H
     1   1  0  0  0   0   1   1   ->    H  L  L  L   L    L
     0   1  0  0  0   0   1   1   ->    H  L  L  L   L    L
     0   1  0  0  0   X   0   X   ->    Z  Z  Z  Z   Z    L
     0   0  0  0  0   X   0   0   ->    Z  Z  Z  Z   Z    H
     1   0  0  0  0   X   0   0   ->    Z  Z  Z  Z   Z    H
     1   0  0  0  0   0   1   0   ->    Z  Z  Z  Z   Z    H
     1   0  0  0  0   0   1   1   ->    L  L  L  L   L    L
     0   0  0  0  0   X   0   X   ->    Z  Z  Z  Z   Z    L
     0   1  0  0  0   X   0   X   ->    Z  Z  Z  Z   Z    H
     1   1  0  0  0   X   0   X   ->    Z  Z  Z  Z   Z    H
     1   1  1  1  1   X   0   0   ->    Z  Z  Z  Z   Z    H
     1   1  1  1  1   0   1   0   ->    Z  Z  Z  Z   Z    H
     1   1  1  1  1   0   1   1   ->    H  L  L  L   H    L
     0   1  1  1  1   X   0   0   ->    Z  Z  Z  Z   Z    H
     1   1  1  1  1   0   1   0   ->    Z  Z  Z  Z   Z    H
     1   1  1  1  1   0   1   1   ->    H  H  H  H   L    L
     0   1  1  1  1   X   0   X   ->    Z  Z  Z  Z   Z    L
     0   0  0  0  0   X   0   X   ->    Z  Z  Z  Z   Z    H
     1   0  0  0  0   X   0   X   ->    Z  Z  Z  Z   Z    H
     1   0  0  0  0   0   1   1   ->    L  L  L  L   L    L
     1   0  0  0  0   X   0   X   ->    Z  Z  Z  Z   Z    L


TEST_VECTORS "Test standard input port I4-7 operation"

( CLK  I4 I5 I6 I7  A0  CS  RD   ->   D0 D1 D2 D3  D4  INTR  )
   0    1  0  1  0   1   0   0   ->    Z  Z  Z  Z   Z    X
   0    1  0  1  0   1   1   0   ->    Z  Z  Z  Z   Z    X
   0    1  0  1  0   1   1   1   ->    H  L  H  L   X    X
   0    0  1  0  1   1   1   0   ->    Z  Z  Z  Z   Z    X
   0    0  1  0  1   1   1   1   ->    L  H  L  H   X    X
   0    0  1  0  1   1   0   0   ->    Z  Z  Z  Z   Z    X
                                                                                                              