TITLE 'APEEL FILE: PEEL18CV8 EXPANADABLE 8-BIT (DUAL 4-BIT) COMPARATOR
DESIGNER: Robin Jigour and James Khong
DATE: 9/13/87'

PEEL18CV8

"DESCRIPTION"

"                     PEEL18CV8

"       Expanadable 8-Bit (or Dual 4-Bit) Comparitor
"                     ____  ____
"                    |    \/    |
"                A0  { 1     20 }  Vcc
"                A1  { 2     19 }- B_EQ_D   ( - = output )
"                A2  { 3     18 }- A_EQ_C
"                A3  { 4     17 }  D3
"                B0  { 5     16 }  D2
"                B1  { 6     15 }  D1
"                B2  { 7     14 }  D0
"                B3  { 8     13 }  C3
"                C0  { 9     12 }  C2
"               Gnd  {10     11 }  C1
"                    |__________|


" This application uses the PEEL18CV8 as an expanadable 8-bit
" (or dual 4-bit) comparator. The inputs are organized into four
" 4-bit groups and are labeled A0-A3, B0-B3, C0-C3, and D0-D3.
" The comparison is done between inputs A and C, and inputs B and D.
" As an 8-bit comparator, both outputs must be tied together with a
" resistor pull-up (2-20K depending on system speed requirements).
" If the comparison is equal, the outputs will disable, allowing the
" resistor to pull the output high.  If the comparison of is not equal
" an output will be asserted low pulling both outputs low.

" The application utilizes the individual output enables and internal
" feedback capability of the 18CV8 macro cell to allow expandability.
" (configuration 7 in figure 6 of the PEEL18CV8 data sheet). This
" configuration is used to implement a wired-or function (actually
" an AND function in this case) allowing additional comparators outputs
" to be tied together. Thus, two 18CV8s could create a 16 bit comparitor,
" three a 24 bit comparitor, and so on.  A dual 4-bit comparator can be
" achieved by using two pull-up resistors (one resistor for each output).
" Note, if expanadability is not needed, the pull-up resistors can be
" removed for the dual 4-bit comparitor by permanantly enabling the
" outputs.


"PIN DEFINITIONS"

"Inputs"

A0       pin 1
A1       pin 2
A2       pin 3
A3       pin 4
B0       pin 5
B1       pin 6
B2       pin 7
B3       pin 8
C0       pin 9
C1       pin 11
C2       pin 12                        "Use as inputs only.
C3       pin 13                        "Pins 12-17 macro configurations
D0       pin 14                        "are defaulted to 'pos com feed_pin'.
D1       pin 15
D2       pin 16
D3       pin 17


"Outputs Macro Cell definitions

A_EQ_C   pin 18 = neg com feed_or      "Internal feedback.
B_EQ_D   pin 19 = neg com feed_or


EQUATIONS

A_EQ_C = !( !A0 & C0  #  A0 & !C0 #     "Compare A0-3 and C0-3,
            !A1 & C1  #  A1 & !C1 #     "when A does not = C then
            !A2 & C2  #  A2 & !C2 #     "A_EQ_C is 0.
            !A3 & C3  #  A3 & !C3 )

Enable A_EQ_C = !A_EQ_C                 "Enable when A does not = C.
                                       "Disable when A = C.

B_EQ_D = !( !B0 & D0  #  B0 & !D0 #     "Compare B0-3 and D0-3.
           !B1 & D1  #  B1 & !D1 #     "When B does not = D then
           !B2 & D2  #  B2 & !D2 #     "B_EQ_D is 0
           !B3 & D3  #  B3 & !D3 )

Enable B_EQ_D = !B_EQ_D                 "Enable when B does not = D.
                                       "Disable when B = D.


TEST_VECTORS

(  A3 A2 A1 A0  C3 C2 C1 C0   ->   A_EQ_C  )
   0  0  0  0   0  0  0  0    ->      Z
   0  0  0  1   0  0  0  0    ->      L
   0  0  1  0   0  0  1  0    ->      Z
   0  0  1  1   0  0  1  0    ->      L
   0  1  0  0   0  1  0  0    ->      Z
   0  1  0  1   0  1  0  0    ->      L
   0  1  1  0   0  1  1  0    ->      Z
   0  1  1  1   0  1  1  0    ->      L
   1  0  0  0   1  0  0  0    ->      Z
   1  0  0  1   1  0  0  0    ->      L
   1  0  1  0   1  0  1  0    ->      Z
   1  0  1  1   1  0  1  0    ->      L
   1  1  0  0   1  1  0  0    ->      Z
   1  1  0  1   1  1  0  0    ->      L
   1  1  1  0   1  1  1  0    ->      Z
   1  1  1  1   1  1  1  0    ->      L
   1  1  1  1   1  1  1  1    ->      Z


TEST_VECTORS

(  B0 B1 B2 B3  D0 D1 D2 D3   ->   B_EQ_D  )
   0  0  0  0   0  0  0  0    ->      Z
   0  0  0  1   0  0  0  0    ->      L
   0  0  1  0   0  0  1  0    ->      Z
   0  0  1  1   0  0  1  0    ->      L
   0  1  0  0   0  1  0  0    ->      Z
   0  1  0  1   0  1  0  0    ->      L
   0  1  1  0   0  1  1  0    ->      Z
   0  1  1  1   0  1  1  0    ->      L
   1  0  0  0   1  0  0  0    ->      Z
   1  0  0  1   1  0  0  0    ->      L
   1  0  1  0   1  0  1  0    ->      Z
   1  0  1  1   1  0  1  0    ->      L
   1  1  0  0   1  1  0  0    ->      Z
   1  1  0  1   1  1  0  0    ->      L
   1  1  1  0   1  1  1  0    ->      Z
   1  1  1  1   1  1  1  0    ->      L
   1  1  1  1   1  1  1  1    ->      Z