TITLE 'APEEL FILE: PEEL18CV8 BUS PROGRAMMBLE 8 TO 1 MUX
DESIGNER: Robin Jigour
DATE: 9/13/87'

PEEL18CV8

"DESCRIPTION"

"                      PEEL18CV8

"          Bus Programmble 8 to 1 Multiplexer
"                     ____  ____
"                    |    \/    |
"                I0  { 1     20 }  Vcc
"                I1  { 2     19 }  I5
"                I2  { 3     18 }  I6
"                I3  { 4     17 }  I7
"                I4  { 5     16 }- OUT     ( - = output )
"               DI0  { 6     15 }- DO0
"               DI1  { 7     14 }- DO1
"               DI2  { 8     13 }- DO2
"               /WR  { 9     12 }  /RD
"               Gnd  {10     11 }  /CS
"                    |__________|


"This application implements an 8 to 1 multiplexor that can be
"interfaced to a uP bus.  Any one of the 8 inputs (I0-7) can be
"selectively routed to the output (OUT) by writing (/WR and /CS =0)
"a 3-bit binary value to the data inputs (DI0-2). The value is
"stored into a 3-bit latch that controls the multiplexer selection.
"Because the latch utilizes internal asynchronous feedback (macro
"configuration #8), the value can also be enabled onto the data
"outputs (DO0-2). The DI and DO (0-2) pins should be tied together
"for write/read bus operation. The truth table for the mux is
"depicted via the test vectors.


"PIN DEFINITIONS"

"Inputs"

I0        pin 1
I1        pin 2
I2        pin 3
I3        pin 4
I4        pin 5
DI0       pin 6
DI1       pin 7
DI2       pin 8
!WR       pin 9
!CS       pin 11
!RD       pin 12                     "Use as inputs only.
I7        pin 17                     "Pins 12, 17-19 macro configurations are
I6        pin 18                     "defaulted to 'pos com feed_pin'.
I5        pin 19


"Outputs and Macro Cell definitions

DO2       pin 13 = pos com feed_or    "Internal feedback from the input of
DO1       pin 14 = pos com feed_or    "the D flip-flop.
DO0       pin 15 = pos com feed_or
MOUT      pin 16 = pos com feed_pin


EQUATIONS

DO0 = DI0 & WR & CS #         "Set D0 latch from bus write.
      DO0 & !WR #             "Hold when not selected.
      DO0 & !CS #
      DI0 & DO0               "Prevent hazard.
Enable DO0 = RD & CS          "Enable D0 output with bus read.

DO1 = DI1 & WR & CS #         "Set D1 latch from bus write.
      DO1 & !WR #             "Hold when not selected.
      DO1 & !CS #
      DI1 & DO1               "Prevent hazard.
Enable DO1 = RD & CS          "Enable D1 output with bus read.

DO2 = DI2 & WR & CS #         "Set D2 latch from bus write.
      DO2 & !WR #             "Hold when not selected.
      DO2 & !CS #
      DI2 & DO2               "Prevent hazard.
Enable DO2 = RD & CS          "Enable D2 output with bus read.

MOUT = I0 & !DO2 & !DO1 & !DO0 #   "Select I0 when D0-2 = 0
       I1 & !DO2 & !DO1 &  DO0 #   "Select I1 when D0-2 = 1
       I2 & !DO2 &  DO1 & !DO0 #   "Select I2 when D0-2 = 2
       I3 & !DO2 &  DO1 &  DO0 #   "Select I3 when D0-2 = 3
       I4 &  DO2 & !DO1 & !DO0 #   "Select I4 when D0-2 = 4
       I5 &  DO2 & !DO1 &  DO0 #   "Select I5 when D0-2 = 5
       I6 &  DO2 &  DO1 & !DO0 #   "Select I6 when D0-2 = 6
       I7 &  DO2 &  DO1 &  DO0     "Select I7 when D0-2 = 7


TEST_VECTORS "Test programmable 8 to 1 mux"

( I0 I1 I2 I3 I4 I5 I6 I7  DI2 DI1 DI0  CS WR RD   ->  DO2 DO1 DO0 MOUT )
   1  0  0  0  0  0  0  0    0   0   0   1  1  0   ->    Z   Z   Z   H
   1  0  0  0  0  0  0  0    0   0   0   0  0  0   ->    Z   Z   Z   H
   0  0  0  0  0  0  0  0    X   X   X   0  0  0   ->    Z   Z   Z   L
   1  0  0  0  0  0  0  0    X   X   X   1  0  1   ->    L   L   L   H

   0  0  1  0  0  0  0  0    0   1   0   1  1  0   ->    Z   Z   Z   H
   0  0  1  0  0  0  0  0    0   1   0   0  0  0   ->    Z   Z   Z   H
   0  0  0  0  0  0  0  0    X   X   X   0  0  0   ->    Z   Z   Z   L
   0  0  1  0  0  0  0  0    X   X   X   1  0  1   ->    L   H   L   H

   0  0  0  0  0  1  0  0    1   0   1   1  1  0   ->    Z   Z   Z   H
   0  0  0  0  0  1  0  0    1   0   1   0  0  0   ->    Z   Z   Z   H
   0  0  0  0  0  0  0  0    X   X   X   0  0  0   ->    Z   Z   Z   L
   0  0  0  0  0  1  0  0    X   X   X   1  0  1   ->    H   L   H   H

   0  0  0  0  0  0  0  1    1   1   1   1  1  0   ->    Z   Z   Z   H
   0  0  0  0  0  0  0  1    1   1   1   0  0  0   ->    Z   Z   Z   H
   0  0  0  0  0  0  0  0    X   X   X   0  0  0   ->    Z   Z   Z   L
   0  0  0  0  0  0  0  1    X   X   X   1  0  1   ->    H   H   H   H