TITLE 'APEEL FILE: PEEL173 16 TO 4 PRIORITY ENCODER
DESIGNER: Robin Jigour, ICT
DATE: 10/15/87'

PEEL173

"DESCRIPTION"

"                       PEEL173
"               16 To 4 Priority Encoder
"                     ____  ____
"                    |    \/    |
"                D0  { 1     24 }  Vcc
"                D1  { 2     23 }- GS      (- = output)
"                D2  { 3     22 }- E3
"                D3  { 4     21 }- E2
"                D4  { 5     20 }- E1
"                D5  { 6     19 }- E0
"                D6  { 7     18 }  OE
"                D7  { 8     17 }  DF
"                D8  { 9     16 }  DE
"                D9  {10     15 }  DD
"                DA  {11     14 }  DC
"               Gnd  {12     13 }  DB
"                    |__________|

" This PEEL173 application implements a 16 to 4 priority encoder with
" high-impedence outputs. If any D0-DF input goes low, the GS (group
" strobe) output will go high and the binary value of the highest
" priority input will be placed on the E0-E3 (Encoded) outputs when
" enabled by OE (output enable). The D0 input is highest priority and
" DF lowest.

" When the E0-E3 outputs are disabled (a function of OE or !GS) they
" assume a high-impedance state. This makes it possible to interface the
" encoded  outputs onto a system bus where GS might serve as an interrupt
" line to a uP and OE as the chip select. The high-impedence control also
" allows multiple PEEL173 priority encoders to be bussed together for
" creating wider (32, 48 or 64 bit etc.) priority encoders. To add
" additional encoders, the highest priority OE must be tied low, and the
" GS must control the next highest priority OE. The multiple GS can be
" further encoded to identify which device is driving the E0-E3 lines.


"PIN DEFINITIONS"

"Inputs"

D0       pin  1
D1       pin  2
D2       pin  3
D3       pin  4
D4       pin  5
D5       pin  6
D6       pin  7
D7       pin  8
D8       pin  9
D9       pin 10
DA       pin 11
DB       pin 13
DC       pin 14           "Pins 14-18, default polarity = pos.
DD       pin 15
DE       pin 16
DF       pin 17
OE       pin 18


"Outputs

E0       pin 19 = pos
E1       pin 20 = pos
E2       pin 21 = pos
E3       pin 22 = pos
GS       pin 23 = neg


EQUATIONS

GS = !(D0 & D1 & D2 & D3 & D4 & D5 & D6 & D7 & D8 & D9 & DA & DB & DC & DD & DE & DF)

E0 = D0 & !D1 #
     D0 & D1 & D2 & !D3 #
     D0 & D1 & D2 & D3 & D4 & !D5 #
     D0 & D1 & D2 & D3 & D4 & D5 & D6 & !D7 #
     D0 & D1 & D2 & D3 & D4 & D5 & D6 & D7 & D8 & !D9 #
     D0 & D1 & D2 & D3 & D4 & D5 & D6 & D7 & D8 & D9 & DA & !DB #
     D0 & D1 & D2 & D3 & D4 & D5 & D6 & D7 & D8 & D9 & DA & DB & DC & !DD #
     D0 & D1 & D2 & D3 & D4 & D5 & D6 & D7 & D8 & D9 & DA & DB & DC & DD & DE
Enable E0 = !OE & GS

E1 = D0 & D1 & !D2 #
     D0 & D1 & D2 & !D3 #
     D0 & D1 & D2 & D3 & D4 & D5 & !D6 #
     D0 & D1 & D2 & D3 & D4 & D5 & D6 & !D7 #
     D0 & D1 & D2 & D3 & D4 & D5 & D6 & D7 & D8 & D9 & !DA #
     D0 & D1 & D2 & D3 & D4 & D5 & D6 & D7 & D8 & D9 & DA & !DB #
     D0 & D1 & D2 & D3 & D4 & D5 & D6 & D7 & D8 & D9 & DA & DB & DC & DD
Enable E1 = !OE & GS

E2 = D0 & D1 & D2 & D3 & !D4 #
     D0 & D1 & D2 & D3 & D4 & !D5 #
     D0 & D1 & D2 & D3 & D4 & D5 & !D6 #
     D0 & D1 & D2 & D3 & D4 & D5 & D6 & !D7 #
     D0 & D1 & D2 & D3 & D4 & D5 & D6 & D7 & D8 & D9 & DA & DB
Enable E2 = !OE & GS

E3 = D0 & D1 & D2 & D3 & D4 & D5 & D6 & D7
Enable E3 = !OE & GS


TEST_VECTORS

( D0 D1 D2 D3 D4 D5 D6 D7 D8 D9 DA DB DC DD DE DF OE -> E3 E2 E1 E0  GS  )
   1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  0 ->  Z  Z  Z  Z   L
   1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1 ->  Z  Z  Z  Z   L
   0  X  X  X  X  X  X  X  X  X  X  X  X  X  X  X  0 ->  L  L  L  L   H
   1  0  X  X  X  X  X  X  X  X  X  X  X  X  X  X  0 ->  L  L  L  H   H
   1  1  0  X  X  X  X  X  X  X  X  X  X  X  X  X  0 ->  L  L  H  L   H
   1  1  1  0  X  X  X  X  X  X  X  X  X  X  X  X  0 ->  L  L  H  H   H
   1  1  1  1  0  X  X  X  X  X  X  X  X  X  X  X  0 ->  L  H  L  L   H
   1  1  1  1  1  0  X  X  X  X  X  X  X  X  X  X  0 ->  L  H  L  H   H
   1  1  1  1  1  1  0  X  X  X  X  X  X  X  X  X  0 ->  L  H  H  L   H
   1  1  1  1  1  1  1  0  X  X  X  X  X  X  X  X  0 ->  L  H  H  H   H
   1  1  1  1  1  1  1  1  0  X  X  X  X  X  X  X  0 ->  H  L  L  L   H
   1  1  1  1  1  1  1  1  1  0  X  X  X  X  X  X  0 ->  H  L  L  H   H
   1  1  1  1  1  1  1  1  1  1  0  X  X  X  X  X  0 ->  H  L  H  L   H
   1  1  1  1  1  1  1  1  1  1  1  0  X  X  X  X  0 ->  H  L  H  H   H
   1  1  1  1  1  1  1  1  1  1  1  1  0  X  X  X  0 ->  H  H  L  L   H
   1  1  1  1  1  1  1  1  1  1  1  1  1  0  X  X  0 ->  H  H  L  H   H
   1  1  1  1  1  1  1  1  1  1  1  1  1  1  0  X  0 ->  H  H  H  L   H
   1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  0  0 ->  H  H  H  H   H
   1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  0 ->  Z  Z  Z  Z   L
                                                                                                                     