;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Filename	: SMPL_18.ASM
; Description	: Sample PnP Resource data file for NM95MS18
; Date		: Jun 01, 1997
; Revision date	: 
; Device	: NM95MS18
; Author	: Fairchild Semiconductor Corp
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note: 
;	This file is constructed in x86 Assembly language format. Common 
; 	assembly language compiler like MASM as well as any other C language 
; 	compiler can compile this file. When using MASM, typical sequence 
;	would be to
; 	1) Compile this file using MASM.EXE
; 	2) Link the Object file using LINK.EXE. This will produce "EXE" 
;	   version.
; 	3) Convert the "EXE" version to "BIN" version using DOS utility called
;    	   EXE2BIN.EXE.
; 	4) Program the "BIN" version of the file on to NM95MS18 using Fairchild
;    	   supplied programming utility "MS18V1.EXE". Also read MS18V1.TXT
;	   for proper syntax.
; 	5) Once the programming is done, run ISOLATE.EXE utility. If everything
;    	   went well, this will successfully detect a Plug and Play Card !!
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;----------------------------------------------------------------------------
;------------------- NM95MS18 USER GUIDE INFORMATION ------------------------
;----------------------------------------------------------------------------
;       word    byte    purpose                         
;       address address 16-bit Register
;       00      0000    I/O Decode Qualification Bits <--- Added definitions
;       01      0002    DMA Level Selection Bits
;       02      0004    Interrupt Level Selection-A
;       03      0006    Interrupt Level Selection-B
;       04      0008    Chip Select 0 Decode Size
;       05      000A    Chip Select 1 Decode Size
;       06      000C    Chip Select 2 Decode Size
;       07      000E    Reserved for Future Use  
;       08      0010    IRQ Type Register      < ----- New Register added 
;       09      0012    Reserved for Future Use
;       0A      0014    Reserved for Future Use
;       0B      0016    Reserved for Future Use
;       0c      0018    Reserved for Future Use
;       0D      001A    Reserved for Future Use
;       0E      001C    Reserved for Future Use
;       0F      001E    Reserved for Future Use
;       10      0020    Vendor ID
;       11      0022    Vendor ID
;       12      0024    Serial Number
;       13      0026    Serial Number
;       14(LSB) 0028    LSB = Checksum of
;                       (Vendor ID + Serial Number)
;       14(MSB) 0029    MSB = Start of Resource Data
;                       Structure
;----------------------------------------------------------------------------


data segment

;Configuration related to NM95MS18 for resource allocation

;----------------------------------------------------------------------------
; 			I/O DECODE QUALIFICATION REGISTER
;----------------------------------------------------------------------------
; Bit[15-13] are defined in NM95MS18, while they are Reserved in NM95MS14
; and NM95MS16.

; Bit[15]       WRITE-PROTECT bit
;		0 --> Write protects entire internal memory ( PnP + N_PnP )
;		1 --> Write protection disabled.
; Bit[14]  	"Wire-OR" enable for IOCS2 with IOCS0
;		1 --> Enable  "Wire-OR" of IOCS2 with IOCS0
;		0 --> Disable "Wire-OR" of IOCS2 with IOCS0
; Bit[13]  	"Wire-OR" enable for IOCS1 with IOCS0
;		1 --> Enable  "Wire-OR" of IOCS1 with IOCS0
;		0 --> Disable "Wire-OR" of IOCS1 with IOCS0
; Bit[12-10]	( Reserved. Must be 0 ) 
; Bit[9-8]      Mode Select bits
;		00 --> DMA Mode
;		01 --> Extended Interrupt Mode
;		10 and 11 --> Illegal values !!
;
; Bit[7-3]	( Reserved. Must be 0 ) 
;
; Bit[2]  	Read-Write-Qualifier for IOCS2 signal
;		0 --> IOCS2 signal will be generated of address bus and also
;		      qualified with "/IORD" and "/IOWR" signals from ISA bus
;		1 --> IOCS2 signal will be generated of address bus only !!
    
; Bit[1]  	Read-Write-Qualifier for IOCS1 signal
;		0 --> IOCS1 signal will be generated of address bus and also
;		      qualified with "/IORD" and "/IOWR" signals from ISA bus
;		1 --> IOCS1 signal will be generated of address bus only !!

; Bit[0]  	Read-Write-Qualifier for IOCS0 signal
;		0 --> IOCS0 signal will be generated of address bus and also
;		      qualified with "/IORD" and "/IOWR" signals from ISA bus
;		1 --> IOCS0 signal will be generated of address bus only !!
;----------------------------------------------------------------------------


db 00h		; In this example the following are assumed.
	        ; All the three I/O Chip selects are by address and 
		; qualified by IOWR&IORD

db 81h          ; Write-Protection disabled
		; "Wire-OR" ing disabled for both IOCS2 and IOCS1
		; Mode --> Extended Interrupt mode.

;------------------------------------------------------------------------
; 			DMA LEVEL SELECTION REGISTER
;              ( This register is valid only in DMA Mode !!! ). 
;------------------------------------------------------------------------

; Bit[15-8]    ( Reserved. Must be 0 ) 
; Bit[7-5]      These bits specify the ISA DMA Channel connected to 
;		"ISADRQ1" pin of NM95MS18 

;		000 --> ISA DRQ0 is connected to ISADRQ1 pin
;		001 --> ISA DRQ1 is connected to ISADRQ1 pin
;		010 --> ISA DRQ2 is connected to ISADRQ1 pin
;		011 --> ISA DRQ3 is connected to ISADRQ1 pin
;		100 --> No DMA channel is connected to ISADRQ1 pin
;		101 --> ISA DRQ5 is connected to ISADRQ1 pin
;		110 --> ISA DRQ6 is connected to ISADRQ1 pin
;		111 --> ISA DRQ7 is connected to ISADRQ1 pin

; Bit[4-3]	( Reserved. Must be 0 ) 

; Bit[2-0]      These bits specify the ISA DMA Channel connected to 
;		"ISADRQ0" pin of NM95MS18 
;		000 --> ISA DRQ0 is connected to ISADRQ0 pin
;		001 --> ISA DRQ1 is connected to ISADRQ0 pin
;		010 --> ISA DRQ2 is connected to ISADRQ0 pin
;		011 --> ISA DRQ3 is connected to ISADRQ0 pin
;		100 --> No DMA channel is connected to ISADRQ0 pin
;		101 --> ISA DRQ5 is connected to ISADRQ0 pin
;		110 --> ISA DRQ6 is connected to ISADRQ0 pin
;		111 --> ISA DRQ7 is connected to ISADRQ0 pin
;----------------------------------------------------------------------

dw 00e5h        ; In this example 
		; ISA DMA Channel 7 is connected to ISADRQ1 pin
		; ISA DMA Channel 5 is connected to ISADRQ0 pin

;---------------------------------------------------------------------
;		INTERRUPT LEVEL SELECTION REGISTER -- A
;----------------------------------------------------------------------
; Bit[15-12]	These bits specify the ISA IRQ channel connected to 
;		"IRQOUT3" pin of NM95MS18. Possible bit values are
;		"0001" through "1111". Setting "0000" implies no 
;		channel is selected !!!
;		For example if the bit values are 
;		0100 --> IRQ4 is connected to IRQOUT3 pin
;		1100 --> IRQ12 is connected to IRQOUT3 pin
; Bit[11-8]	These bits specify the ISA IRQ channel connected to 
;		"IRQOUT2" pin of NM95MS18.
; Bit[7-4]	These bits specify the ISA IRQ channel connected to 
;		"IRQOUT1" pin of NM95MS18.
; Bit[3-0]	These bits specify the ISA IRQ channel connected to 
;		"IRQOUT0" pin of NM95MS18.
;-----------------------------------------------------------------------

dw 0A5C9h	; In this example following ISA interrupts 10,5,12 and 9
		; are selected ( connected ) for IRQOUT3, IRQOUT2, 
		; IRQOUT1 and IRQOUT0 pins respectively.

;----------------------------------------------------------------------
;		INTERRUPT LEVEL SELECTION REGISTER -- B
;            (  Bit[15-8] are DON'T CARES in DMA Mode !!! )
;----------------------------------------------------------------------
; Bit[15-12]	These bits specify the ISA IRQ channel connected to 
;		"IRQOUT7" pin of NM95MS18. 
; Bit[11-8]	These bits specify the ISA IRQ channel connected to 
;		"IRQOUT6" pin of NM95MS18.
; Bit[7-4]	These bits specify the ISA IRQ channel connected to 
;		"IRQOUT5" pin of NM95MS18.
; Bit[3-0]	These bits specify the ISA IRQ channel connected to 
;		"IRQOUT4" pin of NM95MS18.

dw 34fbh	; In this example following ISA interrupts 3,4,15 and 11
		; are selected ( connected ) for IRQOUT7, IRQOUT6, 
		; IRQOUT5 and IRQOUT4 pins respectively.

;----------------------------------------------------------------------------
; CHIPSELECT 0  ( IOCS 0 ) DECODE SIZE REGISTER
;----------------------------------------------------------------------------
;This register should contain a value that reflects the RANGE for a 
;particular chipselect. For example a typical MODEM card would need I/O space 
;from 0x3f8 to 0x3ff. In this case the range is 8 bytes. Hence the 
;"CHIPSELECT 0 DECODE SIZE" Register should contain a binary value of 
;"00000111" (HEX 07 ). This is explained in the User's Guide. 
;For sake of convenience the same information is provided here.

;      RANGE Required 	   Value on the CHIPSELECT DECODE SIZE REGISTER

;    	     1  BYTE			00000000 b or 00 h
;    	     2  BYTES			00000001 b or 01 h
;     3 or   4  BYTES			00000011 b or 03 h
;     5 to   8  BYTES			00000111 b or 07 h
;     9 to  16  BYTES			00001111 b or 0F h
;    17 to  32  BYTES			00011111 b or 1F h
;    33 to  64  BYTES			00111111 b or 3F h
;    65 to 128  BYTES			01111111 b or 7F h
;   129 to 256  BYTES			11111111 b or FF h


dw 0003h        ; chipselect 0 decode size ( Range of 4 bytes )

; ----------------------------------------------
; CHIPSELECT 1  ( IOCS 1 ) DECODE SIZE REGISTER
; ---------------------------------------------- 
; Information provided for CHIPSELECT 0 DECODE SIZE REGISTER is true for 
; this register also.
; -----------------------------------------------------------------------

dw 0007h        ; chipselect 1 decode size ( Range of 8 bytes )

; ----------------------------------------------
; CHIPSELECT 2  ( IOCS 2 ) DECODE SIZE REGISTER
; ---------------------------------------------- 
; Information provided for CHIPSELECT 0 DECODE SIZE REGISTER is true for 
; this register also.
; -----------------------------------------------------------------------


dw 003fh        ; chipselect 2 decode size ( Range of 64 bytes )

dw 0000h	; Reserved for future

;----------------------------------------------------------------------------
; 				IRQ TYPE  REGISTER
;---------------------- New register defined for NM95MS18 ----------------
;----------------------------------------------------------------------------
;
; Bit[15-8] 	( Reserved. Must be 0 ) 
; Bit[7]	IRQ TYPE SELECTION FOR IRQOUT7 pin.
;		This bit selects the type of the IRQOUT7 pin. Setting this bit
;		to "0" configures the IRQOUT7 output type to be TTL type and is
;		compatible with NM95MS14/16.
;		Setting this bit to "1" configures the IRQOUT7 output type to
;		be Open-Drain type which allows this IRQOUT7 to be sharable.
;		0 --> TTL type 
;		1 --> Open-Drain type
;
; Bit[6]	IRQ TYPE SELECTION FOR IRQOUT6 pin.
;		Bit definition is same as Bit[7]
; Bit[5]	IRQ TYPE SELECTION FOR IRQOUT5 pin.
;		Bit definition is same as Bit[7]
; Bit[4]	IRQ TYPE SELECTION FOR IRQOUT4 pin.
;		Bit definition is same as Bit[7]
; Bit[3]	IRQ TYPE SELECTION FOR IRQOUT3 pin.
;		Bit definition is same as Bit[7]
; Bit[2]	IRQ TYPE SELECTION FOR IRQOUT2 pin.
;		Bit definition is same as Bit[7]
; Bit[1]	IRQ TYPE SELECTION FOR IRQOUT1 pin.
;		Bit definition is same as Bit[7]
; Bit[0]	IRQ TYPE SELECTION FOR IRQOUT0 pin.
;		Bit definition is same as Bit[7]

;----------------------------------------------------------------------------
db 00h
db 0C0h	        ; In this file following are assumed
		; Pins IRQOUT7 and IRQOUT6 are configured as Open-drain type
		; Pins IRQOUT[5-0] are configured as TTL type.

; Following 7 words are reserved for future use.

dw 0000h        ; Reserved for future
dw 0000h        ; Reserved for future
dw 0000h        ; Reserved for future
dw 0000h        ; Reserved for future
dw 0000h        ; Reserved for future
dw 0000h        ; Reserved for future
dw 0000h        ; Reserved for future

;----------------------------------------------------------------------------
; Begin of pnp header. Vendor ID and device serial number
;----------------------------------------------------------------------------
;Please refer 'Plug and Play ISA Specification" Chapter6(Sections 6.1, 6.1.1,
;6.1.2 and 6.1.3 ) for detailed explanation.
;----------------------------------------------------------------------------

db 1ah          ; Vendor byte 0 ( FSC0000 -- VENDOR ID )
db 63h          ; Vendor byte 1
db 00h          ; Vendor byte 2
db 00h          ; Vendor byte 3

dw 4567h        ; Serial Number word 0 ( 01234567 -- serial ID )
dw 0123h        ; Serial Number word 1

db 00h          ; ----- placeholder for checksum------

		; This checksum is important and is automatically calculated
		; by Fairchild supplied programming software. Procedure to
		; Checksum generation is also described in Appendix B of the 
		; PnP ISA Specification.
		
;---------------------------------------------------------------------------
; Following is the start of actual Plug-n-Play Resource data. Explanation
; for each section ( refereed as "item" by PnP Specification ) can be found
; in the ISA PNP SPECIFICATION ( Chapters 6 and 7 ).
; To explain better each section ( item ) is numbered. 
;---------------------------------------------------------------------------

;----------------------------------------------------------------------------
; SECTION 1  ---- "Plug and Play  Version number" --------------------------
; For detailed explanation refer section 6.2.2.1 of the ISA PNP SPECIFICATION
;----------------------------------------------------------------------------

db 0ah          ; Small item, item name - 0x1, len - 2
db 10h          ; Plug and Play version 1.0
db 00h          ; Vendor specific version number

;----------------------------------------------------------------------------
; SECTION 2  ---- "Identifier String ( ANSI )"  --------------------------
; For detailed explanation refer section 6.2.3.2 of the ISA PNP SPECIFICATION
;----------------------------------------------------------------------------

db 82h          ; Large item, Type Identifier string(ANSI)
db 2ah          ; length of the string (lower byte)
db 00h          ; length of the string (upper byte)

db "Fairchild Semiconductor NM95MS18 test file"  ; Example string 

;----------------------------------------------------------------------------
; SECTION 3  ---- "Logical device ID"  --------------------------
; For detailed explanation refer section 6.2.2.2 of the ISA PNP SPECIFICATION
;----------------------------------------------------------------------------

db 15h          ; len - 5
db 1ah          ; This byte and the following 3 bytes are
db 63h          ; same as Vendor ID byte0-3
db 00h          ;
db 00h          ;

db 02h          ; Bit[1] of this byte is set to 1 indicating PnP Register 31
		; is supported by this device. PnP register 31 is "I/O range 
		; check" register. Hence this device supports I/O range check
		; option.

;----------------------------------------------------------------------------
;The above three sections (items) are required for any PnP Card irrespective
;of the application. Following sections ( items ) are needed as required by 
;the application and need not be always present for ALL application.
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
; SECTION 4  ---- "Request for DMA" -------------------
;For detailed explanation refer section 6.2.2.5 of the ISA PNP SPECIFICATION
;For each additional DMA Request the following section must be duplicated !!
;
;Note: Though this file assumes Extended Interrupt Mode of NM95MS14, request
;      for DMA is shown here for example purpose !!!
;--------------------------------------------------------------------------
db 2ah		; Small item, type DMA format
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		; 76543210 <- Bit Position for DMA Level selection
db 0a0h		; 10100000 <- Bit value 
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		
db 19h		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		; 76543210 <- Bit Position for DMA Characteristics 
		;       10 (00 - 8bit, 01 - 8/16 bit, 10 - 16bit, 11 - RSVD)
		;      2   ( 0 -> Not a bus master, 1 ->  bus master )
		;     3    (  0 -> May not byte-mode count , 1 ->  may )
		;    4     (  0 -> May not word-mode count , 1 ->  may )
		;  65      ( 00 - compatibility mode, 01 - Type A DMA )
		;          ( 10 - Type D DMA,         11 - Type F DMA )
		; 7        ( RESERVED TO 0 )
		; 00011001 ( 11 My choice )		
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;----------------------------------------------------------------------------
; SECTION 5 ----- "Request for I/O Port" --------------
;                  This request is for the FIRST chipselect ( IOCS0 signal )
; For detailed explanation refer section 6.2.2.8 of the ISA PNP SPECIFICATION
; For each additional I/O port the following section must be duplicated !!!
;----------------------------------------------------------------------------

; Following example section requests for 4 bytes of I/O space anywhere in the
; range from 0x200 to 0x3ff  
; The base address requested here is in multiples of 4 bytes. 
; The Range is 4 bytes ( e.g 0x200 to 0x203, or 0x204 to 0x207, or 
; 0x208 to 0x20B etc )

db 47h          ;I/O Port Header(TAG)-47                Byte 0
db 01h          ;I/O Port Descriptor 0 information-01   Byte 1 16-bit DECODE
db 000h         ;I/O Descr.0 min base address[7:0]-00   Byte 2
db 002h         ;I/O Descr.0 min base address[15:8]-02  Byte 3
db 0fch         ;I/O Descr.0 max base address[7:0]-fc   Byte 4
db 03h          ;I/O Descr.0 max base address[15:8]-03  Byte 5
db 04h          ;I/O Descr.0 Base Alignment - 4        Byte 6 
db 04h          ;I/O Descr.0 max Range Length - 4      Byte 7

; Note: In this "example" the MINIMUM and MAXIMIM base address are different.


;----------------------------------------------------------------------------
; SECTION 6 ----- "Request for Another I/O Port" ( With Multiple choice ) ---
;                  This request is for the SECOND chipselect ( IOCS1 signal ).
; For detailed explanation refer section 6.2.2.6, 6.2.2.7, 6.2.2.8 and 
; section 7.1 of the ISA PNP SPECIFICATION. 
;
;	    -----  Together with I/O an IRQ is also requested.
;		   For detailed explanation on IRQ FORMAT refer section 6.2.2.4
;		   of the ISA PNP SPECIFICATION
;----------------------------------------------------------------------------

; Following example section requests for 8 bytes ( Range is 8 bytes ) of I/O 
; space 
; starting from 0x3f8 to 0x3ff and IRQ4				<---- Choice#1
;          or
; starting from 0x2f8 to 0x3ff and IRQ3 			<---- Choice#2
;          or
; starting from 0x3e8 to 0x3ef and IRQ4 			<---- Choice#3
;          or
; starting from 0x2e8 to 0x2ef and IRQ3				<---- Choice#4
;          or
; anywhere in the range of 0x100 to 0x3f0 and any available IRQ <---- Choice#5
 
db 30h	;START DEPENDENT FUNTION (TAG)-30  ( FOR CHOICE#1)

	;REQUEST FOR 8 I/O PORTS STARTING FROM 0x03f8 TO 0x03ff
	db 47h          ;I/O Port Header(TAG)-47                Byte 0
	db 01h          ;I/O Port Descriptor 0 information-01   Byte 1 
	db 0f8h         ;I/O Descr.0 min base address[7:0]-f8   Byte 2
	db 003h         ;I/O Descr.0 min base address[15:8]-03  Byte 3
	db 0f8h         ;I/O Descr.0 max base address[7:0]-f8   Byte 4
	db 03h          ;I/O Descr.0 max base address[15:8]-03  Byte 5
	db 08h          ;I/O Descr.0 Base Alignment - 08        Byte 6 
	db 08h          ;I/O Descr.0 max Range Length - 08      Byte 7

	; REQUEST FOR IRQ4
	db 23h          ; Small item, type IRQ format
	db 10h          ; IRQ 4
	db 00h          ; 
	db 04h		; HIGH-TRUE-LEVEL-SENSITIVE Type

db 30h	;START DEPENDENT FUNTION (TAG)-30  ( FOR CHOICE#2)
	
	;REQUEST FOR 8 I/O PORTS STARTING FROM 0x02f8 TO 0x02ff
	db 47h          ;I/O Port Header(TAG)-47                Byte 0
	db 01h          ;I/O Port Descriptor 0 information-01   Byte 1
	db 0f8h         ;I/O Descr.0 min base address[7:0]-f8   Byte 2
	db 002h         ;I/O Descr.0 min base address[15:8]-02  Byte 3
	db 0f8h         ;I/O Descr.0 max base address[7:0]-f8   Byte 4
	db 02h          ;I/O Descr.0 max base address[15:8]-02  Byte 5
	db 08h          ;I/O Descr.0 Base Alignment - 08        Byte 6 
	db 08h          ;I/O Descr.0 max Range Length - 08      Byte 7

	; REQUEST FOR IRQ3
	db 23h          ; Small item, type IRQ format
	db 08h          ; IRQ 3
	db 00h          ; 
	db 04h		; HIGH-TRUE-LEVEL-SENSITIVE Type

db 30h	;START DEPENDENT FUNTION (TAG)-30  ( FOR CHOICE#3)


	;REQUEST FOR 8 I/O PORTS STARTING FROM 0x03e8 TO 0x03ef
	db 47h          ;I/O Port Header(TAG)-47                Byte 0
	db 01h          ;I/O Port Descriptor 0 information-01   Byte 1
	db 0e8h         ;I/O Descr.0 min base address[7:0]-e8   Byte 2
	db 003h         ;I/O Descr.0 min base address[15:8]-03  Byte 3
	db 0e8h         ;I/O Descr.0 max base address[7:0]-e8   Byte 4
	db 03h          ;I/O Descr.0 max base address[15:8]-03  Byte 5
	db 08h          ;I/O Descr.0 Base Alignment - 08        Byte 6 
	db 08h          ;I/O Descr.0 max Range Length - 08      Byte 7

	; REQUEST FOR IRQ4
	db 23h          ; Small item, type IRQ format
	db 10h          ; IRQ 4
	db 00h          ; 
	db 04h		; HIGH-TRUE-LEVEL-SENSITIVE Type

db 30h	;START DEPENDENT FUNTION (TAG)-30  ( FOR CHOICE#4)
	
	;REQUEST FOR 8 I/O PORTS STRATING FROM 0x02e8 TO 0x02ef 
	db 47h          ;I/O Port Header(TAG)-47                Byte 0
	db 01h          ;I/O Port Descriptor 0 information-01   Byte 1
	db 0e8h         ;I/O Descr.0 min base address[7:0]-e8   Byte 2
	db 002h         ;I/O Descr.0 min base address[15:8]-02  Byte 3
	db 0e8h         ;I/O Descr.0 max base address[7:0]-e8   Byte 4
	db 02h          ;I/O Descr.0 max base address[15:8]-02  Byte 5
	db 08h          ;I/O Descr.0 Base Alignment - 08        Byte 6 
	db 08h          ;I/O Descr.0 max Range Length - 08      Byte 7

	; REQUEST FOR IRQ3
	db 23h          ; Small item, type IRQ format
	db 08h          ; IRQ 3
	db 00h          ; 
	db 04h		; HIGH-TRUE-LEVEL-SENSITIVE Type

db 30h	;START DEPENDENT FUNTION (TAG)-30  ( FOR CHOICE#5)
	;REQUEST FOR 8 I/O PORTS ANYWHERE IN THE RANGE ( 0x100 to 0x03f0 ) 
	db 47h          ;I/O Port Header(TAG)-47                Byte 0
	db 01h          ;I/O Port Descriptor 0 information-01   Byte 1 
	db 000h         ;I/O Descr.0 min base address[7:0]-00   Byte 2
	db 001h         ;I/O Descr.0 min base address[15:8]-01  Byte 3
	db 0f0h         ;I/O Descr.0 max base address[7:0]-f0   Byte 4
	db 03h          ;I/O Descr.0 max base address[15:8]-03  Byte 5
	db 08h          ;I/O Descr.0 Base Alignment - 08       Byte 6 
	db 08h          ;I/O Descr.0 max Range Length - 08      Byte 7

	; REQUEST FOR ANY ONE IRQ FROM A CHOICE OF 3,4,5,9,10,11,12 and 15
	db 23h          ; Small item, type IRQ format
	db 18h         ; Mask IRQ [7:0], 3,4 and 5  supported
	db 9eh         ; Mask IRQ [15:8], 9, a, b, c and f supported
	db 01h		; HIGH-TRUE-EDGE-SENSITIVE Type

db 38h		; END DEPENDENT FUNCTION (TAG)-38 
		; This TAG marks the end of choice list !! 



;----------------------------------------------------------------------------
; Section 8  ------- "End Of TAG" ----------------
;This section is needed for ALL cards irrespective of the application. This 
;section marks the end of the "Resource Data file".
;For detailed explanation refer section 6.2.2.11 of the ISA PNP SPECIFICATION
;----------------------------------------------------------------------------

db 79h          ; Small item, type END tag
db 00h          ; <-- placeholder for data checksum

		; This checksum is important and is automatically calculated
		; by Fairchild supplied programming software. 
		; This Checksum is generated such that adding this value to 
		; the sum of all the data bytes ( starting from SECTION 1 in 
		; this example ) will produce a ZERO sum.

data ends
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note#1:
;	This file is just a sample PnP resource data file. Like any sample 
; 	file this one also has its limitations and may not be adopted directly 
;	for an application without modification. Please refer chapter#6 and 
;	chapter#7 of the "Plug and Play ISA Specification" for additional 
;	information and  help. 
;
; Note#1:
;	Chapter#7 of "Plug and Play ISA Specification" contains more details
;	on how to define DEPENDENT functions ( alternate choices ) as well as
;  	some examples !!
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

