	list 	ON
;************************************************************************
;* FILE		: WMOD.ASM UNIVERSAL					*
;* PROGRAM	: 							*
;************************************************************************
;
	INCLUDE CONFIG.ASM
	INCLUDE RDEFINE.ASM

	IFFALSE	X2400
	GLOBAL	SET_RTS,CLR_RTS
	GLOBAL	RD0_CNTL,WR0_CNTL,RD1_CNTL,WR1_CNTL
	GLOBAL	SET_B96,SET_B72,SET_B48,SET_B24
	GLOBAL	SET_V22,SET_103,RD_INT,RS_TPEQ
	GLOBAL	SET_DMF,SET_TMOD,SET_V21
	GLOBAL	SET_PDM,SET_SPDM					;104D
	GLOBAL	SET_RAMW,CLR_RAMW,R_PDATA,W_PDATA
	GLOBAL	CHK_MDA0,R_FED,R_FREQ,CHK_MDAB
	GLOBAL	W_CONFIG,W_MEMORY,W_MEMORYA				;506
	GLOBAL	SET_ANS,SET_CRXD,CLR_CRXD
	GLOBAL	SET_NTXD,CLR_NTXD
	GLOBAL	R_FED,ANS_DET,RD_PNDET,CHK_AGC
	GLOBAL	C_DATA,OFF_SCR						;000
	GLOBAL	SET_MK,EN_RXD,SET_S1,RX_MK
	GLOBAL	SET_T12,SET_T24,SET_R12,SET_R24
	GLOBAL	SET_SCM,SET_EQUAL,OFF_EQUAL
	GLOBAL	SET_ASYN
	GLOBAL	SET_NTD,SPK_OFF
	GLOBAL	SET_ALBF,CLR_ALBF,SET_RGAIN
	GLOBAL	CLR_RGAIN
	GLOBAL	CLR_SCM,KIL_EQUAL,FRZ_EQUAL,SET_DOT
	GLOBAL	CLR_HS,SET_SYN,SET_PAR,SET_TXI,CLR_PAR,CLR_TXI
	GLOBAL	SET_X_CLOCK,CLR_CLMP,SET_CLMP		;104
	ENDIF

	IFTRUE	X2400
	GLOBAL	CLR_SCM,SET_DOT,SET_BEL,KIL_EQUAL
	GLOBAL	SET_T12,EN_RXD,RX_MK,FRZ_EQUAL
	GLOBAL	SET_ANS,SET_ASYN,SET_SYN,SET_X_CLOCK
	GLOBAL	SET_R12,SET_R24,SET_IDL,SET_T24
	GLOBAL	CLR_HS,SET_S1,SET_SCM,SET_300A
	GLOBAL	SET_MK,SET_DAT,SET_V22		;104
	GLOBAL	BELL_TXON,SET_EQUAL,SET_HS
	GLOBAL	SET_FSK,SET_PSK,SET_300S,SET_1200A
	GLOBAL	WR1_CNTL,RD_STAT
	ENDIF
	
	IFTRUE	V.23
	EXTERNAL	TX_OFF_23,V23_PA			;125
	EXTERNAL	RXMK_21,RXMK_23ESC,EN_RXD_23		;130 ;158
	ENDIF

;UNIVERSAL
	GLOBAL	TX_BK,TX_BKU,RXTX_MK,RXTX_MKU
	GLOBAL	SET_SLAVE,V22_I				;135 123
	GLOBAL	CLR_LDLB,SET_LDLB			;007
	GLOBAL	RD_DCD,INIT_MOD
	GLOBAL	TX_ON,TX_OFF,CLR_ANS			;128 104
	GLOBAL	C_ENERGY,SPEAK_1,SPEAK_2		;004
	GLOBAL	UPDAT_SPK,DTMF_OFF,SET_DTMF,SPEAK_ON,SPEAK_OFF
	GLOBAL	TT_D10,SPEAK3
	GLOBAL	P_EC,A_EC,SET_GAURD,EN_AL		;300
	GLOBAL	RX_MKD,EN_RXDD					;130
	
	EXTERNAL	TEST_TIM,WAIT_3RD			;135 007
	EXTERNAL	WAIT200,PUT_CHAR,WAIT_3MS,SND_MSG
	EXTERNAL	PP_D45,UPDATE_IO,INIT_FLAGS,SND_HEX
	EXTERNAL	RS_FEQ,SD_CRLF,SND_DIGITS
;
;LOCAL DEFINITION
;
ADDRS0	EQU	00H
ADDRS1	EQU	00H
;
V29B96	EQU	14H	;V.29 9600BPS MODE
V29B72	EQU	12H	;V.29 7200BPS MODE
V29B48	EQU	11H	;V.29 4800BPS MODE
V27B48	EQU	0AH	;V.27 4800BPS
V27B24	EQU	09H	;V.27 2400BPS
V21M	EQU	20H	;V21 HIGH MODE
TON_MOD	EQU	80H	;TONE TRANSMIT MODE
DMF_MOD	EQU	81H	;DTMF MODE
BEL103	EQU	61H	;BELL 103 MODE
V22_MOD	EQU	62H	;V22 MODE
;
	CODE
;---------------------------------------------------------------------- ******
;
	IFFALSE	X2400
;=====================================================================
;INIT_MOD - INITIALIZE ALL THE REGISTERS IN THE EXAR 2902 MODEM CHIP
;CALLS: WR1_CNTL,WR0_CNTL,UPDATE_IO
;DESTROYS: ACC,B,DPTR
;EXPECTS: NOTHING
;RETURNS:  XR2900 CHIP SET RESET
;STACK - 6
;=====================================================================
;
INIT_MOD:
	SETB	P1.7
	CLR	P1.7
;	LCALL	WAIT200
	SETB	P1.7			;HARDWARE RESET FOR TMS320

	MOV	B,#09H	;SET 09H=81H
	MOV	A,#81H
	LCALL	WR0_CNTL

	MOV	B,#0FH	;SET 0FH=00
	MOV	A,#00H
	LCALL	WR0_CNTL

	MOV	B,#0EH	;SET 0EH=00
	MOV	A,#00H
	LCALL	WR0_CNTL

	MOV	B,#0AH	;SET 0AH=6AH ***** DO NOT PUT 7AH *****
	MOV	A,#06AH
	LCALL	WR0_CNTL

	MOV	B,#07H	;SET 07H=00
	MOV	A,#00H
	LCALL	WR0_CNTL

	MOV	B,#05H	;SET 07H=00
	MOV	A,#00H
	LCALL	WR0_CNTL

	MOV	B,#1DH	;SET 1DH=39H
	MOV	A,#39H		   ;8-24-90
	LCALL	WR0_CNTL

	MOV	B,#0DH	;SET 0DH=09	;SET TX GAIN = 09H
	MOV	A,#99H				
	LCALL	WR0_CNTL

	IFTRUE	V.23
	LCALL	TX_OFF_23
	ENDIF

	RET
;
; READ/WRITE MEMORY SUBROUTINES
;
RD0_CNTL:
	PUSH	DPH
	PUSH	DPL
	MOV	DPL,B
	MOV	DPH,#ADDRS0	;SELECT CHIP 0
	MOVX	A,@DPTR
	POP	DPL
	POP	DPH
	RET
;
WR0_CNTL:
	PUSH	DPH
	PUSH	DPL
WRR:	MOV	DPL,B
	MOV	DPH,#ADDRS0
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	POP	DPL
	POP	DPH
	RET
	
;
RD1_CNTL:
	PUSH	DPH
	PUSH	DPL
	MOV	DPL,B
	MOV	DPH,#ADDRS1	;SELECT CHIP 1
	MOVX	A,@DPTR
	POP	DPL
	POP	DPH
	RET
;
WR1_CNTL:
	PUSH	DPH
	PUSH	DPL
	MOV	DPL,B
	MOV	DPH,#ADDRS1
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	POP	DPL
	POP	DPH
	RET
;
SET_B96	MOV	A,#V29B96 	;V29 9600BPS MODE
	LCALL	W_CONFIG
	
	IFTRUE	JCM
	CLR	HS_H
	LCALL	UPDATE_IO
	ENDIF
	
	RET
;
SET_B72	MOV	A,#V29B72	;V29 7200BPS MODE
	LCALL	W_CONFIG
	RET
;
SET_B48	MOV	A,#V27B48	;V27 4800BPS MODE
	LCALL	W_CONFIG
	RET
;
SET_B24	MOV	A,#V27B24	;V27 2400BPS MODE
	LCALL	W_CONFIG
	RET
;
SET_V22:
	MOV	A,#V22_MOD	;V22 1200/2400BPS MODE
	LCALL	W_CONFIG
	RET
;
SET_103	MOV	A,#BEL103	;BELL103 300BPS MODE
	LCALL	W_CONFIG
	RET
;
SET_DMF	MOV	A,#DMF_MOD	;DTMF MODE
	LCALL	W_CONFIG
	RET
;
SET_V21	MOV	A,#V21M		;V21 FSK MODE
	LCALL	W_CONFIG
	
	IFTRUE	JCM
	SETB	HS_H
	LCALL	UPDATE_IO
	ENDIF
	
	RET
;
SET_TMOD:
	MOV	A,#TON_MOD	;SET TONE TRANSMIT
	LCALL	W_CONFIG
	RET
;
SET_PDM:
	MOV	DPL,#0FH		;SET PARALLEL DATA MODE
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	SETB	ACC.7
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	SETB	ACC.5		;SET NORMAL TRANSMIT DATA
	RET
;
SET_ASYN:
	MOV	DPL,#0AH
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	SETB	ACC.0
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET

RXTX_MK:
	MOV	DPL,#09
	MOV	DPH,#ADDRS0
	MOV	A,#81H
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
SET_MK:
TX_MK:
	MOV	DPL,#09
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	SETB	ACC.7
	CLR	ACC.6
	CLR	ACC.5
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET

TX_BK:				;012S
	MOV	DPL,#09
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	ANL	A,#1FH
;	CLR	ACC.5
;	CLR	ACC.6
;	CLR	ACC.7
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET			;012T

SET_NTXD:
SET_NTD:	
	MOV	DPL,#09H		;SET NORMAL TXD MODE( SERIAL )
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	SETB	ACC.5
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET

CLR_NTXD:
	MOV	DPL,#09H		;SET PARALLEL DATA MODE
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	CLR	ACC.5
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET

SET_CRXD:
CLR_CRXD:
RX_MK:
	MOV	DPL,#09H		;SET PARALLEL DATA MODE
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	SETB	ACC.0
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET

EN_RXD:	MOV	DPL,#09
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	CLR	ACC.0    	;UNCLAMP RXDATA
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET			;506T

SET_RTS:				;XXX
TX_ON:					;104 29
	MOV	DPL,#05H		;ENABLE RTS
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	SETB	ACC.7
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET

CLR_RTS:				;XXX
TX_OFF:					;104 29
	MOV	DPL,#05H		;DISABLE RTS
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	CLR	ACC.7
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET

SPK_OFF:
	MOV	DPL,#0AH	;TURN ON SPEAKER
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	CLR	ACC.4
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET

SET_RAMW:
	PUSH	DPH
	PUSH	DPL
	MOV	DPH,#ADDRS0
	MOV	DPL,#05H		;WRITE MEMORY
	MOVX	A,@DPTR
	SETB	ACC.5
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	POP	DPL
	POP	DPH
	RET
;
SET_ANS:
	MOV	DPH,#ADDRS0
	MOV	DPL,#07H
	MOVX	A,@DPTR
	SETB	ACC.1
	SETB	ACC.3			;151
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	MOV	DPL,#0DH
	MOVX	A,@DPTR
	SETB	ACC.7
	MOVX	@DPTR,A
	
	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
;
CLR_ANS:
	MOV	DPH,#ADDRS0
	MOV	DPL,#07H
	MOVX	A,@DPTR
	CLR	ACC.1
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
;
CLR_RAMW:
	PUSH	DPH
	PUSH	DPL
	MOV	DPH,#ADDRS0
	MOV	DPL,#05H		;DISABLE WRITE MEMORY
	MOVX	A,@DPTR
	CLR	ACC.5
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	POP	DPL
	POP	DPH
	RET
;
R_PDATA:
	PUSH	DPH
	PUSH	DPL
	MOV	DPH,#ADDRS0
	MOV	DPL,#00H		;READ DATA TO RAM
	MOVX	A,@DPTR
	POP	DPL
	POP	DPH
	RET
;
W_PDATA:
	PUSH	DPH
	PUSH	DPL
	MOV	DPH,#ADDRS0
	MOV	DPL,#00H		;WRITE DATA TO RAM
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	POP	DPL
	POP	DPH
	RET
;
CHK_MDA0:
	PUSH	DPH
	PUSH	DPL
CHK_MDA1:
	MOV	DPL,#0EH
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	JNB	ACC.0,CHK_MDA1
	POP	DPL
	POP	DPH
	RET
;
CHK_MDAB:
 	PUSH	DPH
 	PUSH	DPL
 	CLR	C
 	MOV	DPL,#0EH
 	MOV	DPH,#ADDRS0
 	MOVX	A,@DPTR
 	JNB	ACC.0,CHK_MDAB1
 	SETB	C
CHK_MDAB1:	
 	POP	DPL
 	POP	DPH
	RET
;
R_FED:
	PUSH	DPH
	PUSH	DPL
	MOV	DPH,#ADDRS0		;101S
	MOV	DPL,#08H		;READ ENERGY DETECT
	MOVX	A,@DPTR
	MOV	C,ACC.2
;	CPL	C				;101T
	POP	DPL
	POP	DPH
	RET
;
RD_PNDET:
	PUSH	DPH
	PUSH	DPL
	MOV	DPH,#ADDRS1
	MOV	DPL,#17H		;READ PNDET
	MOVX	A,@DPTR
	MOV	C,ACC.6
	POP	DPL
	POP	DPH
	RET	
;
RD_DCD:
	PUSH	DPH
	PUSH	DPL
	MOV	DPH,#ADDRS1
	MOV	DPL,#17H		;READ DCD 
	MOVX	A,@DPTR
	MOV	C,ACC.6
	POP	DPL
	POP	DPH
	RET	
;	
ANS_DET:
	MOV	DPH,#ADDRS1
	MOV	DPL,#1BH		;READ TONE DETECT FILTER
	MOVX	A,@DPTR
	MOV	C,ACC.5
	RET
;
R_FREQ:
	MOV	DPH,#ADDRS1
	MOV	DPL,#1BH		;READ TONE DETECTOR
	LCALL	RD1_CNTL
	RET
;--------------------------------------- DESTROY : B,R1,FR1
W_CONFIG:
	PUSH	DPH
	PUSH	DPL
	MOV	DPH,#ADDRS0	;SELECT CHIP 0
	MOV	FR1,A
RS_CFG:	
	MOV	DPL,#04H
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	MOV	DPL,#0FH		;115S
	MOV	A,#00H	
	MOVX	@DPTR,A			;115T

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
;------------------------------------------- CK 2902 buf	
;--------------------------------------------- SET SETUP BIT
	MOV	DPL,#0EH
	MOVX	A,@DPTR
	SETB	ACC.3		
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
;--------------------------------------------- CK SETUP
;--------------------------------------------- CK DSP buf 1	

	IFTRUE	JCM_3
W_CFF2:
;	JNB	JP_004,W_CFF			;115D	
	MOV	A,#C_STB4
	LCALL	WAIT_3MS
	
	MOV	DPL,#0FH
	MOV	A,#69H				;60, 69
	MOVX	@DPTR,A
	MOV	DPL,#00
	MOVX	A,@DPTR
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	MOV	DPL,#02
	MOVX	A,@DPTR
	
	CJNE	A,FR1,WERR

ST_M:					;200
	MOV	DPL,#0FH		;SET PARALLEL DATA MODE
	MOVX	A,@DPTR
	SETB	ACC.7
	MOVX	@DPTR,A
;	SETB	ACC.5			;SET NORMAL TRANSMIT DATA
	ENDIF

;--------------------------------------------- EVERY THINGS OK
W_CFF:
	POP	DPL
	POP	DPH
	RET

	IFTRUE	JCM_3
WERR:				;2901 INTERRUPT FAIL
	SETB	M_READY
	LCALL	UPDATE_IO
	CLR	PASS		;115

	IFTRUE JCM_1
	MOV	DPTR,#MD9_ERR
	LCALL	SND_MSG
	MOV	A,B
	LCALL	SND_HEX
	MOV	DPTR,#ER_ADT
	LCALL	SND_MSG
	ENDIF

	MOV	A,#C_STB4
	LCALL	WAIT_3MS
	MOV	A,FR1
	LJMP	RS_CFG
	ENDIF

W_MEMORY:
	MOV	DPH,#ADDRS0
	MOV	DPL,#0FH		;WRITE TARGET ADDRESS
	MOV	A,#65H
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	LCALL	CHK_MDA0
	LCALL	SET_RAMW
	MOV	DPL,#03		;WRITE TO 03 FOR H_BYTE(R5)
	MOV	A,R5
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	MOV	DPL,#02		;WRITE TO 02 FOR L_BYTE(R4)
	MOV	A,R4
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	LCALL	CHK_MDA0
	LCALL	CLR_RAMW
	RET
;				;506S
; B : TARGET ADDRESS
; R5 : REG3, R4 : REG2
;
W_MEMORYA:
	MOV	DPH,#ADDRS0
	MOV	DPL,#0FH	;WRITE TARGET ADDRESS
	MOV	A,B		;GET TARGET ADDRESS
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	MOV	A,#2		;WAIT 6.6 MS
	LCALL	WAIT_3MS
;	LCALL	CHK_MDA0
	LCALL	SET_RAMW
	MOV	DPL,#03		;WRITE TO 03 FOR H_BYTE(R5)
	MOV	A,R5
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	MOV	DPL,#02		;WRITE TO 02 FOR L_BYTE(R4)
	MOV	A,R4
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	LCALL	CHK_MDA0
	LCALL	CLR_RAMW
	RET

SET_SPDM:			;144S
	MOV	DPL,#09
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	SETB	ACC.1		
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET			;144T

C_ENERGY:
	MOV	DPL,#08
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR	
	MOV	STATUS,A	;106
	MOV	C,ACC.2
 	RET
;
RS_TPEQ:
	MOV	DPL,#1DH
	MOV	DPH,#ADDRS0
	MOV	A,#00
	MOVX	@DPTR,A
	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	RET

SET_EQUAL:
	MOV	DPL,#1DH
	MOV	DPH,#ADDRS1
	MOV	A,#19H
;	MOVX	A,@DPTR
;	SETB	ACC.1
	MOVX	@DPTR,A
	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF

	MOV	DPL,#05		;UNRESET EQUALIZER
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	SETB	ACC.0
	MOVX	@DPTR,A
	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	RET
;
OFF_EQUAL:
	MOV	DPL,#1DH
	MOV	DPH,#ADDRS1
	MOV	A,#1AH
;	MOVX	A,@DPTR
;	SETB	ACC.1
	MOVX	@DPTR,A
	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF

	MOV	DPL,#05		;UNRESET EQUALIZER
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	CLR	ACC.0
	MOVX	@DPTR,A
	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	RET
;
OFF_SCR:			;000S
	MOV	DPL,#05		;UNRESET EQUALIZER
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	CLR	ACC.2
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET			;000T
;
FRZ_EQUAL:
	MOV	DPL,#1DH
	MOV	DPH,#ADDRS1
	MOV	A,#1AH
;	MOVX	A,@DPTR
;	SETB	ACC.1
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
;	
KIL_EQUAL:
	MOV	DPL,#05		;UNRESET EQUALIZER
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	CLR	ACC.0
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET

C_DATA:
	MOV	DPL,#08
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	RET

SET_R24:	
	MOV	DPL,#05
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	SETB	ACC.3
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
SET_R12:
	MOV	DPL,#05
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	CLR	ACC.3
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
SET_T24:	
	MOV	DPL,#05
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	SETB	ACC.4
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
SET_T12:
	MOV	DPL,#05
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	CLR	ACC.4
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
SET_SCM:
	MOV	DPL,#05
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	SETB	ACC.2
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET	
CLR_SCM:
	MOV	DPL,#05
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	CLR	ACC.2
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET	
SET_ALBF:
	MOV	DPL,#07
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	SETB	ACC.7
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET	
CLR_ALBF:
	MOV	DPL,#07
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	CLR	ACC.7
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET	
SET_S1:
	MOV	DPL,#09
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	CLR	ACC.7
	SETB	ACC.6
	CLR	ACC.5
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET	

SET_DOT:
	MOV	DPL,#09
	MOV	DPH,#ADDRS0
	MOVX	A,@DPTR
	SETB	ACC.7
	SETB	ACC.6
	CLR	ACC.5
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET	
;
SET_RGAIN:
	MOV	DPH,#ADDRS0
	MOV	DPL,#07
	MOVX	A,@DPTR
	SETB	ACC.4
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
CLR_RGAIN:
	MOV	DPH,#ADDRS0
	MOV	DPL,#07
	MOVX	A,@DPTR
	CLR	ACC.4
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
;
RD_INT:
	MOV	DPH,#ADDRS0
	MOV	DPL,#0FH
	MOV	A,#69H		;JCM
;	MOV	A,#66H		;READ AGC GAIN WORD
	MOVX	@DPTR,A
	MOV	DPL,#00
	MOVX	A,@DPTR
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	MOV	DPL,#02		;JCM
	MOVX	A,@DPTR		;JCM
	RET

RD_AGC:
	MOV	DPH,#ADDRS0
	MOV	DPL,#0FH
	MOV	A,#66H		;READ AGC GAIN WORD
	MOVX	@DPTR,A
	MOV	DPL,#00
	MOVX	A,@DPTR
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	MOV	DPL,#02
	MOVX	A,@DPTR
	RET
CHK_AGC:
	LCALL	RD_AGC
	CJNE	A,#8,CHK100
CHK100:	JNC	CHK200
	LCALL	SET_RGAIN 
CHK200:	RET
;
; UPDATE SPEAKER OUTPUT LATCH
;
UPDAT_SPK:
	MOV	B,#10
	LCALL	RD0_CNTL
	ANL	A,#9FH
	JNB	SPEAK_A,SPK_E1
	SETB	ACC.5
SPK_E1:	JNB	SPEAK_B,SPK_END
	SETB	ACC.6
SPK_END:
	LCALL	WR0_CNTL
	RET
;
;==================================================
;DTMF CONTROL
;==================================================

DTMF_OFF:
	LCALL	TX_OFF			;104 TURN OFF TRANSMITTER
	MOV	DPTR,#0DH
	MOVX	A,@DPTR
					;SET NORMAL XMIT LEVEL
	ANL	A,#F0H
	ORL	A,#0AH			;-5 db attn.
;	ORL	A,#0FH			;no attn.
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
;
SET_DTMF:
	LCALL	SET_DMF			;SET DTMF MODE
	MOV	DPTR,#0DH
	MOVX	A,@DPTR
	ANL	A,#F0H
	ORL	A,#0FH			;0 db attn.
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	LCALL	TX_ON			;104 TURN ON TRANSMITTER
	RET				;

;====================
;TONE DIAL
;====================
TT_D10:	
	MOV	R4,A			;ACC. CONTAINS FREQUENCY CODE
	MOV	R5,#0
	LCALL	W_MEMORY
	LCALL	WAIT200
	LCALL	SET_DTMF		;SETUP FOR DTMF AND TURN ON TONE
;====================
;CHECK FOR DTMF TEST
;====================
	MOV	A,S16
	CJNE	A,#02,TT_D15		;BRANCH IF NO TOUCH TONE TEST
TT_D13:	JNB	RI,TT_D13		;TOUCH TONE TEST ENABLED, WAIT FOR
					;ANY KEY TO ABORT
	SETB	ABORT
	SJMP	TT_D17
TT_D15:	MOV	A,S11
	MOV	B,#3
	DIV	AB
	MOV	R3,A
	LCALL	WAIT_3MS		;S11 CONTROLS TONE DURATION
TT_D17:	
	LCALL	DTMF_OFF		;
	JB	RI,PP_D45A		;BRANCH IF ABORT                                        
	MOV	A,R3
	LCALL	WAIT_3MS		;INTERDIGIT DELAY
	JB	RI,PP_D45A		;BRANCH IF ABORT                                        
TT_D20:	RET	
PP_D45A:
	LJMP	PP_D45
;
;==================================================
;SPEAK_ON/OFF - SPEAKER ON/OFF ROUTINES
;  THIS ROUTINE ENABLED/DISABLES THE SPEAKER DEPENDING
;  ON THE SETTING OF THE ATM OPTION
; DESTROYS -  ACC,DPTR
; EXPECTS - NOTHING
; RETURNS - NOTHING
; STACK - 3
;==================================================
;
SPEAK_ON:	
	JB	SPEAK_1,SPEAK2	;
	JB	SPEAK_2,SPEAK2
	SJMP	SPEAK5		;134 SPEAKER DISABLED
SPEAK2:	
	MOV	B,#10
	LCALL	RD0_CNTL
	SETB	ACC.4		;SPEAKER ON
	LCALL	WR0_CNTL	
;	SETB	SPEAK_BIT	;SPEAKER ON BIT
	RET
SPEAK_OFF:
	JNB	SPEAK_2,SPEAK5	;
	JNB	SPEAK_1,SPEAK3	;EXIT IF SPEAKER ALWAYS ON
SPEAK5:	MOV	B,#10
	LCALL	RD0_CNTL
	CLR	ACC.4		;SPEAKER OFF
	MOV	B,#10
	LCALL	WR0_CNTL	
;	CLR	SPEAK_BIT	;SPEAKER ON BIT
SPEAK3:	RET
;
CLR_HS:
	RET	
SET_SYN:
	MOV	DPTR,#000AH
	MOVX	A,@DPTR
	CLR	ACC.0
	MOVX	@DPTR,A
	RET
SET_PAR:
	MOV	DPTR,#000FH
	MOVX	A,@DPTR
	SETB	ACC.7
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
SET_TXI:
	MOV	DPTR,#0009H
	MOVX	A,@DPTR
	SETB	ACC.1
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
CLR_PAR:
	MOV	DPTR,#000FH
	MOVX	A,@DPTR
	CLR	ACC.7
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
CLR_TXI:
	MOV	DPTR,#0009H
	MOVX	A,@DPTR
	CLR	ACC.1
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
SET_X_CLOCK:
	MOV	DPTR,#0009H
	MOVX	A,@DPTR
	SETB	ACC.3
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET

SET_SLAVE:				;123S
	MOV	DPTR,#0009H
	MOVX	A,@DPTR
	SETB	ACC.2
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET				;123T

CLR_CLMP:
	MOV	DPTR,#0009H
	MOVX	A,@DPTR
	CLR	ACC.0
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET	
SET_DLB:
	MOV	DPTR,#0009H
	MOVX	A,@DPTR
	SETB	ACC.4
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET
CLR_DLB:
	MOV	DPTR,#0009H
	MOVX	A,@DPTR
	CLR	ACC.4
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET	
SET_CLMP:
	MOV	DPTR,#0009H
	MOVX	A,@DPTR
	SETB	ACC.0
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET	
;TXP_ON:					;104DS
;	MOV	DPTR,#0009H
;	MOVX	A,@DPTR
;	SETB	ACC.5
;	CLR	ACC.7
;	MOVX	@DPTR,A
;	RET					;104DT

;===============================		;300S
;ENABLE DATA TO LINE
;===============================
EN_AL:
	MOV	DPTR,#09
	MOVX	A,@DPTR
	SETB	ACC.5			;ENABLE DATA TO LINE Tx
	CLR	ACC.0			;ENABLE DATA TO LINE Rx
	MOVX	@DPTR,A

	IFTRUE	JCM_2
	LCALL	S_W
	ENDIF
	
	RET

;
;===============================
;ENABLE GAURD TONE IS OPTIONED
;===============================
SET_GAURD:
	MOV	A,S23
	ANL	A,#0C0H		;CHECK GAURD TONE
	JZ	SET_G3		;147S
	JB	ACC.6,SET_G4
	MOV	DPTR,#07
	MOVX	A,@DPTR
	SETB	ACC.3		;1800HZ
SET_G5:	SETB	ACC.2		;ENABLE GAURD TONE
SET_G0:	
SET_G2:
	MOVX	@DPTR,A	
SET_G1:	RET
SET_G3:
	MOV	DPTR,#07
	MOVX	A,@DPTR
	CLR	ACC.2
	SJMP	SET_G2
SET_G4:
	MOV	DPTR,#07
	MOVX	A,@DPTR
	CLR	ACC.3		;550HZ
	SJMP	SET_G5

;^^^
P_EC:
	IFTRUE	V.23
	JNB	V23_SPD,V23_NO1
	LCALL	V23_PA
	RET
V23_NO1:
	ENDIF

;	LCALL	INIT_SOM
	LCALL	SET_SYN			;PUT SYNC MODE
	LCALL	SET_PAR			;PUT PARALLEL BUS
	LCALL	SET_TXI			;TURN TX INTERRUPT
	LCALL	SET_CLMP
	LCALL	SET_NTD
	RET
A_EC:
	JB	SYNC,AEC04		;009
	LCALL	SET_ASYN		;ASYN <-> SYN BUFF
	JNB	BIT_3,A_EC00		;300BPS MODE, BY PASS DATA BUFFER
	LCALL	SET_SYN			;PUT INTO ASYN MODE
A_EC00:
	LCALL	CLR_PAR
	LCALL	CLR_TXI	 		;PUT NON-PARALLEL BUS
	LCALL	CLR_CLMP
	LCALL	SET_NTD
;	LCALL	INIT_FLAGS

; SET UP SPEED FOR UART

	JNB	HI_SPD2,AEC01
	MOV	TL1,#BAUD_24
	MOV	TH1,#BAUD_24
	SJMP	AEC010
AEC01:	JNB	HI_SPD1,AEC02
	MOV	TL1,#BAUD_12
	MOV	TH1,#BAUD_12
	SJMP	AEC010
AEC02:	JB	BIT_1,AEC03
	MOV	TL1,#BAUD_3
	MOV	TH1,#BAUD_3
	SJMP	AEC010
AEC03:	MOV	TL1,#BAUD_11
	MOV	TH1,#BAUD_11
AEC010:	RET			;300T

AEC04:	LCALL	CLR_CLMP	;009S
	LCALL	SET_NTD
	RET			;009T
;				;007S

	ENDIF			;2900




;------------------------------------------------------------------- UNIVERSAL


;==================================================
; V22_I		:
;
; DESTROYS	:
; EXPECTS	:
; RETURNS	:
; STACK 	:
;==================================================

V22_I:				;135S
	IFFALSE	X2400
	LCALL	SET_SCM
	LCALL	SET_V22
	LCALL	SET_MK
	LCALL	TX_ON
	ENDIF
	
	IFTRUE	X2400
	LCALL	SET_1200A
	MOV	A,#W_REG2
	LCALL	RD_STAT
	SETB	ACC.0		;tx_on
	SETB	ACC.1		;scm_on
	CLR	ACC.5		;212 filter
	MOV	B,#W_REG2
	LCALL	WR1_CNTL
	LCALL	SET_PSK
	ENDIF
	
	MOV	A,#10
	LCALL	WAIT_3RD
	RET			;135T
	
;==================================================
;SET_LDLB - ENABLE LOCAL DIGITAL LOOPBACK
; BY SETTING BIT 4 IN XR2400 REGISTER 01
; DESTROYS - ACC,R0,R1,R2
; EXPECTS -  NOTHING
; RETURNS -  NOTHING
; STACK - 4
;==================================================
;
SET_LDLB:
	SETB	LDLB_ON
	SETB	TEST_BIT
	LCALL	SET_NTD			;138
	LCALL	SET_DLB
CLR_L1:
	LCALL	TEST_TIM
	RET
CLR_LDLB:
	CLR	LDLB_ON
	CLR	TEST_BIT
	LCALL	SET_MK		;MARK TO TX
	CLR	M_READY		;MODEM READY LED ON
	LCALL	UPDATE_IO	
	LCALL	CLR_DLB
	SJMP	CLR_L1
				;007T

;==================================================
; RXTX_MKU :
; DESTROYS - 
; EXPECTS - 
; RETURNS -
; STACK - 
;==================================================
RXTX_MKU:				;021S
	IFTRUE	V.23
	MOV	DPTR,#OPT_7
	MOVX	A,@DPTR
	CJNE	A,#3,CKP1
CKP1:	JNC	BCP2
	JB	V23_SPD,K23_1
;	LJMP	
K23_1:
;	LJMP
	RET			;NOT DONE !!!
	ENDIF

BCP2:	LJMP	RXTX_MK		;021T

;==================================================
; TX_BKU :
; DESTROYS - 
; EXPECTS - 
; RETURNS -
; STACK - 
;==================================================
TX_BKU:				;021S
	IFTRUE	V.23
	MOV	DPTR,#OPT_7
	MOVX	A,@DPTR
	CJNE	A,#3,CKP
CKP:	JNC	BCP1
	JB	V23_SPD,K_23
;	LJMP	
K_23:
;	LJMP
	RET			;NOT DONE !!!
	ENDIF

BCP1:	LJMP	TX_BK		;021T

;==================================================
; RX_MKD :
; DESTROYS - 
; EXPECTS - 
; RETURNS -
; STACK - 
;==================================================
RX_MKD:
	IFTRUE	V.23
	MOV	DPTR,#OPT_7
	MOVX	A,@DPTR
	CJNE	A,#3,CKCHIP
CKCHIP:	JNC	BCHIP
	JB	V23_SPD,MK_23
	LJMP	RXMK_21		;158
MK_23:	LJMP	RXMK_23ESC	;158
	ENDIF

BCHIP:	LJMP	RX_MK

;==================================================
; EN_RXDD :
; DESTROYS - 
; EXPECTS - 
; RETURNS -
; STACK - 
;==================================================
EN_RXDD:
	IFTRUE	V.23
	MOV	DPTR,#OPT_7
	MOVX	A,@DPTR
	CJNE	A,#3,CKCP
CKCP:	JNC	BCP
	LJMP	EN_RXD_23
	ENDIF

BCP:	LJMP	EN_RXD


;---------------------------------------------------------------------- ******

	IFTRUE	X2400	
SET_DLB:
	MOV	A,#W_REG1		;128S
	LCALL	RD_STAT
	SETB	ACC.4
	MOV	B,#W_REG1
	LCALL	WR1_CNTL
	RET
CLR_DLB:
	MOV	A,#W_REG1
	LCALL	RD_STAT
	CLR	ACC.4
	MOV	B,#W_REG1
	LCALL	WR1_CNTL		;128T
	RET

;=====================================================================
;INIT_MOD - INITIALIZE ALL THE REGISTERS IN THE EXAR 2402 MODEM CHIP
;  SEND A 200US RESET PULSE TO THE XR2401
;CALLS: WAIT200,WAIT_3MS,WR1_CNTL,UPDATE_IO
;DESTROYS: ACC,DPTR
;EXPECTS: NOTHING
;RETURNS:  XR2400 CHIP SET RESET
;STACK - 6
;=====================================================================
;
INIT_MOD:
	SETB	RSTTMS
	CLR	RSTTMS
	LCALL	WAIT200
	SETB	RSTTMS			;HARDWARE RESET FOR TMS320
	MOV	A,#2
	LCALL	WAIT_3MS		;WAIT 6.6MS FOR RESET

	LCALL	SET_IDL			;PUT CHIP INTO IDLE MODE

	MOV	A,#00000011B
	MOV	B,#W_REG0		;
	LCALL	WR1_CNTL		;BIT 0 = TXL1 = 1
					;BIT 1 = TXL2 = 1
					;BIT 2 = TXL3 = 0 (-6 DBM)
					;BIT 3 = SPEAKER CONTROL = 0
					;BIT 4 = TST1 = 0
					;BIT 5 = TST2 = 0
					;BIT 6 = TXT3 = 0
					;BIT 7 =      = 0
;
	LCALL	UPDAT_SPK
	MOV	A,#10100100B
	MOV	B,#W_REG1
	LCALL	WR1_CNTL		;BIT 0 = BUFF OVERSPEED = 0
					;BIT 1 = REC SPEED SEL 1 = 0
					;BIT 2 = REC SPEED SEL 2 = 1 (300)
					;BIT 3 = EX XMIT CLOCK = 0
					;BIT 4 = DLB ENABLE = 0
					;BIT 5 = BIT COUNT 1 = 1
					;BIT 6 = BIT COUTN 2 = 0 (10 BIT)
					;BIT 7 = SYNC/ASYNC = 1 (ASYNC)

	MOV	A,#00010100B
	MOV	B,#W_REG2
	LCALL	WR1_CNTL		;BIT 0 = XMIT ENABLE = 0
					;BIT 1 = SCRAM ENABLE = 0
					;BIT 2 = 64 BIT MARK DET = 1
					;BIT 3 = EQUAL OFF/ON = 0
					;BIT 4 = EQUAL T,T/2 SEL = 1 (T/2)
					;BIT 5 = BELL/V22 BASE SEL = 0
					;BIT 6 = BELL/V22 ANS TONE = 0
					;BIT 7 = RESET EQUAL = 0
	MOV	A,#10000010B
	MOV	B,#W_REG3
	LCALL	WR1_CNTL		;BIT 0 = HS = 0
					;BIT 1 = CLAMP RXD TO MARK = 1
					;BIT 2 = XMIT SPEED SEL = 0 (1200)
					;BIT 3 = LDLB MODE = 0
					;BIT 4 = PARALLEL TXD = 0
					;BIT 5 = NORMAL XMIT DATA = 0
					;BIT 6 = TX CAR BIT 1 = 0
					;BIT 7 = TX CAR BIT 2 = 1 (MARK)
	MOV	A,#00001000B
	MOV	B,#W_REG4
	LCALL	WR1_CNTL		;BIT 0 = POWER DOWN = 0
					;BIT 1 = ORG/ANS MODE = 0 (ORG)
					;BIT 2 = GAURD TONE ENABLE = 0
					;BIT 3 = GAURD TONE SELECT = 1 (1800)
					;BIT 4 = RECEIVE FILTER GAIN = 0
					;BIT 5 = DTMF MODE = 0
					;BIT 6 = CALL PROGRESS MODE = 0
					;BIT 7 = ALB ENABLE = 0
	MOV	A,#00000000B
	MOV	B,#W_REG5
	LCALL	WR1_CNTL		;BIT 0 = DTMF 1 = 0
					;BIT 1 = DTMF 2 = 0
					;BIT 2 = DTMF 3 = 0
					;BIT 3 = DTMF 4 = 0
					;BIT 4 = 
					;BIT 5 = 
					;BIT 6 = 
					;BIT 7 = 
;
	LCALL	UPDATE_IO		;UPDATE I/O ON EIA
	CLR	RETRAIN
	IFTRUE	V.23
	LCALL	TX_OFF_23
	ENDIF
	RET
;
;============================================================
;SET_PATTERN - THE FOLLOWING ROUTINES MODIFY THE EXAR 2400 
;  INTERNAL REGISTERS
; DESTROYS: ACC,R0,R1,B
; CALLS: RD_STAT,WR1_CNTL
; EXPECTS: NOTHING
; RETURNS: PATTERN SET
; STACK - 6
;============================================================
;
;===============================
;SET TRANSMIT S1 PATTERN
;===============================
SET_S1:
	MOV	A,#W_REG3
	LCALL	RD_STAT
	SETB	ACC.6
	CLR	ACC.7			;S1 PATTERN
	SJMP	SET_M1
;===============================
;SET TRANSMIT MARK PATTERN
;===============================
SET_MK:
	MOV	A,#W_REG3
	LCALL	RD_STAT
	SETB	ACC.7
	CLR	ACC.6			;MARK PATTERN
SET_M1:	CLR	ACC.5
SET_M2:	MOV	B,#W_REG3
	LCALL	WR1_CNTL
	RET
;===============================
;SET TRANSMIT DOTTING PATTERN
;===============================
SET_DOT:
	MOV	A,#W_REG3
	LCALL	RD_STAT
	SETB	ACC.6
	SETB	ACC.7			;DOTTING PATTERN
	SJMP	SET_M1
TX_BK:
	MOV	A,#W_REG3
	LCALL	RD_STAT
	CLR	ACC.6
	CLR	ACC.7
	SJMP	SET_M1

;===============================
;ENABLE DATA TO LINE
;===============================
EN_AL:
	MOV	A,#W_REG3
	LCALL	RD_STAT
	SETB	ACC.5			;ENABLE DATA TO LINE
	CLR	ACC.1
	SJMP	SET_M2

SET_DAT:
SET_NTD:				;138
	MOV	A,#W_REG3
	LCALL	RD_STAT
	SETB	ACC.5			;ENABLE DATA TO LINE
	SJMP	SET_M2

;===============================
;ENABLE DATA TO DTE
;===============================
EN_RXD:
	MOV	A,#W_REG3
	LCALL	RD_STAT
	CLR	ACC.1			;ENABLE DATA TO DTE
	SJMP	SET_M2
;===============================
;FORCE MARK TO DTE
;===============================
RX_MK:
	MOV	A,#W_REG3
	LCALL	RD_STAT
	SETB	ACC.1			;MARK TO DTE
	SJMP	SET_M2
;===============================
;FORCE MARK TO DTE AND LINE
;===============================
RXTX_MK:
	MOV	A,#W_REG3
	LCALL	RD_STAT
	ANL	A,#10011111B
	ORL	A,#10000010B
;	SETB	ACC.1			;MARK TO RXD
;	CLR	ACC.5			;PATTERN TO TXD
;	SETB	ACC.7
;	CLR	ACC.6			;MARK PATTERN TO TXD
	MOV	B,#W_REG3
	SJMP	SETTT3
;
;===============================
;SET RECEIVER SPEED
;===============================
;
SET_R24:
	MOV	A,#W_REG1
	LCALL	RD_STAT
	SETB	ACC.2			;
SET_R2:	SETB	ACC.1			;SET 2400 RECEIVER
	MOV	B,#W_REG1
	SJMP	SETTT3
;
SET_R12:
	MOV	A,#W_REG1
	LCALL	RD_STAT
	CLR	ACC.2			;SET 1200 RECEIVER
	SJMP	SET_R2

SET_T24:
	MOV	A,#W_REG3
	LCALL	RD_STAT
	SETB	ACC.2			;SET 2400 TRANSMIT
SETTT2:	MOV	B,#W_REG3
SETTT3:	LCALL	WR1_CNTL
	RET
;
SET_T12:
	MOV	A,#W_REG3
	LCALL	RD_STAT
	CLR	ACC.2			;SET 1200 TRANSMIT
	SJMP	SETTT2
;
;===============================
;HANDSHAKE CONTROL
;===============================
;
SET_HS:	MOV	A,#W_REG3
	LCALL	RD_STAT
	SETB	ACC.0			;HS ON
SETHS1:	MOV	B,#W_REG3
;	LCALL	WR1_CNTL
;	RET
	SJMP	SETTT3
;
CLR_HS:	MOV	A,#W_REG3
	LCALL	RD_STAT
	CLR	ACC.0			;HS OFF
	SJMP	SETHS1
;
;===============================
;TRANSMITTER CONTROL
;===============================
;
TX_ON:	MOV	A,#W_REG2
	LCALL	RD_STAT
	SETB	ACC.0			;TRANSMITTER ON
	SJMP	TX_11

TX_OFF:	MOV	A,#W_REG2
	LCALL	RD_STAT
	CLR	ACC.0			;TRANSMITTER OFF
TX_11:	SJMP	SCM_11
;
;===============================
;MODE CONTROL
;===============================
;
SET_IDL:
	MOV	A,#IDL_MOD
	SJMP	SET_M
SET_PSK:
	MOV	A,#PSK_MOD
	SJMP	SET_M
SET_FSK:
	MOV	A,#FSK_MOD
SET_M:	MOV	B,#W_REG9
	SJMP	SCM_12
;
;===============================
;SCRAMBLER CONTROL
;===============================
;
SET_SCM:
	MOV	A,#W_REG2
	LCALL	RD_STAT
	SETB	ACC.1			;ENABLE SCRAMBLER
	SJMP	SCM_11

CLR_SCM:
	MOV	A,#W_REG2
	LCALL	RD_STAT
	CLR	ACC.1		;DISABLE SCRAMBLER
SCM_11:	MOV	B,#W_REG2
SCM_12:	LCALL	WR1_CNTL
	RET
;
;===============================
;BELL/CCITT CONTROL
;===============================
;
SET_BEL:
	MOV	A,#W_REG2
	LCALL	RD_STAT
	ANL	A,#10011111B
				;CLR	ACC.5	;SET BELL FILTER
				;CLR	ACC.6	;SET BELL ANSWER TONE
	SJMP	SCM_11

SET_V22:
	MOV	A,#W_REG2
	LCALL	RD_STAT
	ORL	A,#01100000B
				;SETB	ACC.5	;SET V22 FILTER
				;SETB	ACC.6	;SET V22 ANSWER TONE
	SJMP	SCM_11
;
;===============================
;ASYNC/SYNC CONTROL
;===============================
;
SET_ASYN:
	MOV	A,#W_REG1
	LCALL	RD_STAT
	SETB	ACC.7		;ASYNC MODE
	SJMP	SSY_11
SET_SYN:	
	MOV	A,#W_REG1
	LCALL	RD_STAT
	CLR	ACC.7		;SYNC MODE
SSY_11:	MOV	B,#W_REG1
	LCALL	WR1_CNTL
	RET
;
;===============================
;EQUALIZER CONTROL
;===============================
;
SET_EQUAL:
	MOV	A,#W_REG2	
	LCALL	RD_STAT
	ORL	A,#10001000B
				;SETB	ACC.3	;ENABLE EQUALIZER
				;SETB	ACC.7	;ENABLE EQUALIZER
SEQL1:	MOV	B,#W_REG2
	LJMP	WR1_CNTL	;AND RETURN

FRZ_EQUAL:
	MOV	A,#W_REG2	
	LCALL	RD_STAT
	CLR	ACC.3		;HOLD EQUALIZER
	SJMP	SEQL1
KIL_EQUAL:
	MOV	A,#W_REG2	
	LCALL	RD_STAT
	ANL	A,#01110111B	
				;CLR	ACC.3	;HOLD EQUALIZER
				;CLR	ACC.7	;RESET EQUALIZER
	SJMP	SEQL1
;
;===============================
;SET 300BPS SYNC MODE
;===============================
;
SET_300S:
	MOV	A,#W_REG1
	LCALL	RD_STAT
	SETB	ACC.2
	ANL	A,#01111101B
				;CLR	ACC.1	;SET 300BPS RECEIVE
				;CLR	ACC.7	;SET SYNC MODE FOR 103
SET_3S:	MOV	B,#W_REG1
	SJMP	SET_G2

SET_1200A:
	MOV	A,#W_REG1
	LCALL	RD_STAT
	CLR	ACC.2		;SET 1200BPS RECEIVER
	ORL	A,#10000010B
				;SETB	ACC.1
				;SETB	ACC.7	;SET ASYNC MODE
	SJMP	SET_3S

SET_300A:
	MOV	A,#W_REG1
	LCALL	RD_STAT
	CLR	ACC.1		;SET 300BPS RECEIVER
	ORL	A,#10000100B	;SETB	ACC.7	;SET ASYNC MODE
				;SETB	ACC.2
	SJMP	SET_3S
;
SET_X_CLOCK:
	MOV	A,#W_REG1
	LCALL	RD_STAT
	SETB	ACC.3			;ENABLE EXTERNAL XMIT CLOCK
	SJMP	SET_3S
;
SET_SLAVE:				;123S
	RET				;123T
;
SET_ANS:
	MOV	A,#W_REG4
	LCALL	RD_STAT
	SETB	ACC.1			;SET ANSWER MODE
	SJMP	SET_G0

CLR_ANS:					;128S
	MOV	A,#W_REG4
	LCALL	RD_STAT
	CLR	ACC.1
	SJMP	SET_G0			;128T
;===============================
;ENABLE GAURD TONE IS OPTIONED
;===============================
SET_GAURD:
	MOV	A,S23
	ANL	A,#0C0H		;CHECK GAURD TONE
	JZ	SET_G1
	MOV	C,ACC.7		;1800HZ SELECT
	MOV	PASS,C		;
	MOV	A,#W_REG4
	LCALL	RD_STAT
	SETB	ACC.2		;ENABLE GAURD TONE
	MOV	C,PASS
	MOV	ACC.3,C		;SELECT GAURD TONE (1 = 1800HZ)
SET_G0:	MOV	B,#W_REG4
SET_G2:	LCALL	WR1_CNTL	
SET_G1:	RET

;===============================
;SET BELL MODE AND TURN TRANSMITTER ON
;===============================
BELL_TXON:
	MOV	A,#W_REG2
	LCALL	RD_STAT
	SETB	ACC.0			;ENABLE TRANSMITTER
	ANL	A,#9FH			
					;CLR	ACC.6	;SET BELL ANSWER TONE
					;CLR	ACC.5	;SET BELL BASEBAND
	MOV	B,#W_REG2
	SJMP	SET_G2
;^^^
P_EC:	MOV	A,#W_REG1		;PUT INTO SYN MODE
	LCALL	RD_STAT
	CLR	ACC.7
	MOV	B,#W_REG1
	LCALL	WR1_CNTL
	MOV	A,#W_REG3		;PUT PARALLEL BUS
	LCALL	RD_STAT
	SETB	ACC.4			;PTD
	SETB	ACC.5			;NTD
	SETB	ACC.1			;CLAMP TO MARK
	MOV	B,#W_REG3
	LCALL	WR1_CNTL
	RET
A_EC:
	JB	SYNC,AEC010
	MOV	A,#W_REG1		;PUT INTO ASYN MODE
	LCALL	RD_STAT
	SETB	ACC.7
	JNB	BIT_3,A_EC00		;300BPS MODE, BY PASS DATA BUFFER
	CLR	ACC.7
A_EC00:	MOV	B,#W_REG1
	LCALL	WR1_CNTL
	MOV	A,#W_REG3
	LCALL	RD_STAT
	CLR 	ACC.4			;PUT NON-PARALLEL BUS
	CLR 	ACC.1			;UNCLAMP TO MARK
	SETB	ACC.5			;138 NTD
	MOV	B,#W_REG3
	LCALL	WR1_CNTL

; SET UP SPEED FOR UART

	JNB	HI_SPD2,AEC01
	MOV	TL1,#BAUD_24
	MOV	TH1,#BAUD_24
	SJMP	AEC010
AEC01:	JNB	HI_SPD1,AEC02
	MOV	TL1,#BAUD_12
	MOV	TH1,#BAUD_12
	SJMP	AEC010
AEC02:	JB	BIT_1,AEC03
	MOV	TL1,#BAUD_3
	MOV	TH1,#BAUD_3
	SJMP	AEC010
AEC03:	MOV	TL1,#BAUD_11
	MOV	TH1,#BAUD_11
AEC010:	RET

;============================================================
;C_ENERGY - READ THE ENERGY STATUS BIT FROM THE EXAR 2400
; DESTROYS: ACC,R0
; CALLS: NOTHING  
; EXPECTS: NOTHING
; RETURNS:  CARRY = 1 IF ENERGY PRESENT
; STACK - 0
;============================================================
;
C_ENERGY:
	MOV	DPTR,#03	;READ STATUS
	MOVX	A,@DPTR		;GET STATUS
	MOV	STATUS,A
	MOV	C,ACC.2
	RET
;
;============================================================
;WR1_CNTL - WRITE TO SELECTED MODEM CONTROL REGISTER
;BUT FIRST CHECK TO SEE IF IN PSK OR FSK MODE, IF SO THEN WAIT
; 200uS BEFORE SENDING DATA
; DESTROYS: R0,R1,ACC
; CALLS: RD_STAT
; EXPECTS: ACC = DATA TO BE WRITTEN
;          B = ADDRESS TO WRITE TO
; RETURNS: NOTHING 
; STACK - 4
;============================================================
;
WR1_CNTL:
	PUSH	REG_1
	MOV	R1,A		;SAVE STATUS
WRC1:	MOV	A,#100
WRC200:	DJNZ	ACC,WRC200	;WAIT 200 CYCLES
	
	MOV	A,R1
	MOV	DPTR,#01	;DATA
	MOVX	@DPTR,A		;OUTPUT WRITE COMMAND AND DATA
	
	MOV	DPTR,#00	;ADDRESS
	MOV	A,B		;
	MOVX	@DPTR,A		;OUTPUT ADDRESS FOR WRITE
	
	MOV	A,B		;GET ADDRESS
	CALL	RD_STAT		;CHECK WRITE DATA
	
	CJNE	A,REG_1,WRC300
	POP	REG_1		;MODEM SETUP OK
	RET
WRC300:
	IFTRUE JCM_1
	MOV	DPTR,#MD4_ERR
	LCALL	SND_MSG
	MOV	A,B
	LCALL	SND_HEX
	MOV	DPTR,#ER_ADT
	LCALL	SND_MSG
	ENDIF
	SJMP	WRC1
;
;============================================================
;RD_STAT - READ STATUS FROM SELECTED MODEM REGISTER
; DESTROYS: R0
; CALLS: NOTHING
; EXPECTS: ACC = ADDRESS TO READ FROM
; RETURNS: ACC = DATA READ FROM ADDRESS
; STACK - 1
;============================================================
;
RD_STAT:
	PUSH	ACC
	MOV	A,#150
RRC200:	DJNZ	ACC,RRC200	;WAIT 200 CYCLES
	POP	ACC
	MOV	DPTR,#00	;SPECIFY READ OPERATION
	MOVX	@DPTR,A		;OUTPUT READ COMMAND AND ADDRESS
	NOP
	NOP
	NOP
	NOP			;WAIT
	MOV	DPTR,#02
	MOVX	A,@DPTR		;RETREIVE DATA
	RET
;
RD_DCD:
	PUSH	DPH
	PUSH	DPL
	MOV	DPH,#ADDRS1
	MOV	DPL,#17H		;READ DCD 
	MOVX	A,@DPTR
	MOV	C,ACC.0
	POP	DPL
	POP	DPH
	RET	
;
; UPDATE SPEAKER OUTPUT LATCH
;
UPDAT_SPK:
;	MOV	A,RAM22H		;300DS
;	MOV	DPTR,#LATCHS
;	MOVX	@DPTR,A			;300DT
	MOV	A,#W_REG0
	LCALL	RD_STAT
	ANL	A,#00111111B
	JNB	SPEAK_B,LOW_V
	JNB	SPEAK_A,M_V
	SJMP	B_CNT
M_V:	ORL	A,#10000000B
	SJMP	B_CNT
LOW_V:	ORL	A,#11000000B
	
;	MOV	C,SPKR1A
;	MOV	ACC.6,C
;	MOV	C,SPKR2B
;	MOV	ACC.7,C
B_CNT:
	MOV	B,#W_REG0
	LCALL	WR1_CNTL	
	RET
;
;==================================================
;DTMF CONTROL
;==================================================
;
DTMF_OFF:
	LCALL	TX_OFF

	MOV	A,#W_REG4
	LCALL	RD_STAT
	CLR	ACC.5			;CLR DTMF MODE
	MOV	B,#W_REG4
	LCALL	WR1_CNTL
	LCALL	WAIT200

	MOV	A,#W_REG0
	LCALL	RD_STAT
	CLR	ACC.2			;SET NORMAL XMIT LEVEL
CLRD10:	MOV	B,#W_REG0
	LCALL	WR1_CNTL
	LCALL	WAIT200

	LCALL	SET_IDL
	LJMP	WAIT200			;TO RETURN
;
SET_DTMF:
	MOV	A,#DTMF_MOD
	MOV	B,#W_REG9
	LCALL	WR1_CNTL		;SET UP FOR DTMF MODE
	LCALL	WAIT200
	MOV	A,#W_REG0
	LCALL	RD_STAT
	ORL	A,#07H			;SET DTMF XMIT LEVEL
					;	SETB	ACC.0	
					;	SETB	ACC.1	
					;	SETB	ACC.2	
SETD10:	MOV	B,#W_REG0
	LCALL	WR1_CNTL
	LCALL	WAIT200
	MOV	A,#W_REG4
	LCALL	RD_STAT
	SETB	ACC.5			;SET DTMF MODE
	MOV	B,#W_REG4
	LCALL	WR1_CNTL
	LCALL	WAIT200
	LJMP	TX_ON		;TO RETURN
;
;==================================================
;SPEAK_ON/OFF - SPEAKER ON/OFF ROUTINES
;  THIS ROUTINE ENABLED/DISABLES THE SPEAKER DEPENDING
;  ON THE SETTING OF THE ATM OPTION
; DESTROYS -  ACC,DPTR
; CALLS - WR1_CNTL,RD_STAT
; EXPECTS - NOTHING
; RETURNS - NOTHING
; STACK - 3
;==================================================
;
SPEAK_ON:	
	JB	SPEAK_1,SPEAK2	;
	JB	SPEAK_2,SPEAK2
	RET			;SPEAKER DISABLED
SPEAK2:	
	MOV	A,#W_REG0
	LCALL	RD_STAT
	SETB	ACC.3		;SPEAKER ON
	MOV	B,#W_REG0
	LCALL	WR1_CNTL	
;	SETB	SPEAK_BIT	;SPEAKER ON BIT
	RET
SPEAK_OFF:
	JNB	SPEAK_2,SPEAK5	;
	JNB	SPEAK_1,SPEAK3	;EXIT IF SPEAKER ALWAYS ON
SPEAK5:	MOV	A,#W_REG0
	LCALL	RD_STAT
	CLR	ACC.3		;SPEAKER OFF
	MOV	B,#W_REG0
	LCALL	WR1_CNTL	
;	CLR	SPEAK_BIT	;SPEAKER ON BIT
SPEAK3:	RET
;
;====================
;TONE DIAL
;====================
TT_D10:	
	MOV	B,#W_REG5		;OUTPUT DIGIT
	LCALL	WR1_CNTL		;SET UP FOR DTMF MODE
	LCALL	WAIT200
	LCALL	SET_DTMF		;SETUP FOR DTMF AND TURN ON TONE
;====================
;CHECK FOR DTMF TEST
;====================
	MOV	A,S16
	CJNE	A,#02,TT_D15		;BRANCH IF NO TOUCH TONE TEST
TT_D13:	JNB	RI,TT_D13		;TOUCH TONE TEST ENABLED, WAIT FOR
					;ANY KEY TO ABORT
	SETB	ABORT
	SJMP	TT_D17
TT_D15:	MOV	A,S11
	MOV	B,#3
	DIV	AB
	MOV	R3,A
	LCALL	WAIT_3MS		;S11 CONTROLS TONE DURATION
TT_D17:	
	LCALL	DTMF_OFF		;
	JB	RI,PP_D45A		;BRANCH IF ABORT                                        
	MOV	A,R3
	LCALL	WAIT_3MS		;INTERDIGIT DELAY
	JB	RI,PP_D45A		;BRANCH IF ABORT                                        
TT_D20:	RET	
PP_D45A:
	LJMP	PP_D45
	ENDIF

	IFTRUE	JCM
W_JS2:
	PUSH	DPH
	PUSH	DPL
	MOV	DPTR,#JS2
	MOVX	@DPTR,A
	POP	DPL
	POP	DPH
	RET

W_JS3:
	PUSH	DPH
	PUSH	DPL
	MOV	DPTR,#JS3
	MOVX	@DPTR,A
	POP	DPL
	POP	DPH
	RET

	IFTRUE	JCM_2
S_W:
	PUSH	DPH
	PUSH	DPL
	PUSH	ACC
	MOV	A,DPL
	LCALL	SND_HEX
	MOV	A,#' '
	LCALL	PUT_CHAR
	POP	ACC
	PUSH	ACC
	LCALL	SND_HEX
	MOV	A,#' '
	LCALL	PUT_CHAR
	LCALL	PUT_CHAR
	LCALL	PUT_CHAR
	POP	ACC
	POP	DPL
	POP	DPH
	ENDIF

MD4_ERR:	DB	0DH,0AH,07H,'XR2402 I/O ERROR !!!  IN ADDRESS  ',0FFH
MD9_ERR:	DB	0DH,0AH,07H,'XR2902 I/O ERROR !!!  IN ADDRESS  ',0FFH
ER_ADT:		DB	'H',0DH,0AH,0FFH	
	ENDIF

	
	END
