	list	on
	pl	104
	pw	128
;************************************************************************
;* FILE		: MOD6.ASM UNIVERSAL					*
;* SUBJECT	: COMMANDS						*
;************************************************************************

; 3/1/91	RELEASE 1.0

	LIST	OFF
	INCLUDE CONFIG.ASM
	INCLUDE RDEFINE.ASM
	LIST	ON
;========================================
;GLOBAL DEFINITIONS
;========================================
;
	GLOBAL		ATX_C,ATX_D,ATX_F,ATX_J,ATX_J,ATX_L,ATX_M
	GLOBAL		ATX_P,ATX_R,ATX_S,ATX_T,ATX_W,ATX_X
	GLOBAL		ATX_E,ATX_Y,ATX_TY,ATX_Z		;113
	GLOBAL		ATX_K,ATX_Q,TEL_ADD_S				;110;111
	GLOBAL		ATX_U,WRT_NV0
	GLOBAL		GET_S,PUT_S,WRT_NV,READ_NV,READ_NV0,RD_NV_DAT0
	GLOBAL		LOADNV,SAVENV		;007
	GLOBAL		SND_ERR_CNT,ATX_V
	GLOBAL		ATX_G,SD_CRLF
;
;========================================
;EXTERNAL REFERENCES
;========================================
;
;FROM MODULE1.ASM
;
	EXTERNAL	SET_SPEED,WARM0,WARM_ST
	EXTERNAL	IDLE,PUT_CHAR
	EXTERNAL	INIT_IO,INIT_MOD
	EXTERNAL	CXR_OFF,CTS_OFF,DSR_OFF,HIS_OFF
	EXTERNAL	CXR_ON,CTS_ON,DSR_ON
	EXTERNAL	NV_W		;113
;
;FROM MODULE3.ASM
;
	EXTERNAL	ORIGINATE,ANSWER,DATA_MOD
	EXTERNAL	INIT_FLAGS,MAN_ORG
	EXTERNAL	RD_STAT,WR1_CNTL
	EXTERNAL	SET_MK,IRT_OFF,TEST_TIM
	EXTERNAL	DISCONNECT
;
;FROM MODULE4.ASM
;
	EXTERNAL	CPM_MOD,QUIET_A,CHK_DT,CHK_DTW
;
;FROM MODULE5.ASM
;
	EXTERNAL	AT_000,IS_VALID,GET_PARAM,AT_POINT,FETCH
	EXTERNAL	INIT_AT,AT_O,WAIT_3MS,V_CRLF,INITA0
	EXTERNAL	SND_DIGITS,UPDATE_IO,S_CRLF
	EXTERNAL	SET_AA_BIT,SFT_ADD,SND_MSG,AT_ERR		;110
;
;FROM MODULE8.ASM
;
	EXTERNAL	DISPLAY
	EXTERNAL	ATXK0,ATXK3,ATXK4		;110
;										;007S
;FROM WMOD.ASM
;
	EXTERNAL	SET_LDLB,CLR_LDLB		;007T
;
	EJECT
	TITLE THE EXTENDED "AT" COMMAND MODULE
;
;############################################################
;#                                                          #
;#             THE EXTENDED "AT" COMMAND MODULE             #
;#                                                          #
;############################################################
	CODE
;==================================================
;ATX_C - CXR CONTROL
;  THIS COMMAND WILL CONTROL THE WAY THAT THE EIA
;  CXR SIGNAL WILL ACT
;
;   &C0 = CXR ALWAYS ON
;   &C1 = CXR FOLLOWS LINE CARRIER STATUS
; DESTROYS - ACC
; CALLS -  GET_PARAM,CXR_ON,CXR_OFF 
; EXPECTS - NOTHING
; RETURNS - WITH CXR_NORM BIT SET AS SPECIFIED
;==================================================
;
ATX_C:	CLR	CXR_NORM
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATX_C1	;BRANCH IF NONE OR ZERO
	SETB	CXR_NORM
	JB	DATA_BIT,ATX_C1
	LCALL	CXR_OFF
	SJMP	ATX_C2
ATX_C1:	CLR	CXR_L		;FORCE CXR TO EIA ONLY
;	LCALL	CXR_ON
ATX_C2:	LJMP	AT_000		
;
;==================================================
;ATX_D - DTR CONTROL
;  THIS COMMAND SELECTS THE FUNCTION OF THE DTR CONTROL
;
;   &D0 = IGNORE DTR
;   &D1 = DTR OFF GOES TO COMMAND STATE
;   &D2 = DTR OFF GOES TO IDLE STATE
;   &D3 = DTR OFF GOES TO INITIALIZATION STATE
; DESTROYS - ACC
; CALLS -  GET_PARAM 
; EXPECTS - NOTHING
; RETURNS - WITH DTR_OP1 AND DTR_OP2 BITS SET AS SPECIFIED
;           ALSO WITH IGNORE_DTR STATUS SET
;==================================================
;
ATX_D:	ANL	S21,#0E7H	;CLR	DTR_OP1
				;CLR	DTR_OP2
	CLR	IGNORE_DTR
	LCALL	GET_PARAM
	JNB	PASS,ATX_D1	;
	SETB	IGNORE_DTR
	SJMP	ATX_D3
ATX_D1:	CJNE	A,#01,ATX_D2	;DTR MODE 1
	SETB	DTR_OP1
	SJMP	ATX_D3
ATX_D2:	CJNE	A,#02,ATX_D4	;DTR MODE 2
	SETB	DTR_OP2
	SJMP	ATX_D3
ATX_D4:	ORL	S21,#18H	; >2 THEN DTR MODE 3
				;SETB	DTR_OP1	
				;SETB	DTR_OP2
ATX_D3:	SJMP	ATX_C2		;LJMP AT_000		

;==================================================
; ATX_E - OPTION FOR ERROR CONTROL
;==================================================
ATX_E:	LCALL	GET_PARAM
	JNB	PASS,ST_E
	MOV	A,#0H
ST_E:
	PUSH	A
	SUBB	A,#04		;CHECK CHANGE FOR MODE
	JNC	ST_E01
	MOV	DPTR,#OPT_0
	POP	A
	CJNE	A,#0,ST_E02
	SJMP	ST_E04
ST_E02:	CJNE	A,#1,ST_E03
	SJMP	ST_E05
ST_E04:	MOVX	@DPTR,A
	LJMP	AT_000
ST_E03:
	DEC	A
	MOVX	@DPTR,A
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	SETB	ACC.7
	SJMP	ST_E04
ST_E05:
	MOVX	@DPTR,A
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	CLR	ACC.7
	SJMP	ST_E04	
ST_E01:
	MOV	DPTR,#OPT_1	;SET FLOW CONTROL OPTION
	MOVX	@DPTR,A
	POP	A
	LJMP	AT_000
;
;==================================================
;ATX_F - FETCH ACTIVE CONFIGURATION FROM ROM
;  FETCHES S0,S14,S18,S21,S22,S23,S25,S26,S27
; DESTROYS - ACC
; CALLS -  INITA0
; EXPECTS - NOTHING
; RETURNS -
;==================================================
;
ATX_F:	
	LCALL	INITA0		;INITIALIZE S REGISTERS TO FACTORY
	MOV	A,R2
	MOV	U_ST,#00
	ANL	S23,#F1H	;015
	ORL	S23,A		;UPDATE WITH PREVIOUS PARITY
	LCALL	SET_AA_BIT	;SETUP AUTO ANSWER LED BIT
;---
	CLR	CXR_L
;---
	SJMP	ATX_J1		;LJMP AT_000
;
;==================================================
;ATX_G - GAURD TONE SELECT
;  THIS COMMAND SELECTS THE GAURD TONE OPTION
;
;   &G0 = NO GAURD TONE
;   &G1 = 550HZ GAURD TONE
;   &G2 = 1800HZ GAURD TONE
; DESTROYS - ACC
; CALLS -  GET_PARAM
; EXPECTS - NOTHING
; RETURNS - WITH GAURD_1 AND GAURD_2 BITS SET AS SPECIFIED
;==================================================
;
ATX_G:	ANL	S23,#00111111B	
				;CLR	GAURD_1
				;CLR	GAURD_2
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATX_G3	;BRANCH IF NONE OR ZERO
ATX_G1:	CJNE	A,#01,ATX_G2
	SETB	GAURD_1
	SJMP	ATX_G3
ATX_G2:	SETB	GAURD_2
ATX_G3:	SJMP	ATX_J1		;LJMP AT_000		
;
;==================================================
;ATX_J - RJ11/RJ12 JACK SELECT
;  THIS COMMAND WILL UPDATE THE S REGISTER STATUS BIT ONLY
;  AND HAS NO EFFECT ON MODEM OPERATION
;
;   &J0 = RJ11
;   &J1 = RJ12
; DESTROYS - ACC
; CALLS -  GET_PARAM
; EXPECTS - NOTHING
; RETURNS - WITH JACK_SEL BIT SET AS SPECIFIED
;==================================================
;
ATX_J:	CLR	JACK_SEL
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATX_J1	;BRANCH IF NONE OR ZERO
	SETB	JACK_SEL
ATX_J1:	LJMP	AT_000		
;
;==================================================	;110S
;ATX_K - FLOW CONTROL
;
; DESTROYS - ACC,DPTR,PASS
; CALLS -  GET_PARAM
; EXPECTS -
; RETURNS - 
;==================================================
;
ATX_K:	
	MOV	DPTR,#OPT_8
	MOVX	A,@DPTR
	CLR	ACC.5
	MOVX	@DPTR,A

	MOV	DPTR,#OPT_1
	LCALL	GET_PARAM	;GET NEXT PARAMETER	
	JB	PASS,ATX_K0	;BRANCH IF NONE OR ZERO
ATX_K3:	CJNE	A,#03,ATX_K4
	LJMP	ATXK3
ATX_K4:	CJNE	A,#04,ATX_K5
	LJMP	ATXK4
ATX_K5:	CJNE	A,#05,ATX_K6
	MOV	DPTR,#OPT_1
	MOV	A,#3
	MOVX	@DPTR,A
	LJMP	AT_000

ATX_K0:	LJMP	ATXK0
ATX_K6:	LJMP	AT_ERR		
;							;110T
;==================================================
;ATX_L - LEASED LINE/SWITCHED LINE SELECT
;  THIS COMMAND WILL UPDATE THE S REGISTER STATUS BIT ONLY
;  AND HAS NO EFFECT ON MODEM OPERATION
;
;   &L0 = SELECTS SWITCHED LINE
;   &L1 = SELECTS LEASED LINE
; DESTROYS - ACC
; CALLS -  GET_PARAM
; EXPECTS - NOTHING
; RETURNS - WITH LEASED_L BIT SET AS SPECIFIED
;==================================================
;
ATX_L:	CLR	LEASED_L
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATX_L1	;BRANCH IF NONE OR ZERO
	SETB	LEASED_L
ATX_L1:	SJMP	ATX_P1		;LJMP AT_000		
;
;==================================================
;ATX_M - ASYNC/SYNC SELECT
;  THIS COMMAND SELECTS ASYNC OR SYNC MODE
;
;   &M0 = ASYNC MODE
;   &M1 = SYNC MODE (ASYNC DIAL)
;   &M2 = SYNC MODE (DTR ON DIAL STORED NUMBER)
;   &M3 = SYNC MODE (DTR CONTROL CONNECT SEQUENCE)
; DESTROYS - ACC
; CALLS -  GET_PARAM
; EXPECTS - NOTHING
; RETURNS - WITH ASYN_1 AND ASYN_2 BITS SET AS SPECIFIED
;==================================================
;
ATX_M:	
	LCALL	GET_PARAM	;143
ATX_M7:	ANL	S27,#0FCH	;CLEAR ASYN_1 AND ASYN_2
	CLR	SYNC
	CLR	DTR_FLG
	JB	PASS,ATX_M6	;BRANCH IF NONE OR ZERO (ASYNC)
ATX_M1:	CJNE	A,#01,ATX_M2	;SYNC MODE 1
	SETB	ASYN_1
	SJMP	ATX_M5
ATX_M2:	CJNE	A,#02,ATX_M4	;SYNC MODE 2
	SETB	ASYN_2
	SJMP	ATX_M5
ATX_M4:	ORL	S27,#03H	;SET ASYN_1 AND ASYN_2
;	SETB	ASYN_1		; >2 THEN SYNC MODE 3
;	SETB	ASYN_2
ATX_M5:	SETB	SYNC
	SETB	DSR_L
	SETB	CXR_L
ATX_M6:	SJMP	ATX_P1		;LJMP AT_000
;^^^
;==================================================
;ATX_P - PULSE DIAL MAKE/BREAK RATIO
;  THIS COMMAND CONTROLS THE MAKE/BREAK RATIO FOR THE
;  PULSE DIAL SEQUENCE.
;
;   &P0 = SELECTS 39/61 (US STANDARD)
;   &P1 = SELECTS 33/67 (UK STANDARD)
; DESTROYS - ACC
; CALLS -  GET_PARAM
; EXPECTS - NOTHING
; RETURNS - WITH PUL_RATIO BIT SET AS SPECIFIED
;==================================================
;
ATX_P:	CLR	PUL_RATIO
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATX_P1	;BRANCH IF NONE OR ZERO
	SETB	PUL_RATIO
ATX_P1:	LJMP	AT_000		
;
;==================================================	;111S
;ATX_Q - SYNC MODE
;  THIS COMMAND SAME AS &Mn
;
;==================================================
;
ATX_Q:	
	LCALL	GET_PARAM	;143S
	MOV	DPTR,#OPT_NQ	;148S
	MOVX	@DPTR,A
	CJNE	A,#0,ATX_Q3
	MOV	DPTR,#OPT_0
	CLR	A
	MOVX	@DPTR,A
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	CLR	ACC.0
	MOVX	@DPTR,A
	SJMP	ATX_M7		;148T

ATX_Q3:	CJNE	A,#5,ATX_Q1
	MOV	DPTR,#OPT_0
	MOV	A,#1
	MOVX	@DPTR,A
	SJMP	ATX_Q2

ATX_Q1:	CJNE	A,#6,ATX_M7
	MOV	DPTR,#OPT_0
	MOV	A,#00
	MOVX	@DPTR,A
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	SETB	ACC.0
	MOVX	@DPTR,A
ATX_Q2:	LJMP	AT_000		;143T
;				;111T
;==================================================
;ATX_R - RTS/CTS CONTROL
;  THIS COMMAND CONTROLA THE WAY THE RTS AND CTS LINES
;  INTERACT IN SYNC MODE
;
;   &R0 = CTS FOLLOWS RTS
;   &R1 = CTS ALWAYS ON
; DESTROYS - ACC
; CALLS -  GET_PARAM 
; EXPECTS - NOTHING
; RETURNS - WITH CTS_OPT BIT SET AS SPECIFIED
;==================================================
;
ATX_R:	CLR	CTS_OPT
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATX_R1	;BRANCH IF = 0
	SETB	CTS_OPT
	SJMP	ATX_R4
ATX_R1:	JNB	SYNC,ATX_R3
	JNB	DATA_BIT,ATX_R3
	JNB	RTS_L,ATX_R3
	JNB	ASYN_2,ATX_R3
	LCALL	CTS_OFF
ATX_R4:	SJMP	ATX_S2		;
ATX_R3:	LCALL	CTS_ON
	SJMP	ATX_S2		;
;
;==================================================
;ATX_S - DSR CONTROL
;  THIS COMMAND CONTROLS THE WAY THE DSR LINE
;  IS USED
;
;   &S0 = DSR ALWAYS ON
;   &S1 = DSR NORMAL
; DESTROYS - ACC
; CALLS -  GET_PARAM,DSR_ON,DSR_OFF 
; EXPECTS - NOTHING
; RETURNS - WITH DSR_NORM BIT SET AS SPECIFIED
;==================================================
;
ATX_S:	CLR	DSR_NORM
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATX_S1	;BRANCH IF NONE OR ZERO
	SETB	DSR_NORM
	JB	DATA_BIT,ATX_S1
	LCALL	DSR_OFF
	SJMP	ATX_S2
ATX_S1:	LCALL	DSR_ON
ATX_S2:	LJMP	AT_000		
;
;==================================================
;ATX_T - TEST COMMANDS
;  CONTROLS THE TEST MODES
;
;   &T0 = CANCEL TEST IN PROGRESS
;   &T1 = INITIATE ALB
;   &T2 = NOT USED
;   &T3 = INITIATE LDLB
;   &T4 = ENABLE RTRT
;   &T5 = DISABLE RTRT
;   &T6 = INITIATE RDLB
;   &T7 = INITIATE RDLB WITH SELF TEST
;   &T8 = INITIATE ALB WITH SELF TEST
; DESTROYS - ACC
; CALLS -  GET_PARAM
; EXPECTS - NOTHING
; RETURNS - WITH CTS_OPT BIT SET AS SPECIFIED
;==================================================
;
ATX_T:	LCALL	GET_PARAM
	JNB	PASS,ATX_T1	;
	JNB	TEST_BIT,ATX_TX	;EXIT IF NO TEST IN PROGRESS
	LCALL	ATX_TY		;GO CANCEL TEST IN PROGRESS
	LJMP	AT_000		;AND EXIT
ATX_T1:	CJNE	A,#01,ATX_T2
	SETB	ALB_REQ
	LJMP	AT_O
;^^^
; IF ERROR CONTROL OPTION ENABLE, WILL DISABLE DLB FUNCTION
;
ATX_EC:	PUSH	A
	MOV	DPTR,#OPT_0
	MOVX	A,@DPTR
	JNZ	ATX_EC1		;DISCONNECT, IF IN MNP MODE.
	POP	A
	SJMP	ATX_T21
ATX_EC1:
	POP	A
	LJMP	DISCONNECT
;
ATX_T2:	JB	DATA_BIT,ATX_EC
ATX_T21:
	CJNE	A,#02,ATX_T3
	SJMP	ATX_TX		;&T2 - NOTHING???
ATX_T3:	CJNE	A,#03,ATX_T4
	JNB	DATA_BIT,ATX_TX	;NO LDLB IF NOT IN DATA MODE
	LCALL	SET_LDLB	;&T3 - LDLB
	SETB	DLOOP1_R
	SJMP	ATX_TX
ATX_T4:	CJNE	A,#04,ATX_T5	
	SETB	RTRT_ENB	;&T4 - ENABLE RTRT
	SJMP	ATX_TX
ATX_T5:	CJNE	A,#05,ATX_T6
	CLR	RTRT_ENB	;&T5 - DISABLE RTRT
	SJMP	ATX_TX
ATX_T6:	CJNE	A,#06,ATX_T7
	JNB	DATA_BIT,ATX_TX	;NO RDLB IF NOT IN DATA MODE
	SETB	RDLB_REQ	;&T6 - RDLB
	SETB	IRT1_R
	LJMP	AT_O
ATX_T7:	CJNE	A,#07,ATX_T8
	JNB	DATA_BIT,ATX_TX	;NO RDLB IF NOT IN DATA MODE
	SETB	ST_FLAG		;&T7 - RDLB WITH SELF TEST
	SETB	IRT2_R
	SETB	RDLB_REQ
	LJMP	AT_O
ATX_T8:	CJNE	A,#08,ATX_TX
	SETB	ALB1_REQ
	SETB	ST_FLAG		;&T8 - ALB WITH SELF TEST
	LJMP	AT_O
ATX_TX:	LJMP	AT_000		
;******************************
;START ANALOG LOOPBACK TEST
;******************************
ATX_TZ:	SETB	TEST_BIT		;SET TEST STATUS
	LJMP	ORIGINATE

;******************************
; CANCEL ANY TEST IN PROGRESS 
; COULD BE ALB, RLDB AND LDLB
;******************************
ATX_TY:					;138S
	ANL	S16,#00			;CLEAR TEST STATUS FLAGS
	JNB	ALB_ON,ATXTY1	
	LCALL	INIT_MOD
	CLR	DATA_BIT
	LCALL	HIS_OFF
	LCALL	CXR_OFF
ATXTY0:	JNB	ST_FLAG,ATXTY3
	LCALL	V_CRLF		;SEND CRLF FIRST
	LCALL	SND_ERR_CNT	;OUTPUT ERROR COUNT IF SELF TEST 
	SJMP	ATXTY3
ATXTY1:	JNB	RDLB_ON,ATXTY2
	LCALL	IRT_OFF
	SJMP	ATXTY0		;CHECK FOR SELF TEST TOO
ATXTY2:	
	JNB	LDLB_ON,ATXTY3	;138
	LCALL	CLR_LDLB
ATXTY3:	ANL	S16,#00		;CLEAR TEST STATUS FLAGS
	ANL	RAM29H,#00	;CLEAR ALL TEST FLAGS
	CLR	M_READY		;MODEM READY LED ON
	SETB	CXR_L		;DCD LED OFF
	RET

SND_ERR_CNT:
	JNB	ST_FLAG,SNDECNT	;BRANCH IF NO SELF TEST IN PROGRESS
	CLR	ST_FLAG
	MOV	A,ERR_CNT	;GET TEST ERROR COUNT
	LCALL	SND_DIGITS
	LCALL	V_CRLF
SNDECNT:
	RET

;
;==================================================
;  ATX_U - SPEED CONVERSION ON/OFF
;      0 - ON
;      1 - OFF
;==================================================
ATX_U:	MOV	DPTR,#OPT_2
	LCALL	GET_PARAM
	CLR	C
	JB	PASS,ST_U
	CJNE	A,#1,ST_U
	SETB	C
	SJMP	ST_U00
ST_U:	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	ANL	A,#0FEH		;RESET BIT0
	JNC	ST_U00
	ORL	A,#01H		;SET BIT0
ST_U00:	MOVX	@DPTR,A
	LJMP	AT_000
;
;==================================================
;  ATX_V - DISPLAY PROFILE
;==================================================
ATX_V:				;001S
	IFFALSE	V42BIS		;147S
	IFFALSE	V42ONLY
	JB	DATA_BIT,ATX_V2
	ENDIF
	ENDIF			;147T

ATX_V1:
	LCALL	DISPLAY
	LJMP	AT_000
ATX_V2:
	MOV	DPTR,#STK_BK
	LCALL	SND_MSG
	LJMP	AT_000		;001S

;==================================================
;ATX_W - WRITE ACTIVE CONFIGUATION TO NV RAM
;
; DESTROYS - ACC
; CALLS -  SAVE_NV,GET_PARAM
; EXPECTS - JP_004 = 1, SAVE PROFILE 0;	PARAMETER = 0
;		   = 0,		     1;           = 1
; RETURNS - 
;==================================================
;
ATX_W:
	SETB	JP_004
	LCALL	GET_PARAM
W1:	CJNE	A,#1,W0
	CLR	JP_004
W0:	LCALL	SAVENV
	SJMP	ATX_X3		
;
;==================================================
;ATX_X - TRANSMIT CLOCK SOURCE
;  THIS COMMAND SELECTS THE SOURCE OF THE TRANSMIT CLOCK
;
;   &X0 = MODEM GENERATES TRANSMIT CLOCK
;   &X1 = DTE PROVIDES TRANSMIT CLOCK
;   &X2 = TRANSMIT CLOCK IS DERIVED FROM RECEIVE CARRIER
; DESTROYS - ACC
; CALLS -  GET_PARAM 
; EXPECTS - NOTHING
; RETURNS - WITH CLOCK_1 AND CLOCK_2 BITS SET AS SPECIFIED
;==================================================
;
ATX_X:	ANL	S27,#0CFH	;CLR	CLOCK_1
				;CLR	CLOCK_2
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATX_X3	;BRANCH IF NONE OR ZERO
ATX_X1:	CJNE	A,#01,ATX_X2
	SETB	CLOCK_1
	SJMP	ATX_X3
ATX_X2:	SETB	CLOCK_2
ATX_X3:	LJMP	AT_000		
;
;==================================================
;ATX_Y - SETUP HARD RESET PROFILE
;  
;   &Y0 = HARD RESET PROFILE 0
;   &Y1 = HARD RESET PROFILE 1
; DESTROYS - ACC,R0,JP_004
; CALLS -   WRT_NV,FETCH
; EXPECTS - NOTHING
; RETURNS - 
;==================================================
;
ATX_Y:
	LCALL	GET_PARAM
	MOV	R0,#HRST_P		;POINT TO NV RAM &Y PROFILE
	SETB	JP_004			; LSB
	CJNE	A,#0,ATX_Y1
	MOV	A,#EP_ID		;AT&Y0
	RL	A
ATX_Y0:			
	LCALL	WRT_NV
	LJMP	AT_000
ATX_Y1:					;AT&Y1
	MOV	A,#EP_ID
	RL	A
	SETB	ACC.0
	SJMP	ATX_Y0
	
;======================================================================== 113S
;ATX_Z - STORE PHONE NUMBER TO NV RAM
; DESTROYS - ACC,R0,R1,JP_004
; CALLS -  FETCH,IS_VALID
; EXPECTS - 
; RETURNS - 
;========================================================================
;
ATX_Z:	
	MOV	R1,#MAX_ADD	;STORE MAX NV ADD COUNT
	CLR	JP_004
	CLR	S_DIAL
	CLR	ABORT
	PUSH	REG_4
	MOV	R0,#TADD0
;----------------------------------- NEW OLD CHECK
	MOV	REG_4,#0
AZ_27:	LCALL	FETCH
	INC	REG_4
	CJNE	A,#'=',AZ_28
	SJMP	AZ_31
AZ_28:	CJNE	A,S3,AZ_29
	SJMP	AZ_30
AZ_29:	CJNE	R4,#MAX_TEL_DIG,AZ_27
AZ_30:	
	DEC	POINTER			;OLD			
	DJNZ	REG_4,AZ_30
	SJMP	ATX_Z1
;---------------------------------------- NEW
AZ_31:	DEC	POINTER			
	DEC	POINTER	
	LCALL	FETCH
	ACALL	TEL_ADD_S	
	INC	POINTER
ATX_Z1:	LCALL	NV_W
	MOV	A,#BUFFER
	ADD	A,POINTER
	MOV	R1,A
	MOV	@R1,S3			;buffer tail
	POP	REG_4
	LJMP	AT_000

;========================================================================
; TEL_ADD_S - INITIALIZE TEL ADDRESS TO R0
; DESTROYS - ACC,R0,JP_004
; CALLS -  FETCH,IS_VALID
; EXPECTS - 	A = GROUP #
; RETURNS - 	R0 <- ADDRESS AVAILABLE
;		JP_004 = 1
;========================================================================
TEL_ADD_S:
	CJNE	A,#'1',CKP2
	MOV	R0,#TADD1
	SJMP	OKAD
CKP2:	CJNE	A,#'2',CKP3
	MOV	R0,#TADD2
	SJMP	OKAD
CKP3:	CJNE	A,#'3',NOO1
	MOV	R0,#TADD3
	SJMP	OKAD
NOO1:	MOV	R0,#TADD0
OKAD:	SETB	JP_004
	RET

;############################################################
;#                                                          #
;#             THE EXTENDED "AT" SUBROUTINES                #
;#                                                          #
;############################################################
;
;---------------------------------------------------------- SEND CR LF
SD_CRLF:
	PUSH	ACC
	MOV	A,#0DH
	LCALL	PUT_CHAR
	MOV	A,#0AH
	LCALL	PUT_CHAR
	POP		ACC
	RET
;
;==================================================
;GET_S - GET THE CONTENTS OF THE S REGISTER POINTED TO BY R1
;
; DESTROYS - DPTR
; CALLS - NOTHING 
; EXPECTS - R0 POINTING TO THE SELECTED S REGISTER
; RETURNS - WITH THE CONTENTS OF THE SELECTED S REGISTER IN THE ACC
; STACK - 0
;==================================================
;
GET_S:	
	PUSH	REG_1
	MOV	A,R0
	MOV	DPTR,#AT_POINT
	MOVC	A,@A+DPTR		;GET ADDRESS OF S REGISTER IN RAM
	JZ	GET_S1			;RETURN 0 IF REGISTER NOT USED
	MOV	R1,A
	MOV	A,@R1			;GET S REGISTER CONTENTS
GET_S1:	SJMP	PUT_S2
;
;==================================================
;PUT_S - PUT THE VALUE IN THE ACC INTO THE S REGISTER POINTED
;        TO BY THE VALUE IN R1 
;
; DESTROYS - DPTR
; CALLS - NOTHING 
; EXPECTS - R0 POINTING TO THE SELECTED S REGISTER
;           ACC = NEW S REGISTER VALUE
; RETURNS - NOTHING
; STACK - 0
;==================================================
;
PUT_S:	
	PUSH	REG_1
	PUSH	ACC
	MOV	A,R0
	MOV	DPTR,#AT_POINT
	MOVC	A,@A+DPTR		;GET ADDRESS OF S REGISTER IN RAM
	JZ	PUT_S1			;EXIT IF REGISTER NOT USED
	MOV	R1,A
	POP	ACC
	MOV	@R1,A			;UPDATE S REGISTER
PUT_S2:	POP	REG_1
	RET
PUT_S1:	POP	ACC
	SJMP	PUT_S2
;
;========================================
; WRT_NV - WRITE BYTE TO NV RAM (8 bits)
; DESTROYS - B
; CALLS -
; EXPECTS -	ACC = BYTE TO WRITE
;          	R0 = ADDRESS TO WRITE TO
;		JP_004 = 0 ------- WRITE MSB 
;			 1 ------- WRITE LSB
; RETURNS - NOTHING
; STACK - 6
;========================================
;
WRT_NV:
	JNB	JP_004,PF2
	PUSH	ACC
	LCALL	READ_NV
	MOV	B,A
	POP	ACC
PF1:	SJMP	WRT_NV0		;PUT 16 BITS DATA & RET
PF2:	MOV	B,A
	LCALL	READ_NV	
	SJMP	PF1
;
;========================================
;WRT_NV0 - WRITE BYTE TO NV RAM (16 bits)
; DESTROYS - R1
; CALLS -
; EXPECTS - B,ACC = BYTE TO WRITE; B first
;           R0 = ADDRESS TO WRITE TO
; RETURNS - NOTHING
; STACK - 6
;========================================
;
WRT_NV0:
	CLR	NV_CS
	PUSH	ACC
	LCALL	NV_RAM_EN	;enable write
	LCALL	NV_ERASE	;ERASE WORD
	MOV	A,#50H
	LCALL	WRT_NV_COM	;SEND WRITE COMMAND (0101)
	MOV	A,R0
	LCALL	WRT_NV_ADR	;SEND ADDRESS
	POP	ACC
	LCALL	WRT_NV_DAT0	;PUT DATA INTO NV RAM 16 BYTES
	LJMP	NV_RAM_DIS	;AND RETURN
;
;========================================
;READ_NV - READ BYTE FROM NV RAM  (8 bits)
; DESTROYS - ACC,R1
; CALLS - NV_RAM_EN,NV_RAM_DIS,WRT_NV_ADR,RD_NV_DAT
; EXPECTS - R0 = ADDRESS TO READ FROM
;		JP_004 = 0 ------- READ LSB 
;			 1 ------- READ MSB
; RETURNS - ACC = RESULT
; STACK - 4
;========================================
;
READ_NV:
	CLR	NV_CS
	MOV	A,#60H
	LCALL	WRT_NV_COM	;SEND READ COMMAND (0110)
	MOV	A,R0
	LCALL	WRT_NV_ADR	;SEND ADDRESS
	JNB	JP_004,RD_2
	LCALL	RD_NV_DAT2	;GET DATA INTO ACC (MSB bits)
	RET	
RD_2:	LCALL	RD_NV_DAT	;GET DATA INTO ACC (LSB bits)
RD_1:	RET			
;
;========================================
;READ_NV0 - READ BYTE FROM NV RAM  (incoming next 8 bits)
; DESTROYS - ACC,R1,B
; CALLS - NV_RAM_EN,NV_RAM_DIS,WRT_NV_ADR,RD_NV_DAT
; EXPECTS - R0 = ADDRESS TO READ FROM
; RETURNS - ACC = RESULT
;	    NV_CS NOT CLEAR
; STACK - 4
;========================================
;
READ_NV0:
	CLR	NV_CS
	MOV	A,#60H
	LCALL	WRT_NV_COM	;SEND READ COMMAND (0110)
	MOV	A,R0
	LCALL	WRT_NV_ADR	;SEND ADDRESS
	LCALL	RD_NV_DAT0	;GET DATA INTO ACC (8 bits)
	RET			
;
;========================================
;WRT_NV_COM - OUTPUT COMMAND TO NV RAM
; DESTROYS - R1,R2,R3
; CALLS - 
; EXPECTS - R0 = ADDRESS TO READ FROM
; RETURNS - ACC = RESULT
; STACK - 2
;========================================
;
WRT_NV_COM:
	SETB	NV_CS
	MOV	R1,#4
	LCALL	WNV_1		;WRITE COMMAND TO RAM
	RET
;
;========================================
;WRT_NV_DAT - OUTPUT DATA TO NV RAM	B,A --> 16 BITS 
; DESTROYS - R1,R2,R3
; CALLS - 
; EXPECTS - R0 = ADDRESS TO READ FROM
; 		B,ACC
; RETURNS - ACC = RESULT
; STACK - 2
;========================================
;
WRT_NV_DAT:
	SETB	NV_CS
	MOV	R1,#8
	PUSH	ACC	
	MOV	A,B
	LCALL	WNV_1		;WRITE D15-D8
	POP	ACC	
	MOV	R1,#8
	LCALL	WNV_1		;WRITE D7-D0
	CLR	NV_CS		;DISABLE CHIP
	LCALL	CLKNV1
	LCALL	CLKNV1
	MOV	A,#3
	LCALL	WAIT_3MS	
	RET
;
;========================================
;WRT_NV_DAT1 - OUTPUT DATA TO NV RAM	MSB
; DESTROYS - R1,R2,R3
; CALLS - 
; EXPECTS - R0 = ADDRESS TO READ FROM
; RETURNS - ACC = RESULT
; STACK - 2
;========================================
;
WRT_NV_DAT1:
	SETB	NV_CS
	MOV	R1,#8
	LCALL	WNV_1		;WRITE D15-D8
	CLR	NV_CS		;DISABLE CHIP
	
	LCALL	CLKNV1
	LCALL	CLKNV1
	MOV	A,#3
	LCALL	WAIT_3MS	
	RET
;
;========================================
;WRT_NV_DAT0 - OUTPUT DATA TO NV RAM
; DESTROYS - R1,R2,R3
; CALLS - 
; EXPECTS - R0 = ADDRESS 
; RETURNS - ACC = RESULT
; STACK - 2
;========================================
;
WRT_NV_DAT0:
	SETB	NV_CS
	MOV	R1,#8
	PUSH	ACC
	MOV	A,B
	LCALL	WNV_1		;WRITE D15-D8
	POP	ACC	
	
	MOV	R1,#8
	LCALL	WNV_1		;WRITE D7-D0
	CLR	NV_CS		;DISABLE CHIP
	
	LCALL	CLKNV1
	LCALL	CLKNV1
	MOV	A,#3
	LCALL	WAIT_3MS	
	
	RET
;
;========================================
;WRT_NV_ADR - OUTPUT ADDRESS TO NV RAM
; DESTROYS - R1,R2,R3
; CALLS - 
; EXPECTS - R0 = ADDRESS TO READ FROM
; RETURNS - ACC = RESULT
; STACK - 2
;========================================
;
WRT_NV_ADR:
	RL	A
	RL	A		;MAKE SURE MSB IS IN ACC.7 
	MOV	R1,#6
	LCALL	WNV_1		;WRITE A6-A0

	IFTRUE	DOI
	SETB	C	
	MOV	NV_DO,C
	ENDIF

	RET
;
;========================================
;NV_RAM_EN - ENABLE NV RAM FOR WRITE
; DESTROYS - R1,R2,R3
; CALLS - 
; EXPECTS - R0 = ADDRESS TO READ FROM
; RETURNS - ACC = RESULT
; STACK - 2
;========================================
;
NV_RAM_EN:
	SETB	NV_CS
	MOV	A,#4CH
	MOV	R1,#6
NVRE1:	LCALL	WNV_1		;ENABLE CHIP FOR WRITE
	LCALL	CLKNV1
	LCALL	CLKNV1
	LCALL	CLKNV1
	LCALL	CLKNV1
	CLR	NV_CS
	LCALL	CLKNV1
	RET
;
;========================================
;NV_RAM_DIS - DISABLE NV RAM FOR WRITE
; DESTROYS - R1,R2,R3
; CALLS - 
; EXPECTS - R0 = ADDRESS TO READ FROM
; RETURNS - ACC = RESULT
; STACK - 2
;========================================
;
NV_RAM_DIS:			;DISABLE CHIP FOR WRITE
	SETB	NV_CS
	MOV	A,#40H
	MOV	R1,#6
	SJMP	NVRE1
;
;========================================
;RD_NV_DAT - READ BYTE FROM NV RAM;	LSB
; DESTROYS - R1,R2,R3
; CALLS - CLKNV1
; EXPECTS - R0 = ADDRESS TO READ FROM
; RETURNS - ACC = RESULT
; STACK - 2
;========================================
;
RD_NV_DAT:	
	MOV	R1,#8
RD_NV1:	LCALL	CLKNV1		; MSB
	DJNZ	R1,RD_NV1
	MOV	R1,#8
RD_NV2:	LCALL	CLKNV1
	MOV	C,NV_DO
	RLC	A
	DJNZ	R1,RD_NV2
	CLR	NV_CS
	RET
;
;========================================
;RD_NV_DAT2 - READ BYTE FROM NV RAM;	MSB
; DESTROYS - R1,R2,R3
; CALLS - CLKNV1
; EXPECTS - R0 = ADDRESS TO READ FROM
; RETURNS - ACC = RESULT
; STACK - 2
;========================================
;
RD_NV_DAT2:	
	MOV	R1,#8
RD_NV22:	LCALL	CLKNV1
	MOV	C,NV_DO
	RLC	A
	DJNZ	R1,RD_NV22
	CLR	NV_CS
	RET
;
;========================================
;RD_NV_DAT0 - READ BYTE FROM NV RAM;	NEXT BYTE
; DESTROYS - R1,R2,R3
; CALLS - CLKNV1
; EXPECTS - R0 = ADDRESS TO READ FROM
; RETURNS - ACC = RESULT
; STACK - 2
;========================================
;
RD_NV_DAT0:	
	MOV	R1,#8
RD_NV02:	LCALL	CLKNV1
	MOV	C,NV_DO
	RLC	A
	DJNZ	R1,RD_NV02
	RET
;
;========================================
;NV_ERASE - ERASE SELECTED LOCATION IN NV RAM
; DESTROYS - R1,R2,R3
; CALLS - WRT_NV_COM,WRT_NV_ADR,CLKNV1,WAIT_3MS 
; EXPECTS - R0 = ADDRESS TO READ FROM
; RETURNS - ACC = RESULT
; STACK - 4
;========================================
;
NV_ERASE:
	SETB	NV_CS
	MOV	A,#70H
	LCALL	WRT_NV_COM	;SEND ERASE COMMAND (0111)
	MOV	A,R0	
	LCALL	WRT_NV_ADR	;SEND ADDRESS
	LCALL	CLKNV1
	CLR	NV_CS
	LCALL	CLKNV1
	LCALL	CLKNV1
	MOV	A,#3
	LCALL	WAIT_3MS	
	RET		
;
;========================================
;CLKNV1 - CLOCK NV RAM ONCE
; DESTROYS - R1,R2,R3
; CALLS - 
; EXPECTS - R0 = ADDRESS TO READ FROM
; RETURNS - ACC = RESULT
; STACK - 0
;========================================
;
CLKNV1:
	NOP
	SETB	NV_CLK
	NOP
	NOP
	NOP
	CLR	NV_CLK
	NOP
	RET
;========================================
;WNV_1
;WRITE TO NV RAM BIT BY BIT  (ACC = BYTE, R1 = NUMBER OF BITS TO WRITE)
; DESTROYS - R1,R2,R3
; CALLS - NOTHING
; EXPECTS - ACC = BYTE TO WRITE
;           R1 = NUMBER OF BITS TO WRITE
; RETURNS - NOTHING
; STACK - 0
;========================================
;
WNV_1:	RLC	A
	MOV	NV_DI,C		;OUTPUT BIT
	SETB	NV_CLK
	NOP
	NOP	
	NOP	
	CLR	NV_CLK		;CLOCK IN BIT
	NOP
	NOP	
	NOP	
	DJNZ	R1,WNV_1
	RET	
;
;========================================
;SAVE_NV - PUT SAVED OPTIONS FROM ACTIVE S REGISTERS TO NV RAM
; DESTROYS - R0,ACC,B
; CALLS - NOTHING
; EXPECTS -	JP_004 = 1 ------- LSB
;		       = 0 ------- MSB
; RETURNS -
; STACK - 8
;========================================
;
SAVENV:	MOV	R0,#00		;POINT TO S REGISTER STORAGE IN NV RAM
	MOV	A,S0
	LCALL	WRT_NV
	INC	R0
	MOV	A,S14
	LCALL	WRT_NV
	INC	R0
	MOV	A,S18
	LCALL	WRT_NV
	INC	R0
	MOV	A,S21
	LCALL	WRT_NV
	INC	R0
	MOV	A,S22
	LCALL	WRT_NV
	INC	R0
	MOV	A,S23
	LCALL	WRT_NV
	INC	R0
	MOV	A,S25
	LCALL	WRT_NV
	INC	R0
	MOV	A,S26
	LCALL	WRT_NV
	INC	R0			;NV_8
	MOV	A,S27
	CLR	ACC.3			;140
	CLR	ACC.7			;140
	LCALL	WRT_NV

	INC	R0
	MOV	DPTR,#OPT_0
	MOVX	A,@DPTR
	ANL	A,#3
	MOV	B,A
	MOV	DPTR,#OPT_3
	MOVX	A,@DPTR
	ANL	A,#3
	RR	A
	RR	A
	RR	A
	ORL	A,B
	MOV	B,A
	MOV	DPTR,#OPT_5
	MOVX	A,@DPTR
	ANL	A,#7
	RL	A
	RL	A
	ORL	A,B
	LCALL	WRT_NV

	INC	R0
	MOV	DPTR,#OPT_1
	MOVX	A,@DPTR
	LCALL	WRT_NV
	
	INC	R0
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	LCALL	WRT_NV
	
	INC	R0
	MOV	DPTR,#OPT_C
	MOVX	A,@DPTR
	LCALL	WRT_NV
	
	INC	R0
	MOV	DPTR,#OPT_4
	MOVX	A,@DPTR
	LCALL	WRT_NV
	
	INC	R0
	MOV	DPTR,#OPT_D
	MOVX	A,@DPTR
	LCALL	WRT_NV
	
	INC	R0
	MOV	DPTR,#OPT_8
	MOVX	A,@DPTR
	LCALL	WRT_NV
	
	INC	R0
	MOV	DPTR,#OPT_9
	MOVX	A,@DPTR
	LCALL	WRT_NV
	
	INC	R0					;NV_17
	MOV	DPTR,#OPT_A
	MOVX	A,@DPTR
	LCALL	WRT_NV
	
	RET

;==================================================
;LOADNV - LOAD NV RAM OPTIONS
; DESTROYS - ACC,R0,R1,R2
; CALLS -  READ_NV
; EXPECTS - 
; RETURNS -  WITH BUFFER CONTAINING 'D' AND DIAL STRING
; STACK - 2
;==================================================
;
LOADNV:	
	MOV	R0,#00		;POINT TO S REGISTER STORAGE IN NV RAM
	LCALL	READ_NV
	MOV	S0,A
	INC	R0
	LCALL	READ_NV
	MOV	S14,A
	INC	R0
	LCALL	READ_NV
	MOV	S18,A
	INC	R0
	LCALL	READ_NV
	MOV	S21,A
	INC	R0
	LCALL	READ_NV
	MOV	S22,A
	INC	R0
	LCALL	READ_NV
	MOV	S23,A
	INC	R0
	LCALL	READ_NV
	MOV	S25,A
	INC	R0
	LCALL	READ_NV
	MOV	S26,A
	INC	R0				;NV_8
	LCALL	READ_NV
	MOV	S27,A
	CLR	S27.3				;140
	CLR	S27.7				;140

	INC	R0					
	LCALL	READ_NV
	MOV	B,A
	ANL	A,#3
	MOV	DPTR,#OPT_0
	MOVX	@DPTR,A
	MOV	A,B
	RL	A
	RL	A
	RL	A
	ANL	A,#3
	MOV	DPTR,#OPT_3
	MOVX	@DPTR,A
	MOV	A,B
	RR	A
	RR	A
	ANL	A,#7
	MOV	DPTR,#OPT_5
	MOVX	@DPTR,A

	INC	R0
	LCALL	READ_NV
	MOV	DPTR,#OPT_1
	MOVX	@DPTR,A

	INC	R0
	LCALL	READ_NV
	MOV	DPTR,#OPT_2
	MOVX	@DPTR,A

	INC	R0
	LCALL	READ_NV
	MOV	DPTR,#OPT_C
	MOVX	@DPTR,A

	INC	R0
	LCALL	READ_NV
	MOV	DPTR,#OPT_4
	MOVX	@DPTR,A

	INC	R0
	LCALL	READ_NV
	MOV	DPTR,#OPT_D
	MOVX	@DPTR,A

	INC	R0
	LCALL	READ_NV
	MOV	DPTR,#OPT_8
	MOVX	@DPTR,A

	INC	R0
	LCALL	READ_NV
	MOV	DPTR,#OPT_9
	MOVX	@DPTR,A

	INC	R0					;NV_17
	LCALL	READ_NV
	MOV	DPTR,#OPT_A
	MOVX	@DPTR,A

	RET
STK_BK:	DB	0DH,0AH,'NOT SUPPORTED IN ON LINE MODE !',0FFH	;001
	END		
