 	list	on
	PL	104
	pw	128
;************************************************************************
;* FILE		: MOD3.ASM  UNIVERSAL					*
;* SUBJECT	: ORIGINATE/ANSWER AND DATA MODE			*
;************************************************************************

; 3/1/91	RELEASE 1.0
	
	LIST	OFF
	INCLUDE CONFIG.ASM
	INCLUDE RDEFINE.ASM
	LIST	ON
;
;========================================
;EXTERNAL DEFINITIONS
;========================================
;
;FROM MODULE1.ASM
	EXTERNAL	INIT_MOD,INIT_IO,INIT_TIM
	EXTERNAL	SET300,SET1200,SET2400
	EXTERNAL	WARM0,WARM1,WARM_ST,PWR_ON
	EXTERNAL	WAIT200
	EXTERNAL	CXR_OFF,CXR_ON
	EXTERNAL	DSR_ON,DSR_OFF
	EXTERNAL	HIS_ON,HIS_OFF
	EXTERNAL	CTS_ON,CTS_OFF
	EXTERNAL	SET_T1,RST_EC
	EXTERNAL	PUT_CHAR,BK_RAM
	EXTERNAL	SET_OUT
	
	IFFALSE	NSP
	EXTERNAL	BRK_SND,DCE_S			;145
	ENDIF
	
	IFFALSE	X2400
	EXTERNAL	IDLE,CTS_ON1,SET_UR,INIT_SOM
	ENDIF

;FROM MODULE4.ASM
	EXTERNAL	C_ENERGY

;FROM MODULE5.ASM
	EXTERNAL	ON_HOOK,OFF_HOOK,SND_RESULT,MSG_NCAR
	EXTERNAL	MSG_OK,CON_MSG,MSG_ERR,WAIT_3MS,WAIT_SEC
	EXTERNAL	SPEAK_OFF,SPEAK_ON,SND_DIGITS,V1_CRLF
	EXTERNAL	V_CRLF,UPDATE_IO,WAIT_3RD,SND_BITS
	EXTERNAL	SND_OK

;FROM MODULE5.ASM
	EXTERNAL	CLR_LDLB,SET_LDLB
	EXTERNAL	GO_ONLINE

;FROM MODULE6.ASM
	EXTERNAL	SND_ERR_CNT

;FROM MODULE8.ASM
	EXTERNAL	SD_CRLF

;FROM MNP4S.ASM
	EXTERNAL	EC_MAIN,P_ECRAM_1

;FROM SPDCNV.ASM	
	EXTERNAL	SPD_IN,INI_SPD


;FROM WMOD.ASM
	IFTRUE	X2400
	EXTERNAL	SET_FSK,SET_PSK,SET_300S,SET_1200A
	EXTERNAL	RXTX_MK,BELL_TXON,SET_EQUAL,SET_HS
	EXTERNAL	SET_MK,SET_DAT,SET_V22		;104
	EXTERNAL	CLR_HS,SET_S1,SET_SCM,P_EC,A_EC,SET_300A
	EXTERNAL	SET_R12,SET_R24,SET_MN,SET_IDL,SET_T24
	EXTERNAL	SET_ANS,SET_ASYN,SET_SYN,SET_X_CLOCK
	EXTERNAL	SET_GAURD,SET_T12,EN_RXD,RX_MK,FRZ_EQUAL
	EXTERNAL	CLR_SCM,SET_DOT,SET_BEL,EN_AL,KIL_EQUAL
	EXTERNAL	WR1_CNTL,RD_STAT
	ENDIF

	IFFALSE	X2400
	EXTERNAL	WR1_CNTL,RS_TPEQ
	EXTERNAL	SET_V21,SET_T12,SET_T24,SET_R12,SET_R24
	EXTERNAL	SET_SCM,SET_EQUAL,OFF_EQUAL
	EXTERNAL	RXTX_MK,SET_MK,EN_RXD,SET_S1,RX_MK
	EXTERNAL	SET_ASYN,SET_ANS
	EXTERNAL	SET_V22,SET_103
	EXTERNAL	CHK_AGC
;	EXTERNAL	CLR_RTS,SET_RTS				;104D
	EXTERNAL	SET_NTD,WR0_CNTL,RD0_CNTL,SET_ALBF,FAX_ANS
	EXTERNAL	CLR_NTXD			;138
	EXTERNAL	SET_TMOD,OFF_SCR					;000
	EXTERNAL	CLR_SCM,KIL_EQUAL,FRZ_EQUAL,SET_DOT
	EXTERNAL	CLR_HS,SET_SYN,SET_PAR,SET_TXI,CLR_PAR,CLR_TXI
	EXTERNAL	SET_X_CLOCK,CLR_CLMP,SET_CLMP	;104D
	EXTERNAL	P_EC,A_EC,SET_GAURD,EN_AL		;300

	ENDIF
	
	EXTERNAL	CLR_ANS				;131
	EXTERNAL	TX_ON,TX_OFF			;104
	EXTERNAL	SET_SLAVE,V22_I		;135 123
	EXTERNAL	RX_MKD,EN_RXDD			;130
	EXTERNAL	TX_BK

	IFTRUE	V.23
;FROM MOD10.ASM FOR XR2321
	EXTERNAL	V_ORG,B_ENERGY,V21_ANS,ORG_TRY,ORG_PRE
	EXTERNAL	V23_TRY,INIT_21SPD		;158
	EXTERNAL	V21TRY,ORGV21			;171
	EXTERNAL	V23_PA,VSPD_IN,VINI_SPD,S23MD	;160
	ENDIF

;========================================
;Public Definitions
;========================================
	GLOBAL	ORIGINATE,ANSWER,DISCONNECT,DATA_MOD
	GLOBAL	INIT_FLAGS,MAN_ORG
	GLOBAL	MSG_VER1,CHECK_TST
	GLOBAL	IRT_OFF
	GLOBAL	V22A15
	GLOBAL	TEST_TIM,ND_SPD				;125	
	GLOBAL	CLR_ON_FLGS,CHK_PAT
	GLOBAL	SET_T2,SET_LCXR
	GLOBAL	CHK070,CHECK_ESC
	GLOBAL	DATS00
	GLOBAL	DISCONNECTM
	GLOBAL	SPD_OUT,ESC_CNT,PRE_TIM,S2
	GLOBAL	ANS103,C_FAILED

	IFTRUE	X2400					;300S
	GLOBAL	CHK_RET
	ENDIF						;300T

	IFTRUE	MICROCOM
	GLOBAL	ON_LOOP,GO_MNP
	ENDIF	

	IFFALSE	NSP
	GLOBAL	GC_SPD
	ENDIF

;	EJECT
	TITLE Module 3 - ORIGINATE/ANSWER AND DATA MODE
;-------------------------------------------------------------------------
	CODE
;
MSG_VER1:
	IFFALSE	MICROCOM
	DB	'3'	;FOR XR2900
	ENDIF

	IFTRUE	V42ONLY
	DB	'7'	;FOR XR2942
	ENDIF
	
	IFTRUE	V42BIS
	DB	'9'	;FOR XR2943
	ENDIF

	DB	'.'	
	
	IFTRUE	X2400
	DB	'0'
	ENDIF
	IFFALSE	X2400
	DB	'1'
	ENDIF
	
	DB	'0 E '	

	IFTRUE	V.23
	DB	' + V.23'	;FOR XR2923
	ENDIF
	
	IFTRUE	REMOTE
	DB	'+ REMOTE'	;FOR REMOTE ACCESS
	ENDIF

	DB	'      REVISION 2.1'
	DB	0FFH		;MESSAGE TAIL

;############################################################
;#                                                          #
;#                 ORIGINATE MODE                           #
;#                                                          #
;############################################################
;
;============================================================
; ORIGINATE - COMES HERE AFTER ANSWER TONE DETECTED IN DIAL MODE.
; MAN_ORG - COMES HERE FOR MANUAL ORIGINATE
;  THIS IS THE MAIN ENTRY POINT FOR THE ORIGINATE MODE.  
;  IF THE ORIGINATE "AT" COMMAND IS AT 2400 BAUD THEN CCITT V.22BIS
;    MODE IS ASSUMED AND THE PROGRAM BRANCHES TO BIS_ORG.
;  IF THE ORIGINATE "AT" COMMAND IS AT 1200 BAUD AND BELL212 FLAG IS
;    CLEARED THEN CCITT V.22 MODE IS ASSUMED AND THE PROGRAM BRANCHES
;    TO V22_ORG.
;  THE ORIGINATE "AT" COMMAND IS AT 1200 BAUD AND BELL212 FLAG IS
;    CLEARED THEN CCITT V.22 MODE IS ASSUMED AND THE PROGRAM BRANCHES
;    TO V22_ORG.
;  IF THE ORIGINATE "AT" COMMAND IS AT 1200 BAUD AND BELL212 FLAG IS
;    SET THEN BELL 212 MODE IS ASSUMED AND THE PROGRAM BRANCHES
;    TO BELL_ORG.
;  IF THE ORIGINATE "AT" COMMAND IS AT 300 BAUD THEN BELL 103 MODE IS
;    ASSUMED AND THE PROGRAM BRANCHES TO BELL_ORG.
; 
; DESTROYS: ACC,DPTR,R0,R1,R2,SOFT TIMER 1,SOFT TIMER 2,SOFT TIMER 4
;           SOFT TIMER 7
; CALLS:  SET_S7,SPEAK_ON,C_ENERGY,SPEAK_OFF,WAIT_3MS,C_DATA,ALB_MODE  
;         SET_FSK,SET_PSK,WAIT_3RD,CHK_AGC,DSR_ON,BELL_TXON,RXTX_MK
;         SET_1200A,WR1_CNTL,SET_SCM,SET_EQUAL,SET_V22,CLR_HS,SET_S1
;         TX_ON,SET_MK,SET_300S,SET_T24,SET_R24
; EXPECTS:  BELL212 Flag set for Bell 212 originate
;           BELL212 Flag cleared for CCITT V.22 originate
;        
;============================================================
;
MAN_ORG:	
	LCALL	SET_S7			;START S7 TIMER (30 SECONDS)
	LCALL	SPEAK_ON
ORIGINATE:
	LCALL	CT_INIT			;131
	SETB	ORG_BIT			;ORIGINATE STATUS BIT
	
	LCALL	CLR_ANS			;SETUP FILTER

	JB	ALB_REQ,ALB
	JB	ALB1_REQ,ALB
ORG010:	JNB	LEASED_L,ORG011
	LJMP	L_LINE

ALB:	LJMP	ALB_MODE		;TURN ALB ON

ORG011:	JNB	BIT_24,ORG012		;
	LJMP	BIS_ORG			;2400BPS ORIGINATE

ORG012:	JB	BIT_3,ORG_3		;160S

	IFTRUE	V.23
	MOV	DPTR,#JS5
	MOVX	A,@DPTR
	JB	ACC.0,ORG23
	ENDIF

	JB	BELL212,BELL_ORG
	LJMP	BIS_ORG			;V22 (1200) ORIGINATE

ORG_3:	
	IFTRUE	V.23
	JB	BELL212,G_BELL
ORG23:	LJMP	V_ORG
	ENDIF

;========================================
;
;BELL 212/103 ORIGINATE
;
;========================================
;
BELL_ORG:
G_BELL:					;160T
	IFFALSE	X2400
	LCALL	SET_103
	ENDIF

	IFTRUE	X2400
	LCALL	SET_FSK
	ENDIF
	
ORG020:	LCALL	C_ENERGY
	JBC	RI,ORG090		;EXIT IF USER ABORT
	JB	LEASED_L,ORG021		;NO S7 ABORT IF LEASED LINE
	JNB	TIM_1F,ORG090		;EXIT IF S7 TIMEOUT
ORG021:	JNC	ORG020			;WAIT FOR ENERGY
;
;====================
;ENERGY DETECTED FROM FAR END - VALIDATE
;====================
;
ORG030:	LCALL	CHK_AGC			;CHECK RECEIVE GAIN
	MOV	A,S9
	LCALL	SET_T2			;CXR DETECT RESPONSE TIME
ORG032:	LCALL	C_ENERGY
	JBC	RI,ORG090		;BRANCH IF USER ABORT
	JNC	ORG020			;ENERGY DISAPPEARED, GO BACK 
	JB	TIM_2F,ORG032
	LCALL	DSR_ON
;
;====================
;VALID ANSWER TONE DETECTED
;====================
;
ORG035:	JB	BIT_12,ORG050		;BRANCH IF 212 ORIGINATE 1200
;
;====================
;103 ORIGINATE MODE
;====================
;
ORG037:
	IFFALSE	X2400
	LCALL	SET_103
	LCALL	TX_ON
	ENDIF

	IFTRUE	X2400
	LCALL	SET_FSK
	LCALL	SET_300S
	LCALL	BELL_TXON
	ENDIF
	
	LCALL	RXTX_MK
	MOV	A,#90
	LCALL	WAIT_3RD		;WAIT 300MS
	MOV	DPTR,#OPT_7		;130S
	MOV	A,#3
	MOVX	@DPTR,A			;130T 
	LJMP	ANS103			;GO TO DATA MODE
ORG040:	MOV	A,#3
	LCALL	SET_T2

ORG042:	LCALL	C_ENERGY
	JBC	RI,ORG090
	JNB	TIM_1F,ORG090		;BRANCH IF S7 TIMOUT
	JNC	ORG040			;BRANCH IF ENERGY DISAPPEARS
	JNB	ACC.0,ORG040		;BRANCH IF NOT MARK
	JB	TIM_2F,ORG042		;WAIT FOR 300MS
	MOV	DPTR,#OPT_7
	MOV	A,#1
	MOVX	@DPTR,A			;SET 300 CONNECTION
	LJMP	ANS103			;GO TO DATA MODE

ORG090:	LJMP	C_FAILED		;USER ABORT
;
;====================
;BELL 212 ORIGINATE
;====================
;
ORG050:
	LCALL	V22_I
	MOV	TIM_4,#30		;133S GAIN
	SJMP	ORG050B
ORG050A:
	MOV	TIM_4,#10		;GAIN
ORG050B:
	SETB	TIM_4F
ORG052:	LCALL	C_ENERGY
	JBC	RI,ORG090		;EXIT IF USER ABORT
	JNC	ORG020A
	JB	LEASED_L,ORG053		;NO S7 ABORT IF LEASED LINE
	JNB	TIM_1F,ORG090		;EXIT IF S7 TIMEOUT
ORG053:	JB	TIM_4F,ORG052		;WAIT FOR 50MS
	LCALL	CHK_AGC

	MOV	A,#60		
	LCALL	SET_T2
ORG055:	MOV	TIM_4,#30
	SETB	TIM_4F
ORG060:	JBC	RI,ORG090	;EXIT IF USER ABORT
	JB	LEASED_L,ORG061
	JNB	TIM_1F,ORG090	;EXIT IF S7 TIMEOUT
ORG061:	LCALL	C_ENERGY
	JNC	ORG055		;ENERGY LOST - RESTART TIMER
	LCALL	C_DATA
	JNB	TIM_2F,ORG062	;133T
	JNB	ACC.0,ORG055	;NOT A MARK - RESTART TIMER
	JB	TIM_4F,ORG060	;WAIT FOR 100MS OF SCRAM MARK

	LCALL	SET_EQUAL	;EQUALIZER ON
	MOV	DPTR,#OPT_7		;130S
	MOV	A,#4
	MOVX	@DPTR,A			;130T 
;====================
;100MS OF SCRAMBLED MARK DETECTED
;====================
ORG071:	SETB	HI_SPD1		;SET 1200 STATUS
ORG072:	
	MOV	A,#240		;WAIT 700MS
	LCALL	WAIT_3RD	;
	LJMP	ANS070		;GO TO DATA MODE

ORG062:	LJMP	ORG037

ORG020A:
	LJMP	ORG020
;============================================================
;
;V.22 Originate Sequence (1200)
;
;============================================================
;
V22_ORG:
V22_54:	MOV	A,#82
	LCALL	WAIT_3RD		;WAIT 270MS FOR FAR END TO DETECT 
	LCALL	SET_EQUAL		;EQUALIZER ON
;
;====================
;WAIT FOR SCRAMBLED MARK FROM FAR END
;====================
;
	MOV	TIM_3,#50		;169S
	MOV	TIM_3P,#33
	SETB	TIM_3F			;169T 5000 ms window
V22_55:	MOV	A,#7			;WAIT FOR 600MS OF SCRAMBLED MARK
	LCALL	SET_T2
V22_60:	LCALL	C_ENERGY
	JBC	RI,V22_99
	JNB	TIM_1F,V22_99		
	JNB	TIM_3F,ORG_3A		;169T
	JNC	V22_99			;ABORT IF NO CARRIER
	LCALL	C_DATA
	JNB	ACC.0,V22_55		;ABORT IF NO SCRAMBLED MARK
	JB	TIM_2F,V22_60		;WAIT FOR 600MS OF SCRAMBLED MARK
	MOV	A,#30
	MOV	DPTR,#OPT_7		;130S
	MOV	A,#05H
	MOVX	@DPTR,A			;130T
	LJMP	ORG071			;WAIT 100MS AND THEN CONNECT

ORG_3A:	LJMP	ORG_3			;169
;
;====================
;CONNECT FAILED
;====================
V22_99:	LJMP	C_FAILED
;
;============================================================
;
;V.22 bis Originate Sequence
;
;============================================================
;
BIS_ORG:
	IFFALSE	X2400
	LCALL	SET_V22
	ENDIF

	IFTRUE	X2400
	LCALL	SET_FSK
	LCALL	SET_HS
	ENDIF
	
	LCALL	WAIT_33			;WAIT 33MS FOR FSK SWITCH		
;
BIS100:	MOV	A,S9			;CARRIER DETECT RESPONSE TIME
	LCALL	SET_T2
;
BIS110:	LCALL	C_ENERGY
	JNB	TIM_1F,V22_99		;EXIT IF TIMEOUT
	JBC	RI,V22_99		;BRANCH IF USER ABORT
	JNC	BIS100			;ENERGY DISAPPEARED, GO BACK 
	JB	TIM_2F,BIS110
	LCALL	DSR_ON
	LCALL	CHK_AGC			;CHECK RECEIVE GAIN
;
;========================================
; ENERGY DETECTED LOOK FOR UNSCRAMBLED MARK
;========================================
;
BIS120: 
	IFFALSE	X2400
	MOV	A,#00H		  	;SET UP FOR REG 5
	MOV	B,#05
	LCALL	WR0_CNTL
	LCALL	SET_V22			;SET V.22 BANDS
	ENDIF

	IFTRUE	X2400
	LCALL	SET_1200A
	LCALL	SET_V22			;SET V.22 BANDS
	LCALL	SET_PSK
	ENDIF
	
	LCALL	WAIT_33			;WAIT FOR PSK SWITCH

BIS140A:
	MOV	A,#4			;172S
	LCALL	SET_T2
BIS140:
	MOV	TIM_4,#30		;100ms timer
	SETB	TIM_4F
BIS150:	JBC	RI,V22_99		;EXIT IF USER ABORT
	JNB	TIM_1F,V22_99		;EXIT IF S7 TIMEOUT
	LCALL	C_ENERGY
	JNC	BIS140			;ENERGY LOST - RESTART TIMER
	LCALL	C_DATA
;	JNB	ACC.1,BIS140		;NOT A MARK - RESTART TIMER
	JB	ACC.1,BISMK
	JB	TIM_2F,BIS140
	
	IFTRUE	V.23	
	JB	BELL212,BIS140A
	LCALL	V21TRY
	JNC	BIS140A
	LJMP	ORGV21
	ENDIF	
	
	SJMP	BIS140A			;172T
	
BISMK:	JB	TIM_4F,BIS150		;WAIT FOR 100MS OF UNSCRAM MARK
	SJMP	BIS153

;========================================
;UNSCRAMBLED MARK DETECTED (TIME TO SEND S1 FOR 100MS)
;========================================
;
BIS153:
	IFTRUE	NOISE

	LCALL	CHK_AGC
BIS15A:	MOV	TIM_4,#30
	SETB	TIM_4F
BIS15W:	LCALL	C_DATA
	JNB	ACC.1,BIS15A	;NOT A MARK, RESET TIMER
	JB	TIM_4F,BIS15W

	ENDIF

	MOV	A,#60		;200MS CONSTANT
	LCALL	WAIT_3RD	;WAIT
	LCALL	CLR_HS
	MOV	A,#78		;256MS CONSTANT
	LCALL	WAIT_3RD	;WAIT

	IFFALSE	X2400
	MOV	DPTR,#0FH
	MOVX	A,@DPTR
	ENDIF

	IFTRUE	X2400
	MOV	A,#W_REG6
	LCALL	RD_STAT
	ENDIF
	
	MOV	BK_AGC,A	;SAVE AT TOP OF STACK

BIS155:	JB	BIT_12,BIS156	;BRANCH IF V22 ORIGINATE
	LCALL	SET_S1		;SEND OUT S1
	LCALL	TX_ON
	MOV	A,#30
	LCALL	WAIT_3RD	;TRANSMIT S1 FOR 100MS
BIS156:
	LCALL	TX_ON
	LCALL	SET_SCM		;SEND OUT SCRAMBLED MARK
	LCALL	SET_MK		;
	SETB	PASS
;
;========================================
;TRY TO DETECT S1 PATTERN FROM REMOTE MODEM
;========================================
;
BIS198:	MOV	A,#10		;LOOK FOR S1 FOR 1000MS
	LCALL	SET_T2

BIS200:	MOV	TIM_4,#6	;LOOK FOR 20MS OF S1 SIGNAL
	SETB	TIM_4F

BIS210:	JBC	RI,BIS910	;EXIT IF USER ABORT
	JNB	TIM_1F,BIS910	;EXIT IF S7 TIMEOUT
	JNB	TIM_2F,BIS250A	;BRANCH IF NO S1 SIGNAL IN 200MS
	LCALL	C_ENERGY
	JNC	BIS199		;ENERGY LOST - RESTART TIMER
	LCALL	C_DATA
	JNB	PASS,BIS211
	JB	ACC.1,BIS200	;WAIT FOR UNSCR MARK TO GO LOW 

	MOV	A,#02H
	LCALL	SET_T2		;DELAY 15MS
	LCALL	WAIT_33

	IFTRUE	X2400
	LCALL	SET_300S
	LCALL	SET_1200A	;RESET TIMING RECOVERY
	ENDIF

	CLR	PASS
	SJMP	BIS200
BIS211:	JNB	ACC.4,BIS200	;NOT S1 SIGNAL - RESTART TIMER
	JB	TIM_4F,BIS210	;WAIT FOR 33MS OF S1
	SJMP	BIS250
;
;ENERGY DISAPPEARED (CTS MODEM?)
;
BIS199:	JBC	RI,BIS910	;COMES HERE IF ENERGY DISAPPEARS
	JNB	TIM_1F,BIS910	;EXIT IF S7 TIMEOUT
	LCALL	C_ENERGY
	JNC	BIS199		;WAIT FOR ENERGY TO COME BACK
;
	IFFALSE	X2400
	MOV	DPTR,#0FH
	MOV	A,BK_AGC	;GET AGC GAIN WORD STORED AT BEGIN OF RTRT
	MOVX	@DPTR,A
	ENDIF

	IFTRUE	X2400
	MOV	A,BK_AGC
	MOV	B,#W_REG6
	LCALL	WR1_CNTL
	ENDIF

	MOV	A,#5
	LCALL	WAIT_3MS	;WAIT 16MS

	IFTRUE	X2400
	LCALL	SET_300S
	LCALL	SET_1200A
	ENDIF
;
;ENERGY LOSS DETECTED - IF UNSCRAMBLED MARK DETECTED WITHIN 100MS THEN
; THE MODEM IS NOT A CTS MODEM.
;
BIS230:	MOV	A,#33
	LCALL	WAIT_3RD
	SJMP	BIS250		;LOOK FOR UNSCRAMBLED MARK FOR 100MS
;
;BIS231:	MOV	TIM_4,#10	;CHECK FOR 33MS UNSCRAMBLED MARK
;	SETB	TIM_4F
;;
;BIS232:	LCALL	C_DATA
;	JNB	TIM_2F,BIS250	;BRANCH IF CTS MODEM
;	JNB	TIM_4F,BIS250	;BRANCH IF UNSCRAMBLED MARK DETECTED
;				; THIS COULD STILL BE A V22 OR V22BIS MODEM
;	JB	ACC.1,BIS232	;WAIT FOR UNSCR MARK TO GO LOW 
;	SJMP	BIS231
;;
BIS220:	LJMP	V22_54		;NO S1 SIGNAL (MUST BE V22 MODEM)
BIS910:	LJMP	C_FAILED	;ABORT
;
;========================================
;NO S1 SIGNAL DETECTED, BUT DONT GIVE UP NOW
;========================================
;
BIS250A:
	SETB	PASS		;S1 SIGNAL NOT DETECTED FLAG
	SJMP	BIS254
;
;========================================
;33MS OF S1 SIGNAL DETECTED
;========================================
;
BIS250:	CLR	PASS
BIS254:	LCALL	CLR_HS
	MOV	A,#30
	LCALL	WAIT_3RD	;WAIT 100MS

	LCALL	SET_EQUAL	;EQUALIZER ON
	MOV	A,#105
	LCALL	WAIT_3RD	;WAIT 350MS

	LCALL	SET_R24
	MOV	A,#45
	LCALL	WAIT_3RD	;WAIT 150MS
;
;CHECK 2400BPS RX DATA
;
	JNB	PASS,BIS251	
	MOV	TIM_3,#03H	;SET 60MS WINDOW
	MOV	TIM_3P,#06H	;
	SETB	TIM_3F
BIS252:	MOV	TIM_4,#06H
	SETB	TIM_4F		;CHECK 2400RXD FOR 20MS

BIS253:	LCALL	C_DATA
	JNB	ACC.0,BIS252	;BRANCH IF NOT MARK
	JNB	TIM_3F,BIS255	;BRANCH IF 60MS WINDOW TIMEOUT
	JNB	TIM_4F,BIS251	;BRANCH IF 2400 MARK DETECTED
	SJMP	BIS253		;AND LOOP
;
;STILL NO S1 DETECTED
;
BIS255:
	JNB	LEASED_L,BIS255A	;135S
	LJMP	RET_REQ
BIS255A:			;135T	
	LCALL	SET_R12		;SET 1200 RECIEVE
	LJMP	BIS220		;BACK TO 1200 HANDSHAKE
;
;SUCESSFUL 2400 CONNECT
;
BIS251:	LCALL	SET_T24		;ENABLE 2400 TRANSMITTER AND RECEIVER
	MOV	DPTR,#OPT_7		;130S
	MOV	A,#06H
	MOVX	@DPTR,A			;130T
	SETB	HI_SPD2		;SET 2400 STATUS
	LJMP	ORG072		;SEND CONNECT MESSAGE
BIS900:	LJMP	C_FAILED	;ABORT
;
;############################################################
;#                                                          #
;#                 ANSWER MODE                              #
;#                                                          #
;############################################################
;
;============================================================
;ANSWER - ANSWER MODE OF THE MODEM (BELL 212/103 MODE)
;  IF "AT" AT 300 OR 1200 BAUD AND BELL212 = 1 THEN BELL ANSWER MODE
;  IF "AT" AT 2400 THEN CCITT ANSWER MODE IS ASSUMED
;  IF "AT" AT 1200 AND BELL212 = 0 THEN CCITT ANSWER MODE IS ASSUMED
; DESTROYS:  ACC,DPTR,R0,R1,TIMER 1,TIMER 2,TIMER 3,TIMER 4,TIMER 7
; CALLS: OFF_HOOK,WAIT_3MS,SET_S7,C_ENERGY,C_DATA,CON_MSG,INIT_FLAGS
;        ON_HOOK,SPEAK_OFF,SPEAK_ON,INIT_MOD,SND_RESULT  
; EXPECTS:  BELL212 BIT = 1 FOR BELL 212/103 CONNECT SEQUENCE
;                       = 0 FOR CCITT V.22 CONNECT
;============================================================
;
ANSWER:	
	CLR	ORG_BIT
	LCALL	CT_INIT

	LCALL	SET_ANS
	
	JB	ALB_REQ,ALB_1
	JB	ALB1_REQ,ALB_1
ANS010:	LCALL	OFF_HOOK
	LCALL	SPEAK_ON
	JB	LEASED_L,ANS_L
	
	IFTRUE	FAX
	MOV	DPTR,#OPT_FAX		;4-26-90
	MOVX	A,@DPTR			;4-26-90
	JNB	ACC.1,N_FX		;4-26-90 JUMP IF +FAA
	LCALL	SET_V21			;SET FOR CNG TONE
	CLR	RI
;--------------------------------------- CNG WINDOW
	MOV	A,#4
	LCALL	SET_T1
ANS012:	MOV	TIM_4,#80		;80 * 3.3 ms
	SETB	TIM_4F
ANS011:	JB	RI,ANS014
	MOV	B,#1BH
	LCALL	RD0_CNTL
	JNB	ACC.6,N_CNG
	JNB	TIM_4F,CNG
	JB	TIM_1F,ANS011		;CNG WINDOW
	SJMP	ANS015			;OUT
CNG:
	LJMP	FAX_ANS			;4-26-90 AUTO SWITCH TO FAX H.S.
N_CNG:	
	JB	TIM_1F,ANS012		;CNG WINDOW
N_FX:
	ENDIF

;--------------------------------------- 2150 ms
	CLR	RI
	MOV	A,#50
	LCALL	WAIT_3RD
	MOV	A,#2
	LCALL	WAIT_SEC

ANS015:
	LCALL	SET_S7			;START S7 TIMER
	JB	BIT_24,ANS019
	JB	BELL212,BELL_ANS
	
	IFTRUE	V.23			;149S
	JNB	BIT_3,ANS019
	LJMP	V21_ANS
	ENDIF				;149T
ANS019:	LJMP	V22_ANS
ANS_L:	LJMP	L_LINE
ALB_1:	LJMP	ALB_MODE
ANS014:	LJMP	C_FAILED

;========================================
;103/212 ANSWER MODE
;========================================
;
BELL_ANS:	
	LCALL	SET_ANS

	IFFALSE	X2400
	LCALL	SET_103
ANS025:	LCALL	TX_ON
	ENDIF

	IFTRUE	X2400
	LCALL	SET_300S
ANS025:	LCALL	BELL_TXON
	LCALL	SET_FSK
	ENDIF
	
	LCALL	DSR_ON			;DSR ON WITH ANSWER TONE
	MOV	A,#3
	LCALL	WAIT_3RD		;WAIT 10MS FOR SWITCH TO 103 MODE
;
;LOOK FOR ENERGY FROM FAR END
;
ANS030:	MOV	TIM_4,#20
	SETB	TIM_4F			;START 100MS TIMER
ANS035:	LCALL	C_ENERGY
	JB	LEASED_L,ANS036		;NO TIMEOUT IF LEASED LINE
	JNB	TIM_1F,ANS014		;BRANCH IF S7 TIMEOUT
ANS036:	JBC	RI,ANS014		;BRANCH IF USER ABORT
	JNC	ANS030			;RESET TIMER IF NO ENERGY
	JB	TIM_4F,ANS035		;
	LCALL	CHK_AGC			;CHECK RECEIVE GAIN
;
;====================
;100 MS OF ENERGY DETECTED FROM FAR END
;====================
;
	MOV	A,#16			;WAIT 33MS
	LCALL	WAIT_3RD
	
NTOUT:	MOV	TIM_4,#60
	SETB	TIM_4F			;START 200MS TIMER
ANS040:	JNB	TIM_4F,ANS050		;BRANCH IF 200MS OF 103 MARK DETECTED
	LCALL	C_DATA			
	JB	LEASED_L,ANS041
	JNB	TIM_1F,ANS014		;BRANCH IF S7 TIMEOUT
ANS041:	JBC	RI,ANS014		;BRANCH IF USER ABORT
	JB	ACC.0,ANS040		;STAY IN 103 ANSWER MODE IF 103
	JB	LEASED_L,NTOUT
;	JB	BIT_3,NTOUT		;169

ANS042:	LJMP	ANS060			;DTE NOT 300BPS
;
;====================
;VALIDATE 103 MODE ENERGY		DTE 300BPS
;====================
;
ANS050:	MOV	TIM_4,#100		;133 300 MS CONSTANT
	SETB	TIM_4F
ANS055:	JNB	TIM_4F,ANS057		;BRANCH IF 103 CONNECT
	LCALL	C_DATA
	JB	LEASED_L,ANS054
	JNB	TIM_1F,ANS014		;S7 TIME OUT
ANS054:	JNB	ACC.0,ANS050		;BRANCH IF NO MARK
	JBC	RI,ANS014		;USER ABORT
	LCALL	C_ENERGY
	JC	ANS055
	SJMP	ANS030			;ENERGY DISAPPEARED
ANS057:	SETB	HS_H			;SET 103 MODE
	SETB	BIT_3
	MOV	DPTR,#OPT_7		;130S
	MOV	A,#03H
	MOVX	@DPTR,A			;130T
	SJMP	ANS103
;
;========================================
;CONNECT SEQUENCE FINISHED - TIME TO SEND OUT CONNECT MESSAGE
;========================================
;
ANS070:
	JB	LL_BIT2,SQ_OK
NCK_SQ:	JB	RETRAIN,SQ_CK		;135T
	JB	RET_BIT,SQ_CK
	SJMP	SQ_OK
SQ_CK:
	IFFALSE X2400
	LCALL	SQS_CK			;CK SIGNAL QUALITY
	JNC	Q_FAIL
	ENDIF

SQ_OK:	JB	SYNC,ANS071
	LCALL	SET_ASYN
	SJMP	ANS072

Q_FAIL:	LJMP	RET_REQ

ANS071:	LCALL	SET_SYN
	JNB	CLOCK_1,ANS078		;123S BRANCH IF NOT EXTERNAL CLOCK
	LCALL	SET_X_CLOCK		;SET EXTERNAL CLOCK
	SJMP	ANS077

ANS078:	JNB	CLOCK_2,ANS077		;
	LCALL	SET_SLAVE		;123T 

ANS077:	JNB	ASYN_1,ANS072		;&M0 or &M2
	JB	ASYN_2,ANS072		;&M2
	SETB	SYNC_DTR		;AT&M1
	MOV	TIM_6,S25		;TIME TO IGNORE DTR
	MOV	TIM_6P,#150	
	SETB	TIM_6PF
	SETB	TIM_6F

ANS072:	JB	LL_BIT2,ANS_LL		;135
	JB	RET_BIT,ANS076		;112S no  MESSAGE in RETRAIN
ANS_LL:	JB	SYNC,ANS103		;135
	MOV	DPTR,#OPT_0	
	MOVX	A,@DPTR			
	JNZ	ANS076			;No message in reliable mode
ANS103:	
;	LCALL	CXR_ON			;701 Baytech
	LCALL	CON_MSG			;SEND OUT CONNECT MESSAGE
ANS076:	
;AAA	NOT TO TURN CARRIER ON
;	LCALL	CXR_ON
	JNB	SYNC,ANS073
	JB	CTS_OPT,ANS075		;BRANCH IF CTS ALWAYS ON
	JNB	RTS_L,ANS075		;BRANCH IF RTS ON
	LCALL	CTS_OFF
	SJMP	ANS073
B_DATB:					;146S
	IFTRUE	MICROCOM
	MOV	DPTR,#CB_BUFF
	CLR	A
	MOVX	@DPTR,A
	INC	DPTR
	MOVX	@DPTR,A
	ENDIF
	
	LJMP	B_DATA			;146T

ANS075:	LCALL	CTS_ON
ANS073:	LCALL	HIS_ON			;TURN ON SPEED INDICATION
ANS074:	
	LCALL	INIT_FLAGS		;
	LCALL	SPEAK_OFF		;TURN SPEAKER OFF IF OPTIONED
	
	IFFALSE	X2400
	MOV	DPTR,#0FH
	MOVX	A,@DPTR
	ENDIF

	IFTRUE	X2400
	MOV	A,#W_REG6
	LCALL	RD_STAT
	ENDIF
	
	MOV	BK_AGC,A		;SAVE AT TOP OF STACK
	
	LCALL	RST_EC
	JB	ALB_ON,B_DATB		;146 ;138	US RBT	

	IFTRUE	MICROCOM
	MOV	DPTR,#OPT_0
	MOVX	A,@DPTR
	JZ	B_DATB			;146
	JB	SYNC,SPD_NOI
	MOV	DPTR,#OPT_7		;CHECK CONNECT 300
	MOVX	A,@DPTR
	CJNE	A,#4,Q23		;130S
Q23:	JC	B_DAT00
	JB	BIT_24,GO_MNP		;130T
;	JNB	BELL212,B_DAT00		;139D
GO_MNP:	LCALL	P_EC
	CLR	A			;144S
	MOV	DPTR,#JS7
	MOVX	@DPTR,A			;144T
	LCALL	CH_S4			;122D
;TRY TO COMPENSATE DELAY (OPTOCOM )
;	MOV	A,#3			;DELAY 300 MS
;	LCALL	SET_T2
;LOP_H:	JB	TIM_2F,LOP_H
	MOV	DPTR,#F1ST_E		;161S
	MOV	A,#5
	MOVX	@DPTR,A			;161T
	LJMP	EC_MAIN			;MNP EXIT
SPD_NOI:
	LJMP	SPD_NO
EC_FAIL:
	LJMP	DISCONNECT
ON_LOOP:
	MOV	DPTR,#OPT_6
	MOVX	A,@DPTR
	JZ	ON_LP2
	LCALL	INIT_FLAGS
	SJMP	ON_LP0
ON_LP2:	MOV	DPTR,#OPT_0
	MOVX	A,@DPTR
	CJNE	A,#02,ON_LP1		;AUTO-RELIABLE
	SJMP	ON_LP0	
ON_LP1:	JC	EC_FAIL	
ON_LP0:	LCALL	CON_MSG
;
; AUTO-RELIABLE MODE FALL BACK CHECKING.
;
B_DAT00:
	ENDIF			;mnp

; CHECK NEED SPEED CONVERSION OR NOT.
;
B_DATA:
	
	IFTRUE	V.23		;125S
	JB	V23_SPD,V23_I
	MOV	DPTR,#OPT_7	;158S
	MOVX	A,@DPTR
	CJNE	A,#1,NV21
	SETB	HS_H
	LCALL	ND_SPD
	JNC	SPD_NO
	SETB	V21_SPD
	LCALL	INIT_21SPD
	LJMP	SPD_ON
NV21:				;158T
	ENDIF			;125T
	
	
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	JNB	ACC.0,SPD_NO	
	
	MOV	DPTR,#OPT_7	;129S
	MOVX	A,@DPTR
	CJNE	A,#3,NB103
B103:
;	MOV	DPTR,#JS4	;168DS
;	MOVX	A,@DPTR
;	JB	ACC.2,SPD_ON	;168DT	
NB103:				;129T	
	LCALL	ND_SPD
	JNC	SPD_NO
; -------------------------------------- SPDCNV
SPD_ON:
	IFFALSE	NSP
	LCALL	BK_RAM			;
	LCALL	INI_SPD
	LCALL	P_EC
	SJMP	SPD_GO
	ENDIF

	IFTRUE	V.23
V23_I:
	LCALL	P_EC
 	LCALL	BK_RAM			;
	LCALL	VINI_SPD
	LCALL	S23MD			;160
	LJMP	DAT000
	ENDIF
; -------------------------------------- NO SPDCNV
SPD_NO:
	IFTRUE	V.23		;130S
	MOV	DPTR,#OPT_7	
	MOVX	A,@DPTR
	CJNE	A,#1,OP29
	MOV	DPTR,#XR23P0	;158S V21 
	CLR	A
	JB	ORG_BIT,O_UMK
	SETB	ACC.1
O_UMK:	MOVX	@DPTR,A		;158T
	SJMP	SPD_GO
	ENDIF			;130T

OP29:	LCALL	A_EC
SPD_GO:
	LCALL	R_INITFG		;131
	LCALL	CXR_ON
	
	IFTRUE	MICROCOM
	LCALL	DISP_CBUFF		;146
	ENDIF
	
	LJMP	DAT000			;GO TO DATA LOOP

;========================================
;CHECK FOR 212 ENERGY
;========================================
;
ANS060:	
	IFFALSE	X2400		;135S
	LCALL	V22_I
	ENDIF			;135T

	IFTRUE	X2400
	LCALL	SET_1200A
	LCALL	SET_SCM
	LCALL	SET_PSK
	ENDIF
	
	MOV	A,#30			;135S
	SJMP	ANS060B
ANS060A:	
	MOV	A,#10
ANS060B:	
	LCALL	WAIT_3MS		;WAIT 100MS
	LCALL	CHK_AGC			
	MOV	A,#3
	LCALL	SET_T2			;window
N_MK:	MOV	TIM_4,#20
	SETB	TIM_4F			;TIMER
ANS065:	LCALL	C_ENERGY
	JNC	ANS066			;BRANCH IF ENERGY DISAPPEARS
	JB	LEASED_L,ANS064		;NO TIMEOUT IF LEASED LINE
	JNB	TIM_1F,C_FAILED		;EXIT IF S7 TIMEOUT
ANS064:	JBC	RI,C_FAILED		;EXIT IF USER ABORT
	JNB	TIM_4F,ANS067		;100MS OF 212 SCRAMBLED MARK DETECTED
	LCALL	C_DATA
	JNB	ACC.0,N_MK		;135T
	JB	TIM_2F,ANS065
;	JB	LEASED_L,ANS065		;NO TIMEOUT IF LEASED LINE
	LJMP	BELL_ANS		;GOTO 103 MODE CHECK
ANS066:	LJMP	ANS030
;
;====================
;212 ENERGY RECEIVED 
;====================
;
ANS067:	LCALL	SET_EQUAL		;EQUALIZER ON
	MOV	DPTR,#OPT_7		;130S
	MOV	A,#04H
	MOVX	@DPTR,A			;130T
	LJMP	ORG071			;GO SEND OUT CONNECT MESSAGE
;
;====================
;CONNECT FAILED
;====================
;
C_FAILED:
	CLR	RI
	CLR	HS_H
	LCALL	ON_HOOK
	LCALL	DSR_OFF
	LCALL	SPEAK_OFF
	LCALL	SET_OUT
	MOV	DPTR,#MSG_NCAR
	LCALL	SND_RESULT
	LJMP	WARM_ST
;
;============================================================
;V.22 bis ANSWER MODE
;============================================================
;
V22_ANS:

	IFFALSE	X2400
	CLR	NOISE_BIT
	LCALL	SET_TMOD
	MOV	B,#03H			;SETUP COEFFICIENT FOR ANSWER TONE
	MOV	A,#38H
	LCALL	WR0_CNTL
	MOV	B,#02
	MOV	A,#00
	LCALL	WR0_CNTL
	LCALL	TX_ON
	ENDIF

	IFTRUE	X2400
	CLR	NOISE_BIT
	LCALL	SET_ANS
	LCALL	SET_300S
	LCALL	TX_ON

	MOV	A,#W_REG2
	LCALL	RD_STAT
	ORL	A,#01000001B	
;	SETB	ACC.0			;ENABLE TRANSMITTER
;	SETB	ACC.6			;SET CCITT ANSWER TONE
	CLR	ACC.5			;BELL BASE BAND SHAPING
	MOV	B,#W_REG2
	LCALL	WR1_CNTL	
	LCALL	SET_FSK			;300
	ENDIF

	LCALL	SPEAK_ON		
	LCALL	DSR_ON			;DSR ON WITH ANSWER TONE
;
;SEND 1000MS OF 2100HZ ANSWER TONE
;
;	MOV	A,#10			;SEND 2100HZ FOR 3300MS
	MOV	A,#9
	LCALL	SET_T2
V22A06:	JNB	TIM_2F,V22A07		;WAIT 1000MS
	JNB	RI,V22A06
V22_F1:	LJMP	C_FAILED
V22A07:

	IFTRUE	NOISE
;
;CHECK AGC GAIN WORD HERE
;
	IFFALSE	X2400
	MOV	DPTR,#0FH
	MOVX	A,@DPTR
	ENDIF

	IFTRUE	X2400
	MOV	A,#W_REG6
	LCALL	RD_STAT
	ENDIF
	
	
	MOV	BK_AGC,A	;SAVE AT TOP OF STACK
;	CALL	SND_DIGITS	;OUTPUT VALUE OF AGC TO DTE
;	MOV	A,#20H
;	CALL	PUT_CHAR	;OUTPUT SPACE
	LCALL	C_ENERGY
	JNC	V22AAA		;BRANCH IF NO NOISE DETECTED	
	SETB	NOISE_BIT
	
	ENDIF


;
;SEND 2300MS OF 2100HZ ANSWER TONE
;
V22AAA:
	MOV	A,#23			;SEND 2100HZ FOR 2300MS
	LCALL	SET_T2

	IFTRUE	NOISE

V22A10:					;125S
	JNB	TIM_2F,V22A11		;WAIT 2300MS
	JBC	RI,V22_F1
	SJMP	V22A10			;125T USER ABORT

	ELSE

V22A08:	MOV	TIM_4,#30		;100MS ENERGY TIMER
	SETB	TIM_4F
V22A10:	JBC	RI,V22_F1		;USER ABORT
;AAA	JNB	TIM_4F,V22A12
	JNB	TIM_2F,V22A11		;WAIT 3300MS
	LCALL	C_ENERGY
	JNC	V22A08			;BRANCH IF NO ENERGY PRESENT
	SJMP	V22A10
V22A12:	LJMP	ANS025			;MUST BE BELL MODEM
	ENDIF

;
;SQUELCH TRANSMITTER FOR 75MS
;
V22A11:
	LCALL	TX_OFF			;TRANSMITTER OFF
	MOV	A,#23
	LCALL	WAIT_3RD		;75MS OF NO TONES

	IFFALSE	X2400
	LCALL	SET_V22
	LCALL	OFF_EQUAL
	LCALL	OFF_SCR			;000
	ENDIF

	IFTRUE	V.23			;149S
	MOV	DPTR,#JS5
	MOVX	A,@DPTR
	JNB	ACC.0,NV23
	LJMP	V21_ANS			;ATB2
NV23:
	ENDIF				;149T
;
;SEND UNSCRAMBLED PSK MARK
;
	IFFALSE	X2400
	LCALL	TX_ON
V22A13:	LCALL	SET_V22			;PSK MODE
	LCALL	SET_GAURD		;147 ENABLE GAURD TONE	
	ENDIF


	IFTRUE	X2400
	LCALL	SET_300A
	MOV	A,#W_REG2
	LCALL	RD_STAT
;	ORL	A,#00110001B	
	ORL	A,#00010001B		;702 bell shaping
;	SETB	ACC.0			;ENABLE TRANSMITTER
;	SETB	ACC.4			;SET T/2 EQUALIZER
;	SETB	ACC.5			;SET CCITT BASEBAND
	MOV	B,#W_REG2
	LCALL	WR1_CNTL	
	LCALL	SET_GAURD		;ENABLE GAURD TONE	
V22A13:	LCALL	SET_PSK			;PSK MODE
	ENDIF
	
	
	MOV	A,#100
;AAA	MOV	A,#20
	LCALL	WAIT_3RD		;WAIT FOR PSK SWITCH
;
;WAIT FOR ENERGY FROM FAR END

	IFTRUE	FAX
	MOV	TIM_2,#10D		;5-25-90SEND UNSC FOR 1 SEC
	MOV	TIM_2P,#30		;5-25
	SETB	TIM_2F			;5-25
	ENDIF

	IFTRUE	NOISE
;
;WAIT 500MS AND THEN READ AGC GAIN WORD
;
	JNB	NOISE_BIT,V22A15
	SJMP	V22W100
;
; CHECK	IF BELL MODEM COMING IN
;
V22W12: 
	LJMP	ANS025

V22W100:
	IFFALSE	X2400
	LCALL	SET_V22
	ENDIF
	
	IFTRUE	X2400
	LCALL	SET_HS
	LCALL	SET_1200A
	ENDIF
	
	MOV	A,#4			;WAIT 400MS
	LCALL	SET_T2
V22W14:
	MOV	TIM_4,#30		;100MS RXD DETECT
	SETB	TIM_4F
V22W10:	LCALL	C_DATA
	JNB	ACC.0,V22W14
	JNB	TIM_4F,V22W12
	JB	TIM_2F,V22W10		;WAIT 1 S

; NOT BELL MODEM, WAIT ANOTHER 600MS FOR 2400BPS CONNECTION
;
	IFTRUE	X2400
	LCALL	SET_300A
	ENDIF

	MOV	A,#6			;WAIT 600MS
	LCALL	SET_T2
V22W11:	JB	TIM_2F,V22W11
	
	IFFALSE	X2400
	MOV	DPTR,#0FH
	MOVX	A,@DPTR
	ENDIF

	IFTRUE	X2400
	MOV	A,#W_REG6
	LCALL	RD_STAT
	ENDIF

	CLR	C
	XCH	A,BK_AGC
	SUBB	A,BK_AGC
	JC	V22A16		;BRANCH IF  LOWER
	CJNE	A,#8,V22A17

V22A17:	JNC	V22A18		;VALID SIGNAL LEVEL DETECTED
;
;NOISE DETECTED, JUST SIT HERE AND WAIT FOR ABORT OR TIMEOUT
;
V22A16:	
;	MOV	A,#'F'
;	CALL	PUT_CHAR		;OUTPUT FAILED MESSAGE
V22A19:
	SJMP	V22A18			;FOR 300BPS CONNECTION
;	JNB	TIM_1F,V22_F2		;EXIT IF S7 TIMEOUT
;	JBC	RI,V22_F2		;EXIT IF USER ABORT
;	SJMP	V22A19
;
;SIGNAL DECTECTED HERE, SHOULD HAVE BEEN S1 SIGNAL, SO WE CANNOT DETECT
; THIS SIGNAL.  SINCE WE CANNOT DETECT S1, WE ASSUME THAT WE RECIEVED
; S1 SIGNAL AND START LOOKING FOR 2400 MARK.  ALSO HERE WE SHOULD
; RESTART THE AGC BY SETTING 6F.4
;
V22A18:	
;	MOV	A,#'P'
;	CALL	PUT_CHAR		;OUTPUT GOOD MESSAGE

	IFTRUE	X2400
	MOV	A,#W_REGF
	LCALL	RD_STAT
	SETB	ACC.4			; SET AGC INTO START MODE
	MOV	B,#W_REGF
	LCALL	WR1_CNTL		; 
	ENDIF

	LCALL	CHK_AGC			;CHECK RECEIVE GAIN

	IFFALSE	X2400
	LCALL	SET_V22
	ENDIF

	IFTRUE	X2400
	LCALL	SET_HS
	LCALL	SET_1200A
	ENDIF

	LJMP	V22A30			;GO TO 2400 CONNECT MODE	

	ENDIF

V22A15:
	IFTRUE	V.23
	MOV	TIM_3,#150		;wait 3 sec V21
	MOV	TIM_3P,#6
	SETB	TIM_3F
	ENDIF
V22A15A:	
	LCALL	C_ENERGY
	JC	NORM_H			;

	IFTRUE	FAX
	JB	TIM_2F,FX_BK		;5-25-90
	MOV	DPTR,#OPT_FAX		;4-26-90
	MOVX	A,@DPTR			;4-26-90
	JNB	ACC.1,FX_BK		;4-26-90 JUMP IF +FAA
	LJMP	FAX_ANS			;4-26-90 AUTO SWITCH TO FAX H.S.
FX_BK:	
	ENDIF

	IFTRUE	V.23
	JB	TIM_3F,SWV22	
	LJMP	V21_ANS	
SWV22:	
	ENDIF

	JNB	TIM_1F,V22_F2		;EXIT IF S7 TIMEOUT
	JNB	RI,V22A15A		;EXIT IF USER ABORT
V22_F2:	LJMP	C_FAILED

;Energy Found - LOOK FOR 33ms of S1 SIGNAL in 100ms period
NORM_H:	
;------------------------------------------------------- BIG DIFFERENCE 24/29S
	IFFALSE	X2400
	MOV	A,#2
	LCALL	SET_T2			;window
	MOV	TIM_4,#6		;S1 window
	SETB	TIM_4F
	MOV	TIM_3,#10		;Scrmk timer
	MOV	TIM_3P,#6
	SETB	TIM_3F
	MOV	C,ACC.1
	MOV	PASS,C			;UPDATE UNSCRAMBLED DATA STORAGE
V22A25:	JNB	TIM_1F,V22_F2		;EXIT IF S7 TIMEOUT
	JBC	RI,V22_F2		;EXIT IF USER ABORT
	JNB	TIM_4F,V22A30		;S1 DETECTED
	JNB	TIM_3F,V22A70		;scrmk DETECTED
	JNB	TIM_2F,V22A70		;time out
	LCALL	C_DATA
	JB	ACC.4,V22A26		;BRANCH IF S1 DETECTED
	MOV	TIM_4,#6
	SETB	TIM_4F
V22A26:	JB	ACC.0,V22A25		;BRANCH IF SCRAMARK DETECTED
	MOV	TIM_3,#10	
	MOV	TIM_3P,#6
	SETB	TIM_3F
	SJMP	V22A25	
	ENDIF

;------------------------------------------------------- BIG DIFFERENCE 24/29
	IFTRUE	X2400
	LCALL	CHK_AGC			;CHECK RECEIVE GAIN
	LCALL	SET_HS
	LCALL	SET_1200A
	MOV	TIM_3,#5		;100MS WINDOW
	MOV	TIM_3P,#6		;20MS PRESCALAR
	SETB	TIM_3F
;
V22A24:
	LCALL	C_ENERGY
	JC	NORM_HA			;BRANCH IF NO ENERGY FOUND
V22A24A:
	CLR	P1.7
	SETB	P1.7
	LCALL	SET_PSK
	LCALL	SET_300S
;	LCALL	RST_DSP
	SJMP	V22A15
NORM_HA:
	MOV	TIM_4,#10		;START 33.3MS TIMER FOR S1
	SETB	TIM_4F
	MOV	C,ACC.1
	MOV	PASS,C			;UPDATE UNSCRAMBLED DATA STORAGE
	SJMP	V22A25
V22A97:	LJMP	C_FAILED		;ABORT
V22A25:	JNB	TIM_1F,V22_F3		;EXIT IF S7 TIMEOUT
	JBC	RI,V22_F3		;EXIT IF USER ABORT
	JNB	TIM_4F,V22A30		;BRANCH IF 33MS OF S1 DETECTED
	JNB	TIM_3F,V22A71		;BRANCH IF S1 NOT DETECTED IN 100MS
	LCALL	C_DATA
	JNB	ACC.4,V22A24		;BRANCH IF S1 NOT DETECTED
	JB	ACC.0,V22A25		;BRANCH IF MARK ON RXD
	MOV	TIM_7,#3
	MOV	TIM_7P,#3
	SETB	TIM_7F			;RESTART 30MS MARK COUNTER
	SJMP	V22A25	
	ENDIF
;------------------------------------------------------- BIG DIFFERENT 24/29T

V22_F3:	LJMP	C_FAILED		;ABORT
;
;100MS TIMER TIMEOUT - CHECK FOR MARK ON RXD
;
V22A71:	JNB	TIM_7F,V22A70		;BRANCH IF 30MS OF MARK DETECTED
	SJMP	V22A30			;GO TO 2400 CONNECT MODE	
;
;S1 NOT DETECTED - LOOK FOR 1200 SCRAMBLED MARK
;
V22A70:	MOV	A,#20			;IF NO UNSC MARK IN 2 SEC CHECK FOR 103
	LCALL	SET_T2
V22A72:	MOV	TIM_4,#30		;START 100MS TIMER FOR SCRAM MK
	SETB	TIM_4F
;
V22A75:	JNB	TIM_1F,V22_F3		;EXIT IF S7 TIMEOUT
	JNB	TIM_2F,V22A78
	JBC	RI,V22_F3		;EXIT IF USER ABORT
	LCALL	C_ENERGY
;	JNC	V22A24A			;BRANCH IF ENERGY DISAPPEARS
	JNC	B_24
	JNB	TIM_4F,V22A77		;BRANCH IF 100MS OF MARK DETECTED
	LCALL	C_DATA
	JNB	ACC.0,V22A72		;BRANCH IF MARK NOT DETECTED
	SJMP	V22A75	
V22A77:	LJMP	V22A40
V22A78:	LJMP	BELL_ANS		;GO TO BELL ANSWER MODE
B_24:	
	JBC	RI,V22_F3
	JNB	TIM_1F,V22_F3
	LJMP	V22A11

;S1 SIGNAL DETECTED
;
V22A30:
	IFFALSE	X2400
	SJMP	SKIP1			;153
	ENDIF

	IFTRUE	X2400
	LCALL	WAIT_24B		;WAIT 1 2400 BIT TIME		
	ENDIF
SKIP0:
	LCALL	C_DATA
	JB	ACC.4,V22A30		;WAIT FOR S1 TO GO AWAY
;
;SEND S1 SIGNAL FOR 100MS
;
;	LCALL	CLR_HS
SKIP1:	LCALL	SET_S1
	LCALL	CHK_AGC			;2400 no
	MOV	A,#S1_A			;153 33
	LCALL	WAIT_3RD		;SEND S1 FOR 100MS
;
;SEND PSK SCRAMBLED MARK
;
	LCALL	SET_R12

V22A31:	LCALL	SET_MK
	LCALL	SET_SCM			;SCRAMBLER ON
	MOV	TIM_7,#130
	MOV	TIM_7P,#30
	SETB	TIM_7F			;START 1300MS TIMER
	MOV	A,#5			;500MS TIMER TILL 2400 XMIT
	LCALL	SET_T2
	LCALL	SET_EQUAL		;EQUALIZER ON
	MOV	A,#105
	LCALL	WAIT_3RD		;WAIT 350MS
;
;LOOK FOR 2400 SCRAMBLED MARK
;
	LCALL	SET_R24			;ENABLE 2400 RECEIVER
	SETB	PASS
V22A80:	MOV	TIM_4,#4		;START 15MS TIMER FOR SCRAM MK
	SETB	TIM_4F

V22A85:	LCALL	WAIT_24B		;WAIT 433US
	LCALL	C_ENERGY
	JNC	B_24			;BRANCH IF ENERGY DISAPPEARS
	JNB	TIM_7F,V22A88		;BRANCH IF 2400BPS MARK NOT DETECTED
	JB	LEASED_L,NO_DP		;135
					;IN 700MS
	JNB	TIM_1F,V22A99		;EXIT IF S7 TIMEOUT
;8-16-89
NO_DP:	JB	RET_BIT,NO_ABT		;135
	JBC	RI,V22A99		;EXIT IF USER ABORT
NO_ABT:	JNB	TIM_4F,V22A87		;BRANCH IF 15MS OF MARK DETECTED
	JNB	ACC.0,V22A80		;BRANCH IF MARK NOT DETECTED
	JNB	TIM_2F,V22A86		;BRANCH IF TIME FOR 2400 XMIT
	SJMP	V22A85	
V22A86:	JNB	PASS,V22A85
	LCALL	SET_T24			;SET 2400 XMIT
	CLR	PASS
	SJMP	V22A85
RET_REQA:					;135			
	LJMP	RET_REQ			;135
;
;2400 SCRAMBLED MARK NOT DETECTED IN 700MS AFTER S1 FINISHED
; MUST BE 1200 MODEM ORIGINATING
;
V22A88:	
	JB	LEASED_L,RET_REQA	;135
	LCALL	SET_T12			;SET 1200 XMIT
	LCALL	SET_R12			;ENABLE 1200 RECEIVER
	LJMP	V22A70			;GO CHECK FOR 300BPS
;
;2400 SCRAMBLED MARK DETECTED 
;
V22A87:	JB	TIM_2F,V22A87		;WAIT 600MS BEFORE TX 2400
	LCALL	SET_T24
	MOV	DPTR,#OPT_7		;130S
	MOV	A,#6
	MOVX	@DPTR,A			;130T
	SETB	HI_SPD2			;SET 2400 CONNECT STATUS
	LJMP	ORG072
;
;1200 SCRAMBLED MARK DETECTED (1200 CONNECT)
;
V22A40:	LCALL	SET_EQUAL		;EQUALIZER ON
	LCALL	SET_SCM			;SCRAMBLER ON
	MOV	A,#232
	LCALL	WAIT_3RD		;WAIT 765MS
V22A41:	MOV	DPTR,#OPT_7		;130S
	MOV	A,#5
	MOVX	@DPTR,A
	LJMP	ORG071			;130T

V22A99:	LJMP	C_FAILED
;
;############################################################
;#                                                          #
;#                      DATA MODE                           #
;#                                                          #
;############################################################
;
;============================================================
;DATA_MOD - ONLINE DATA LOOP
; DESTROYS:  ACC,DPTR,R0,R1
;            TIMER1 - SIGNAL QUALITY MONITOR
;            TIMER2 - CARRIER LOSS TIMER
;            TIMER3 - LONG SPACE DISCONNECT TIMER
;            TIMER4 - IRT TIMER
;            TIMER5 - ESCAPE CODE GUARD TIMER
;            TIMER6 - TEST TIMER (SECONDS)
;            TIMER7 - DTR LOSS TIMER
;            TIMER8 - RTS/CTS TIMER
;            TIMER9 - MISC TIMER
;
; CALLS: SET_1200A,SET_T12,CLR_SCM,KIL_EQUAL,EN_RXD,CXR_ON,UPDATE_IO
;        CHECK_TXT,CXR_OFF,RX_MK,FRZ_EQUAL,CLR_LDLB,C_ENERGY,SET_EQUAL
;        SET_LOC,WAIT_3RD,SND_RESULT,CLR_SCM,RXTX_MK,CHK_RTS
; EXPECTS:  NOTHING
;============================================================
;
;========================================
;START OF DATA LOOP
;  CHECK FOR RETRAIN REQUEST
;========================================

DATA_MOD:
	JNB	RETRAIN,DATM00
	LJMP	RET_REQ		;GO TO RETRAIN REQUES ;DAT076:
	
DATM00:
	JB	RDLB_REQ,DAT_R	;138
DATS00:
	IFTRUE	MICROCOM
	MOV	DPTR,#MNP_S
	MOVX	A,@DPTR
	JNB	ACC.5,DAT00S
	LCALL	P_EC
	CLR	A		;144S
	MOV	DPTR,#JS7
	MOVX	@DPTR,A		;144T
	LCALL	CH_S4
	LCALL	R_INITFG	;131
	LJMP	P_ECRAM_1	;GO BACK TO MNP MODE
	ENDIF

DAT00S:	LJMP	B_DATB		;146 GO TO CHECK SPEED CONVERSION OPTION
DAT_R:	LJMP	IRT_MODE	;138 REQUEST DIGITAL LOOPBACK


	IFTRUE	MICROCOM

; ROUTINE TO DISPLAY CB_BUFF FOR \C1, \C2

DISP_CBUFF:
	MOV	DPTR,#CB_BUFF
	MOVX	A,@DPTR
	JZ	NO_CDAT
	SETB	TI		;DISPLAY CB_BUFF FOR \C1,\C2
	MOV	B,A
	MOV	DPTR,#9500H
CB_OUT:	MOVX	A,@DPTR
	LCALL	PUT_CHAR
	DJNZ	B,CB_OUT1
	MOV	DPTR,#CB_BUFF	;RESET CB_BUFF
	CLR	A
	MOVX	@DPTR,A
	SETB	TI
NO_CDAT:
	RET
CB_OUT1:
	INC	DPL
	SJMP	CB_OUT
	ENDIF

GC_SPD:				;118S
	LCALL	CHECK_ESC	;010
	JNB	SPD_FLG,NSP_OUT	;138
	JB	LOST_IT,NSP_OUT	;138

	IFTRUE	V.23
	JNB	V23_SPD,V23_NO
	LJMP	VSPD_IN	
V23_NO:
	ENDIF

	IFFALSE	NSP
	LJMP	SPD_IN
	ENDIF

SPD_OUT:
NSP_OUT:			;138
	RET	

;========================================
;DATA LOOP
;========================================
DAT000:
	IFFALSE	X2400
	LCALL	RS_TPEQ
	ENDIF
	
	LCALL	GC_SPD		;118T
DAT001:	JNB	SYNC,DAT003
	JB	ASYN_2,DAT003	;DONT IGNORE DTR IF AT&M2 OR &M3
;	JB	IGNORE_DTR,DAT005
	JNB	SYNC_DTR,DAT003
	JB	TIM_6F,DAT005	;IGNORE DTR FOR S25 SECONDS AFTER CONNECT
	CLR	SYNC_DTR	;
;
DAT003:	JNB	DTR_L,DAT005	;BRANCH IF DTR STILL ON
	LJMP	LOSS_DTR	;CHECK FOR DTR LOSS
DAT005:	CLR	LOST_DTR

DAT010:	
	IFTRUE	V.23		;125S
	MOV	DPTR,#OPT_7
	MOVX	A,@DPTR
	CJNE	A,#3,Q23D
Q23D:	JNC	G_DATA
V21C:	LCALL	B_ENERGY
	JC	DAT015
	SJMP	L_DATA		;125T
	ENDIF

G_DATA:
	LCALL	C_ENERGY
	JC	DAT015
L_DATA:	LCALL	LOSS_CXR	;GO TO LOSS OF CXR SECTION
	JNC	DAT020		;BRANCH IF NOT TIME TO DROP
	LJMP	DISCONNECT	;CARRIER LOST
DAT015:	JNB	LOST_IT,DAT016
;
; CARRIER LOST, MAKE SURE IT RETURNS FOR 66MS
;
DAT015A:
	MOV	TIM_4,#20
	SETB	TIM_4F
DAT015B:
	IFTRUE	V.23		;130S
	MOV	DPTR,#OPT_7
	MOVX	A,@DPTR
	CJNE	A,#3,Q23E
Q23E:	JNC	CKBCD

	LCALL	B_ENERGY	;2321
	SJMP	SAME		;130T
	ENDIF

CKBCD:	LCALL	C_ENERGY
	
SAME:	JB	RI,DAT020	;ESC
	JNC	DAT020		;BRANCH IF NO ENERGY
	JB	TIM_4F,DAT015B	;WAIT FOR 60MS OF ENERGY

	CLR	LOST_IT		;ENERGY PRESENT 
	LJMP	B_DATA		;136

	LCALL	ND_SPD		;106
	JC	DAT012		;106

				;130S
	LCALL	EN_RXDD		;ENABLE DATA TO DTE
				;130T

DAT012:	JB	CXRLST1,DAT077A	;BRANCH IF S10=255 
DAT016:	LCALL	CXR_ON
DAT020:	
;	LJMP	CHECK_ESC	;010 GO CHECK FOR ESCAPE
	LJMP	DAT030A		;010

DAT077A:
	LJMP	DAT077	;BRANCH IF S10=255 

;====================
;LONG SPACE DISCONNECT CHECK
;====================
;
DAT030:	RET			;010S
DAT030A:
;	LCALL	GC_SPD		;010T
	JNB	LSD_ENB,DAT035	;BRANCH IF LONG SPACE DISCONNECT DISABLED
	JB	LOST_IT,DAT035	;DONT CHECK FOR LSD IF NO CARRIER PRESENT
	MOV	A,STATUS
	JB	ACC.0,DAT033	;BRANCH IF MARK ON LINE (RESET LSD TIMER)
	JB	TIM_3F,DAT035	;BRANCH IF NOT TIME TO DISCONNECT YET
	LJMP	DISCONNECT	;GO DISCONNECT
DAT033:
	MOV	TIM_3,#80	;901S 75 1.5 SECOND CONSTANT
	MOV	TIM_3P,#6	;20MS PRESCALAR
	SETB	TIM_3F
;
;====================
;RTRT CHECK
;====================
;
DAT035:	LCALL	CHK_PAT
	LCALL	GC_SPD		;010 159
	JB	LOST_IT,DAT040	;DONT CHECK FOR RTRT IF NO CARRIER PRESENT
	JNB	RTRT_ENB,DAT040
	JB	HI_SPD1,DAT036
	JB	HI_SPD2,DAT036
	SJMP	DAT040		;NO RTRT IN LOW SPEED MODE
DAT036:	MOV	A,UNSM_CNT
	JNZ	DAT040		;BRANCH IF NO UNSC MARK DETECTED
	LCALL	RTRT_MODE	;GO INTO RTRT MODE
	LJMP	DAT000
;
;====================
;TEST CHECK
;====================
;
DAT040:	JNB	TEST_BIT,DAT050	;BRANCH IF NO TEST IN PROGRESS
	LCALL	UPDATE_IO
	LCALL	CHECK_TST	;CHECK ON TEST STATUS
	JNC	DAT050		
	LJMP	CHK071		;SEND OK MSG THEN WARM START
;
;====================
;S1 CHECK (SEE IF RETRAIN REQUESTED)
;====================
;
DAT050:	JNB	HI_SPD2,DAT060	;ONLY CHECK FOR RETRAIN AT 2400BPS
	JB	LOST_IT,DAT060	;DONT CHECK FOR S1 IF NO CARRIER PRESENT
	JB	ALB_REQ,DAT060	;109S NO RETRAIN IN ALB
	JB	ALB1_REQ,DAT060	;NO RETRAIN IN ALB
	JB	RDLB_ON,DAT060	;138 NO RETRAIN IN RDLB
	JB	DLOOP2_R,DAT060	;138 NO RETRAIN IN R_RDLB

	IFFALSE	X2400
	JB	TIM_4F,DAT060	;BRANCH IF NO S1 DETECTED
	ENDIF

	IFTRUE	X2400
	MOV	A,S1_CNT
	JNZ	DAT060
	ENDIF			;109T

	IFTRUE	JCM		;168S
	MOV	DPTR,#JS4
	MOVX	A,@DPTR
	JB	ACC.1,DAT060A	
	
	IFFALSE	X2400			;300D
	MOV	TIM_4,#S1_STB		;S1 TIMER FOR RETRAIN REQUEST
	SETB	TIM_4F
	ENDIF				;300D
	
	IFTRUE	X2400			;300DS
	MOV	S1_CNT,#S1_NB
	ENDIF				;300DT
	SJMP	DAT060
DAT060A:
	ENDIF			;168T

	LJMP	REQ_RETRAIN	;OTHER SIDE REQESTING RETRAIN
;
;====================
;RTS/CTS DELAY CHECK
;====================
;
DAT060:	
	LCALL	GC_SPD		;118
	JNB	SYNC,DAT070
	LCALL	CHK_RTS		;CHECK FOR RTS/CTS DELAY
;
;====================
;SIGNAL QUALITY CHECK AND AUTOMATIC RETRAIN REQUEST
;====================
;
DAT070:
	JB	RDLB_ON,DAT071	;138
	JB	DLOOP2_R,DAT071	;138
	JNB	HI_SPD2,DAT072	;NO RETRAIN REQUEST IF NOT 2400
	JB	LOST_IT,DAT072	;DONT CHECK FOR RETRAIN IF NO CARRIER PRESENT
DAT073:	MOV	A,STATUS
	JNB	ACC.3,DAT071	;BRANCH IF GOOD SIGNAL QUALITY

	IFTRUE	JCM
	MOV	DPTR,#JS4	;AT.T
	MOVX	A,@DPTR
	JNB	ACC.0,DAT072	;168
	ENDIF
	
	JB	TIM_1F,DAT072
	MOV	A,#255		;
	CJNE	A,S10,DAT075
;
;EQUALIZER CRASH AND S10 = 255
;
DAT077:	JNB	HI_SPD2,DAT071	;ONLY IF 2400
	CLR	CXRLST1		
	LCALL	REST_AGC	;RESTORE AGC GAIN WORD
	LCALL	WAIT_33		;WAIT 33MS
	LCALL	RST_TIM		;RESET TIMING RECOVERY
;
; Equalizer crash - check for retrain
;	
DAT075:	
	IFFALSE	X2400
	LCALL	SQS_CK
	JC	DAT071		;good Q
	SETB	RETRAIN
	LJMP	RET_REQ
	ENDIF

	IFTRUE	X2400		;135S
	LCALL	SET_RTRN
	LCALL	RTRN		;TRY TO RETRAIN
	JNC	DAT074
	ENDIF			;135T
	
;IF LEASED LINE MODE CHECK FOR USER ABORT
;
DAT013:	JNB	LL_BIT2,DAT080	;2400
	JNB	RI,DAT080
	LJMP	V22A99		;USER ABORT
;
DAT080:	SETB	RET_BIT		;
	LJMP	RET250		;GO FINISH RETRAIN SEQUENCE
;
; START RETRAIN MODE
;
DAT074:	MOV	A,#2	
	LCALL	SET_T1		;IF 2 SECONDS OF BAD SIGNAL QUALITY RETRAIN
	SJMP	DAT013

;GOOD SIGNAL; RESET 2 SECOND BAD SIGNAL QUALITY TIMER
;
DAT071:	MOV	A,#2		;RESET 2 SECOND TIMER - GOOD SIGNAL QUALITY
	LCALL	SET_T1		;IF 2 SECONDS OF BAD SIGNAL QUALITY RETRAIN
DAT072:	LJMP	DAT000
;
;============================================================
;LOSS_CXR - LOSS OF CARRIER DETECTED - VALIDATE
; DESTROYS:  ACC,B,R0,R1,TIMER 2
; CALLS: CLR_LDLB,CXR_OFF,RX_MK,C_ENERGY,SET_EQUAL
; EXPECTS:  NOTHING
; RETURNS:  CARRY = 1 TIME TO DISCONNECT
;           CARRY = 0 NO DISCONNECT
; STACK - 10
;============================================================
;
LOSS_CXR:
	LCALL	CXR_OFF
;	JB	RTRT_ON,LOSS3		;BRANCH IF IN RTRT
	JB	DLOOP2_R,LOSS3		;138 BRANCH IF IN RTRT
	JB	LOST_IT,LOSS2		;
LOSS1:	MOV	A,S10			;LOSS OF CXR TIMER
	LCALL	SET_T2
	SETB	LOST_IT			;SET LOST CARRIER FLAG
	LCALL	RX_MKD			;130 CLAMP RECEIVE DATA TO MARK
LOSS2:	
;	JB	LL_BIT2,LOSS2B		;135
	MOV	A,#255
	CJNE	A,S10,LOSS2A		;BRANCH IF CARRIER LOSS DISCONNECT ENB
LOSS2B:	SETB	CXRLST1			;CARRIER LOST AND S10=255
LOSS0A:	CLR	C			;
	RET	
LOSS2A:	JB	TIM_2F,LOSS0A		;BRANCH IF NOT TIME TO DISCONNECT YET
	SETB	C			;DISCONNECT FLAG
	RET
;
;====================
;LOSS OF CARRIER DETECTED,BUT ALSO IN RTRT, RTRT FINISH
;====================
;
LOSS3:	LCALL	FRZ_EQUAL		;FREEZE EQUALIZER
	LCALL	RX_MK
	LCALL	CLR_LDLB
;	CLR	RTRT_ON
	CLR	DLOOP2_R
	MOV	TIM_4,#30		;100MS TIMER
	SETB	TIM_4F
LOSS4:	LCALL	C_ENERGY

	IFTRUE	X2400			;138S
	JNB	TIM_4F,LOSS5
	ENDIF				;138T

	JNC	LOSS4			;WAIT FOR CARRIER TO COME BACK

LOSS5:	LCALL	REST_AGC		;138
	MOV	A,#5			;15MS TIMER
	LCALL	WAIT_3RD
;
	LCALL	RST_TIM			;RESET TIMING RECOVERY
;
;RE-ENABLE EQUALIZER
;
LOSS5B:	LCALL	SET_EQUAL
	MOV	A,#255
	LCALL	WAIT_3RD		;WAIT 830MS 
	SJMP	LOSS1			;
SET_LCXR:
	SETB	LOST_IT
	MOV	A,S10
SET_T2:	MOV	TIM_2,A
	MOV	TIM_2P,#30
	SETB	TIM_2F
	RET
;
;============================================================	
;RESET TIMING RECOVERY - THIS ROUTINE WILL RESET THE TIMING RECOVERY BY 
;                        SWITCHING TO 300BPS RECIEVE AND BACK TO 1200/2400
; CALLS - 
; DESTROYS -
; EXPECTS - NOTHING
; RETURNS - NOTHING
;
;============================================================	
;
RST_TIM:
	IFTRUE	X2400
	MOV	A,#W_REG1
	LCALL	RD_STAT
	CLR	ACC.1
	SETB	ACC.2			;SET 30BPS MODE
	MOV	B,#W_REG1
	LCALL	WR1_CNTL		
	ENDIF

	JB	HI_SPD2,RSTT10
	LJMP	SET_R12			;AND RETURN
RSTT10:
	IFTRUE	X2400			;138S
	LJMP	SET_R24			;AND RETURN
	ENDIF
	
	IFFALSE	X2400
	MOV	DPTR,#4
	MOV	A,#61H
	MOVX	@DPTR,A
	MOV	A,#62H
	MOVX	@DPTR,A
	
	ENDIF				;138T
;
;RESTORE AGC GAIN WORD
;
REST_AGC:

	IFTRUE	X2400
	MOV	A,BK_AGC	;GET AGC GAIN WORD STORED AT BEGIN OF RTRT
	MOV	B,#W_REG6
	LJMP	WR1_CNTL
	ENDIF

	IFFALSE	X2400

	ENDIF

	RET
;
;============================================================
;CHECK_ESC - CHECK FOR "AT" ESCAPE SEQUENCE
; DESTROYS: ACC  
; CALLS:  NOTHING
; EXPECTS:  NOTHING 
;============================================================
;
CHECK_ESC:
	JB	SPD_FLG,SPEC_0
	JB	RI,CHK022		;
CHK013:	JNB	TIM_5F,CHK060		;BRANCH IF GAURD TIMER UP
	LJMP	DAT030			;BACK TO DATA LOOP	
SPEC_0:	MOV	DPTR,#PASS_B
	MOVX	A,@DPTR
	JBC	PSW.5,CK_BK		;131
	SJMP	CHK013
;====================
;CHARACHTER RECEIVED
;====================
CHK022:	MOV	A,SBUF
	CLR	RI
CK_BK:					;131S
	JNZ	N_BKI
	JB	RB8,N_BKI
	PUSH	ACC			;Bk in	
	MOV	DPTR,#JS3		
	MOVX	A,@DPTR
	JNB	ACC.7,N_BKC
	JNB	ACC.0,N_PBK		;Bk ck
	POP	ACC

	IFFALSE	NSP			;145S
	JNB	SPD_FLG,DIR_BK
	JNB	ALB_ON,DIR_BK
	MOV	A,#00
	MOV	BK_TMR,A
	CLR	BRK_SND
	CLR	DCE_S
	MOV	A,#10
	LCALL	SET_T2
WT_BK:	JB	TIM_2F,WT_BK
DIR_BK:
	ENDIF				;145T
	LJMP	CHK070

N_PBK:	SETB	ACC.0			;1st
	MOVX	@DPTR,A
	POP	ACC
	LJMP	DAT030

N_BKI:	PUSH	ACC	
	MOV	DPTR,#JS3
	MOVX	A,@DPTR
	CLR	ACC.0			;Not bk
G_BK:	MOVX	@DPTR,A
N_BKC:	POP	ACC			;131T

CHK021:	MOV	TIM_5,S12		
	MOV	TIM_5P,#6		;20MS PRESCALAR
	SETB	TIM_5F			;START PRE GAURD TIMER

	ANL	A,#7FH			;MASK OFF PARITY
	CJNE	A,S2,CHK050		;BRANCH IF NOT ESCAPE CODE

	JNB	PRE_TIM,CHK050		;BRANCH IF PRE GAURD TIME NOT MET
;========================================
;VALID ESCAPE CHAR WITH VALID PRE GAURD TIME
;========================================
	MOV	A,ESC_CNT
	JZ	CHK050			;TOO MANY ESCAPE CHARACHTERS
	DJNZ	ESC_CNT,CHK040		;BRANCH IF NOT ENOUGH CHARS YET
	NOP				;3 PLUS DETECTED HERE
CHK040:	LJMP	DAT030			;GO BACK TO DATA LOOP
;
;====================
;INVALID CHARACHTER 
;====================
;
CHK050:	MOV	ESC_CNT,#03H		;INIT ESCAPE COUNTER DOWN COUNTER
	CLR	PRE_TIM			;CLEAR PRE GAURD TIME FLAG
	LJMP	DAT030
;
;========================================
;GAURD TIMER TIMED OUT
;========================================
;
CHK060:	MOV	A,ESC_CNT	
	JZ	CHK070B			;BRANCH IF THREE CHARS RECEIVED
	SETB	PRE_TIM
	MOV	ESC_CNT,#03H
	LJMP	DAT030			;BACK TO DATA LOOP
;========================================
;VALID ESCAPE SEQUENCE RECEIVED
;========================================
;
CHK070:	LCALL	SET_LOC			;SETUP FOR LOCAL MODE
CHK071:	LCALL	WAIT_33			;WAIT 33MS FOR SETTLE
	LCALL	RX_MKD			;138

	IFTRUE	V.23			;154S
	JNB	V23_SPD,TXOK
	JB	ORG_BIT,TXOK
	MOV	DPTR,#(XR23P0+2)
	MOV	A,#3
	MOVX	@DPTR,A
TXOK:
	ENDIF				;154T
	
	LCALL	SND_OK
	LJMP	WARM0			;GOTO AUTO BAUD ROUTINE
CHK070B:				;131S
	MOV	DPTR,#JS3
	MOVX	A,@DPTR
	JNB	ACC.7,CHK070C		;010S
	LJMP	DAT030			;131T
CHK070C:
	POP	A			;Be careful !!!
	POP	A
	POP	A
	POP	A
	SJMP	CHK070			;010T

;
;============================================================
;LOSS_DTR - LOSS OF DTR DETECTED - VALIDATE
;  THIS LOSS OCCURS DURING ON LINE MODE ONLY
;  IF &D0 - IGNORE DTR
;  IF &D1 - GO INTO COMMAND STATE
;  IF &D2 - DISCONNECT
;  IF &D3 - RESET MODEM (AND DISCONNECT)
; CALLS: NOTHING
; EXITS - DISCONNECT IF AT&D2 OR AT&D3 AND DTR IS LOST
;       - DAT010: IF DTR IS IGNORED OR DTR STILL PRESENT
;       - CHK070: IF AT&D1 AND DTR IS LOST
;       - PWR_ON: IF AT&D3 AND DTR IS LOST
;============================================================
;
LOSS_DTR:
	JB	ASYN_2,L_DTR50		;BRANCH IF AT&M2 OR AT&M3
	JB	LOST_DTR,L_DTR10	;BRANCH IF DTR LOST PREVIOUSLY
	CLR	A
	CJNE	A,S25,L_DTR20		;BRANCH IF DTR LOSS DELAY	
	SJMP	L_DTR11
L_DTR20:
	MOV	TIM_7,S25
	SETB	TIM_7F			;START DTR LOSS TIMER
	SETB	LOST_DTR		;SET LOST FLAG
L_DTR15:
	LJMP	DAT010
L_DTR10:
	JB	TIM_7F,L_DTR15		;EXIT IF DTR LOSS NOT CONFIRMED
;
;DTR LOST AND S25 LOSS DELAY CONFIRMED
;
L_DTR11:
	MOV	A,S21
	ANL	A,#18H			;ISOLATE DTR STATUS BITS
	CJNE	A,#18H,L_DTR30		;
	LJMP	PWR_ON			;&D3 - RESET MODEM
;
L_DTR30:
	JNB	ACC.4,L_DTR32	
	LJMP	DISCONNECT		;&D2 - DISCONNECT	
;
L_DTR32:	
	JNB	ACC.3,L_DTR34		;BRANCH IF &D0 (DTR FORCED ON)
	LJMP	CHK070			;&D1 - GO TO COMMAND STATE 
					;(SAME AS +++ ESCAPE)
;
L_DTR34:				;IGNORE DTR
	JB	ASYN_1,L_DTR50		;DISCONNECT IF AT&M1 AND AT&D0
	LJMP	DAT010
;====================
;SYNC MODE DTR LOSS
;====================
;
L_DTR50:	
	LJMP	DISCONNECT		
;	
;============================================================
;CHECK_TST - CHECK TEST MODE STATUS
;  THIS ROUTINE CHECKS THE STATUS OF THE TEST MODES.  THE ONLY
;  TESTS THAT ARE CAN POSSIBLY BE RUNNING IN THIS MODE ARE THE
;  RDLB, RDLB/ST, ALB, ALB/ST,RTRT
; DESTROYS: ACC,DPTR,B,R0,R1  
; CALLS:  SND_DIGITS,V_CRLF,SET_MK,KILL_TEST,INIT_MOD,IRT_OFF
;         CLR_LDLB
; EXPECTS: NOTHING  
; RETURNS: CARRY = 1 IF TEST FINISHED
;          CARRY = 0 IF TEST STILL RUNNING
; STACK - 8
;============================================================
;
CHECK_TST:
;	JB	RTRT_ON,CHKT40	;NO TEST TIMER IN RTRT MODE
	JB	DLOOP2_R,CHKT40	;138 NO TEST TIMER IN RTRT MODE
	JB	TIM_6F,CHKT30	;EXIT IF TEST TIMER NOT FINISHED
;	JB	ALB_REQ,CHKT40	;138 2400 no
	CLR	A
	CJNE	A,S18,CHKT10	;BRANCH IF TEST TIMER ENABLED
	SJMP	CHKT40
CHKT10:	LCALL	KILL_TEST	;EXIT ANY TEST IN PROGRESS
	LCALL	SET_OUT
	LCALL	SND_ERR_CNT	;OUTPUT ERROR COUNT IF SELF TEST
	LCALL	SET_MK
CHKT20:	SETB	C
	RET
CHKT40:	MOV	TIM_6,#255
	SETB	TIM_6F		;RESTART TIMER TO KEEP LED BLINKING
CHKT30:	CLR	C		;TEST NOT FINISHED STATUS
	RET

;S18 TIME OUT IN DATA MODE
KILL_TEST:
	CLR	M_READY		;MODEM READY LIGHT ON
	MOV	S16,#00		;CLEAR ALL TEST STATUS
	JNB	ALB_ON,KT_001
	LCALL	INIT_MOD
	CLR	TEST_BIT
	CLR	DATA_BIT	;CLEAR ONLINE STATUS
	CLR	ALB_ON
	CLR	ALB_REQ
	CLR	ALB1_REQ	; 2400 y
	SJMP	KT_003
KT_001:	JNB	RDLB_ON,KT_002
	LCALL	RX_MK		;MARK TO DTE
	LCALL	IRT_OFF
	MOV	A,#60
	LCALL	WAIT_3RD	;WAIT 200MS
	JB	ST_FLAG,KT_003
	LJMP	EN_RXD
;	RET
KT_002:	
	JNB	LDLB_ON,KT_003	;138
	LCALL	CLR_LDLB
KT_003:	RET
;	
;============================================================
;CHK_RTS - CHECK RTS/CTS DELAY
; DESTROYS: ACC,TIMER 8  
; CALLS:  UPDATE_IO
; EXPECTS: NOTHING
; RETURNS: NOTHING
; STACK - 2
;============================================================
;
CHK_RTS:
	JB	CTS_OPT,CRTS10	;EXIT IF &R1 (CTS ON DURING DATA MODE)
;====================
;CTS FOLLOWS RTS
;====================
	JB	RTS_L,CRTS20	;BRANCH IF RTS OFF
	JB	RTS_LOSS,CRTS30	;BRANCH IF PREVIOUS WAS OFF
	JB	TIM_8F,CRTS10	;EXIT IF NOT TIME TO TURN ON CTS
CRTS15:	CLR	CTS_L		;CTS ON AFTER DELAY
	SJMP	CRTS10		;	
CRTS20:	SETB	CTS_L		;RTS OFF - TURN CTS OFF
	SETB	RTS_LOSS	
	SJMP	CRTS10
CRTS30:	CLR	RTS_LOSS
	CLR	A
	CJNE	A,S26,CRTS40	;BRANCH IF RTS/CTS DELAY > 10 MS
	SJMP	CRTS15		;0 DELAY TURN ON CTS
CRTS40:	MOV	TIM_8,S26
	SETB	TIM_8F
	MOV	TIM_8P,#3	;10MS PRESCALAR
CRTS10:	LJMP	UPDATE_IO	;AND RETURN
;	
;============================================================
;
;REQ_RETRAIN - FAR END REQUESTING RETRAIN
;  S1 PATTERN DETECTED
;============================================================
;
REQ_RETRAIN:
	LCALL	SET_RTRN
	SETB	RET_BIT
;	LCALL	SET_1200A	;set 1200 async mode
;	LCALL	SET_T12		;set transmitter to 1200
;	LCALL	CLR_SCM		;SCRAMBLER OFF
;	LCALL	RXTX_MK		
;	LCALL	KIL_EQUAL
	LJMP	SKIP1		;135
;
;############################################################
;#                                                          #
;#                    TEST MODES                            #
;#                                                          #
;############################################################
;
;============================================================
;IRT_MODE - INITIATE REMOTE TEST
;  REMOTE TEST SEQUENCE - 1.  FORCE RECEIVED DATA TO MARK
;                         2.  FORCE TRANSMITTER TO MARK
;                         3.  DISABLE SCRAMBLER
;                         4.  WAIT 180MS
;                         5.  WAIT FOR DOTTING PATTERN FOR 212 MS
;                      IF DOTTING PATTERN RECEIVED
;                         6.  TURN SCRAMBLER ON
;                         7.  WAIT 270MS
;                         8.  RE-ENABLE TRANSMIT AND RECEIVE DATA
;                         9.  SEND OUT CONNECT MESSAGE
;                        10.  GO TO DATA LOOP
;                      IF DOTTING PATTERN NOT RECEIVED
;                         6.  TURN SCRAMBLER ON
;                         7.  RE-ENABLE TRANSMIT AND RECEIVED DATA
;                         8.  SEND OUT ERROR MESSAGE
;                         9.  GO TO DATA LOOP  
; DESTROYS:  ACC,DPTR,TIMER 4
; REQUIRES:  NOTHING
; CALLS:   SET_SCM,WAIT_3MS,SND_RESULT,INIT_FLAGS,SET_LOC,CON_MSG
; RETURNS:  RDLB_ON = 1 IF SUCESSFUL REMOTE TEST INITIATION
; EXITS:  TO DATA MODE
;============================================================
IRT_MODE:
	LCALL	CLR_SCM		;TURN SCRAMBLER OFF
	LCALL	RX_MK
	LCALL	SET_MK
;	LCALL	OFF_SCR
	MOV	A,#54		;WAIT 180MS
	LCALL	WAIT_3RD
	MOV	TIM_4,#250	;START 800 MS TIMER
	SETB	TIM_4F
;
;TRY TO DETECT DOTTING PATTERN
;
IRT_M1:	MOV	DOT_CNT,#75
	MOV	ST_CNT,#16	;16X BAUD CLOCK
	CLR	TF1
IRT_M5:	JNB	TIM_4F,IRT_M6	;BRANCH IF DOTTING PATTERN NOT RECEIVED
	JNB	TF1,IRT_M5
	CLR	TF1
	DJNZ	ST_CNT,IRT_M5
	MOV	ST_CNT,#16	;16X BAUD CLOCK
	LCALL	C_DATA
	JNB	ACC.5,IRT_M1	;BRANCH IF NO DOTTING PATTERN
	DJNZ	DOT_CNT,IRT_M5
	SJMP	IRT_M2		;BRANCH IF DOTTING PATTERN RECEIVED

IRT_M6:	LCALL	SET_LOC
	MOV	DPTR,#MSG_ERR
	LCALL	SND_RESULT
	MOV	A,#30
	LCALL	WAIT_3RD
	LCALL	SET_SCM		;
	LCALL	INIT_FLAGS
	CLR	ST_FLAG
	SJMP	IRT_M4		;SEND ERROR MESSAGE AND GO BACK ONLINE
;
;DOTTING PATTERN RECEIVED
;
IRT_M2:	MOV	A,#1
	LCALL	WAIT_3RD
	LCALL	SET_SCM		;SCRAMBLER ON AGAIN

	IFFALSE	X2400
	LCALL	SET_T12		;138S
	MOV	A,#5
	ENDIF

	IFTRUE	X2400
	MOV	A,#1
	ENDIF

	LCALL	WAIT_3RD
IRT_M7:	LCALL	C_DATA
	JB	ACC.5,IRT_M7	;WAIT FOR DOTTING PATTERN TO GO AWAY
	
	IFFALSE	X2400
	LCALL	SET_T24		;138T
	ENDIF
	
	MOV	A,#81
	LCALL	WAIT_3RD	;WAIT 270MS
	LCALL	SET_LOC
	MOV	DPTR,#MSG_RDLB
	LCALL	SND_RESULT
	LCALL	TEST_TIM	;START TEST TIMER
	LCALL	V_CRLF		;SEND <CR><LF>
	LCALL	INIT_FLAGS
	MOV	A,#30
	LCALL	WAIT_3RD
	SETB	RDLB_ON
	SETB	TEST_BIT
IRT_M4:
	CLR	RDLB_REQ	;138
	JNB	ST_FLAG,IRT_M3	;138
	JB	IRT1_R,IRT_M3
IRT_M8:	LJMP	ALB_35		;GO SET DOTTING MODE AND GO TO INTER MODE
IRT_M3:	
	LJMP	B_DATA		;136

;	IFFALSE	X2400
;	LCALL	EN_AL		;ENABLE DATA
;	ENDIF
;	LJMP	DAT000
;
;============================================================
;IRT_OFF - TURN REMOTE TEST OFF
; DESTROYS:  ACC,B,R0,R1,TIMER 4
; REQUIRES:  NOTHING
; CALLS:  WAIT_3RD,RDLB_ON,TX_ON
; RETURNS:  RDLB_ON = 0
; STACK - 8
;============================================================
;
IRT_OFF:
	IFTRUE	X2400
	JNB	ST_FLAG,IRTO1
	LCALL	SET_MK		;TRANSMIT MARK
	ENDIF
IRTO1:
	LCALL	TX_OFF
	MOV	A,#24
	LCALL	WAIT_3RD	;SQ 75MS

	IFFALSE	X2400		;138S
	LCALL	SET_MK
	LCALL	CLR_NTXD
	ENDIF			;138T

	LCALL	TX_ON
	MOV	A,#81
	LCALL	WAIT_3RD
	CLR	RDLB_ON
	CLR	TEST_BIT
	
;	IFFALSE	X2400		;169DS
;	LCALL	SET_NTD
;	ENDIF			;169DT
	
	RET
;
;============================================================
;CHK_PAT - CHECK FOR PATTERNS ON RECEIVED DATA
;   THIS ROUTINE WILL CHECK SEVERAL PATTERNS EVERY BIT TIME.
;   IT WILL CHECK FOR UNSCRAMBLED MARK - UNSM_CNT
;                     DOTTING PATTERN  - DOT_CNT
;                     S1 PATTERN       - S1_CNT
;                     
; DESTROYS:  ACC,B,DPTR,R0,R1,ST_CNT
; CALLS: C_DATA
; EXPECTS:  NOTHING
; RETURNS: IRT_CNT,UNSM_CNT,DOT_CNT,S1_CNT UPDATED IF NEEDED 
; STACK - 2
;============================================================
;
CHK_PAT:	
	
	IFTRUE	X2400
	JNB	TTF1,CHK_P9		;TTF1 set by tim0
	CLR	TTF1
	DJNZ	ST_CNT,CHK_P9
	MOV	ST_CNT,#4
	ENDIF
	
	LCALL	C_DATA

;--------------------------- CHECK FOR UNSCRAMBLED MARK
	JNB	ACC.1,CHK_P2	;BRANCH IF NO UNSCRAMBLED MARK
	MOV	R0,UNSM_CNT
	CJNE	R0,#00,CHK_P1
	SJMP	CHK_P3
CHK_P1:	
	IFFALSE	X2400		;138S
	CJNE	R0,#(USMK_C/3),CHK_US
	LCALL	FRZ_EQUAL
CHK_US:
	ENDIF			;138T
	
	DEC	UNSM_CNT	;DECREMENT UNSCRAMBLED MARK COUNT	
	SJMP	CHK_P3
CHK_P2:	MOV	UNSM_CNT,#240	;138 240

;--------------------------- CHECK FOR DOTTING PATTERN ERRORS IN TEST MODE
CHK_P3:	JNB	ACC.5,CHK_P4
	INC	DOT_CNT
	SJMP	CHK_P7
CHK_P4:	MOV	DOT_CNT,#00	;CLEAR DOTTING COUNT
	JNB	ST_FLAG,CHK_P7
	MOV	A,ERR_CNT
	CJNE	A,#0FFH,CHK_P5	;BRANCH IF ERR COUNT NOT AT MAX
	SJMP	CHK_P7
CHK_P5:	INC	ERR_CNT

;------------------------ CHECK FOR RETRAIN REQUEST (S1 PATTERN) FROM FAR END
CHK_P7:	
	IFFALSE	X2400
	MOV	A,STATUS		;109S
	MOV	C,ACC.4

	IFTRUE	S1_H
	JC	CHK_P9
	SJMP	CKP7A
	ENDIF
	
	JC	CKP8
	JB	S1_PBIT,CKP7A
	SJMP	CKP9
CKP8:
	JB	S1_PBIT,CKP9
CKP7A:	
	MOV	TIM_4,#S1_STB
	SETB	TIM_4F
CKP9:	MOV	S1_PBIT,C
CHK_P9:	RET
	ENDIF

	IFTRUE	X2400
	RET

CHK_RET:
	LCALL	C_DATA
	MOV	A,STATUS
	MOV	C,ACC.4
;	CPL	P3.4			;300D PIN 14
	MOV	S1_TBIT,C
	JC	CHKP7A			;BRANCH IF BIT = 1

;SPACE ON S1
CHKP7F:	JB	S1_PBIT,CHKP7P		;BRANCH IF CHANGE OCCURED	
	SJMP	CHKP7G

;MARK ON S1
CHKP7A:	JB	S1_PBIT,CHKP7G		;BRANCH IF PREVIOUS ALSO MARK

CHKP7P:	MOV	A,#3
	CJNE	A,S1_TEMP,CHKP7B
	SJMP	CHKP7E
CHKP7B:	INC	A
	CJNE	A,S1_TEMP,CHKP7C
	SJMP	CHKP7E
CHKP7C:	INC	A
	CJNE	A,S1_TEMP,CHKP7D
CHKP7E:	MOV	A,S1_CNT
	JZ	CHKP7M			;BRANCH IF ALREADY 0
	DEC	S1_CNT
CHKP7M:	MOV	S1_TEMP,#1		;INIT BIT COUNT
CHKP7N:	MOV	C,S1_TBIT
	MOV	S1_PBIT,C		;UPDATE PREVIOUS BIT STATUS
CHK_P9:	RET

;NO CHANGE IN PATTERN DETECTED
CHKP7G:	INC	S1_TEMP
	MOV	A,#6
	CJNE	A,S1_TEMP,CHKP7N

;BIT COUNT != 3,4,5
CHKP7D:	MOV	S1_CNT,#S1_NB		;UNKNOWN PATTERN, UPDATE S1 COUNT
	SJMP	CHKP7M

	ENDIF				;109T

;============================================================
;RTRT_MODE - RESPOND TO REMOTE TEST
;  REMOTE TEST SEQUENCE - 1.  COMES HERE IF UNSCRAMBLED MARK DETECTED
;                         2.  SENDS DOTTING PATTERN 
;                         3.  WAITS FOR UNSCRAMBLED MARK TO GO AWAY
;                         4.  PUT EXAR 2400 INTO DIGITAL LOOPBACK 
;                         5.  EXIT TO DATA MODE
; DESTROYS:  ACC,B,R0,R1
; REQUIRES:  NOTHING
; CALLS: SET_DOT,SET_LDLB,RX_MK
; RETURNS:  IN REMOTE DIGITAL LOOPBACK MODE IF UNSCRAMBLED MARK DETECTED
;           AND RTRT_ON = 1
; STACK - 8
;============================================================
;
RTRT_MODE:			;138S
	LCALL	RX_MKD
	LCALL	SET_DOT		;SEND DOTTING PATTERN
RTMD10:	LCALL	C_DATA
	JB	ACC.1,RTMD10	;WAIT FOR UNSCRAM MARK TO GO AWAY

	IFFALSE	X2400
	LCALL	RS_TPEQ
	ENDIF

	MOV	A,#DOT_T
	LCALL	WAIT_3RD

	IFFALSE	X2400
	LCALL	SET_MK
	MOV	A,#SQH_T
	LCALL	WAIT_3RD
	ENDIF

	LCALL	SET_LDLB
;	SETB	RTRT_ON
	SETB	DLOOP2_R
;	LCALL	RX_MK
	RET			;138T

;============================================================
;ALB_MODE - START ANALOG LOOPBACK MODE
; DESTROYS:  ACC,DPTR
; REQUIRES:  NOTHING
; CALLS:  INIT_FLAGS,CON_MSG,WAIT_3RD 
; EXPECTS:  NOTHING
;============================================================
;
ALB_MODE:
	LCALL	CT_INIT			;131
;	ANL	RAM2BH,#9FH		;134S
;	CLR	HI_SPD1
;	CLR	HI_SPD2			;134T

	IFFALSE	X2400
	LCALL	SET_ALBF		;MODEM SETUP
	ENDIF

	IFTRUE	X2400
	MOV	A,#W_REG4
	LCALL	RD_STAT
	SETB	ACC.7			;ANALOG LOOPBACK
	MOV	B,#W_REG4
	LCALL	WR1_CNTL
	ENDIF

	SETB	TEST_BIT
	SETB	ALB_ON
;	LCALL	TEST_TIM		;147D ;138

	MOV	U_ST,#7
	JNB	BIT_24,ALB_10		

;v22bis ALB
;
	LCALL	BIS_ON			;SETUP FOR V22 BIS
	MOV	DPTR,#OPT_7		;131S
	MOV	A,#6
	MOVX	@DPTR,A			;131T
	SJMP	ALB_30

ALB_10:	JNB	BIT_12,ALB_20
;
;1200 bps alb
;
	LCALL	FB_ON			;SETUP FOR 1200BPS
	MOV	DPTR,#OPT_7		;131S
	MOV	A,#5
	MOVX	@DPTR,A			;131T
	SJMP	ALB_30
ALB_20:	
;
;300 bps alb
;
	IFFALSE	X2400
	LCALL	SET_103
	ENDIF

	IFTRUE	X2400
	LCALL	SET_SYN
	LCALL	SET_FSK
	ENDIF
	
	MOV	DPTR,#OPT_7
	MOV	A,#3			;130
	MOVX	@DPTR,A
	
ALB_30:
	LCALL	TX_ON
	MOV	A,#255
	LCALL	WAIT_3RD		;2 SECOND WAIT
	LCALL	V_CRLF			;SEND <CR><LF> TO DTE
	LCALL	INIT_FLAGS		;
	LCALL	TEST_TIM		;147 START TEST TIMER
	JB	ALB1_REQ,SF_T
	LJMP	ALB_40

SF_T:	
ALB_35:	
;	LCALL	TEST_TIM		;147D START SELFTEST TIMER
	LCALL	SPEAK_OFF		;TURN SPEAKER OFF IF OPTIONED
	LCALL	SET_LOC			;SETUP FOR LOCAL MODE
	LCALL	SET_DOT			;START DOTTING PATTERN
	MOV	A,#200			;wait 600 ms for pattern to settle
	LCALL	WAIT_3RD		;
SURE1:	LCALL	C_ENERGY		;147S
	JNC	SURE1			;147T
	MOV	ERR_CNT,#00		;CLEAR ERROR COUNT
	LJMP	WARM0			;ONLINE INTERACTIVE ROUTINE

; -------------------------------------- NO SELFTEST
ALB_40:
	
	IFFALSE	X2400
	LCALL	EN_RXD			;130 ENABLE DATA TO DTE
	ENDIF

	IFTRUE	X2400
;	LCALL	EN_RXD			;ENABLE DATA TO DTE
;	LCALL	SET_DAT			;ENABLE DATA TO DTE
	ENDIF

	SJMP	B_ANS			;147

;	IFTRUE	MICROCOM
;	LCALL	RST_EC
;	JB	BIT_3,B_ANS
;	MOV	DPTR,#OPT_0
;	MOVX	A,@DPTR
;	JZ	B_ANS
;	SETB	ORG_BIT
;	LCALL	BK_RAM
;	LCALL	P_EC

;	MOV	MRCNT,#60
;^spd
;	LCALL	INI_SPDM

;	LCALL	CH_S4			;122D
;	CLR	A			;144S
;	MOV	DPTR,#JS7
;	MOVX	@DPTR,A			;144T
;	LJMP	EC_MAIN
;	ENDIF

B_ANS:
SURE:	LCALL	C_ENERGY		;147S
	JNC	SURE			;147T
	LJMP	ANS074			;GO ONLINE

;SETUP MODEM FOR V22 BIS 
;
BIS_ON:
	LCALL	TX_ON
	
	IFFALSE	X2400
	LCALL	SET_SCM
	MOV	A,#85H
	MOV	DPTR,#0005H
	MOVX	@DPTR,A
	LCALL	SET_V22
	ENDIF
	
	IFTRUE	X2400
	LCALL	SET_SYN
	LCALL	SET_SCM
	LCALL	SET_T12	
	LCALL	SET_R12
	LCALL	SET_V22
	LCALL	SET_PSK			;TURN ON 1200BPS 
	ENDIF
	
	MOV	A,#30
	LCALL	WAIT_3RD		;WAIT 100 MS
	JB	LL_BIT2,BISON2
	LCALL	SET_EQUAL		;ENABLE EQUALIZER
	MOV	A,#2
	LCALL	WAIT_SEC		;WAIT 2 SECONDS
BISON1:	LCALL	SET_R24
	MOV	A,#45
	LCALL	WAIT_3RD		;WAIT 150 MS
BISON2:	LCALL	SET_T24	
	SETB	HI_SPD2
	MOV	A,#100
	LCALL	WAIT_3RD		;WAIT 330 MS
	LCALL	SET_ASYN
	RET

FB_ON:
	IFFALSE	X2400
	MOV	A,#84H			;135 85H
	MOV	DPTR,#0005H
	MOVX	@DPTR,A
	LCALL	SET_V22
	SETB	HI_SPD1
	ENDIF
	
	IFTRUE	X2400	
	LCALL	SET_T12	
	LCALL	SET_R12
	LCALL	SET_SCM
	LCALL	SET_BEL
	LCALL	SET_PSK
	LCALL	SET_ASYN
	SETB	HI_SPD1
	ENDIF
	
	LCALL	TX_ON
	
	MOV	A,#30
	LCALL	WAIT_3RD		;100ms
	LCALL	SET_EQUAL		;ENABLE EQUALIZER
	MOV	A,#1
	LCALL	WAIT_SEC		;WAIT 2 SECONDS
	RET
;
;============================================================
;L_LINE - START LEASED LINE MODE - WHEN ORIGINATE AND ANSWER
;  WHEN LEASED LINE ENABLED, GO DIRECTLY INTO DATA MODE AT
;  AUTOBAUD SPEED.
; DESTROYS:  ACC,DPTR
; REQUIRES:  NOTHING
; CALLS:  INIT_FLAGS,SET_ANS,BIS_ON,FB_ON
;============================================================
;
L_LINE:
	JB	BIT_24,LLINE9
	JB	BIT_12,LLINE5

;--------------------------------------- 300BPS LEASED LINE
;
	JB	ORG_BIT,LLINE1
	LJMP	BELL_ANS		;103 ANSWER MODE
LLINE1:	LJMP	BELL_ORG		;GOTO 103 ORIGINATE MODE	

;--------------------------------------- 1200BPS LEASED LINE
;
LLINE5:	LCALL	V22_I			;135S
W_R01:	LCALL	C_ENERGY
	JBC	RI,LLINE6		;USER ABORT
	JNC	W_R01
	JB	ORG_BIT,LLINE3
	LJMP	ANS060A
LLINE3:	LJMP	ORG050A			;135T
LLINE6:	LJMP	V22A99			;USER ABORT
;
;============================================================
;LLINE24 - LEASED LINE 2400BPS CONNECT MODE
;============================================================
;
LLINE9:
LLINE8:	SETB	LL_BIT2
	LCALL	BIS_ON
;	LCALL	INIT_FLAGS
	LCALL	RX_MK			;FORCE MARK TO DTE UNTIL RETRAIN
LLINE10:
	LJMP	LLL050			;135
	MOV	TIM_4,#30
	SETB	TIM_4F	
LLINE7:	JBC	RI,LLINE6
	LCALL	C_ENERGY
	JNC	LLINE10			;WAIT FOR 100MS ENERGY FROM FAR END
	JB	TIM_4F,LLINE7	
	LCALL	CHK_AGC			;CHECK RECEIVE GAIN

	CLR	P1.7
	SETB	P1.7
	
	IFFALSE	X2400
	LCALL	SET_V22
	ENDIF

	IFTRUE	X2400
	LCALL	SET_PSK
	ENDIF

	LCALL	BIS_ON
W_R00:	LCALL	C_ENERGY
	JBC	RI,LLINE6		;USER ABORT
	JNC	W_R00
;	LCALL	CHK_AGC
	
	IFFALSE	X2400
;	LCALL	SET_V22
	ENDIF

	IFTRUE	X2400
;	LCALL	SET_300S
;	LCALL	SET_1200A
	ENDIF

;	SJMP	LLL050			;GO TO CONNECT LOOP
;
LLL050:					;135S
	MOV	A,#1
	JB	ORG_BIT,LLL060
	MOV	A,#7
LLL060:	LCALL	SET_T2			;100ms
;	MOV	TIM_9,#255
;	SETB	TIM_9F

LLL100:	JBC	RI,LLINE6		;USER ABORT
	LCALL	C_ENERGY
	JNC	LLL050			;BRANCH IF ENERGY DISSAPEARS
LLL120:	JB	TIM_2F,LLL100		;BRANCH IF NOT TIME TO RETRAIN
	LCALL	CHK_AGC
	LJMP	RET_REQ			;135T


;	SETB	P3.4			;135 SEND SIGNAL TO PIN FOR RETRAIN
	LCALL	SET_RTRN		;SETUP FOR RETRAIN
	LCALL	RTRN			;RETRAIN
	LCALL	CLR_RTRN		;BACK TO 2400 MODE
;	CLR	P3.4			;135 SEND SIGNAL TO PIN FOR RETRAIN
	JNC	LLL050			;BRANCH IF RETRAIN FAIL
	LJMP	ANS070			;GO TO CONNECT MODE	
;
LLL150:	JB	ACC.3,LLL160		;BRANCH IF BAD SIGNAL QUALITY
	JNB	ACC.0,LLL160		;BRANCH IF NOT MARK
;
;GOOD SIGNAL QUALITY	
;
	JB	TIM_9F,LLL100		;BRANCH IF NOT 840MS OF GOOD QUALITY
;
;840MS OF GOOD SIGNAL QUALITY
;
	LJMP	ANS070			;GO TO CONNECT MODE
;
;BAD SIGNAL QUALITY - RESET 840MS TIMER
;
LLL160:	MOV	TIM_9,#255
	SETB	TIM_9F
	LJMP	LLL100			;GO BACK
;
; CHECK ANY RELIABLE MODE FALL BACK
;
DISCONNECTM:
	MOV	DPTR,#MRCVP2
	MOVX	A,@DPTR
	CJNE	A,#02,DISCONNECT
;7-22-89
	MOV	DPTR,#Z_BUF
	MOVX	A,@DPTR
	JZ	CNM0
	CLR	A
	MOVX	@DPTR,A
	SJMP	CNM1
	
;7-19 -89
CNM0:	MOV	DPTR,#MRCVP2+3
	MOVX	A,@DPTR
	JNZ	DISCONNECT
CNM1:	LCALL	P_EC
	MOV	DPTR,#MNP_S		;FALLBACK TO NORMAL MODE
	CLR	A
	MOVX	@DPTR,A
	MOV	DPTR,#OPT_6
	MOVX	@DPTR,A
	SETB	EA			;152
	MOV	A,#3			;DELAY 
	LCALL	WAIT_SEC
	LJMP	GO_ONLINE
;	
;============================================================
;DISCONNECT - HANG UP AND RETURN TO IDLE MODE
; DESTROYS:  ACC,DPTR TIMER 4
; REQUIRES:  NOTHING
; CALLS:  CLR_ON_FLGS,WAIT_3MS,SND_RESULT
;      
; RETURNS:  MODEM ONHOOK
;           XR2400 MODEM CHIP RESET
;           INTERRUPT DISABED EXCEPT FOR TIMER
;============================================================
;
DISCONNECT:

;	IFFALSE	X2400
;	LCALL	RX_MK		;154D
;	ENDIF

	MOV	IE,#82H		;155
	CLR	HS_H
	LCALL	CLR_ON_FLGS
	MOV	A,#20
	LCALL	WAIT_3MS	;WAIT 66 MS
	JNB	TEST_BIT,DISC3
	CLR	TEST_BIT
	MOV	DPTR,#MSG_OK
	SJMP	DISC4
DISC3:	
	LCALL	INIT_TIM	;001
	LCALL	SET_OUT		;001
;	LCALL	SD_CRLF
	MOV	DPTR,#MSG_NCAR
DISC4:	LCALL	SND_RESULT
	LJMP	WARM_ST
;
;============================================================
;CLR_ON_FLGS - CLEAR ALL ONLINE FLAGS
;  THIS ROUTINE IS CALLED PRIOR TO GOING BACK TO IDLE MODE
; DESTROYS:  ACC,R0,R1,B,DPTR,S16,TIMER 4,TIMER 1
; REQUIRES:  NOTHING
; CALLS:  WAIT_SEC,ON_HOOK,DSR_OFF,CXR_OFF,CTS_OFF,WAIT_3MS
;         INIT_MOD,INIT_TIM
; RETURNS: NOTHING  
; STACK - 6 
;============================================================
;
CLR_ON_FLGS:
	SETB	RXD_D
	LCALL	RXTX_MK		;MARK TO LINE AND DTE
	JNB	LSD_ENB,CONLF0
	LCALL	TX_BK		;012
	MOV	A,#4
	LCALL	WAIT_SEC	;SEND 4 SECONDS OF SPACE TO FAR END
CONLF0:	LCALL	ON_HOOK
	LCALL	CXR_OFF
	LCALL	DSR_OFF
	LCALL	TX_OFF
	CLR	A
	MOV	DPTR,#OPT_6
	MOVX	@DPTR,A
	MOV	DPTR,#OPT_7
	MOVX	@DPTR,A
	
	IFTRUE	MICROCOM	
	CLR	A		;144S
	MOV	DPTR,#JS7
	MOVX	@DPTR,A
	LCALL	RST_EC		;144T
	ENDIF
;CONLF1:
	CLR	DATA_BIT	;CLEAR ONLINE STATUS
	MOV	A,#151
	LCALL	WAIT_3MS	;WAIT 1/2 SECONDS
	MOV	S16,#00		;CLEAR ALL TEST FLAGS
	CLR	ALB_ON		;146
	CLR	RDLB_ON		;146
	CLR	M_READY		;MODEM READY LED ON
	CLR	SYNC_D		;103
	CLR	RETRAIN		;133
	CLR	RET_BIT		;133


	RET
;
;============================================================
;SET_S7 - SETUP TIMER 1 FOR S7 TIME OUT
; DESTROYS: NOTHING
; CALLS: NOTHING  
; EXPECTS: NOTHING
; RETURNS:  WITH TIMER 1 RUNNING S7 TIMEOUT
; STACK - 0
;============================================================
;
SET_S7:	MOV	TIM_1,S7
	MOV	TIM_1P,#150
	SETB	TIM_1PF
	SETB	TIM_1F
	RET
;
;============================================================
;C_DATA - READ SCRAMBLED AND UNSCRAMBLED DATA STATUS INTO ACC
;		2400	2900
; DESTROYS: DPTR
; CALLS: NOTHING  
; EXPECTS: NOTHING
; RETURNS:  ACC = MODEM STATUS WORD 1
;           ACC.0 = DESCRAMBLED RXD
;           ACC.1 = UNDESCRAMBLED RXD
; STACK - 0
;============================================================
;
C_DATA:
	MOV	DPTR,#RX_P
	MOVX	A,@DPTR		;GET MODEM STATUS
	MOV	STATUS,A	;SAVE IT 
	RET
;
;============================================================
;INIT_FLAGS - INIT FLAGS FOR ONLINE MODE
; DESTROYS: ACC,B,R0,R1
; REQUIRES: NOTHING
; CALLS:  SET300,SET1200,SET2400,RD_STAT,WR1_CNTL  
; RETURNS:  WITH FLAGS AND TEMP REGISTERS READY FOR ONLINE  
; STACK - 6
;============================================================
;
INIT_FLAGS:				;135S
	CLR	LOST_IT			;LOSS OF CARRIER STATUS
	CLR	PRE_TIM			;ESCAPE FLAG
	CLR	CXRLST1
	CLR	RETRAIN			;RETRAIN
	CLR	RET_BIT			;RETRAIN
	SETB	DATA_BIT		;SET ONLINE STATUS
	SETB	REN			;ENABLE UART FOR +++ ESCAPE
	MOV	ESC_CNT,#03		;ESCAPE CODE COUNTER
	MOV	DOT_CNT,#100		;DOTTING PATTERN COUNTER
	MOV	UNSM_CNT,#240		;138 240 UNSCRAMBLED MARK COUNTER
	MOV	TIM_3,#75		;START LONG SPACE DISCONNECT TIMER
	SETB	TIM_3F			;START TIMER
	
	IFFALSE	X2400			;300D
	MOV	TIM_4,#S1_STB		;S1 TIMER FOR RETRAIN REQUEST
	SETB	TIM_4F
	ENDIF				;300D
	
	IFTRUE	X2400			;300DS
	MOV	S1_CNT,#S1_NB
	ENDIF				;300DT

	IFTRUE	MICROCOM
	MOV	DPTR,#OPT_6		;\O, \U, \Y
	CLR	A
	MOVX	@DPTR,A
	ENDIF
	
	IFTRUE	X2400	
	MOV	A,#W_REG3
	LCALL	RD_STAT
	CLR	ACC.0		;300 HANDSHAKE OFF
	SETB	ACC.1
	SETB	ACC.5		;ENABLE TRANSMIT DATA TO LINE
	MOV	B,#W_REG3
	LCALL	WR1_CNTL	
	ENDIF
	
INFL4:	RET			;135T
;
;============================================================
;SET_LOC - SET UP MODEM FOR ONLINE INTERACTIVE MODE
; DESTROYS: DPTR,ACC,B,R0,R1
; CALLS: SET300,SET1200,SET2400,INIT_TIM,RXTX_MK
; EXPECTS: 
; RETURNS:  MODEM IN ONLINE INTERACTIVE MODE
; STACK - 8 
;============================================================
;
SET_LOC:
	MOV	IE,#00000010B	;JUST ENABLE TIMER 0 INTERRUPT
	
	IFTRUE	V.23		;167S
	MOV	DPTR,#OPT_7
	MOVX	A,@DPTR
	CJNE	A,#3,CK_CIP
CK_CIP:	JC	S_CHIP
	ENDIF

	IFFALSE	X2400
	MOV	B,#09		;MODEM IN DATA LOCAL MODE
	LCALL	RD0_CNTL
	CLR	ACC.5		;DISABLE NORMAL TXDATA
	SETB	ACC.0		;CLAMP RXDATA
	LCALL	WR0_CNTL
	ENDIF

	LCALL	RXTX_MK
S_CHIP:			
	LCALL	RX_MKD		;167T
	JB	BIT_1,SETL21
	ANL	RAM2DH,#0F0H		
					;CLR	BIT_1
					;CLR	BIT_3
					;CLR	BIT_12
					;CLR	BIT_24
	LCALL	INIT_TIM		;INIT TIMERS FOR IDLE MODE
	
	MOV	DPTR,#OPT_2		;CHECK SERIAL PORT ADJUSTMENT
	MOVX	A,@DPTR
	JNB	ACC.1,SETL22
	
	JB	HI_SPD1,SETL10		;1200 STATUS
	JB	HI_SPD2,SETL20		;2400 STATUS
	LCALL	SET300	
	SETB	BIT_3
SETL21:	SETB	EA
	RET				;SET BAUD RATE FOR UART (CONNECT SPEED)
SETL22:	LCALL	INIT_TIM
	SJMP	SETL21
SETL10:	LCALL	SET1200	
	SETB	BIT_12
	SJMP	SETL21
SETL20:	LCALL	SET2400	
	SETB	BIT_24
	SJMP	SETL21
;
;============================================================
;TEST_TIM - SET UP TEST TIMER
; DESTROYS: ACC 
; CALLS: NOTHING
; EXPECTS: NOTHING
; RETURNS: NOTHING
; STACK - 0
;============================================================
;
TEST_TIM:
	MOV	TIM_6,S18
	MOV	A,S18
	JNZ	TTIM1
	MOV	TIM_6,#255
TTIM1:	MOV	TIM_6P,#150
	SETB	TIM_6PF
	SETB	TIM_6F
	RET
;
;WAIT  1 2400BPS BIT TIME (433US)
;
WAIT_24B:
	MOV	A,#190
WAIT24:	DJNZ	ACC,WAIT24	;WAIT 380 CYCLES
	RET
;
;============================================================
;CHK_AGC - CHECK TO SEE IF AGC NEEDS SOME HELP
;  THIS ROUTINE CHECKS THE STATUS OF THE AGC.  IF THE AGC IS OUT
;  OF RANGE THIS ROUTINE WILL REDUCE THE RECIEVE GAIN TO 6DB
; DESTROYS: ACC,B,R0,R1
; CALLS: WAIT_3RD,C_ENERGY,RD_STAT,WR1_CNTL
; EXPECTS: NOTHING
; RETURNS: NOTHING
; STACK - 6
;============================================================
;
;CHK_AGC:
	IFFALSE	X2400
	MOV	DPTR,#0FH
	MOV	A,#66H
	MOVX	@DPTR,A
	MOV	A,#5		;16.6 MS CONSTANT
	LCALL	WAIT_3RD
	LCALL	C_ENERGY
	JNC	AGC100		;EXIT IF ENERGY GONE
;	MOV	DPTR,#0EH
;G_LO:	MOVX	A,@DPTR
;	JNB	ACC.0,G_LO
;
	MOV	DPTR,#2H
	MOVX	A,@DPTR
	CJNE	A,#8,AGC200
AGC200:	JNC	B_AGC
	MOV	DPTR,#7H
	MOVX	A,@DPTR
	SETB	ACC.4
	MOVX	@DPTR,A
AGC100:
	RET
B_AGC:	MOV	DPTR,#7H
	MOVX	A,@DPTR
	CLR	ACC.4
	MOVX	@DPTR,A
	RET
	ENDIF
;
	IFTRUE	X2400
CHK_AGC:
	MOV	A,#5		;16.6 MS CONSTANT
	LCALL	WAIT_3RD
	LCALL	C_ENERGY
	JNC	AGC100		;EXIT IF ENERGY GONE
	MOV	A,#W_REG6
	LCALL	RD_STAT		;READ AGC GAIN WORD
	CJNE	A,#9,AGC200
AGC200:	JNC	AGC100
	MOV	A,#W_REG4
	LCALL	RD_STAT
	SETB	ACC.4		;SET RECEIVE GAIN TO 6DB
	MOV	B,#W_REG4
	LCALL	WR1_CNTL
	MOV	A,#10H		;
	MOV	B,#W_REG6
	LCALL	WR1_CNTL	;SET AGC GAIN WORD TO 8
AGC100:	RET
	ENDIF

;**************************************************
;RET_REQ - COMES HERE IF ATO1 COMMAND IS ENTERED OR
;  SIGNAL QUALITY DEGRADES.  THIS ROUTINE WILL REQUEST
;  A RETRAIN USING THE CCITT V.22BIS RETRAIN SEQUENCE.
;  THE REQUEST WILL BE MADE UP TO 5 TIMES.  IF RETRAIN 
;  REQUEST FAILS THE MODEM WILL DISCONNECT. 
;
; DESTROYS: ACC,R0,R1,B
; CALLS: SET_S1,TX_ON,WAIT_3RD,SET_SCM 
;        SET_EQUAL,SET_R24,SET_T24
; EXPECTS: NOTHING
; RETURNS:  NOTHING 
; STACK - 10
; EXITS: 
;**************************************************
;
RET_REQ:
	LCALL	CHK_AGC		;120
;	LCALL	SET_RTRN	;135 SETUP FOR RETRAIN
	MOV	RET_CNT,#9	;REQUEST RETRAIN 9 TIMES
	JNB	LEASED_L,RET050	;135
	MOV	RET_CNT,#20	;135 REQUEST RETRAIN 9 TIMES
RET050:	DJNZ	RET_CNT,RET060
RET057:	LJMP	DISCONNECT	;FAIL S1	
	
	IFFALSE	X2400	
RET051:	MOV	A,#10		;1000MS S1 window
	LCALL	SET_T2
RET052:	MOV	TIM_4,#15	;50ms timer
	SETB	TIM_4F
RET053:	JNB	TIM_2F,RET050	;GO RETRAIN AGAIN
	JNB	LEASED_L,RET056	;135
	JB	RI,RET057	;135
RET056:	LCALL	C_ENERGY
	JNB	ACC.4,RET052	;NOT S1 SIGNAL - RESTART TIMER
	JB	TIM_4F,RET053	;WAIT FOR 50MS OF S1
	LJMP	REQ_RETRAIN	;OTHER SIDE REQESTING RETRAIN

RET060:	LCALL	RTRN		;RETRAIN
	JNC	RET051		;BRANCH IF NO S1 RESPONSE FROM FAR END
	LCALL	SET_R12		;50MS OF S1 SIGNAL DETECTED
	LJMP	BIS250		;ORG RETRAIN

RET250:	LCALL	CLR_RTRN	;**NUSE GO TO 2400 MODE
	JC	RET253		;BRANCH IF RETRAIN SUCCESSFUL
	LCALL	ON_HOOK
	SETB	CXR_L

RET251:	LJMP	DISCONNECT	;FAIL RETRAIN
RET253:	LCALL	EN_AL		;ENABLE DATA TO LINES
	LJMP	ORG072		;**SEND CONNECT MESSAGE IF NEEDED
	ENDIF

	IFTRUE	X2400
RET051:	MOV	A,#10		;LOOK FOR S1 FOR 1000MS
	LCALL	SET_T2
RET052:	MOV	TIM_4,#15
	SETB	TIM_4F
RET053:	JNB	TIM_2F,RET050	;GO RETRAIN AGAIN
	LCALL	C_ENERGY
	JNB	ACC.4,RET052	;NOT S1 SIGNAL - RESTART TIMER
	JB	TIM_4F,RET053	;WAIT FOR 50MS OF S1
	LJMP	REQ_RETRAIN	;OTHER SIDE REQESTING RETRAIN

RET060:	LCALL	RTRN		;RETRAIN
	JNC	RET051		;300 BRANCH IF NO RESPONSE FROM FAR END
	LCALL	SET_R12		;300 50MS OF S1 SIGNAL DETECTED
	LJMP	BIS250		;300 ORG RETRAIN

;50MS OF S1 SIGNAL DETECTED

RET250:	LCALL	CLR_RTRN	;GO TO 2400 MODE
	JC	RET253		;BRANCH IF RETRAIN SUCCESSFUL
	LJMP	DAT071		;GO BACK TO DATA LOOP (RETRAIN UNSUCESSFUL)
	LJMP	DISCONNECT	;300 GO BACK TO DATA LOOP (RETRAIN UNSUCESSFUL)
RET253:	LJMP	ORG072		;SEND CONNECT MESSAGE IF NEEDED
	ENDIF

;************************************************************
;CLEAR RETRAIN REQUEST - BACK TO 2400 MODE
; RETURNS: C = 0 RETRAIN FAILED
;	   C = 1 RETRAIN SUCCESSFUL
;************************************************************
;
CLR_RTRN:
	LCALL	CLR_HS
	MOV	A,#30
	LCALL	WAIT_3RD	;WAIT 100MS
	LCALL	SET_EQUAL	;EQUALIZER ON
	MOV	A,#105
	LCALL	WAIT_3RD	;WAIT 350MS
	LCALL	SET_R24
	MOV	A,#45
	LCALL	WAIT_3RD	;WAIT 150MS
	LCALL	SET_SCM		;SEND OUT SCRAMBLED MARK
	LCALL	SET_T24		;ENABLE 2400 TRANSMITTER AND RECEIVER
	SETB	HI_SPD2		;SET 2400 STATUS
	MOV	A,#60		;
	LCALL	WAIT_3RD	;WAIT 200MS BEFORE CHECK FOR 2400 MARK

	IFTRUE	X2400
;VERIFY 66MS OF 2400 SCRAMBLED MARK BEFORE RETRAIN SUCESSFULL

	JNB	LL_BIT2,CLRRT3
	MOV	TIM_4,#255	;841MS
	SJMP	CLRRT4
CLRRT3:	MOV	TIM_4,#20	;66MS
CLRRT4:	SETB	TIM_4F		;START 66MS TIMER
CLRRT2:	LCALL	C_DATA
	JNB	TIM_4F,CLRRT5
;	JNB	ACC.0,CLRRT7	;BRANCH IF INCOMING SPACE
	JNB	ACC.3,CLRRT2	;BRANCH IF GOOD SIGNAL QUALITY
CLRRT7:	CLR	C
	RET			;BAD RETRAIN STATUS
CLRRT5:	SETB	C		;GOOD RETRAIN STATUS
	RET
	ENDIF	

	IFFALSE	X2400	
; SIGNAL QUALITY DUTYCYCLE CHECK 

SQS_CK:
	IFTRUE	JCM
	MOV	DPTR,#JS4
	MOVX	A,@DPTR
	JNB	ACC.2,CLRRT5	;168
	ENDIF

	PUSH	B
	MOV	B,#40		;DP AHEAD
	MOV	TIM_2,#30	;T2*100 MS sampling window
	SETB	TIM_2F		;
CLRRT2:	LCALL	C_DATA
	JNB	ACC.3,CLRRT8	;BRANCH IF GOOD SIGNAL QUALITY
	DEC	B
	SJMP	CLRRT11
CLRRT8:	INC	B
CLRRT11:
	JNB	TIM_2F,CLRRT9	;Sampling window timeout
	MOV	TIM_4,#11	;T4*3.3 ms sampling period
				;(100*T2)/(3.3*T4) <= 127-DP+1 
	SETB	TIM_4F		;
CLRRT10:
	JB	TIM_4F,CLRRT10
	SJMP	CLRRT2
CLRRT9:	MOV	A,B
	POP	B
	JB	ACC.7,CLRRT7
CLRRT5:	SETB	C		;GOOD RETRAIN STATUS
	RET
CLRRT7:	CLR	C
	RET			;BAD RETRAIN STATUS
	ENDIF

;**************************************************
;RETRAIN REQUEST SUBROUTINE
; DESTROYS: ACC,DPTR,R0,R1
; CALLS: SET_S1,TX_ON,SET_SCM,SET_MK,C_ENERGY,WAIT_3RD
; RETURNS: C = 1 SUCCESSFULL RETRAIN RESPONSE
;          C = 0 NO RESPONSE FROM FAR END
; STACK - 8
;**************************************************
;
RTRN:
	LCALL	SET_RTRN	;135 SETUP FOR RETRAIN
	LCALL	SET_S1		;SEND OUT S1
	LCALL	TX_ON
RTRN10:	MOV	TIM_4,#31	;SEND S1 FOR 100MS
	SETB	TIM_4F
RTRN15:	JB	TIM_4F,RTRN15

	LCALL	SET_SCM		;SEND OUT SCRAMBLED MARK
	LCALL	SET_MK		;
	MOV	A,#3		;LOOK FOR S1 FOR 300MS
	LCALL	SET_T2
RTRN20:	MOV	TIM_4,#S1_STB	;133 S1 timer
	SETB	TIM_4F
RTRN21:	JNB	TIM_2F,RTRN22	;EXIT IF NO S1 SIGNAL IN 300MS
	MOV	S1_PBIT,C	;133
;AAA	JB	RI,RTRN22	;EXIT IF +++ ESCAPE DETECTED
	LCALL	C_ENERGY
	JNC	RTRN20		;ENERGY LOST

	IFFALSE	S1_H		;133S
	MOV	C,ACC.4
	JC	CKPH
	JNB	S1_PBIT,RTRN23
	SJMP	RTRN20
CKPH:	JB	S1_PBIT,RTRN23
	SJMP	RTRN20
	ENDIF

	JNB	ACC.4,RTRN20	;NOT S1 SIGNAL - RESTART TIMER
RTRN23:	JB	TIM_4F,RTRN21	;133T WAIT FOR 50MS OF S1
;
;50MS OF S1 SIGNAL DETECTED
	SETB	C
	RET
;
;NO S1 SIGNAL DETECTED IN 300MS
RTRN22:
	CLR	C
	RET
;
;SETUP FOR RETRAIN - 1200 MODE SCRAMBER OFF AND EQUALIZER OFF
;
SET_RTRN:
	LCALL	RXTX_MK		;MARK TO DTE AND LINE
	
	IFFALSE	X2400
	LCALL	SET_V22
	ENDIF

	IFTRUE	X2400
	LCALL	SET_1200A
	ENDIF

	LCALL	SET_T12		;set transmitter to 1200
	LCALL	CLR_SCM		;SCRAMBLER OFF
	LCALL	KIL_EQUAL	;EQUALIZER OFF	
	RET

				;300D block deleted here !!!

;===============================
; WAIT 33 MILLISECONDS
;===============================
WAIT_33:
	MOV	A,#10	
	LJMP	WAIT_3RD	;WAIT 33MS
		
SET_RN:
	LCALL	RXTX_MK		
	
	IFFALSE	X2400
	LCALL	SET_V22
	ENDIF

	IFTRUE	X2400
	LCALL	SET_1200A
	ENDIF

	LCALL	SET_T12		
	LCALL	CLR_SCM		
	LCALL	KIL_EQUAL	
	RET
ND_SPD:
	MOV	A,TH1
	JNB	HI_SPD2,ND_12
	CJNE	ACC,#BAUD_24,SET_SPD
	CLR	C
	RET	
ND_12:	JNB	HI_SPD1,ND_03
;	CJNE	ACC,#BAUD_12,ND_03
	CJNE	ACC,#BAUD_12,SET_SPD
	CLR	C
	RET
ND_03:	JB	BIT_1,NDDD
	CJNE	ACC,#BAUD_3,SET_SPD
NDDD:	CLR	C
	RET
SET_SPD:
	SETB	C
	RET
	
R_INITFG:				;131S	
	CLR	RET_BIT
	CLR	RETRAIN
	CLR	LL_BIT2	
	MOV	DPTR,#JS3	
	MOVX	A,@DPTR	
	ANL	A,#F0H
	MOVX	@DPTR,A		
	SETB	REN			;ENABLE UART FOR +++ ESCAPE
	MOV	ESC_CNT,#03		;ESCAPE CODE COUNTER
	MOV	DOT_CNT,#100		;DOTTING PATTERN COUNTER
	MOV	UNSM_CNT,#240		;138 240 UNSCRAMBLED MARK COUNTER
	MOV	TIM_3,#75		;START LONG SPACE DISCONNECT TIMER
	SETB	TIM_3F			;START TIMER
	
	IFFALSE	X2400			;300D
	MOV	TIM_4,#S1_STB		;S1 TIMER FOR RETRAIN REQUEST
	SETB	TIM_4F
	ENDIF				;300D
	
	IFTRUE	X2400			;300DS
	MOV	S1_CNT,#S1_NB
	ENDIF				;300DT

	RET

CT_INIT:
	CLR	PSW.5
	CLR	HI_SPD1
	CLR	HI_SPD2		
	IFTRUE	V.23
	CLR	V23_SPD
	ENDIF
	MOV	DPTR,#OPT_7
	CLR	A
	MOVX	@DPTR,A
	MOV	DPTR,#JS3
	MOVX	A,@DPTR
	ANL	A,#80H
	MOVX	@DPTR,A
	RET				;131T

CH_S4:
	MOV	DPTR,#TEMP_S21
	MOV	A,S21
	MOVX	@DPTR,A
	ANL	A,#E7H
	MOV	S21,A
	MOV	DPTR,#TEMP_S10
	MOV	A,S10
	MOVX	@DPTR,A
	MOV	A,#255
	MOV	S10,A
	RET

MSG_RDLB:
	DB	0DH,0AH,'RDLB',0FFH

L_CD:	DB	'90 2400MK LOST ENERGY',0FFH
N_S1:	DB	'90 NO S1',0FFH
N_24MK:	DB	'90 NO 2400MK',0FFH
	
	END
	
;++++	d6
	IFFALSE	X2400
	ENDIF

	IFTRUE	X2400
	ENDIF
;++++	
