
;************************************************************************
;* FILE		: MOD2.ASM	UNIVERSAL				*
;* SUBJECT	: JCM							*
;************************************************************************

; 12/21/90 - RELEASE 1.0 O
;  9/19/91 - RELEASE 2.2 S

	LIST	OFF
	INCLUDE CONFIG.ASM
	INCLUDE RDEFINE.ASM
	LIST	ON

JD	EQU	0
;========================================================================
;EXTERNAL DEFINITIONS
;========================================================================
;FROM MOD1.ASM
	EXTERNAL	PUT_CHAR

;FROM WMOD.ASM
	EXTERNAL	SET_B96,SET_V21

;FROM MOD5.ASM
	EXTERNAL	AT_000,PARSE,AT_OK,FETCH,IS_VALID,SND_DIGITS
	EXTERNAL	SND_MSG,GET_PARAM,AT_ERR

;FROM MOD6.ASM
	EXTERNAL	SD_CRLF,READ_NV0,RD_NV_DAT0,WRT_NV0
	EXTERNAL	READ_NV,WRT_NV

;FROM MOD8.ASM
	EXTERNAL	SND_HEX

;FROM	WMOD.ASM

;========================================================================
; Public Definitions
;========================================================================
	GLOBAL		MSG_VER,NV_R,NV_W,AT.V0
	
	IFTRUE	JCM
	GLOBAL		LEE_COM
	GLOBAL		JS0,JS1,JS2,JS3,JS4,REG_0,JP_004
	GLOBAL		JS5,JS6,JS7,JS8,JS9,JS10

;========================================================================
	CODE
;========================================================================
LEE_COM:
	LCALL	FETCH
	CJNE	A,#0DH,CD1
	LJMP	AT_OK
CD1:	MOV	DPTR,#LEE_TAB
	LJMP	PARSE

LEE_TAB:
	DB	'A'
	DW	AT.A		;
	DB	'B'
	DW	AT.B		;
	DB	'D'
	DW	AT.D		;
	DB	'E'
	DW	AT.E		;
	DB	'F'
	DW	AT.F
	DB	'I'
	DW	AT.I		;
	DB	'N'
	DW	AT.N		;
	DB	'P'
	DW	AT.P		;
	DB	'R'
	DW	AT.R		;
	DB	'S'
	DW	AT.S		;
	DB	'T'
	DW	AT.T		;
	DB	'V'
	DW	AT.V		;
	DB	'X'
	DW	AT.X		;
	DB	'Y'
	DW	AT.Y		;
	DB	'Z'
	DW	AT.Z		;
	DB	FFH

;========================================================================
; AT.D		: Display JS register
; DESTROYS	: 
; CALLS		: 
; EXPECTS	:
; RETURNS	:
; STACK 	:
;========================================================================
AT.D:
	PUSH	REG_0
	LCALL	SD_CRLF
	MOV	DPTR,#JS_H
	LCALL	SND_MSG
	MOV	R0,#10
	MOV	DPTR,#(JS0-1)
DD1:	INC	DPTR
	PUSH	DPL
	PUSH	DPH
	MOVX	A,@DPTR
	LCALL	SND_HEX
	MOV	DPTR,#JS_I
	LCALL	SND_MSG
	POP	DPH
	POP	DPL
	DJNZ	R0,DD1
	LCALL	SD_CRLF
	POP	REG_0
	LJMP	AT_000

;========================================================================
; AT.En		: RX EQ setting
; DESTROYS	: 
; CALLS		: 
; EXPECTS	:
; RETURNS	:
; STACK 	:
;========================================================================
AT.E:
	LCALL	GET_PARAM
	MOV	DPTR,#JS1
R_OUT:	MOVX	@DPTR,A
	LJMP	AT_000

;========================================================================
; AT.Fn		: TX EQ setting
; DESTROYS	: 
; CALLS		: 
; EXPECTS	:
; RETURNS	:
; STACK 	:
;========================================================================
AT.F:
	LCALL	GET_PARAM
	MOV	DPTR,#JS2
	SJMP	R_OUT

	IFTRUE	JD
;========================================================================
; AT.I		: 
; DESTROYS	: ACC,DPTR,R0,R4,JP_004
; CALLS		: SND_MSG,SND_DIGITS,READ_NV,WRT_NV,SD_CRLF
; EXPECTS	:
; RETURNS	:
; STACK 	:
;========================================================================
AT.I:
	MOV	R0,#0
; ------------------------------------------------------- MSB
I_1:	SETB	JP_004
	LCALL	READ_NV
	MOV	R4,A
	CPL	A
	CLR	JP_004
	LCALL	WRT_NV
	SETB	JP_004
	LCALL	READ_NV
	CPL	A
	CJNE	A,REG_4,I_2
	CLR	JP_004
	LCALL	WRT_NV
; ------------------------------------------------------- LSB
	CLR	JP_004
	LCALL	READ_NV
	MOV	R4,A
	CPL	A
	SETB	JP_004
	LCALL	WRT_NV
	CLR	JP_004
	LCALL	READ_NV
	CPL	A
	CJNE	A,REG_4,I_2
	SETB	JP_004
	LCALL	WRT_NV
	INC	R0
	CJNE	R0,#(MAX_NV_ADD+1),I_1
; ------------------------------------------------------- MSG
	MOV	DPTR,#NV_OK
	LCALL	SND_MSG
I_3:	LJMP	AT_000
I_2:	MOV	DPTR,#NV_ERR
	LCALL	SND_MSG
	MOV	A,R0
	LCALL	SND_DIGITS
	LCALL	SD_CRLF
	MOV	DPTR,#NV_RG
	LCALL	SND_MSG
	MOV	A,#MAX_NV_ADD
	LCALL	SND_DIGITS
	LCALL	SD_CRLF
	SJMP	I_3

;========================================================================
; AT.N		: 
; DESTROYS	: ACC,R0,R4
; CALLS		:
; EXPECTS	:
; RETURNS	:
; STACK 	:
;========================================================================
AT.N:
	MOV	R0,#0
	MOV	R4,#10
	LCALL	SD_CRLF
AT.N1:
	SETB	JP_004
	LCALL	READ_NV
	LCALL	SND_HEX
	CLR	JP_004
	LCALL	READ_NV
	LCALL	SND_HEX
	MOV	DPTR,#NV_S
	LCALL	SND_MSG
	INC	R0
	CJNE	R0,#(MAX_NV_ADD+1),AT.N2
	SJMP	AT.N3
AT.N2:	DJNZ	R4,AT.N1
	LCALL	SD_CRLF
	MOV	R4,#10
	SJMP	AT.N1
AT.N3:	LCALL	SD_CRLF
	LJMP	AT_000
	ENDIF

;========================================================================
; AT.Pn		: 
; DESTROYS	:
; CALLS		:
; EXPECTS	:
; RETURNS	:
; STACK 	:
;========================================================================
AT.P:
	MOV	DPTR,#JS3
	LCALL	GET_PARAM
	JB	PASS,AT.P0
	CJNE	A,#1,AT.P2
	MOV	A,#80H
AT.P0:	MOVX	@DPTR,A
	LJMP	AT_000
AT.P2:	CJNE	A,#2,AT.PR
	MOV	A,#40H
	SJMP	AT.P0
AT.PR:	LJMP	AT_ERR

;========================================================================
; AT.Rnn	: 
; DESTROYS	:
; CALLS		:
; EXPECTS	:
; RETURNS	:
; STACK 	:
;			****** NOT FINISH ! *****
;========================================================================
;AT.R:
;	PUSH	REG_5
;	PUSH	REG_6
;	MOV	R5,#00
;	LCALL	GET_PARAM
;	MOV	DPH,A
;	MOV	DPL,#00
;	LCALL	SD_CRLF
;	MOV	A,#SPACE
;	LCALL	PUT_CHAR
;	LCALL	PUT_CHAR
;	LCALL	PUT_CHAR
;	MOV	A,#00
;AT.R1:	LCALL	SND_HEX
;	MOV	A,#SPACE
;	LCALL	PUT_CHAR
;	INC	R5
;	MOV	A,R5
;	CJNE	R5,#10H,AT.R1
;	LCALL	SD_CRLF
;	MOV	R6,#10H
;AT.R3:	MOV	R5,#10H
;	MOV	A,DPL
;	LCALL	SND_HEX
;	MOV	A,#SPACE
;	LCALL	PUT_CHAR
;AT.R2:	MOVX	A,@DPTR
;	LCALL	SND_HEX
;	MOV	A,#SPACE
;	LCALL	PUT_CHAR
;	INC	DPL
;	DJNZ	R5,AT.R2
;	LCALL	SD_CRLF
;	DJNZ	R6,AT.R3
;	LCALL	SD_CRLF
;	POP	REG_6
;	POP	REG_5
;	LJMP	AT_000

	IFTRUE	JD
;========================================================================
; AT.S		: 
; DESTROYS	: ACC
; CALLS		: SD_CRLF,SND_HEX
; EXPECTS	:
; RETURNS	:
; STACK 	:
;========================================================================
AT.S:
	LCALL	SD_CRLF
	MOV	A,U_ST
	LCALL	SND_HEX
	LJMP	AT_000
	ENDIF

;========================================================================
; AT.Tn		: 
; DESTROYS	: 
; CALLS		: 
; EXPECTS	: n =	0
;			1
;			2
;			3
;			1
; RETURNS	:
; STACK 	:
;========================================================================
AT.T:
	LCALL	GET_PARAM
	MOV	DPTR,#JS4
	MOVX	@DPTR,A
	LJMP	AT_000

;========================================================================
; AT.V		: SYSTEM ID
; DESTROYS	:
; CALLS		:
; EXPECTS	:
; RETURNS	:
; STACK 	:
;========================================================================
AT.V:
AT.V0:
	MOV	DPTR,#VER_H
	LCALL	SND_MSG
	MOV	A,#EP_ID
	LCALL	SND_DIGITS
	MOV	DPTR,#EXAR
	LCALL	SND_MSG
	LCALL	SD_CRLF
	LJMP	AT_000

;========================================================================
; AT.X		: 
; DESTROYS	:
; CALLS		:
; EXPECTS	:
; RETURNS	:
; STACK 	:
;========================================================================
AT.X:
AT.R:
AT.Y:
AT.Z:	
AT.A:
AT.B:
	IFFALSE	JD
AT.I:
AT.N:
AT.S:
	ENDIF
	LJMP	AT_000	
	ENDIF				;JCM

;========================================================================
; NV_R	:	READ TELPHONE NUMBER AND DECOMPRESS DATA	
; DESTROYS -	ACC,B(TAB COUNTER),R0,R1,R2
; CALLS -	READ_NV
; EXPECTS -	B  = Tab
;		R0 = INITIAL ADDRESS OF NV RAM
;		U_ST =	2 - BUFF & PUT;	JP_004 = 0
;			3 - PUT			 1
; RETURNS -	WITH BUFFER CONTAINING 'D' AND DIAL STRING
;          	POINTER POINTING TO THE SECOND DIGIT
; STACK -	2
;========================================================================
NV_R:	
	PUSH	REG_4
	PUSH	REG_5
	PUSH	REG_6
	PUSH	REG_7
	CLR	S_DIAL
	MOV	R2,#MAX_ADD	;ADD COUNTER
	JB	JP_004,GDIAL1	;DISPLAY 
	MOV	R1,#BUFFER
	MOV	A,#'D'
	MOV	@R1,A
	MOV	POINTER,#01
GDIAL1:	PUSH	REG_1
	LCALL	READ_NV0	
	MOV	R5,A
	LCALL	RD_NV_DAT0
	POP	REG_1
	CLR	NV_CS
	CLR	C
	RRC	A
	JC	GD_4S		
	MOV	R6,A		;RECOVER TOKEN
	ANL	A,#1FH
	LCALL	DCD_5		
	MOV	R7,A
	MOV	A,R6
	RL	A
	RL	A
	RL	A
	ANL	A,#3
	MOV	R6,A
	MOV	A,R5
	ANL	A,#7
	CLR	C
	RLC	A
	RLC	A
	ORL	A,R6
	LCALL	DCD_5
	MOV	R6,A
	MOV	A,R5
	RR	A
	RR	A
	RR	A
	ANL	A,#1FH
	LCALL	DCD_5
	MOV	R5,A
	MOV	R4,#0
DCC:	PUSH	REG_0
	MOV	R0,#4
DC1:	CJNE	R0,#4,DC2
	MOV	A,R5
	SJMP	GD_P
DC2:	CJNE	R0,#3,DC3
	MOV	A,R6
	SJMP	GD_P
DC3:	CJNE	R0,#2,DC4
	MOV	A,R7
	SJMP	GD_P
DC4:	MOV	A,R4
GD_P:	CJNE	A,#FFH,GD_1
	SJMP	GD_E
GD_1:	CJNE	A,#0,GD_3
	SJMP	GD_4
GD_3:	JB	JP_004,GD_13
	INC	R1	
	MOV	@R1,A		
GD_13:	LCALL	PUT_CHAR
	DEC	B
	MOV	A,#(TEL_TAB-MAX_TEL_DIG)
	CJNE	A,B,GD_4
	SJMP	GD_E
GD_4:	DJNZ	R0,DC1
	JB	S_DIAL,GD_E	;MARK ?
	DJNZ	R2,GD_11A	;SPACE ?
	SJMP	GD_E
GD_11A:	POP	REG_0
	INC	R0		
	LJMP	GDIAL1

GD_E:	POP	REG_0
	JB	JP_004,GD9A
	INC	R1		
	MOV	@R1,S3		;<CR>
GD9A:	CLR	NV_CS
	POP	REG_7
	POP	REG_6
	POP	REG_5
	POP	REG_4
	RET

GD_4S:	PUSH	B		;BS ADJ
	XCH	A,R5		
	CLR	C
	RRC	A
	JNC	GD_4S1
	XCH	A,R5	
	SETB	ACC.7
	XCH	A,R5		;0AR5
GD_4S1:	MOV	B,R5
	MOV	R4,#30H		
	MOV	R7,#30H
	MOV	R6,#30H
	MOV	R5,#30H
	INC	A
GD_4S3:	DJNZ	A,GD_4S0
	SJMP	GD_4S2

GD_4S0:	PUSH	ACC
	INC	R6
	INC	R6
	MOV	A,#5
	ADD	A,R7
	MOV	R7,A
	MOV	A,#6
	ADD	A,R4
	MOV	R4,A
	POP	ACC
	ACALL	ADJ
	SJMP	GD_4S3

GD_4S2:	MOV	A,B
	POP	B
GD_4S8:CJNE	A,#10,GD_4S4
GD_4S4:	JC	GD_4S5		
	CJNE	A,#100,GD_4S6
GD_4S6:	JC	GD_4S7	
	CLR	C
	SUBB	A,#100
	INC	R6
	ACALL	ADJ_3
	SJMP	GD_4S8

GD_4S7:	CLR	C
	SUBB	A,#10
	INC	R7
	ACALL	ADJ_2
	SJMP	GD_4S8

GD_4S5:	ADD	A,R4
	MOV	R4,A
	ACALL	ADJ
	MOV	A,R5
	JNB	S_DIAL,GD_4S9
	MOV	A,#FFH
GD_4S9:	LJMP	DCC	

ADJ:	CJNE	R4,#3AH,AD1
AD1:	JNC	AD11
ADJ_2:	CJNE	R7,#3AH,AD2
AD2:	JNC	AD22
ADJ_3:	CJNE	R6,#3AH,AD3
AD3:	JNC	AD33
ADJ_4:	CJNE	R5,#3AH,AD4
AD4:	JNC	AD44
AD5:	RET

AD11:	PUSH	ACC
	MOV	A,R4
	CLR	C
	SUBB	A,#10
	MOV	R4,A
	POP	ACC
	INC	R7
	SJMP	ADJ_2

AD22:	PUSH	ACC
	MOV	A,R7
	CLR	C
	SUBB	A,#10
	MOV	R7,A
	POP	ACC
	INC	R6
	SJMP	ADJ_3

AD33:	PUSH	ACC
	MOV	A,R6
	CLR	C
	SUBB	A,#10
	MOV	R6,A
	POP	ACC
	INC	R5
	SJMP	ADJ_4

AD44:	SETB	S_DIAL
	SJMP	AD5
	
;========================================================================
; DCD_5		: 
; DESTROYS	: ACC
; CALLS		: 
; EXPECTS	: ACC
; RETURNS	:
; STACK 	:
;========================================================================
DCD_5:
	PUSH	DPH
	PUSH	DPL
	MOV	DPTR,#DCD_TABLE
	MOVC	A,@A+DPTR
	CJNE	A,#FFH,DCD_OK
	SETB	S_DIAL
DCD_OK:	POP	DPL
	POP	DPH
	RET
	
;========================================================================
; NV_W : WRITE TELEPHONE NUMBER WITH DATA COMPRESSION
; DESTROYS - ACC,B,R0,R1,JP_004
; CALLS -  FETCH,IS_VALID
; EXPECTS - 
; RETURNS - 
;========================================================================
;
NV_W:
	PUSH	REG_5
	PUSH	REG_6
	PUSH	REG_7
CMP1:	MOV	B,#4		
	CLR	JP_004
CMP2:	LCALL	FETCH
	CJNE	A,S3,ATX_Z2
	MOV	A,B
	CJNE	A,#4,T2D
	MOV	R5,#31
	SJMP	AZ_22A
T2D:	CJNE	A,#3,T3D
	MOV	R6,#31
	SJMP	AZ_22A
T3D:	CJNE	A,#2,T4D
	MOV	R7,#31
AZ_22A:	LJMP	AZ_22
T4D:	LJMP	ATX_Z9
ATX_Z2:	LCALL	IS_VALID
	JNB	PASS,CMP2
	XCH	A,B
	CJNE	A,#4,S2D
	MOV	R5,B
	SJMP	AZ_2A
S2D:	CJNE	A,#3,S3D
	MOV	R6,B
	SJMP	AZ_2A
S3D:	CJNE	A,#2,S4D
	MOV	R7,B
	SJMP	AZ_2A
S4D:	MOV	R4,B
AZ_2A:	XCH	A,B
	ACALL	CHK
	DJNZ	B,CMP2

	JB	JP_004,ATX_Z9		
	MOV	B,#0		;BODY LENGTH
	CLR	C
	MOV	A,R4
	CJNE	R7,#0,AZ_6
	SJMP	AZ_7
AZ_6:	ADD	A,#AH
	JNC	AZ_13
	ACALL	AZ_8
AZ_13:	DJNZ	R7,AZ_6

AZ_7:	CJNE	R6,#0,AZ_10
	SJMP	AZ_12
AZ_10:	ADD	A,#64H
	JNC	AZ_14
	ACALL	AZ_8
AZ_14:	DJNZ	R6,AZ_10
	
AZ_12:	CJNE	R5,#0,AZ_11
	LJMP	AZ_18
AZ_11:	INC	B
	INC	B
	INC	B
	ADD	A,#E8H
	JNC	AZ_16
	ACALL	AZ_8
AZ_16:	DJNZ	R5,AZ_11
AZ_18:	PUSH	ACC		;BS ADJ
	MOV	A,B
	CLR	C
	RLC	A
	MOV	B,A	
	POP	ACC
	CLR	C
	RLC	A
	JNC	AZ_21
	INC	B
AZ_21:	SETB	ACC.0
	LJMP	AZ_17
AZ_22:	SETB	S_DIAL
	SJMP	AZ_23
CHK:	CLR	C		
	ADD	A,#F6H
	JNC	AZ_24
	SETB	JP_004		
AZ_24:	RET

ATX_Z9:	DEC	POINTER		
AZ_23:	MOV	A,R5		;GET TOKEN
	ANL	A,#1FH
	RL	A
	RL	A
	RL	A
	MOV	R5,A
	MOV	A,R6
	RR	A
	RR	A
	ANL	A,#7
	ORL	A,R5
	MOV	B,A
	MOV	A,R7
	RL	A
	ANL	A,#3EH
	MOV	R7,A
	MOV	A,R6
	RR	A
	RR	A
	ANL	A,#C0H		;GET HEADER
	ORL	A,R7
AZ_17:	PUSH	REG_1
	LCALL	WRT_NV0		
	POP	REG_1
	INC	R0
ATX_Z7:	JB	S_DIAL,ATX_Z8	;MARK
	DJNZ	R1,AZ_19	
	SETB	ABORT		;OVERFLOW
ATX_Z8:	DEC	POINTER		
AZ_25:	POP	REG_7
	POP	REG_6
	POP	REG_5
	RET	

AZ_19:	LJMP	CMP1

AZ_8:	INC	B
	CLR	C
	RET

;========================================================================
; ECD_5		: 
; DESTROYS	: 
; CALLS		: 
; EXPECTS	: ACC
; RETURNS	: ACC
; STACK 	:
;========================================================================
ECD_5:
	PUSH	REG_0
	PUSH	REG_1
	PUSH	DPH
	PUSH	DPL
	CJNE	A,#0DH,ECD1
	MOV	A,#31
ECD4:	POP	DPL
	POP	DPH
	POP	REG_1
	POP	REG_0
	RET

ECD1:	MOV	R0,A
	MOV	A,#00
	MOV	R1,#00
	MOV	DPTR,#DCD_TABLE
ECD2:	MOVC	A,@A+DPTR
	CJNE	A,REG_0,ECD3
	MOV	A,R1
	SJMP	ECD4
ECD3:	INC	R1
	CJNE	R1,#MAX_COD,ECD5
	MOV	A,#00
	SJMP	ECD4
ECD5:	MOV	A,R1
	SJMP	ECD2

DCD_TABLE:
	DB	'0'
	DB	'1'
	DB	'2'
	DB	'3'
	DB	'4'
	DB	'5'
	DB	'6'
	DB	'7'
	DB	'8'
	DB	'9'
	DB	'A'
	DB	'B'
	DB	'C'
	DB	'D'
	DB	'P'
	DB	'R'
	DB	'T'
	DB	'W'
	DB	'!'
	DB	'@'
	DB	'#'
	DB	'*'
	DB	';'
	DB	','
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	FFH

NV_OK:	DB	0DH,0AH,'ALL NVRAM ADDRESS ARE FUNCTIONING PROPERLY' 
	DB	0DH,0AH,FFH
NV_ERR:	DB	07H,0DH,0AH,'NVRAM OUT OF ORDER AFTER ADDRESS = ',FFH
NV_RG:	DB	'TOTAL EEPROM ADDRESS : 000 --- ',FFH
NV_S:	DB	'H ',FFH
VER_H	DB	0DH,0AH,'     VERSION ID : ',0FFH
JS_H	DB	0DH,0AH,'0     1     2     3     4     5     6     7     8     9'
	DB	0DH,0AH,0dH,0AH,0FFH
JS_I	DB	'H   ',0FFH
MSG_VER:
;	DB	0DH,0AH,'!!! THIS EPROM IS FOR TESTING ONLY !!!'
	DB	0DH,0AH,' 9/27/91       ',0FFH
EXAR	DB	'_092791A',0FFH
	END	
