using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace CS_IO_Demo
{
    class Program
    {
        [DllImport("SXIO.dll")]
        public static extern byte SX_inpb(uint nAddr);

        [DllImport("SXIO.dll")]
        public static extern void SX_outp(uint nAddr, byte dbData);

        [DllImport("SXIO.dll")]
        public static extern int SX_inpw(uint nAddr);

        [DllImport("SXIO.dll")]
        public static extern void SX_outw(uint nAddr, UInt16 dwData);

        [DllImport("SXIO.dll")]
        public static extern uint SX_inpl(UInt32 nAddr);

        [DllImport("SXIO.dll")]
        public static extern void SX_outl(uint nAddr, UInt32 ddData);



        static void Main(string[] args)
        {
            uint nAddr = 0x80;

            System.Console.WriteLine("1st Test:");
            SX_outp(nAddr, 0x12);
            SX_outp(nAddr + 1, 0x34);
            SX_outp(nAddr + 2, 0x56);
            SX_outp(nAddr + 3, 0x78);

            byte b1 = SX_inpb(nAddr);
            byte b2 = SX_inpb(nAddr + 1);
            byte b3 = SX_inpb(nAddr + 2);
            byte b4 = SX_inpb(nAddr + 3);
            System.Console.WriteLine("Read byte form " + Convert.ToString(nAddr, 16) + "H  port is:" + Convert.ToString(b1, 16) + "H");
            System.Console.WriteLine("Read byte form " + Convert.ToString((nAddr + 1), 16) + "H  port is:" + Convert.ToString(b2, 16) + "H");
            System.Console.WriteLine("Read byte form " + Convert.ToString((nAddr + 2), 16) + "H  port is:" + Convert.ToString(b3, 16) + "H");
            System.Console.WriteLine("Read byte form " + Convert.ToString((nAddr + 3), 16) + "H  port is:" + Convert.ToString(b4, 16) + "H");

            int w1 = SX_inpw(nAddr);
            int w2 = SX_inpw(nAddr + 1);
            int w3 = SX_inpw(nAddr + 2);
            System.Console.WriteLine("Read word form " + Convert.ToString(nAddr, 16) + "H port is:" + Convert.ToString(w1, 16) + "H");
            System.Console.WriteLine("Read word form " + Convert.ToString((nAddr + 1), 16) + "H port is:" + Convert.ToString(w2, 16) + "H");
            System.Console.WriteLine("Read word form " + Convert.ToString((nAddr + 2), 16) + "H port is:" + Convert.ToString(w3, 16) + "H");

            Int64 dd = SX_inpl(nAddr);
            System.Console.WriteLine("Read double word form " + Convert.ToString(nAddr, 16) + "H port is:" + Convert.ToString(dd, 16) + "H");


            System.Console.WriteLine("2nd Test:");
            SX_outw(nAddr, 0x5678);
            SX_outw(nAddr + 2, 0xabcd);
            w1 = SX_inpw(nAddr);
            w2 = SX_inpw(nAddr + 2);
            System.Console.WriteLine("Read word form " + Convert.ToString(nAddr, 16) + "H port is:" + Convert.ToString(w1, 16) + "H");
            System.Console.WriteLine("Read word form " + Convert.ToString((nAddr + 2), 16) + "H port is:" + Convert.ToString(w2, 16) + "H");

            dd = SX_inpl(nAddr);
            System.Console.WriteLine("Read double word form " + Convert.ToString(nAddr, 16) + "H port is:" + Convert.ToString(dd, 16) + "H");

            b1 = SX_inpb(nAddr);
            b2 = SX_inpb(nAddr + 1);
            b3 = SX_inpb(nAddr + 2);
            b4 = SX_inpb(nAddr + 3);
            System.Console.WriteLine("Read byte form " + Convert.ToString(nAddr, 16) + "H  port is:" + Convert.ToString(b1, 16) + "H");
            System.Console.WriteLine("Read byte form " + Convert.ToString((nAddr + 1), 16) + "H  port is:" + Convert.ToString(b2, 16) + "H");
            System.Console.WriteLine("Read byte form " + Convert.ToString((nAddr + 2), 16) + "H  port is:" + Convert.ToString(b3, 16) + "H");
            System.Console.WriteLine("Read byte form " + Convert.ToString((nAddr + 3), 16) + "H  port is:" + Convert.ToString(b4, 16) + "H");


            System.Console.WriteLine("3rd Test:");
            SX_outl(nAddr, 0xabcdef12);
            dd = SX_inpl(nAddr);
            System.Console.WriteLine("Read word form " + Convert.ToString(nAddr, 16) + "H port is:" + Convert.ToString(dd, 16) + "H");

            w1 = SX_inpw(nAddr);
            w2 = SX_inpw(nAddr + 2);
            System.Console.WriteLine("Read word form " + Convert.ToString(nAddr, 16) + "H port is:" + Convert.ToString(w1, 16) + "H");
            System.Console.WriteLine("Read word form " + Convert.ToString((nAddr + 2), 16) + "H port is:" + Convert.ToString(w2, 16) + "H");

            b1 = SX_inpb(nAddr);
            b2 = SX_inpb(nAddr + 1);
            b3 = SX_inpb(nAddr + 2);
            b4 = SX_inpb(nAddr + 3);
            System.Console.WriteLine("Read byte form " + Convert.ToString(nAddr, 16) + "H  port is:" + Convert.ToString(b1, 16) + "H");
            System.Console.WriteLine("Read byte form " + Convert.ToString((nAddr + 1), 16) + "H  port is:" + Convert.ToString(b2, 16) + "H");
            System.Console.WriteLine("Read byte form " + Convert.ToString((nAddr + 2), 16) + "H  port is:" + Convert.ToString(b3, 16) + "H");
            System.Console.WriteLine("Read byte form " + Convert.ToString((nAddr + 3), 16) + "H  port is:" + Convert.ToString(b4, 16) + "H");
        }
    }
}
